/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.expando.kernel.service.ExpandoRowLocalService;
import com.liferay.exportimport.kernel.configuration.ExportImportConfigurationSettingsMapFactoryUtil;
import com.liferay.exportimport.kernel.lar.ExportImportHelperUtil;
import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.exportimport.kernel.service.ExportImportConfigurationLocalService;
import com.liferay.exportimport.kernel.service.ExportImportLocalService;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.exception.DuplicateUserGroupException;
import com.liferay.portal.kernel.exception.DuplicateUserGroupExternalReferenceCodeException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.RequiredUserGroupException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.exception.UserGroupNameException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Team;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.model.UserGroupModel;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.SortFactoryUtil;
import com.liferay.portal.kernel.search.reindexer.ReindexerBridge;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.exportimport.UserGroupImportTransactionThreadLocal;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserGroupGroupRoleLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.persistence.GroupPersistence;
import com.liferay.portal.kernel.service.persistence.TeamPersistence;
import com.liferay.portal.kernel.service.persistence.UserFinder;
import com.liferay.portal.kernel.service.persistence.UserPersistence;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LinkedHashMapBuilder;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ServiceProxyFactory;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.service.base.UserGroupLocalServiceBaseImpl;
import com.liferay.portal.service.persistence.constants.UserGroupFinderConstants;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.util.PropsValues;
import com.liferay.users.admin.kernel.util.UsersAdminUtil;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class UserGroupLocalServiceImpl
extends UserGroupLocalServiceBaseImpl {
    private static volatile ReindexerBridge _reindexerBridge = (ReindexerBridge)ServiceProxyFactory.newServiceTrackedInstance(ReindexerBridge.class, UserGroupLocalServiceImpl.class, (String)"_reindexerBridge", (boolean)false);
    @BeanReference(type=ExpandoRowLocalService.class)
    private ExpandoRowLocalService _expandoRowLocalService;
    @BeanReference(type=ExportImportConfigurationLocalService.class)
    private ExportImportConfigurationLocalService _exportImportConfigurationLocalService;
    @BeanReference(type=ExportImportLocalService.class)
    private ExportImportLocalService _exportImportLocalService;
    @BeanReference(type=GroupLocalService.class)
    private GroupLocalService _groupLocalService;
    @BeanReference(type=GroupPersistence.class)
    private GroupPersistence _groupPersistence;
    @BeanReference(type=ResourceLocalService.class)
    private ResourceLocalService _resourceLocalService;
    @BeanReference(type=TeamPersistence.class)
    private TeamPersistence _teamPersistence;
    @BeanReference(type=UserFinder.class)
    private UserFinder _userFinder;
    @BeanReference(type=UserGroupGroupRoleLocalService.class)
    private UserGroupGroupRoleLocalService _userGroupGroupRoleLocalService;
    @BeanReference(type=UserLocalService.class)
    private UserLocalService _userLocalService;
    @BeanReference(type=UserPersistence.class)
    private UserPersistence _userPersistence;

    @Override
    public void addGroupUserGroup(long groupId, long userGroupId) {
        super.addGroupUserGroup(groupId, userGroupId);
        try {
            this.reindexUsers(userGroupId);
        }
        catch (PortalException portalException) {
            throw new SystemException((Throwable)portalException);
        }
    }

    @Override
    public void addGroupUserGroup(long groupId, UserGroup userGroup) {
        super.addGroupUserGroup(groupId, userGroup);
        try {
            this.reindexUsers(userGroup);
        }
        catch (PortalException portalException) {
            throw new SystemException((Throwable)portalException);
        }
    }

    @Override
    public void addGroupUserGroups(long groupId, List<UserGroup> userGroups) {
        super.addGroupUserGroups(groupId, userGroups);
        try {
            this.reindexUsers(userGroups);
        }
        catch (PortalException portalException) {
            throw new SystemException((Throwable)portalException);
        }
    }

    @Override
    public void addGroupUserGroups(long groupId, long[] userGroupIds) {
        super.addGroupUserGroups(groupId, userGroupIds);
        try {
            this.reindexUsers(userGroupIds);
        }
        catch (PortalException portalException) {
            throw new SystemException((Throwable)portalException);
        }
    }

    public UserGroup addOrUpdateUserGroup(String externalReferenceCode, long userId, long companyId, String name, String description, ServiceContext serviceContext) throws PortalException {
        UserGroup userGroup = this.fetchUserGroupByExternalReferenceCode(externalReferenceCode, companyId);
        if (userGroup != null) {
            return this.updateUserGroup(companyId, userGroup.getUserGroupId(), name, description, serviceContext);
        }
        userGroup = this.addUserGroup(userId, companyId, name, description, serviceContext);
        userGroup.setExternalReferenceCode(externalReferenceCode);
        return (UserGroup)this.userGroupPersistence.update((BaseModel)userGroup);
    }

    @Override
    public void addTeamUserGroup(long teamId, UserGroup userGroup) {
        super.addTeamUserGroup(teamId, userGroup);
        try {
            this.reindexUsers(userGroup);
        }
        catch (PortalException portalException) {
            throw new SystemException((Throwable)portalException);
        }
    }

    @Override
    public void addTeamUserGroups(long teamId, long[] userGroupIds) {
        super.addTeamUserGroups(teamId, userGroupIds);
        try {
            this.reindexUsers(userGroupIds);
        }
        catch (PortalException portalException) {
            throw new SystemException((Throwable)portalException);
        }
    }

    public UserGroup addUserGroup(long userId, long companyId, String name, String description, ServiceContext serviceContext) throws PortalException {
        this.validate(0L, companyId, name);
        User user = this._userPersistence.findByPrimaryKey(userId);
        long userGroupId = this.counterLocalService.increment();
        UserGroup userGroup = this.userGroupPersistence.create(userGroupId);
        if (serviceContext != null) {
            userGroup.setUuid(serviceContext.getUuid());
        }
        userGroup.setCompanyId(companyId);
        userGroup.setUserId(user.getUserId());
        userGroup.setUserName(user.getFullName());
        userGroup.setParentUserGroupId(0L);
        userGroup.setName(name);
        userGroup.setDescription(description);
        userGroup.setAddedByLDAPImport(UserGroupImportTransactionThreadLocal.isOriginatesFromImport());
        userGroup.setExpandoBridgeAttributes(serviceContext);
        userGroup = (UserGroup)this.userGroupPersistence.update((BaseModel)userGroup);
        this._groupLocalService.addGroup(userId, 0L, UserGroup.class.getName(), userGroup.getUserGroupId(), 0L, this.getLocalizationMap(String.valueOf(userGroupId)), null, 0, true, 0, null, false, true, null);
        this._resourceLocalService.addResources(companyId, 0L, userId, UserGroup.class.getName(), userGroup.getUserGroupId(), false, false, false);
        this.reindexUserGroup(userGroup);
        return userGroup;
    }

    @Override
    public void addUserUserGroup(long userId, long userGroupId) throws PortalException {
        super.addUserUserGroup(userId, userGroupId);
        this.reindexUserGroup(this.getUserGroup(userGroupId));
    }

    @Override
    public void addUserUserGroup(long userId, UserGroup userGroup) throws PortalException {
        super.addUserUserGroup(userId, userGroup);
        this.reindexUserGroup(userGroup);
    }

    @Override
    public void addUserUserGroups(long userId, List<UserGroup> userGroups) throws PortalException {
        super.addUserUserGroups(userId, userGroups);
        for (UserGroup userGroup : userGroups) {
            this.reindexUserGroup(userGroup);
        }
    }

    @Override
    public void addUserUserGroups(long userId, long[] userGroupIds) throws PortalException {
        super.addUserUserGroups(userId, userGroupIds);
        for (long userGroupId : userGroupIds) {
            this.reindexUserGroup(this.getUserGroup(userGroupId));
        }
    }

    @Override
    public UserGroup deleteUserGroup(long userGroupId) throws PortalException {
        UserGroup userGroup = this.userGroupPersistence.findByPrimaryKey(userGroupId);
        return this.userGroupLocalService.deleteUserGroup(userGroup);
    }

    @Override
    @SystemEvent(action=1, type=1)
    public UserGroup deleteUserGroup(UserGroup userGroup) throws PortalException {
        int count;
        if (!PortalInstances.isCurrentCompanyInDeletionProcess() && (count = this._userFinder.countByKeywords(userGroup.getCompanyId(), null, 0, LinkedHashMapBuilder.put((Object)"usersUserGroups", (Object)userGroup.getUserGroupId()).build())) > 0) {
            throw new RequiredUserGroupException();
        }
        this._expandoRowLocalService.deleteRows(userGroup.getUserGroupId());
        this._groupLocalService.deleteGroup(userGroup.getGroup());
        this._userGroupGroupRoleLocalService.deleteUserGroupGroupRolesByUserGroupId(userGroup.getUserGroupId());
        this._resourceLocalService.deleteResource(userGroup.getCompanyId(), UserGroup.class.getName(), 4, userGroup.getUserGroupId());
        this.userGroupPersistence.remove((BaseModel)userGroup);
        return userGroup;
    }

    public void deleteUserGroups(long companyId) throws PortalException {
        List userGroups = this.userGroupPersistence.findByCompanyId(companyId);
        for (UserGroup userGroup : userGroups) {
            this.userGroupLocalService.deleteUserGroup(userGroup);
        }
    }

    public UserGroup fetchUserGroup(long companyId, String name) {
        return this.userGroupPersistence.fetchByC_N(companyId, name);
    }

    public List<UserGroup> getGroupUserUserGroups(long groupId, long userId) throws PortalException {
        long[] groupUserGroupIds = this._groupPersistence.getUserGroupPrimaryKeys(groupId);
        if (groupUserGroupIds.length == 0) {
            return Collections.emptyList();
        }
        long[] userUserGroupIds = this._userPersistence.getUserGroupPrimaryKeys(userId);
        if (userUserGroupIds.length == 0) {
            return Collections.emptyList();
        }
        Set userGroupIds = SetUtil.intersect((long[])groupUserGroupIds, (long[])userUserGroupIds);
        if (userGroupIds.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<UserGroup> userGroups = new ArrayList<UserGroup>(userGroupIds.size());
        for (Long userGroupId : userGroupIds) {
            userGroups.add((UserGroup)this.userGroupPersistence.findByPrimaryKey((Serializable)userGroupId));
        }
        return userGroups;
    }

    public UserGroup getUserGroup(long companyId, String name) throws PortalException {
        return this.userGroupPersistence.findByC_N(companyId, name);
    }

    public List<UserGroup> getUserGroups(long companyId) {
        return this.userGroupPersistence.findByCompanyId(companyId);
    }

    public List<UserGroup> getUserGroups(long companyId, String name, int start, int end) {
        if (Validator.isNull((String)name)) {
            return this.userGroupPersistence.findByCompanyId(companyId, start, end);
        }
        return this.userGroupPersistence.findByC_LikeN(companyId, name, start, end);
    }

    public List<UserGroup> getUserGroups(long companyId, String name, int start, int end, OrderByComparator<UserGroup> orderByComparator) {
        if (Validator.isNull((String)name)) {
            return this.userGroupPersistence.findByCompanyId(companyId, start, end, orderByComparator);
        }
        return this.userGroupPersistence.findByC_LikeN(companyId, StringUtil.quote((String)name, (String)"%"), start, end, orderByComparator);
    }

    public List<UserGroup> getUserGroups(long[] userGroupIds) throws PortalException {
        ArrayList<UserGroup> userGroups = new ArrayList<UserGroup>(userGroupIds.length);
        for (long userGroupId : userGroupIds) {
            userGroups.add(this.getUserGroup(userGroupId));
        }
        return userGroups;
    }

    public int getUserGroupsCount(long companyId, String name) {
        if (Validator.isNull((String)name)) {
            return this.userGroupPersistence.countByCompanyId(companyId);
        }
        return this.userGroupPersistence.countByC_LikeN(companyId, StringUtil.quote((String)name, (String)"%"));
    }

    public List<UserGroup> search(long companyId, String keywords, LinkedHashMap<String, Object> params, int start, int end, OrderByComparator<UserGroup> orderByComparator) {
        if (this.isUseCustomSQL(params)) {
            return this.userGroupFinder.findByKeywords(companyId, keywords, params, start, end, orderByComparator);
        }
        String orderByCol = orderByComparator.getOrderByFields()[0];
        String orderByType = "asc";
        if (!orderByComparator.isAscending()) {
            orderByType = "desc";
        }
        Sort sort = SortFactoryUtil.getSort(UserGroup.class, (String)orderByCol, (String)orderByType);
        try {
            return UsersAdminUtil.getUserGroups((Hits)this.search(companyId, keywords, params, start, end, sort));
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    public Hits search(long companyId, String keywords, LinkedHashMap<String, Object> params, int start, int end, Sort sort) {
        String name = null;
        String description = null;
        boolean andOperator = false;
        if (Validator.isNotNull((String)keywords)) {
            name = keywords;
            description = keywords;
        } else {
            andOperator = true;
        }
        if (params != null) {
            params.put("keywords", keywords);
        }
        return this.search(companyId, name, description, params, andOperator, start, end, sort);
    }

    public List<UserGroup> search(long companyId, String name, String description, LinkedHashMap<String, Object> params, boolean andOperator, int start, int end, OrderByComparator<UserGroup> orderByComparator) {
        if (this.isUseCustomSQL(params)) {
            return this.userGroupFinder.findByC_N_D(companyId, name, description, params, andOperator, start, end, orderByComparator);
        }
        String orderByCol = orderByComparator.getOrderByFields()[0];
        String orderByType = "asc";
        if (!orderByComparator.isAscending()) {
            orderByType = "desc";
        }
        Sort sort = SortFactoryUtil.getSort(UserGroup.class, (String)orderByCol, (String)orderByType);
        try {
            return UsersAdminUtil.getUserGroups((Hits)this.search(companyId, name, description, params, andOperator, start, end, sort));
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    public Hits search(long companyId, String name, String description, LinkedHashMap<String, Object> params, boolean andSearch, int start, int end, Sort sort) {
        try {
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(UserGroup.class);
            SearchContext searchContext = this.buildSearchContext(companyId, name, description, params, andSearch, start, end, sort);
            return indexer.search(searchContext);
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    public int searchCount(long companyId, String keywords, LinkedHashMap<String, Object> params) {
        if (this.isUseCustomSQL(params)) {
            return this.userGroupFinder.countByKeywords(companyId, keywords, params);
        }
        String name = null;
        String description = null;
        boolean andOperator = false;
        if (Validator.isNotNull((String)keywords)) {
            name = keywords;
            description = keywords;
        } else {
            andOperator = true;
        }
        if (params != null) {
            params.put("keywords", keywords);
        }
        try {
            SearchContext searchContext = this.buildSearchContext(companyId, name, description, params, andOperator, -1, -1, null);
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(UserGroup.class);
            return (int)indexer.searchCount(searchContext);
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    public int searchCount(long companyId, String name, String description, LinkedHashMap<String, Object> params, boolean andOperator) {
        if (this.isUseCustomSQL(params)) {
            return this.userGroupFinder.countByC_N_D(companyId, name, description, params, andOperator);
        }
        try {
            SearchContext searchContext = this.buildSearchContext(companyId, name, description, params, true, -1, -1, null);
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(UserGroup.class);
            return (int)indexer.searchCount(searchContext);
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    public BaseModelSearchResult<UserGroup> searchUserGroups(long companyId, String keywords, LinkedHashMap<String, Object> params, int start, int end, Sort sort) throws PortalException {
        String name = null;
        String description = null;
        boolean andOperator = false;
        if (Validator.isNotNull((String)keywords)) {
            name = keywords;
            description = keywords;
        } else {
            andOperator = true;
        }
        if (params != null) {
            params.put("keywords", keywords);
        }
        return this.searchUserGroups(companyId, name, description, params, andOperator, start, end, sort);
    }

    public BaseModelSearchResult<UserGroup> searchUserGroups(long companyId, String name, String description, LinkedHashMap<String, Object> params, boolean andSearch, int start, int end, Sort sort) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(UserGroup.class);
        SearchContext searchContext = this.buildSearchContext(companyId, name, description, params, andSearch, start, end, sort);
        for (int i = 0; i < 10; ++i) {
            Hits hits = indexer.search(searchContext);
            List userGroups = UsersAdminUtil.getUserGroups((Hits)hits);
            if (userGroups == null) continue;
            return new BaseModelSearchResult(userGroups, hits.getLength());
        }
        throw new SearchException("Unable to fix the search index after 10 attempts");
    }

    @Override
    public void setUserUserGroups(long userId, long[] userGroupIds) throws PortalException {
        this._userPersistence.setUserGroups(userId, userGroupIds);
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(User.class);
        indexer.reindex((Object)this._userLocalService.fetchUser(userId));
    }

    public void unsetGroupUserGroups(long groupId, long[] userGroupIds) {
        List teams = this._teamPersistence.findByGroupId(groupId);
        for (Team team : teams) {
            this._teamPersistence.removeUserGroups(team.getTeamId(), userGroupIds);
        }
        this._userGroupGroupRoleLocalService.deleteUserGroupGroupRoles(userGroupIds, groupId);
        this._groupPersistence.removeUserGroups(groupId, userGroupIds);
        try {
            this.reindexUsers(userGroupIds);
        }
        catch (PortalException portalException) {
            throw new SystemException((Throwable)portalException);
        }
    }

    public void unsetTeamUserGroups(long teamId, long[] userGroupIds) {
        this._teamPersistence.removeUserGroups(teamId, userGroupIds);
        try {
            this.reindexUsers(userGroupIds);
        }
        catch (PortalException portalException) {
            throw new SystemException((Throwable)portalException);
        }
    }

    @Indexable(type=IndexableType.REINDEX)
    public UserGroup updateExternalReferenceCode(UserGroup userGroup, String externalReferenceCode) throws PortalException {
        if (Objects.equals(userGroup.getExternalReferenceCode(), externalReferenceCode)) {
            return userGroup;
        }
        this._validateExternalReferenceCode(userGroup.getUserGroupId(), externalReferenceCode);
        userGroup.setExternalReferenceCode(externalReferenceCode);
        return this.updateUserGroup(userGroup);
    }

    public UserGroup updateUserGroup(long companyId, long userGroupId, String name, String description, ServiceContext serviceContext) throws PortalException {
        this.validate(userGroupId, companyId, name);
        UserGroup userGroup = this.userGroupPersistence.findByPrimaryKey(userGroupId);
        userGroup.setName(name);
        userGroup.setDescription(description);
        userGroup.setExpandoBridgeAttributes(serviceContext);
        userGroup = (UserGroup)this.userGroupPersistence.update((BaseModel)userGroup);
        this.reindexUserGroup(userGroup);
        return userGroup;
    }

    protected SearchContext buildSearchContext(long companyId, String name, String description, LinkedHashMap<String, Object> params, boolean andSearch, int start, int end, Sort sort) {
        String keywords;
        long[] userIds;
        SearchContext searchContext = new SearchContext();
        searchContext.setAndSearch(andSearch);
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("description", description);
        attributes.put("name", name);
        if (params != null && ArrayUtil.isNotEmpty((long[])(userIds = (long[])params.get("userIds")))) {
            attributes.put("userIds", userIds);
        }
        searchContext.setAttributes(attributes);
        searchContext.setCompanyId(companyId);
        searchContext.setEnd(end);
        if (params != null && Validator.isNotNull((String)(keywords = (String)params.remove("keywords")))) {
            searchContext.setKeywords(keywords);
        }
        if (sort != null) {
            searchContext.setSorts(new Sort[]{sort});
        }
        searchContext.setStart(start);
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        return searchContext;
    }

    protected File[] exportLayouts(long userGroupId, Map<String, String[]> parameterMap) throws PortalException {
        ExportImportConfiguration exportImportConfiguration;
        Map exportLayoutSettingsMap;
        File[] files = new File[2];
        UserGroup userGroup = this.userGroupPersistence.findByPrimaryKey(userGroupId);
        User user = this._userLocalService.getUser(GetterUtil.getLong((String)PrincipalThreadLocal.getName()));
        Group group = userGroup.getGroup();
        if (userGroup.hasPrivateLayouts()) {
            exportLayoutSettingsMap = ExportImportConfigurationSettingsMapFactoryUtil.buildExportLayoutSettingsMap((User)user, (long)group.getGroupId(), (boolean)true, (long[])ExportImportHelperUtil.getAllLayoutIds((long)group.getGroupId(), (boolean)true), parameterMap);
            exportImportConfiguration = this._exportImportConfigurationLocalService.addDraftExportImportConfiguration(user.getUserId(), 0, exportLayoutSettingsMap);
            files[0] = this._exportImportLocalService.exportLayoutsAsFile(exportImportConfiguration);
        }
        if (userGroup.hasPublicLayouts()) {
            exportLayoutSettingsMap = ExportImportConfigurationSettingsMapFactoryUtil.buildExportLayoutSettingsMap((User)user, (long)group.getGroupId(), (boolean)false, (long[])ExportImportHelperUtil.getAllLayoutIds((long)group.getGroupId(), (boolean)false), parameterMap);
            exportImportConfiguration = this._exportImportConfigurationLocalService.addDraftExportImportConfiguration(user.getUserId(), 0, exportLayoutSettingsMap);
            files[1] = this._exportImportLocalService.exportLayoutsAsFile(exportImportConfiguration);
        }
        return files;
    }

    protected Map<String, String[]> getLayoutTemplatesParameters() {
        return LinkedHashMapBuilder.put((Object)"DATA_STRATEGY", (Object)new String[]{"DATA_STRATEGY_MIRROR"}).put((Object)"DELETE_MISSING_LAYOUTS", (Object)new String[]{Boolean.FALSE.toString()}).put((Object)"DELETE_PORTLET_DATA", (Object)new String[]{Boolean.FALSE.toString()}).put((Object)"LAYOUT_SET_SETTINGS", (Object)new String[]{Boolean.FALSE.toString()}).put((Object)"LAYOUTS_IMPORT_MODE", (Object)new String[]{"MERGE_BY_LAYOUT_NAME"}).put((Object)"LOGO", (Object)new String[]{Boolean.FALSE.toString()}).put((Object)"PERMISSIONS", (Object)new String[]{Boolean.TRUE.toString()}).put((Object)"PORTLET_CONFIGURATION", (Object)new String[]{Boolean.TRUE.toString()}).put((Object)"PORTLET_CONFIGURATION_ALL", (Object)new String[]{Boolean.TRUE.toString()}).put((Object)"PORTLET_DATA", (Object)new String[]{Boolean.TRUE.toString()}).put((Object)"PORTLET_DATA_ALL", (Object)new String[]{Boolean.TRUE.toString()}).put((Object)"PORTLET_SETUP_ALL", (Object)new String[]{Boolean.TRUE.toString()}).put((Object)"PORTLETS_MERGE_MODE", (Object)new String[]{"ADD_TO_BOTTOM"}).put((Object)"THEME_REFERENCE", (Object)new String[]{Boolean.TRUE.toString()}).put((Object)"UPDATE_LAST_PUBLISH_DATE", (Object)new String[]{Boolean.FALSE.toString()}).put((Object)"USER_ID_STRATEGY", (Object)new String[]{"CURRENT_USER_ID"}).build();
    }

    protected void importLayouts(long userId, Map<String, String[]> parameterMap, File privateLayoutsFile, File publicLayoutsFile) throws PortalException {
        ExportImportConfiguration exportImportConfiguration;
        Map importLayoutSettingsMap;
        User user = this._userPersistence.findByPrimaryKey(userId);
        long groupId = user.getGroupId();
        if (privateLayoutsFile != null) {
            importLayoutSettingsMap = ExportImportConfigurationSettingsMapFactoryUtil.buildImportLayoutSettingsMap((User)user, (long)groupId, (boolean)true, null, parameterMap);
            exportImportConfiguration = this._exportImportConfigurationLocalService.addDraftExportImportConfiguration(user.getUserId(), 6, importLayoutSettingsMap);
            this._exportImportLocalService.importLayouts(exportImportConfiguration, privateLayoutsFile);
        }
        if (publicLayoutsFile != null) {
            importLayoutSettingsMap = ExportImportConfigurationSettingsMapFactoryUtil.buildImportLayoutSettingsMap((User)user, (long)groupId, (boolean)false, null, parameterMap);
            exportImportConfiguration = this._exportImportConfigurationLocalService.addDraftExportImportConfiguration(user.getUserId(), 6, importLayoutSettingsMap);
            this._exportImportLocalService.importLayouts(exportImportConfiguration, publicLayoutsFile);
        }
    }

    protected boolean isUseCustomSQL(LinkedHashMap<String, Object> params) {
        if (MapUtil.isEmpty(params)) {
            return false;
        }
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(UserGroup.class);
        if (!indexer.isIndexerEnabled() || !PropsValues.USER_GROUPS_SEARCH_WITH_INDEX) {
            return true;
        }
        if (MapUtil.isEmpty(params)) {
            return false;
        }
        for (String key : params.keySet()) {
            if (!ArrayUtil.contains((Object[])UserGroupFinderConstants.PARAM_KEYS, (Object)key)) continue;
            return true;
        }
        return false;
    }

    protected void reindex(long companyId, long[] userIds) throws PortalException {
        _reindexerBridge.reindex(companyId, User.class.getName(), userIds);
    }

    protected void reindexUserGroup(UserGroup userGroup) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(UserGroup.class);
        indexer.reindex((Object)userGroup);
    }

    protected void reindexUsers(List<UserGroup> userGroups) throws PortalException {
        HashMap<Long, List> map = new HashMap<Long, List>();
        for (UserGroup userGroup : userGroups) {
            List companyUserGroups = map.computeIfAbsent(userGroup.getCompanyId(), companyId -> new ArrayList());
            companyUserGroups.add(userGroup);
        }
        for (Map.Entry entry : map.entrySet()) {
            TransactionCommitCallbackUtil.registerCallback(() -> {
                LinkedHashSet<Long> userIdsSet = new LinkedHashSet<Long>();
                Iterator iterator = TransformUtil.transform((Collection)((Collection)entry.getValue()), UserGroupModel::getUserGroupId).iterator();
                while (iterator.hasNext()) {
                    long userGroupId = (Long)iterator.next();
                    for (long userId : this.getUserPrimaryKeys(userGroupId)) {
                        userIdsSet.add(userId);
                    }
                }
                if (!userIdsSet.isEmpty()) {
                    this.reindex((Long)entry.getKey(), ArrayUtil.toArray((Long[])userIdsSet.toArray(new Long[0])));
                }
                return null;
            });
        }
    }

    protected void reindexUsers(long userGroupId) throws PortalException {
        this.reindexUsers(this.getUserGroup(userGroupId));
    }

    protected void reindexUsers(long[] userGroupIds) throws PortalException {
        this.reindexUsers(TransformUtil.transformToList((long[])userGroupIds, this::getUserGroup));
    }

    protected void reindexUsers(UserGroup userGroup) throws PortalException {
        long companyId = userGroup.getCompanyId();
        long userGroupId = userGroup.getUserGroupId();
        TransactionCommitCallbackUtil.registerCallback(() -> {
            long[] userIds = this.getUserPrimaryKeys(userGroupId);
            if (ArrayUtil.isNotEmpty((long[])userIds)) {
                this.reindex(companyId, userIds);
            }
            return null;
        });
    }

    protected void validate(long userGroupId, long companyId, String name) throws PortalException {
        if (Validator.isNull((String)name) || name.indexOf(44) != -1 || name.indexOf(42) != -1) {
            throw new UserGroupNameException();
        }
        if (Validator.isNumber((String)name) && !PropsValues.USER_GROUPS_NAME_ALLOW_NUMERIC) {
            throw new UserGroupNameException();
        }
        UserGroup userGroup = this.fetchUserGroup(companyId, name);
        if (userGroup != null && userGroup.getUserGroupId() != userGroupId) {
            throw new DuplicateUserGroupException("{name=" + name + "}");
        }
    }

    private void _validateExternalReferenceCode(long userGroupId, String externalReferenceCode) throws PortalException {
        if (Validator.isNull((String)externalReferenceCode)) {
            return;
        }
        UserGroup userGroup = this.getUserGroup(userGroupId);
        if ((userGroup = this.fetchUserGroupByExternalReferenceCode(externalReferenceCode, userGroup.getCompanyId())) == null) {
            return;
        }
        if (userGroup.getUserGroupId() != userGroupId) {
            throw new DuplicateUserGroupExternalReferenceCodeException();
        }
    }
}

