/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.permission;

import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.permission.PortalPermission;
import java.util.Map;
import java.util.Objects;

public class PortalPermissionImpl
implements PortalPermission {
    public void check(PermissionChecker permissionChecker, String actionId) throws PrincipalException {
        if (!this.contains(permissionChecker, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, new String[]{"90", "90", actionId});
        }
    }

    public boolean contains(PermissionChecker permissionChecker, String actionId) {
        CacheKey cacheKey;
        Map permissionChecksMap = permissionChecker.getPermissionChecksMap();
        Boolean contains = (Boolean)permissionChecksMap.get(cacheKey = new CacheKey(actionId));
        if (contains == null) {
            contains = permissionChecker.hasPermission(null, "90", "90", actionId);
            permissionChecksMap.put(cacheKey, contains);
        }
        return contains;
    }

    private static class CacheKey {
        private final String _actionId;

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof CacheKey)) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)object;
            return Objects.equals(this._actionId, cacheKey._actionId);
        }

        public int hashCode() {
            return this._actionId.hashCode();
        }

        private CacheKey(String actionId) {
            this._actionId = actionId;
        }
    }
}

