/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet;

import com.liferay.petra.lang.CentralizedThreadLocal;
import com.liferay.portal.kernel.cookies.CookiesManagerUtil;
import com.liferay.portal.kernel.servlet.TransferHeadersHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class TransferHeadersHelperImpl
implements TransferHeadersHelper {
    private static final ThreadLocal<Boolean> _transferringHeaders = new CentralizedThreadLocal(TransferHeadersHelperImpl.class + "._transferringHeaders", () -> false);

    public RequestDispatcher getTransferHeadersRequestDispatcher(RequestDispatcher requestDispatcher) {
        return new TransferHeadersRequestDispatcher(requestDispatcher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transferHeaders(Map<String, Object[]> headers, HttpServletResponse httpServletResponse) {
        boolean transferringHeaders = _transferringHeaders.get();
        _transferringHeaders.set(true);
        try {
            for (Map.Entry<String, Object[]> entry : headers.entrySet()) {
                String[] stringValues;
                int n;
                int n2;
                String name = entry.getKey();
                Object[] values = entry.getValue();
                if (values instanceof Cookie[]) {
                    Cookie[] cookies;
                    for (Cookie cookie : cookies = (Cookie[])values) {
                        CookiesManagerUtil.addCookie((Cookie)cookie, null, (HttpServletResponse)httpServletResponse);
                    }
                    continue;
                }
                if (values instanceof Integer[]) {
                    Integer[] intValues;
                    Integer[] integerArray = intValues = (Integer[])values;
                    n2 = integerArray.length;
                    for (n = 0; n < n2; ++n) {
                        int n3 = integerArray[n];
                        if (httpServletResponse.containsHeader(name)) {
                            httpServletResponse.addIntHeader(name, n3);
                            continue;
                        }
                        httpServletResponse.setIntHeader(name, n3);
                    }
                    continue;
                }
                if (values instanceof Long[]) {
                    Long[] dateValues;
                    Long[] longArray = dateValues = (Long[])values;
                    n2 = longArray.length;
                    for (n = 0; n < n2; ++n) {
                        long l = longArray[n];
                        if (httpServletResponse.containsHeader(name)) {
                            httpServletResponse.addDateHeader(name, l);
                            continue;
                        }
                        httpServletResponse.setDateHeader(name, l);
                    }
                    continue;
                }
                if (!(values instanceof String[])) continue;
                for (String string : stringValues = (String[])values) {
                    if (httpServletResponse.containsHeader(name)) {
                        httpServletResponse.addHeader(name, string);
                        continue;
                    }
                    httpServletResponse.setHeader(name, string);
                }
            }
        }
        finally {
            _transferringHeaders.set(transferringHeaders);
        }
    }

    private class TransferHeadersServletResponse
    extends HttpServletResponseWrapper {
        private final List<HeaderAction<?>> _headerActions;
        private final HttpServletResponse _httpServletResponse;

        public void addCookie(Cookie cookie) {
            if (((Boolean)_transferringHeaders.get()).booleanValue()) {
                this._headerActions.add(new HeaderAction(cookie.getName(), cookie, false));
                return;
            }
            CookiesManagerUtil.addCookie((Cookie)cookie, null, (HttpServletResponse)this._httpServletResponse);
        }

        public void addDateHeader(String name, long value) {
            if (((Boolean)_transferringHeaders.get()).booleanValue()) {
                this._headerActions.add(new HeaderAction(name, value, false));
                return;
            }
            this._httpServletResponse.addDateHeader(name, value);
        }

        public void addHeader(String name, String value) {
            if (((Boolean)_transferringHeaders.get()).booleanValue()) {
                this._headerActions.add(new HeaderAction(name, value, false));
                return;
            }
            this._httpServletResponse.addHeader(name, value);
        }

        public void addIntHeader(String name, int value) {
            if (((Boolean)_transferringHeaders.get()).booleanValue()) {
                this._headerActions.add(new HeaderAction(name, value, false));
                return;
            }
            this._httpServletResponse.addIntHeader(name, value);
        }

        public void setDateHeader(String name, long value) {
            if (((Boolean)_transferringHeaders.get()).booleanValue()) {
                this._headerActions.add(new HeaderAction(name, value, true));
                return;
            }
            this._httpServletResponse.setDateHeader(name, value);
        }

        public void setHeader(String name, String value) {
            if (((Boolean)_transferringHeaders.get()).booleanValue()) {
                this._headerActions.add(new HeaderAction(name, value, true));
                return;
            }
            this._httpServletResponse.setHeader(name, value);
        }

        public void setIntHeader(String name, int value) {
            if (((Boolean)_transferringHeaders.get()).booleanValue()) {
                this._headerActions.add(new HeaderAction(name, value, true));
                return;
            }
            this._httpServletResponse.setIntHeader(name, value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void transferHeaders() {
            boolean transferringHeaders = (Boolean)_transferringHeaders.get();
            _transferringHeaders.set(true);
            try {
                for (HeaderAction<?> headerAction : this._headerActions) {
                    Object value = headerAction.getValue();
                    if (value instanceof Long) {
                        if (headerAction.isOverride()) {
                            this._httpServletResponse.setDateHeader(headerAction.getName(), ((Long)value).longValue());
                            continue;
                        }
                        this._httpServletResponse.addDateHeader(headerAction.getName(), ((Long)value).longValue());
                        continue;
                    }
                    if (value instanceof Cookie) {
                        CookiesManagerUtil.addCookie((Cookie)((Cookie)value), null, (HttpServletResponse)this._httpServletResponse);
                        continue;
                    }
                    if (value instanceof Integer) {
                        if (headerAction.isOverride()) {
                            this._httpServletResponse.setIntHeader(headerAction.getName(), ((Integer)value).intValue());
                            continue;
                        }
                        this._httpServletResponse.addIntHeader(headerAction.getName(), ((Integer)value).intValue());
                        continue;
                    }
                    if (headerAction.isOverride()) {
                        this._httpServletResponse.setHeader(headerAction.getName(), (String)value);
                        continue;
                    }
                    this._httpServletResponse.addHeader(headerAction.getName(), (String)value);
                }
            }
            finally {
                _transferringHeaders.set(transferringHeaders);
            }
        }

        private TransferHeadersServletResponse(HttpServletResponse httpServletResponse) {
            super(httpServletResponse);
            this._headerActions = new ArrayList();
            this._httpServletResponse = httpServletResponse;
        }
    }

    private class TransferHeadersRequestDispatcher
    implements RequestDispatcher {
        private final RequestDispatcher _requestDispatcher;

        public void forward(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
            this._requestDispatcher.forward(servletRequest, servletResponse);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void include(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
            TransferHeadersServletResponse transferHeadersServletResponse = new TransferHeadersServletResponse((HttpServletResponse)servletResponse);
            try {
                this._requestDispatcher.include(servletRequest, (ServletResponse)transferHeadersServletResponse);
            }
            finally {
                transferHeadersServletResponse.transferHeaders();
            }
        }

        private TransferHeadersRequestDispatcher(RequestDispatcher requestDispatcher) {
            this._requestDispatcher = requestDispatcher;
        }
    }

    private class HeaderAction<T> {
        private final String _name;
        private final boolean _override;
        private final T _value;

        public String getName() {
            return this._name;
        }

        public T getValue() {
            return this._value;
        }

        public boolean isOverride() {
            return this._override;
        }

        private HeaderAction(String name, T value, boolean override) {
            this._name = name;
            this._value = value;
            this._override = override;
        }
    }
}

