/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.password.modified;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.util.HttpComponentsUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.servlet.filters.BasePortalFilter;
import java.util.Date;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class PasswordModifiedFilter
extends BasePortalFilter {
    private static final Log _log = LogFactoryUtil.getLog(PasswordModifiedFilter.class);

    protected void processFilter(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws Exception {
        String requestPath = this._getRequestPath(httpServletRequest);
        if (!requestPath.equals("/c/portal/logout") && this._isPasswordModified(httpServletRequest)) {
            httpServletResponse.sendRedirect(PortalUtil.getPathMain() + "/portal/logout");
        } else {
            filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        }
    }

    private String _getRequestPath(HttpServletRequest httpServletRequest) {
        String requestURI = httpServletRequest.getRequestURI();
        String contextPath = httpServletRequest.getContextPath();
        if (Validator.isNotNull((String)contextPath) && !contextPath.equals("/")) {
            requestURI = requestURI.substring(contextPath.length());
        }
        return HttpComponentsUtil.removePathParameters((String)requestURI);
    }

    private boolean _isPasswordModified(HttpServletRequest httpServletRequest) {
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession == null || !httpServletRequest.isRequestedSessionIdValid()) {
            return false;
        }
        try {
            User user = PortalUtil.getUser((HttpServletRequest)httpServletRequest);
            if (user == null || user.isDefaultUser() || !this._isValidRealUserId(httpSession, user)) {
                return false;
            }
            Date passwordModifiedDate = user.getPasswordModifiedDate();
            if (passwordModifiedDate == null) {
                return false;
            }
            return !httpServletRequest.isRequestedSessionIdValid() || httpSession.getCreationTime() < passwordModifiedDate.getTime();
        }
        catch (PortalException portalException) {
            _log.error((Throwable)portalException);
            return false;
        }
    }

    private boolean _isValidRealUserId(HttpSession httpSession, User user) {
        Long realUserId = (Long)httpSession.getAttribute("USER_ID");
        return realUserId != null && user.getUserId() == realUserId.longValue();
    }
}

