/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.log;

import com.liferay.portal.dao.db.BaseDB;
import com.liferay.portal.kernel.dao.db.BaseDBProcess;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogContext;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.BaseUpgradeCallable;
import com.liferay.portal.kernel.upgrade.UpgradeStep;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.tools.DBUpgrader;
import com.liferay.portal.verify.VerifyProperties;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class UpgradeLogContext
implements LogContext {
    private static final UpgradeLogContext _INSTANCE = new UpgradeLogContext();
    private static final Log _log = LogFactoryUtil.getLog(UpgradeLogContext.class);
    private static final ConcurrentHashMap<String, String> _context = new ConcurrentHashMap();
    private final Class<?>[] _baseUpgradeClasses = new Class[]{BaseDB.class, BaseDBProcess.class, BaseUpgradeCallable.class, UpgradeStep.class};
    private final Map<String, String> _defaultContext = Collections.singletonMap("component", "framework");
    private final Set<String> _upgradeClassNames = SetUtil.fromArray((Object[])new String[]{DBUpgrader.class.getName(), LoggingTimer.class.getName(), VerifyProperties.class.getName(), "com.liferay.portal.upgrade.internal.registry.UpgradeStepRegistratorTracker", "com.liferay.portal.upgrade.internal.release.ReleaseManagerImpl"});

    public static void clearContext() {
        _context.clear();
    }

    public static LogContext getInstance() {
        return _INSTANCE;
    }

    public static void setContext(String component) {
        _context.put("component", component);
    }

    public Map<String, String> getContext(String logName) {
        if (this._isUpgradeClass(logName)) {
            if (_context.isEmpty()) {
                return this._defaultContext;
            }
            return _context;
        }
        return Collections.emptyMap();
    }

    public String getName() {
        return "upgrade";
    }

    private boolean _isUpgradeClass(String name) {
        block4: {
            try {
                if (this._upgradeClassNames.contains(name)) {
                    return true;
                }
                Thread thread = Thread.currentThread();
                Class<?> clazz = Class.forName(name, true, thread.getContextClassLoader());
                for (Class<?> baseClazz : this._baseUpgradeClasses) {
                    if (!baseClazz.isAssignableFrom(clazz)) continue;
                    return true;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (!_log.isDebugEnabled()) break block4;
                _log.debug((Throwable)classNotFoundException);
            }
        }
        return false;
    }
}

