/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v7_0_0;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.dao.jdbc.spring.DataSourceFactoryBean;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.util.UpgradeColumn;
import com.liferay.portal.kernel.upgrade.util.UpgradeTable;
import com.liferay.portal.kernel.upgrade.util.UpgradeTableFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.upgrade.v7_0_0.util.ClassNameTable;
import com.liferay.portal.upgrade.v7_0_0.util.ClusterGroupTable;
import com.liferay.portal.upgrade.v7_0_0.util.CompanyTable;
import com.liferay.portal.upgrade.v7_0_0.util.CounterTable;
import com.liferay.portal.upgrade.v7_0_0.util.CountryTable;
import com.liferay.portal.upgrade.v7_0_0.util.PortalPreferencesTable;
import com.liferay.portal.upgrade.v7_0_0.util.RegionTable;
import com.liferay.portal.upgrade.v7_0_0.util.ReleaseTable;
import com.liferay.portal.upgrade.v7_0_0.util.ResourceActionTable;
import com.liferay.portal.upgrade.v7_0_0.util.ServiceComponentTable;
import com.liferay.portal.upgrade.v7_0_0.util.VirtualHostTable;
import com.liferay.portal.util.PropsUtil;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;

public class UpgradeSharding
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(UpgradeSharding.class);

    protected void copyCompanyTable(Connection sourceConnection, Connection targetConnection, String shardName) throws Exception {
        this.copyControlTable(sourceConnection, targetConnection, "Company", CompanyTable.TABLE_COLUMNS, "create table Company (mvccVersion LONG default 0 not null,companyId LONG not null primary key,accountId LONG,webId VARCHAR(75) null,key_ TEXT null,mx VARCHAR(75) null,homeURL STRING null,logoId LONG,system BOOLEAN,maxUsers INTEGER,active_ BOOLEAN)");
        String companyIdsString = ListUtil.toString(this.getCompanyIds(shardName), (String)"null", (String)",");
        this.runSQL(sourceConnection, "delete from Company where companyId in (" + companyIdsString + ")");
        this.runSQL(targetConnection, "delete from Company where companyId not in (" + companyIdsString + ")");
    }

    protected void copyControlTable(Connection sourceConnection, Connection targetConnection, String tableName, Object[][] columns, String createSQL) throws Exception {
        block3: {
            try {
                if (this.hasRows(targetConnection, tableName) && _log.isWarnEnabled()) {
                    _log.warn((Object)StringBundler.concat((String[])new String[]{"Control table ", tableName, " should not contain ", "data in a nondefault shard"}));
                }
                this.dropTable(targetConnection, tableName);
            }
            catch (SQLException sqlException) {
                if (!_log.isInfoEnabled()) break block3;
                _log.info((Object)("Unable to drop control table " + tableName + " because it  does not exist in the target shard"), (Throwable)sqlException);
            }
        }
        UpgradeTable upgradeTable = UpgradeTableFactoryUtil.getUpgradeTable((String)tableName, (Object[][])columns, (UpgradeColumn[])new UpgradeColumn[0]);
        upgradeTable.setCreateSQL(createSQL);
        upgradeTable.copyTable(sourceConnection, targetConnection);
    }

    protected void copyControlTables(List<String> shardNames) throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            List uniqueShardNames = ListUtil.unique(shardNames);
            if (uniqueShardNames.size() == 1) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)"Skip copying of control tables because all companies are located in the same shard");
                }
                return;
            }
            String defaultShardName = GetterUtil.getString((String)PropsUtil.get("shard.default.name"), (String)"default");
            for (String uniqueShardName : uniqueShardNames) {
                if (uniqueShardName.equals(defaultShardName)) continue;
                this.copyControlTables(uniqueShardName);
            }
        }
    }

    protected void copyControlTables(String shardName) throws Exception {
        DataSourceFactoryBean dataSourceFactoryBean = new DataSourceFactoryBean();
        dataSourceFactoryBean.setPropertyPrefix("jdbc." + shardName + ".");
        DataSource dataSource = dataSourceFactoryBean.createInstance();
        try (Connection targetConnection = dataSource.getConnection();){
            this.copyCompanyTable(this.connection, targetConnection, shardName);
            this.copyControlTable(this.connection, targetConnection, "ClassName_", ClassNameTable.TABLE_COLUMNS, "create table ClassName_ (mvccVersion LONG default 0 not null,classNameId LONG not null primary key,value VARCHAR(200) null)");
            this.copyControlTable(this.connection, targetConnection, "ClusterGroup", ClusterGroupTable.TABLE_COLUMNS, "create table ClusterGroup (mvccVersion LONG default 0 not null,clusterGroupId LONG not null primary key,name VARCHAR(75) null,clusterNodeIds VARCHAR(75) null,wholeCluster BOOLEAN)");
            this.copyControlTable(this.connection, targetConnection, "Counter", CounterTable.TABLE_COLUMNS, "create table Counter (name VARCHAR(75) not null primary key,currentId LONG)");
            this.copyControlTable(this.connection, targetConnection, "Country", CountryTable.TABLE_COLUMNS, "create table Country (mvccVersion LONG default 0 not null,countryId LONG not null primary key,name VARCHAR(75) null,a2 VARCHAR(75) null,a3 VARCHAR(75) null,number_ VARCHAR(75) null,idd_ VARCHAR(75) null,zipRequired BOOLEAN,active_ BOOLEAN)");
            this.copyControlTable(this.connection, targetConnection, "PortalPreferences", PortalPreferencesTable.TABLE_COLUMNS, "create table PortalPreferences (mvccVersion LONG default 0 not null,portalPreferencesId LONG not null primary key,ownerId LONG,ownerType INTEGER,preferences TEXT null)");
            this.copyControlTable(this.connection, targetConnection, "Region", RegionTable.TABLE_COLUMNS, "create table Region (mvccVersion LONG default 0 not null,regionId LONG not null primary key,countryId LONG,regionCode VARCHAR(75) null,name VARCHAR(75) null,active_ BOOLEAN)");
            this.copyControlTable(this.connection, targetConnection, "Release_", ReleaseTable.TABLE_COLUMNS, "create table Release_ (mvccVersion LONG default 0 not null,releaseId LONG not null primary key,createDate DATE null,modifiedDate DATE null,servletContextName VARCHAR(75) null,schemaVersion VARCHAR(75) null,buildNumber INTEGER,buildDate DATE null,verified BOOLEAN,state_ INTEGER,testString VARCHAR(1024) null)");
            this.copyControlTable(this.connection, targetConnection, "ResourceAction", ResourceActionTable.TABLE_COLUMNS, "create table ResourceAction (mvccVersion LONG default 0 not null,resourceActionId LONG not null primary key,name VARCHAR(255) null,actionId VARCHAR(75) null,bitwiseValue LONG)");
            this.copyControlTable(this.connection, targetConnection, "ServiceComponent", ServiceComponentTable.TABLE_COLUMNS, "create table ServiceComponent (mvccVersion LONG default 0 not null,serviceComponentId LONG not null primary key,buildNamespace VARCHAR(75) null,buildNumber LONG,buildDate LONG,data_ TEXT null)");
            this.copyControlTable(this.connection, targetConnection, "VirtualHost", VirtualHostTable.TABLE_COLUMNS, "create table VirtualHost (mvccVersion LONG default 0 not null,virtualHostId LONG not null primary key,companyId LONG,layoutSetId LONG,hostname VARCHAR(75) null)");
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to copy control tables", (Throwable)exception);
        }
    }

    protected void doUpgrade() throws Exception {
        List<String> shardNames = this.getShardNames();
        if (shardNames.size() <= 1) {
            return;
        }
        this.copyControlTables(shardNames);
    }

    protected void dropTable(Connection connection, String tableName) throws IOException, SQLException {
        this.runSQL(connection, "DROP_TABLE_IF_EXISTS(" + tableName + ")");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Deleted table " + tableName));
        }
    }

    /*
     * Exception decompiling
     */
    protected List<Long> getCompanyIds(String shardName) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    protected List<String> getShardNames() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

