/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v7_4_x;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.UpgradeProcessFactory;
import com.liferay.portal.kernel.upgrade.UpgradeStep;
import com.liferay.portal.kernel.util.PortalUtil;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

public class UpgradeAccount
extends UpgradeProcess {
    private static final String _CLASS_NAME_ACCOUNT = "com.liferay.portal.kernel.model.Account";

    protected void doUpgrade() throws Exception {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("update ListType set type_ = ? where type_ = ?");){
            for (String typeName : new String[]{"address", "emailAddress", "phone", "website"}) {
                preparedStatement.setString(1, Company.class.getName() + "." + typeName);
                preparedStatement.setString(2, "com.liferay.portal.kernel.model.Account." + typeName);
                preparedStatement.addBatch();
            }
            preparedStatement.executeBatch();
        }
        long accountClassNameId = PortalUtil.getClassNameId((String)_CLASS_NAME_ACCOUNT);
        long companyClassNameId = PortalUtil.getClassNameId(Company.class);
        String updateCompanySQL = StringBundler.concat((String[])new String[]{"update Company set userId = ?, userName = ?, createDate = ?, ", "modifiedDate = ?, name = ?, legalName = ?, legalId = ?, ", "legalType = ?, sicCode = ?, tickerSymbol = ?, industry = ?, ", "type_ = ?, size_ = ? where companyId = ?"});
        try (Statement selectAccountsStatement = this.connection.createStatement();
             PreparedStatement updateCompanyPreparedStatement = this.connection.prepareStatement(updateCompanySQL);
             PreparedStatement updateAddressPreparedStatement = this.connection.prepareStatement(this._getUpdateClassNameIdClassPKSQL("Address"));
             PreparedStatement updateEmailAddressPreparedStatement = this.connection.prepareStatement(this._getUpdateClassNameIdClassPKSQL("EmailAddress"));
             PreparedStatement updatePhonePreparedStatement = this.connection.prepareStatement(this._getUpdateClassNameIdClassPKSQL("Phone"));
             PreparedStatement updateWebsitePreparedStatement = this.connection.prepareStatement(this._getUpdateClassNameIdClassPKSQL("Website"));){
            try (ResultSet resultSet = selectAccountsStatement.executeQuery("select * from Account_");){
                while (resultSet.next()) {
                    updateCompanyPreparedStatement.setLong(1, resultSet.getLong("userId"));
                    updateCompanyPreparedStatement.setString(2, resultSet.getString("userName"));
                    updateCompanyPreparedStatement.setDate(3, resultSet.getDate("createDate"));
                    updateCompanyPreparedStatement.setDate(4, resultSet.getDate("modifiedDate"));
                    updateCompanyPreparedStatement.setString(5, resultSet.getString("name"));
                    updateCompanyPreparedStatement.setString(6, resultSet.getString("legalName"));
                    updateCompanyPreparedStatement.setString(7, resultSet.getString("legalId"));
                    updateCompanyPreparedStatement.setString(8, resultSet.getString("legalType"));
                    updateCompanyPreparedStatement.setString(9, resultSet.getString("sicCode"));
                    updateCompanyPreparedStatement.setString(10, resultSet.getString("tickerSymbol"));
                    updateCompanyPreparedStatement.setString(11, resultSet.getString("industry"));
                    updateCompanyPreparedStatement.setString(12, resultSet.getString("type_"));
                    updateCompanyPreparedStatement.setString(13, resultSet.getString("size_"));
                    updateCompanyPreparedStatement.setLong(14, resultSet.getLong("companyId"));
                    updateCompanyPreparedStatement.addBatch();
                    for (PreparedStatement preparedStatement : new PreparedStatement[]{updateAddressPreparedStatement, updateEmailAddressPreparedStatement, updatePhonePreparedStatement, updateWebsitePreparedStatement}) {
                        preparedStatement.setLong(1, companyClassNameId);
                        preparedStatement.setLong(2, resultSet.getLong("companyId"));
                        preparedStatement.setLong(3, accountClassNameId);
                        preparedStatement.setLong(4, resultSet.getLong("accountId"));
                        preparedStatement.addBatch();
                    }
                }
            }
            updateCompanyPreparedStatement.executeBatch();
            updateAddressPreparedStatement.executeBatch();
            updateEmailAddressPreparedStatement.executeBatch();
            updatePhonePreparedStatement.executeBatch();
            updateWebsitePreparedStatement.executeBatch();
        }
        this.runSQL("delete from ClassName_ where value = 'com.liferay.portal.kernel.model.Account'");
    }

    protected UpgradeStep[] getPostUpgradeSteps() {
        return new UpgradeStep[]{UpgradeProcessFactory.dropTables((String[])new String[]{"Account_"})};
    }

    protected UpgradeStep[] getPreUpgradeSteps() {
        return new UpgradeStep[]{UpgradeProcessFactory.addColumns((String)"Company", (String[])new String[]{"userId LONG", "userName VARCHAR(75) null", "createDate DATE null", "modifiedDate DATE null", "name VARCHAR(75) null", "legalName VARCHAR(75) null", "legalId VARCHAR(75) null", "legalType VARCHAR(75) null", "sicCode VARCHAR(75) null", "tickerSymbol VARCHAR(75) null", "industry VARCHAR(75) null", "type_ VARCHAR(75) null", "size_ VARCHAR(75) null"}), UpgradeProcessFactory.dropColumns((String)"Company", (String[])new String[]{"accountId"}), UpgradeProcessFactory.dropColumns((String)"Contact", (String[])new String[]{"accountId"})};
    }

    private String _getUpdateClassNameIdClassPKSQL(String tableName) {
        return StringBundler.concat((String[])new String[]{"update ", tableName, " set classNameId = ?, classPK = ? where ", "classNameId = ? and classPK = ?"});
    }
}

