/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.permission;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.WorkflowInstanceLink;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.WorkflowInstanceLinkLocalServiceUtil;
import com.liferay.portal.kernel.workflow.WorkflowException;
import com.liferay.portal.kernel.workflow.WorkflowInstance;
import com.liferay.portal.kernel.workflow.WorkflowInstanceManagerUtil;
import com.liferay.portal.kernel.workflow.WorkflowTaskManagerUtil;
import com.liferay.portal.kernel.workflow.permission.WorkflowPermission;
import java.util.Objects;

public class WorkflowPermissionImpl
implements WorkflowPermission {
    private static final Log _log = LogFactoryUtil.getLog(WorkflowPermissionImpl.class);

    public Boolean hasPermission(PermissionChecker permissionChecker, long groupId, String className, long classPK, String actionId) {
        try {
            return this.doHasPermission(permissionChecker, groupId, className, classPK, actionId);
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            return null;
        }
    }

    protected Boolean doHasPermission(PermissionChecker permissionChecker, long groupId, String className, long classPK, String actionId) throws Exception {
        long companyId = permissionChecker.getCompanyId();
        if (permissionChecker.isContentReviewer(companyId, groupId)) {
            return Boolean.TRUE;
        }
        if (WorkflowInstanceLinkLocalServiceUtil.hasWorkflowInstanceLink((long)companyId, (long)groupId, (String)className, (long)classPK)) {
            WorkflowInstanceLink workflowInstanceLink = WorkflowInstanceLinkLocalServiceUtil.getWorkflowInstanceLink((long)companyId, (long)groupId, (String)className, (long)classPK);
            if (Objects.equals(actionId, "VIEW") && permissionChecker.getUserId() == workflowInstanceLink.getUserId()) {
                return Boolean.TRUE;
            }
            WorkflowInstance workflowInstance = WorkflowInstanceManagerUtil.getWorkflowInstance((long)companyId, (long)workflowInstanceLink.getWorkflowInstanceId());
            if (workflowInstance.isComplete()) {
                return null;
            }
            boolean hasPermission = this.hasImplicitPermission(permissionChecker, workflowInstance);
            if (!hasPermission && actionId.equals("VIEW")) {
                return null;
            }
            return hasPermission;
        }
        return null;
    }

    protected boolean hasImplicitPermission(PermissionChecker permissionChecker, WorkflowInstance workflowInstance) throws WorkflowException {
        int count = WorkflowTaskManagerUtil.getWorkflowTaskCountByWorkflowInstance((long)permissionChecker.getCompanyId(), (Long)permissionChecker.getUserId(), (long)workflowInstance.getWorkflowInstanceId(), (Boolean)Boolean.FALSE);
        if (count > 0) {
            return true;
        }
        count = WorkflowTaskManagerUtil.getWorkflowTaskCountByUserRoles((long)permissionChecker.getCompanyId(), (long)permissionChecker.getUserId(), (long)workflowInstance.getWorkflowInstanceId(), (Boolean)Boolean.FALSE);
        return count > 0;
    }
}

