/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.petra.lang.HashUtil;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.service.PortletPreferencesLocalServiceUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.xml.simple.Element;
import com.liferay.portlet.Preference;
import com.liferay.portlet.PreferencesValueUtil;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.portlet.PortletPreferences;
import javax.portlet.PreferencesValidator;
import javax.portlet.ReadOnlyException;
import javax.portlet.ValidatorException;

public class PortletPreferencesImpl
implements Cloneable,
PortletPreferences,
Serializable {
    private static final Log _log = LogFactoryUtil.getLog(PortletPreferencesImpl.class);
    private final long _companyId;
    private PortletPreferences _defaultPreferences;
    private Map<String, Preference> _modifiedPreferences;
    private final Map<String, Preference> _originalPreferences;
    private final String _originalXML;
    private final long _ownerId;
    private final int _ownerType;
    private long _plid;
    private final String _portletId;

    public PortletPreferencesImpl() {
        this(0L, 0L, 0, 0L, null, null, Collections.emptyMap());
    }

    public PortletPreferencesImpl(long companyId, long ownerId, int ownerType, long plid, String portletId, String xml, Map<String, Preference> preferences) {
        this._companyId = companyId;
        this._ownerId = ownerId;
        this._ownerType = ownerType;
        this._plid = plid;
        this._portletId = portletId;
        this._originalXML = xml;
        this._originalPreferences = preferences;
    }

    public PortletPreferencesImpl(String xml, Map<String, Preference> preferences) {
        this(0L, 0L, 0, 0L, null, xml, preferences);
    }

    public Object clone() {
        return new PortletPreferencesImpl(this.getCompanyId(), this.getOwnerId(), this.getOwnerType(), this._plid, this._portletId, this.getOriginalXML(), this.getOriginalPreferences());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PortletPreferencesImpl)) {
            return false;
        }
        PortletPreferencesImpl portletPreferencesImpl = (PortletPreferencesImpl)object;
        return this.getCompanyId() == portletPreferencesImpl.getCompanyId() && this.getOwnerId() == portletPreferencesImpl.getOwnerId() && this.getOwnerType() == portletPreferencesImpl.getOwnerType() && this.getPlid() == portletPreferencesImpl.getPlid() && Objects.equals(this.getPortletId(), portletPreferencesImpl.getPortletId()) && Objects.equals(this.getPreferences(), portletPreferencesImpl.getPreferences());
    }

    public Map<String, String[]> getMap() {
        Map<String, Preference> preferences = this.getPreferences();
        if (preferences.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        for (Map.Entry<String, Preference> entry : preferences.entrySet()) {
            Preference preference = entry.getValue();
            map.put(entry.getKey(), PreferencesValueUtil.getActualValues(preference.getValues()));
        }
        return map;
    }

    public Enumeration<String> getNames() {
        Map<String, Preference> preferences = this.getPreferences();
        return Collections.enumeration(preferences.keySet());
    }

    public long getOwnerId() {
        return this._ownerId;
    }

    public int getOwnerType() {
        return this._ownerType;
    }

    public long getPlid() {
        return this._plid;
    }

    public Map<String, Preference> getPreferences() {
        if (this._modifiedPreferences != null) {
            return this._modifiedPreferences;
        }
        return this._originalPreferences;
    }

    public String getValue(String key, String def) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        Map<String, Preference> preferences = this.getPreferences();
        Preference preference = preferences.get(key);
        if (preference == null) {
            return def;
        }
        String[] values = preference.getValues();
        if (PreferencesValueUtil.isNull(values)) {
            return def;
        }
        return PreferencesValueUtil.getActualValue(values[0]);
    }

    public String[] getValues(String key, String[] def) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        Map<String, Preference> preferences = this.getPreferences();
        Preference preference = preferences.get(key);
        if (preference == null) {
            return def;
        }
        String[] values = preference.getValues();
        if (PreferencesValueUtil.isNull(values)) {
            return def;
        }
        return PreferencesValueUtil.getActualValues(values);
    }

    public int hashCode() {
        int hashCode = HashUtil.hash((int)0, (long)this.getCompanyId());
        hashCode = HashUtil.hash((int)hashCode, (long)this.getOwnerId());
        hashCode = HashUtil.hash((int)hashCode, (int)this.getOwnerType());
        hashCode = HashUtil.hash((int)hashCode, (long)this.getPlid());
        hashCode = HashUtil.hash((int)hashCode, (Object)this.getPortletId());
        hashCode = HashUtil.hash((int)hashCode, this.getPreferences());
        return hashCode;
    }

    public boolean isReadOnly(String key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        Map<String, Preference> preferences = this.getPreferences();
        Preference preference = preferences.get(key);
        return preference != null && preference.isReadOnly();
    }

    public void reset(String key) throws ReadOnlyException {
        block7: {
            if (this.isReadOnly(key)) {
                throw new ReadOnlyException(key);
            }
            if (this._defaultPreferences == null && this._portletId != null) {
                try {
                    this._defaultPreferences = PortletPreferencesLocalServiceUtil.getDefaultPreferences((long)this._companyId, (String)this._portletId);
                }
                catch (Exception exception) {
                    if (!_log.isWarnEnabled()) break block7;
                    _log.warn((Throwable)exception);
                }
            }
        }
        String[] defaultValues = null;
        if (this._defaultPreferences != null) {
            defaultValues = this._defaultPreferences.getValues(key, defaultValues);
        }
        if (defaultValues != null) {
            this.setValues(key, defaultValues);
        } else {
            Map<String, Preference> modifiedPreferences = this.getModifiedPreferences();
            modifiedPreferences.remove(key);
        }
    }

    public void setPlid(long plid) {
        this._plid = plid;
    }

    public void setValue(String key, String value) throws ReadOnlyException {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        value = PreferencesValueUtil.getXMLSafeValue(value);
        Map<String, Preference> modifiedPreferences = this.getModifiedPreferences();
        Preference preference = modifiedPreferences.get(key);
        if (preference != null && preference.isReadOnly()) {
            throw new ReadOnlyException(key);
        }
        modifiedPreferences.put(key, new Preference(key, value));
    }

    public void setValues(String key, String ... values) throws ReadOnlyException {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        values = PreferencesValueUtil.getXMLSafeValues(values);
        Map<String, Preference> modifiedPreferences = this.getModifiedPreferences();
        Preference preference = modifiedPreferences.get(key);
        if (preference != null && preference.isReadOnly()) {
            throw new ReadOnlyException(key);
        }
        modifiedPreferences.put(key, new Preference(key, values));
    }

    public int size() {
        Map<String, Preference> preferences = this.getPreferences();
        return preferences.size();
    }

    public void store() throws IOException, ValidatorException {
        if (this._portletId == null) {
            throw new UnsupportedOperationException();
        }
        try {
            PreferencesValidator preferencesValidator;
            Portlet portlet = PortletLocalServiceUtil.getPortletById((long)this._companyId, (String)this._portletId);
            if (portlet != null && (preferencesValidator = PortalUtil.getPreferencesValidator((Portlet)portlet)) != null) {
                preferencesValidator.validate((PortletPreferences)this);
            }
            PortletPreferencesLocalServiceUtil.updatePreferences((long)this.getOwnerId(), (int)this.getOwnerType(), (long)this._plid, (String)this._portletId, (PortletPreferences)this);
        }
        catch (SystemException systemException) {
            throw new IOException(systemException);
        }
    }

    protected long getCompanyId() {
        return this._companyId;
    }

    protected Map<String, Preference> getModifiedPreferences() {
        if (this._modifiedPreferences == null) {
            this._modifiedPreferences = new ConcurrentHashMap<String, Preference>(this._originalPreferences);
        }
        return this._modifiedPreferences;
    }

    protected Map<String, Preference> getOriginalPreferences() {
        return this._originalPreferences;
    }

    protected String getOriginalXML() {
        return this._originalXML;
    }

    protected String getPortletId() {
        return this._portletId;
    }

    protected String toXML() {
        if (this._modifiedPreferences == null && this._originalXML != null) {
            return this._originalXML;
        }
        Map<String, Preference> preferences = this.getPreferences();
        if (preferences == null || preferences.isEmpty()) {
            return "<portlet-preferences />";
        }
        Element portletPreferencesElement = new Element("portlet-preferences", false);
        for (Map.Entry<String, Preference> entry : preferences.entrySet()) {
            Preference preference = entry.getValue();
            Element preferenceElement = portletPreferencesElement.addElement("preference");
            preferenceElement.addElement("name", preference.getName());
            for (String value : preference.getValues()) {
                preferenceElement.addElement("value", value);
            }
            if (!preference.isReadOnly()) continue;
            preferenceElement.addElement("read-only", (Object)Boolean.TRUE);
        }
        return portletPreferencesElement.toXMLString();
    }
}

