/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.impl;

import com.liferay.document.library.kernel.exception.FileEntryLockException;
import com.liferay.document.library.kernel.exception.NoSuchFileEntryException;
import com.liferay.document.library.kernel.model.DLVersionNumberIncrease;
import com.liferay.document.library.kernel.service.DLAppHelperLocalService;
import com.liferay.document.library.kernel.util.DLAppHelperThreadLocal;
import com.liferay.document.library.kernel.util.DLProcessorRegistryUtil;
import com.liferay.document.library.kernel.util.comparator.FolderNameComparator;
import com.liferay.document.library.kernel.util.comparator.RepositoryModelModifiedDateComparator;
import com.liferay.document.library.kernel.util.comparator.RepositoryModelTitleComparator;
import com.liferay.petra.function.UnsafeRunnable;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.cache.thread.local.ThreadLocalCachable;
import com.liferay.portal.kernel.exception.NoSuchGroupException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.lock.Lock;
import com.liferay.portal.kernel.lock.LockManagerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.repository.InvalidRepositoryIdException;
import com.liferay.portal.kernel.repository.RepositoryException;
import com.liferay.portal.kernel.repository.RepositoryProvider;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileShortcut;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.repository.model.RepositoryEntry;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionFactory;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionUtil;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermissionFactory;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.persistence.RepositoryPersistence;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.TempFileEntryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.repository.temporaryrepository.TemporaryFileEntryRepository;
import com.liferay.portlet.documentlibrary.service.base.DLAppServiceBaseImpl;
import com.liferay.portlet.documentlibrary.util.DLAppUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public class DLAppServiceImpl
extends DLAppServiceBaseImpl {
    @BeanReference(type=RepositoryProvider.class)
    protected RepositoryProvider repositoryProvider;
    private static final Log _log = LogFactoryUtil.getLog(DLAppServiceImpl.class);
    private static volatile ModelResourcePermission<Folder> _folderModelResourcePermission = ModelResourcePermissionFactory.getInstance(DLAppServiceImpl.class, (String)"_folderModelResourcePermission", Folder.class);
    private static volatile PortletResourcePermission _portletResourcePermission = PortletResourcePermissionFactory.getInstance(DLAppServiceImpl.class, (String)"_portletResourcePermission", (String)"com.liferay.document.library");
    @BeanReference(type=DLAppHelperLocalService.class)
    private DLAppHelperLocalService _dlAppHelperLocalService;
    @BeanReference(type=RepositoryPersistence.class)
    private RepositoryPersistence _repositoryPersistence;

    @Deprecated
    public FileEntry addFileEntry(long repositoryId, long folderId, String sourceFileName, String mimeType, String title, String description, String changeLog, File file, ServiceContext serviceContext) throws PortalException {
        return this.addFileEntry(null, repositoryId, folderId, sourceFileName, mimeType, title, "", description, changeLog, file, null, null, serviceContext);
    }

    public FileEntry addFileEntry(String externalReferenceCode, long repositoryId, long folderId, String sourceFileName, String mimeType, String title, String urlTitle, String description, String changeLog, byte[] bytes, Date expirationDate, Date reviewDate, ServiceContext serviceContext) throws PortalException {
        FileEntry fileEntry;
        File file = null;
        try {
            if (ArrayUtil.isNotEmpty((byte[])bytes)) {
                file = FileUtil.createTempFile((byte[])bytes);
            }
            fileEntry = this.addFileEntry(externalReferenceCode, repositoryId, folderId, sourceFileName, mimeType, title, urlTitle, description, changeLog, file, expirationDate, reviewDate, serviceContext);
        }
        catch (IOException ioException) {
            try {
                throw new SystemException("Unable to write temporary file", (Throwable)ioException);
            }
            catch (Throwable throwable) {
                FileUtil.delete(file);
                throw throwable;
            }
        }
        FileUtil.delete((File)file);
        return fileEntry;
    }

    public FileEntry addFileEntry(String externalReferenceCode, long repositoryId, long folderId, String sourceFileName, String mimeType, String title, String urlTitle, String description, String changeLog, File file, Date expirationDate, Date reviewDate, ServiceContext serviceContext) throws PortalException {
        if (file == null || !file.exists() || file.length() == 0L) {
            return this.addFileEntry(externalReferenceCode, repositoryId, folderId, sourceFileName, mimeType, title, urlTitle, description, changeLog, null, 0L, expirationDate, reviewDate, serviceContext);
        }
        mimeType = DLAppUtil.getMimeType(sourceFileName, mimeType, title, file);
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(repositoryId);
        return repository.addFileEntry(externalReferenceCode, this.getUserId(), folderId, sourceFileName, mimeType, title, urlTitle, description, changeLog, file, expirationDate, reviewDate, serviceContext);
    }

    public FileEntry addFileEntry(String externalReferenceCode, long repositoryId, long folderId, String sourceFileName, String mimeType, String title, String urlTitle, String description, String changeLog, InputStream inputStream, long size, Date expirationDate, Date reviewDate, ServiceContext serviceContext) throws PortalException {
        if (inputStream == null) {
            inputStream = new UnsyncByteArrayInputStream(new byte[0]);
            size = 0L;
        }
        if (Validator.isNull((String)mimeType) || mimeType.equals("application/octet-stream")) {
            if (size == 0L) {
                mimeType = MimeTypesUtil.getExtensionContentType((String)DLAppUtil.getExtension(title, sourceFileName));
            } else {
                File file = null;
                try {
                    file = FileUtil.createTempFile((InputStream)inputStream);
                    FileEntry fileEntry = this.addFileEntry(externalReferenceCode, repositoryId, folderId, sourceFileName, mimeType, title, urlTitle, description, changeLog, file, expirationDate, reviewDate, serviceContext);
                    return fileEntry;
                }
                catch (IOException ioException) {
                    throw new SystemException("Unable to write temporary file", (Throwable)ioException);
                }
                finally {
                    FileUtil.delete((File)file);
                }
            }
        }
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(repositoryId);
        return repository.addFileEntry(externalReferenceCode, this.getUserId(), folderId, sourceFileName, mimeType, title, urlTitle, description, changeLog, inputStream, size, expirationDate, reviewDate, serviceContext);
    }

    public FileShortcut addFileShortcut(long repositoryId, long folderId, long toFileEntryId, ServiceContext serviceContext) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(repositoryId);
        return repository.addFileShortcut(this.getUserId(), folderId, toFileEntryId, serviceContext);
    }

    public Folder addFolder(String externalReferenceCode, long repositoryId, long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(repositoryId);
        Folder folder = repository.addFolder(externalReferenceCode, this.getUserId(), parentFolderId, name, description, serviceContext);
        this._dlAppHelperLocalService.addFolder(this.getUserId(), folder, serviceContext);
        return folder;
    }

    public FileEntry addTempFileEntry(long groupId, long folderId, String folderName, String fileName, File file, String mimeType) throws PortalException {
        ModelResourcePermissionUtil.check(_folderModelResourcePermission, (PermissionChecker)this.getPermissionChecker(), (long)groupId, (long)folderId, (String)"ADD_DOCUMENT");
        return TempFileEntryUtil.addTempFileEntry((long)groupId, (long)this.getUserId(), (String)folderName, (String)fileName, (File)file, (String)mimeType);
    }

    public FileEntry addTempFileEntry(long groupId, long folderId, String folderName, String fileName, InputStream inputStream, String mimeType) throws PortalException {
        ModelResourcePermissionUtil.check(_folderModelResourcePermission, (PermissionChecker)this.getPermissionChecker(), (long)groupId, (long)folderId, (String)"ADD_DOCUMENT");
        return TempFileEntryUtil.addTempFileEntry((long)groupId, (long)this.getUserId(), (String)folderName, (String)fileName, (InputStream)inputStream, (String)mimeType);
    }

    public void cancelCheckOut(long fileEntryId) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.repositoryProvider.getFileEntryRepository(fileEntryId);
        FileEntry fileEntry = repository.getFileEntry(fileEntryId);
        FileVersion draftFileVersion = repository.cancelCheckOut(fileEntryId);
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setWorkflowAction(1);
        this._dlAppHelperLocalService.cancelCheckOut(this.getUserId(), fileEntry, null, fileEntry.getFileVersion(), draftFileVersion, serviceContext);
    }

    public void checkInFileEntry(long fileEntryId, DLVersionNumberIncrease dlVersionNumberIncrease, String changeLog, ServiceContext serviceContext) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.repositoryProvider.getFileEntryRepository(fileEntryId);
        repository.checkInFileEntry(this.getUserId(), fileEntryId, dlVersionNumberIncrease, changeLog, serviceContext);
        FileEntry fileEntry = repository.getFileEntry(fileEntryId);
        FileVersion fileVersion = fileEntry.getLatestFileVersion();
        this._dlAppHelperLocalService.updateFileEntry(this.getUserId(), fileEntry, null, fileVersion, fileVersion.getFileVersionId());
    }

    public void checkInFileEntry(long fileEntryId, String lockUuid, ServiceContext serviceContext) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.repositoryProvider.getFileEntryRepository(fileEntryId);
        repository.checkInFileEntry(this.getUserId(), fileEntryId, lockUuid, serviceContext);
        FileEntry fileEntry = repository.getFileEntry(fileEntryId);
        FileVersion fileVersion = fileEntry.getLatestFileVersion();
        this._dlAppHelperLocalService.updateFileEntry(this.getUserId(), fileEntry, null, fileVersion, fileVersion.getFileVersionId());
    }

    public void checkOutFileEntry(long fileEntryId, ServiceContext serviceContext) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.repositoryProvider.getFileEntryRepository(fileEntryId);
        FileEntry fileEntry = repository.checkOutFileEntry(fileEntryId, serviceContext);
        FileVersion fileVersion = fileEntry.getLatestFileVersion();
        this._dlAppHelperLocalService.updateFileEntry(this.getUserId(), fileEntry, null, fileVersion, fileEntryId);
    }

    public FileEntry checkOutFileEntry(long fileEntryId, String owner, long expirationTime, ServiceContext serviceContext) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.repositoryProvider.getFileEntryRepository(fileEntryId);
        FileEntry fileEntry = repository.checkOutFileEntry(fileEntryId, owner, expirationTime, serviceContext);
        FileVersion fileVersion = fileEntry.getLatestFileVersion();
        this._dlAppHelperLocalService.updateFileEntry(this.getUserId(), fileEntry, null, fileVersion, fileEntryId);
        return fileEntry;
    }

    public Folder copyFolder(long repositoryId, long sourceFolderId, long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(repositoryId);
        Folder srcFolder = repository.getFolder(sourceFolderId);
        Folder destFolder = repository.addFolder(null, this.getUserId(), parentFolderId, name, description, serviceContext);
        this._dlAppHelperLocalService.addFolder(this.getUserId(), destFolder, serviceContext);
        this.copyFolder(repository, srcFolder, destFolder, serviceContext);
        return destFolder;
    }

    public void deleteFileEntry(long fileEntryId) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.repositoryProvider.getFileEntryRepository(fileEntryId);
        this._dlAppHelperLocalService.deleteFileEntry(repository.getFileEntry(fileEntryId));
        repository.deleteFileEntry(fileEntryId);
    }

    public void deleteFileEntryByTitle(long repositoryId, long folderId, String title) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(repositoryId);
        this._dlAppHelperLocalService.deleteFileEntry(repository.getFileEntry(folderId, title));
        repository.deleteFileEntry(folderId, title);
    }

    public void deleteFileShortcut(long fileShortcutId) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.repositoryProvider.getFileShortcutRepository(fileShortcutId);
        repository.deleteFileShortcut(fileShortcutId);
    }

    public void deleteFileVersion(long fileVersionId) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.repositoryProvider.getFileVersionRepository(fileVersionId);
        repository.deleteFileVersion(fileVersionId);
    }

    public void deleteFileVersion(long fileEntryId, String version) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.repositoryProvider.getFileEntryRepository(fileEntryId);
        repository.deleteFileVersion(fileEntryId, version);
    }

    public void deleteFolder(long folderId) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.repositoryProvider.getFolderRepository(folderId);
        Folder folder = repository.getFolder(folderId);
        List fileEntries = repository.getRepositoryFileEntries(0L, folderId, -1, -1, null);
        for (FileEntry fileEntry : fileEntries) {
            this._dlAppHelperLocalService.deleteFileEntry(fileEntry);
        }
        repository.deleteFolder(folderId);
        this._dlAppHelperLocalService.deleteFolder(folder);
    }

    public void deleteFolder(long repositoryId, long parentFolderId, String name) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(repositoryId);
        repository.deleteFolder(parentFolderId, name);
    }

    public void deleteTempFileEntry(long groupId, long folderId, String folderName, String fileName) throws PortalException {
        ModelResourcePermissionUtil.check(_folderModelResourcePermission, (PermissionChecker)this.getPermissionChecker(), (long)groupId, (long)folderId, (String)"ADD_DOCUMENT");
        TempFileEntryUtil.deleteTempFileEntry((long)groupId, (long)this.getUserId(), (String)folderName, (String)fileName);
    }

    public List<FileEntry> getFileEntries(long repositoryId, long folderId) throws PortalException {
        return this.getFileEntries(repositoryId, folderId, -1, -1);
    }

    public List<FileEntry> getFileEntries(long repositoryId, long folderId, int start, int end) throws PortalException {
        return this.getFileEntries(repositoryId, folderId, start, end, (OrderByComparator<FileEntry>)new RepositoryModelTitleComparator(true));
    }

    public List<FileEntry> getFileEntries(long repositoryId, long folderId, int start, int end, OrderByComparator<FileEntry> orderByComparator) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(repositoryId);
        return repository.getFileEntries(folderId, start, end, orderByComparator);
    }

    public List<FileEntry> getFileEntries(long repositoryId, long folderId, long fileEntryTypeId) throws PortalException {
        return this.getFileEntries(repositoryId, folderId, fileEntryTypeId, -1, -1);
    }

    public List<FileEntry> getFileEntries(long repositoryId, long folderId, long fileEntryTypeId, int start, int end) throws PortalException {
        return this.getFileEntries(repositoryId, folderId, fileEntryTypeId, start, end, (OrderByComparator<FileEntry>)new RepositoryModelTitleComparator(true));
    }

    public List<FileEntry> getFileEntries(long repositoryId, long folderId, long fileEntryTypeId, int start, int end, OrderByComparator<FileEntry> orderByComparator) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(repositoryId);
        return repository.getFileEntries(folderId, fileEntryTypeId, start, end, orderByComparator);
    }

    public List<FileEntry> getFileEntries(long repositoryId, long folderId, String[] mimeTypes) throws PortalException {
        return this.getFileEntries(repositoryId, folderId, mimeTypes, -1, -1, (OrderByComparator<FileEntry>)new RepositoryModelTitleComparator(true));
    }

    public List<FileEntry> getFileEntries(long repositoryId, long folderId, String[] mimeTypes, int start, int end, OrderByComparator<FileEntry> orderByComparator) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(repositoryId);
        return repository.getFileEntries(folderId, mimeTypes, start, end, orderByComparator);
    }

    public List<Object> getFileEntriesAndFileShortcuts(long repositoryId, long folderId, int status, int start, int end) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(repositoryId);
        return repository.getFileEntriesAndFileShortcuts(folderId, status, start, end);
    }

    public int getFileEntriesAndFileShortcutsCount(long repositoryId, long folderId, int status) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(repositoryId);
        return repository.getFileEntriesAndFileShortcutsCount(folderId, status);
    }

    public int getFileEntriesAndFileShortcutsCount(long repositoryId, long folderId, int status, String[] mimeTypes) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(repositoryId);
        return repository.getFileEntriesAndFileShortcutsCount(folderId, status, mimeTypes);
    }

    public int getFileEntriesCount(long repositoryId, long folderId) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(repositoryId);
        return repository.getFileEntriesCount(folderId);
    }

    public int getFileEntriesCount(long repositoryId, long folderId, long fileEntryTypeId) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(repositoryId);
        return repository.getFileEntriesCount(folderId, fileEntryTypeId);
    }

    public int getFileEntriesCount(long repositoryId, long folderId, String[] mimeTypes) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(repositoryId);
        return repository.getFileEntriesCount(folderId, mimeTypes);
    }

    public FileEntry getFileEntry(long fileEntryId) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.repositoryProvider.getFileEntryRepository(fileEntryId);
        return repository.getFileEntry(fileEntryId);
    }

    public FileEntry getFileEntry(long groupId, long folderId, String title) throws PortalException {
        try {
            com.liferay.portal.kernel.repository.Repository repository = this.getRepository(groupId);
            return repository.getFileEntry(folderId, title);
        }
        catch (NoSuchFileEntryException noSuchFileEntryException) {
            if (folderId == 0L) {
                throw noSuchFileEntryException;
            }
            com.liferay.portal.kernel.repository.Repository repository = this.repositoryProvider.getFolderRepository(folderId);
            return repository.getFileEntry(folderId, title);
        }
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public FileEntry getFileEntryByExternalReferenceCode(long groupId, String externalReferenceCode) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(groupId);
        return repository.getFileEntryByExternalReferenceCode(externalReferenceCode);
    }

    public FileEntry getFileEntryByFileName(long groupId, long folderId, String fileName) throws PortalException {
        try {
            com.liferay.portal.kernel.repository.Repository repository = this.getRepository(groupId);
            return repository.getFileEntryByFileName(folderId, fileName);
        }
        catch (NoSuchFileEntryException noSuchFileEntryException) {
            if (folderId == 0L) {
                throw noSuchFileEntryException;
            }
            com.liferay.portal.kernel.repository.Repository repository = this.repositoryProvider.getFolderRepository(folderId);
            return repository.getFileEntryByFileName(folderId, fileName);
        }
    }

    public FileEntry getFileEntryByUuidAndGroupId(String uuid, long groupId) throws PortalException {
        FileEntry fileEntry = this.fetchFileEntryByUuidAndRepositoryId(uuid, groupId);
        if (fileEntry != null) {
            return fileEntry;
        }
        List repositories = this._repositoryPersistence.findByGroupId(groupId);
        for (Repository repository : repositories) {
            if (Objects.equals(repository.getClassName(), TemporaryFileEntryRepository.class.getName())) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)"Skipping temporary file entry repository");
                continue;
            }
            fileEntry = this.fetchFileEntryByUuidAndRepositoryId(uuid, repository.getRepositoryId());
            if (fileEntry == null) continue;
            return fileEntry;
        }
        throw new NoSuchFileEntryException(StringBundler.concat((Object[])new Object[]{"No DLFileEntry exists with the key {uuid=", uuid, ", groupId=", groupId, "}"}));
    }

    public FileShortcut getFileShortcut(long fileShortcutId) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.repositoryProvider.getFileShortcutRepository(fileShortcutId);
        return repository.getFileShortcut(fileShortcutId);
    }

    public FileVersion getFileVersion(long fileVersionId) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.repositoryProvider.getFileVersionRepository(fileVersionId);
        return repository.getFileVersion(fileVersionId);
    }

    public Folder getFolder(long folderId) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.repositoryProvider.getFolderRepository(folderId);
        return repository.getFolder(folderId);
    }

    public Folder getFolder(long repositoryId, long parentFolderId, String name) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(repositoryId);
        return repository.getFolder(parentFolderId, name);
    }

    public Folder getFolderByExternalReferenceCode(String externalReferenceCode, long groupId) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(groupId);
        return repository.getFolderByExternalReferenceCode(externalReferenceCode);
    }

    public List<Folder> getFolders(long repositoryId, long parentFolderId) throws PortalException {
        return this.getFolders(repositoryId, parentFolderId, -1, -1);
    }

    public List<Folder> getFolders(long repositoryId, long parentFolderId, boolean includeMountFolders) throws PortalException {
        return this.getFolders(repositoryId, parentFolderId, includeMountFolders, -1, -1);
    }

    public List<Folder> getFolders(long repositoryId, long parentFolderId, boolean includeMountFolders, int start, int end) throws PortalException {
        return this.getFolders(repositoryId, parentFolderId, includeMountFolders, start, end, (OrderByComparator<Folder>)new FolderNameComparator(true));
    }

    public List<Folder> getFolders(long repositoryId, long parentFolderId, boolean includeMountFolders, int start, int end, OrderByComparator<Folder> orderByComparator) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(repositoryId);
        return repository.getFolders(parentFolderId, includeMountFolders, start, end, orderByComparator);
    }

    public List<Folder> getFolders(long repositoryId, long parentFolderId, int status, boolean includeMountFolders, int start, int end, OrderByComparator<Folder> orderByComparator) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(repositoryId);
        return repository.getFolders(parentFolderId, status, includeMountFolders, start, end, orderByComparator);
    }

    public List<Folder> getFolders(long repositoryId, long parentFolderId, int start, int end) throws PortalException {
        return this.getFolders(repositoryId, parentFolderId, start, end, (OrderByComparator<Folder>)new FolderNameComparator(true));
    }

    public List<Folder> getFolders(long repositoryId, long parentFolderId, int start, int end, OrderByComparator<Folder> orderByComparator) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(repositoryId);
        return repository.getFolders(parentFolderId, true, start, end, orderByComparator);
    }

    public List<Object> getFoldersAndFileEntriesAndFileShortcuts(long repositoryId, long folderId, int status, boolean includeMountFolders, int start, int end) throws PortalException {
        return this.getFoldersAndFileEntriesAndFileShortcuts(repositoryId, folderId, status, includeMountFolders, start, end, (OrderByComparator<?>)new RepositoryModelTitleComparator(true));
    }

    public List<Object> getFoldersAndFileEntriesAndFileShortcuts(long repositoryId, long folderId, int status, boolean includeMountFolders, int start, int end, OrderByComparator<?> orderByComparator) throws PortalException {
        return this.getFoldersAndFileEntriesAndFileShortcuts(repositoryId, folderId, status, null, includeMountFolders, start, end, orderByComparator);
    }

    public List<Object> getFoldersAndFileEntriesAndFileShortcuts(long repositoryId, long folderId, int status, String[] mimeTypes, boolean includeMountFolders, boolean includeOwner, int start, int end, OrderByComparator<?> orderByComparator) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(repositoryId);
        return repository.getFoldersAndFileEntriesAndFileShortcuts(folderId, status, mimeTypes, includeMountFolders, includeOwner, start, end, orderByComparator);
    }

    public List<Object> getFoldersAndFileEntriesAndFileShortcuts(long repositoryId, long folderId, int status, String[] mimeTypes, boolean includeMountFolders, int start, int end, OrderByComparator<?> orderByComparator) throws PortalException {
        return this.getFoldersAndFileEntriesAndFileShortcuts(repositoryId, folderId, status, mimeTypes, includeMountFolders, true, start, end, orderByComparator);
    }

    @ThreadLocalCachable
    public int getFoldersAndFileEntriesAndFileShortcutsCount(long repositoryId, long folderId, int status, boolean includeMountFolders) throws PortalException {
        return this.getFoldersAndFileEntriesAndFileShortcutsCount(repositoryId, folderId, status, null, includeMountFolders);
    }

    public int getFoldersAndFileEntriesAndFileShortcutsCount(long repositoryId, long folderId, int status, String[] mimeTypes, boolean includeMountFolders) throws PortalException {
        return this.getFoldersAndFileEntriesAndFileShortcutsCount(repositoryId, folderId, status, mimeTypes, includeMountFolders, true);
    }

    public int getFoldersAndFileEntriesAndFileShortcutsCount(long repositoryId, long folderId, int status, String[] mimeTypes, boolean includeMountFolders, boolean includeOwner) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(repositoryId);
        return repository.getFoldersAndFileEntriesAndFileShortcutsCount(folderId, status, mimeTypes, includeMountFolders, includeOwner);
    }

    public int getFoldersCount(long repositoryId, long parentFolderId) throws PortalException {
        return this.getFoldersCount(repositoryId, parentFolderId, true);
    }

    public int getFoldersCount(long repositoryId, long parentFolderId, boolean includeMountFolders) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(repositoryId);
        return repository.getFoldersCount(parentFolderId, includeMountFolders);
    }

    public int getFoldersCount(long repositoryId, long parentFolderId, int status, boolean includeMountFolders) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(repositoryId);
        return repository.getFoldersCount(parentFolderId, status, includeMountFolders);
    }

    public int getFoldersFileEntriesCount(long repositoryId, List<Long> folderIds, int status) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(repositoryId);
        return repository.getFoldersFileEntriesCount(folderIds, status);
    }

    public List<FileEntry> getGroupFileEntries(long groupId, long userId, int start, int end) throws PortalException {
        return this.getGroupFileEntries(groupId, userId, 0L, start, end, (OrderByComparator<FileEntry>)new RepositoryModelModifiedDateComparator());
    }

    public List<FileEntry> getGroupFileEntries(long groupId, long userId, int start, int end, OrderByComparator<FileEntry> orderByComparator) throws PortalException {
        return this.getGroupFileEntries(groupId, userId, 0L, start, end, orderByComparator);
    }

    public List<FileEntry> getGroupFileEntries(long groupId, long userId, long rootFolderId, int start, int end) throws PortalException {
        return this.getGroupFileEntries(groupId, userId, rootFolderId, start, end, (OrderByComparator<FileEntry>)new RepositoryModelModifiedDateComparator());
    }

    public List<FileEntry> getGroupFileEntries(long groupId, long userId, long rootFolderId, int start, int end, OrderByComparator<FileEntry> orderByComparator) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(groupId);
        return repository.getRepositoryFileEntries(userId, rootFolderId, start, end, orderByComparator);
    }

    public List<FileEntry> getGroupFileEntries(long groupId, long userId, long rootFolderId, String[] mimeTypes, int status, int start, int end, OrderByComparator<FileEntry> orderByComparator) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(groupId);
        return repository.getRepositoryFileEntries(userId, rootFolderId, mimeTypes, status, start, end, orderByComparator);
    }

    public int getGroupFileEntriesCount(long groupId, long userId) throws PortalException {
        return this.getGroupFileEntriesCount(groupId, userId, 0L);
    }

    public int getGroupFileEntriesCount(long groupId, long userId, long rootFolderId) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(groupId);
        return repository.getRepositoryFileEntriesCount(userId, rootFolderId);
    }

    public int getGroupFileEntriesCount(long groupId, long userId, long rootFolderId, String[] mimeTypes, int status) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(groupId);
        return repository.getRepositoryFileEntriesCount(userId, rootFolderId, mimeTypes, status);
    }

    public List<Folder> getMountFolders(long repositoryId, long parentFolderId) throws PortalException {
        return this.getMountFolders(repositoryId, parentFolderId, -1, -1);
    }

    public List<Folder> getMountFolders(long repositoryId, long parentFolderId, int start, int end) throws PortalException {
        return this.getMountFolders(repositoryId, parentFolderId, start, end, (OrderByComparator<Folder>)new FolderNameComparator(true));
    }

    public List<Folder> getMountFolders(long repositoryId, long parentFolderId, int start, int end, OrderByComparator<Folder> orderByComparator) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(repositoryId);
        return repository.getMountFolders(parentFolderId, start, end, orderByComparator);
    }

    public int getMountFoldersCount(long repositoryId, long parentFolderId) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(repositoryId);
        return repository.getMountFoldersCount(parentFolderId);
    }

    public void getSubfolderIds(long repositoryId, List<Long> folderIds, long folderId) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(repositoryId);
        repository.getSubfolderIds(folderIds, folderId);
    }

    public List<Long> getSubfolderIds(long repositoryId, long folderId) throws PortalException {
        return this.getSubfolderIds(repositoryId, folderId, true);
    }

    public List<Long> getSubfolderIds(long repositoryId, long folderId, boolean recurse) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(repositoryId);
        return repository.getSubfolderIds(folderId, recurse);
    }

    public String[] getTempFileNames(long groupId, long folderId, String folderName) throws PortalException {
        ModelResourcePermissionUtil.check(_folderModelResourcePermission, (PermissionChecker)this.getPermissionChecker(), (long)groupId, (long)folderId, (String)"ADD_DOCUMENT");
        return TempFileEntryUtil.getTempFileNames((long)groupId, (long)this.getUserId(), (String)folderName);
    }

    public Lock lockFolder(long repositoryId, long folderId) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(repositoryId);
        return repository.lockFolder(folderId);
    }

    public Lock lockFolder(long repositoryId, long folderId, String owner, boolean inheritable, long expirationTime) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(repositoryId);
        return repository.lockFolder(folderId, owner, inheritable, expirationTime);
    }

    public FileEntry moveFileEntry(long fileEntryId, long newFolderId, ServiceContext serviceContext) throws PortalException {
        Folder toFolder;
        com.liferay.portal.kernel.repository.Repository fromRepository = this.repositoryProvider.getFileEntryRepository(fileEntryId);
        com.liferay.portal.kernel.repository.Repository toRepository = this.getFolderRepository(newFolderId, serviceContext.getScopeGroupId());
        if (newFolderId != 0L && (toFolder = toRepository.getFolder(newFolderId)).isMountPoint()) {
            toRepository = this.getRepository(toFolder.getRepositoryId());
        }
        if (fromRepository.getRepositoryId() == toRepository.getRepositoryId()) {
            return fromRepository.moveFileEntry(this.getUserId(), fileEntryId, newFolderId, serviceContext);
        }
        return this.moveFileEntry(fileEntryId, newFolderId, fromRepository, toRepository, serviceContext);
    }

    public Folder moveFolder(long folderId, long parentFolderId, ServiceContext serviceContext) throws PortalException {
        Folder toFolder;
        com.liferay.portal.kernel.repository.Repository fromRepository = this.repositoryProvider.getFolderRepository(folderId);
        com.liferay.portal.kernel.repository.Repository toRepository = this.getFolderRepository(parentFolderId, serviceContext.getScopeGroupId());
        if (parentFolderId != 0L && (toFolder = toRepository.getFolder(parentFolderId)).isMountPoint()) {
            toRepository = this.getRepository(toFolder.getRepositoryId());
        }
        if (fromRepository.getRepositoryId() == toRepository.getRepositoryId()) {
            return fromRepository.moveFolder(this.getUserId(), folderId, parentFolderId, serviceContext);
        }
        return this.moveFolder(folderId, parentFolderId, fromRepository, toRepository, serviceContext);
    }

    public Lock refreshFileEntryLock(String lockUuid, long companyId, long expirationTime) throws PortalException {
        Lock lock = LockManagerUtil.getLockByUuidAndCompanyId((String)lockUuid, (long)companyId);
        long fileEntryId = GetterUtil.getLong((String)lock.getKey());
        com.liferay.portal.kernel.repository.Repository repository = this.repositoryProvider.getFileEntryRepository(fileEntryId);
        return repository.refreshFileEntryLock(lockUuid, companyId, expirationTime);
    }

    public Lock refreshFolderLock(String lockUuid, long companyId, long expirationTime) throws PortalException {
        Lock lock = LockManagerUtil.getLockByUuidAndCompanyId((String)lockUuid, (long)companyId);
        long folderId = GetterUtil.getLong((String)lock.getKey());
        com.liferay.portal.kernel.repository.Repository repository = this.repositoryProvider.getFolderRepository(folderId);
        return repository.refreshFolderLock(lockUuid, companyId, expirationTime);
    }

    public void revertFileEntry(long fileEntryId, String version, ServiceContext serviceContext) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.repositoryProvider.getFileEntryRepository(fileEntryId);
        repository.revertFileEntry(this.getUserId(), fileEntryId, version, serviceContext);
        FileEntry fileEntry = repository.getFileEntry(fileEntryId);
        this._dlAppHelperLocalService.updateFileEntry(this.getUserId(), fileEntry, null, fileEntry.getFileVersion(), serviceContext);
    }

    public Hits search(long repositoryId, long creatorUserId, int status, int start, int end) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(repositoryId);
        return repository.search(creatorUserId, status, start, end);
    }

    public Hits search(long repositoryId, long creatorUserId, long folderId, String[] mimeTypes, int status, int start, int end) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(repositoryId);
        return repository.search(creatorUserId, folderId, mimeTypes, status, start, end);
    }

    public Hits search(long repositoryId, SearchContext searchContext) throws SearchException {
        try {
            com.liferay.portal.kernel.repository.Repository repository = this.getRepository(repositoryId);
            PermissionChecker permissionChecker = this.getPermissionChecker();
            searchContext.setCompanyId(permissionChecker.getCompanyId());
            searchContext.setUserId(permissionChecker.getUserId());
            return repository.search(searchContext);
        }
        catch (Exception exception) {
            throw new SearchException((Throwable)exception);
        }
    }

    public Hits search(long repositoryId, SearchContext searchContext, Query query) throws SearchException {
        try {
            com.liferay.portal.kernel.repository.Repository repository = this.getRepository(repositoryId);
            PermissionChecker permissionChecker = this.getPermissionChecker();
            searchContext.setCompanyId(permissionChecker.getCompanyId());
            searchContext.setUserId(permissionChecker.getUserId());
            return repository.search(searchContext, query);
        }
        catch (Exception exception) {
            throw new SearchException((Throwable)exception);
        }
    }

    public void subscribeFileEntryType(long groupId, long fileEntryTypeId) throws PortalException {
        _portletResourcePermission.check(this.getPermissionChecker(), groupId, "SUBSCRIBE");
        this.dlAppLocalService.subscribeFileEntryType(this.getUserId(), groupId, fileEntryTypeId);
    }

    public void subscribeFolder(long groupId, long folderId) throws PortalException {
        ModelResourcePermissionUtil.check(_folderModelResourcePermission, (PermissionChecker)this.getPermissionChecker(), (long)groupId, (long)folderId, (String)"SUBSCRIBE");
        this.dlAppLocalService.subscribeFolder(this.getUserId(), groupId, folderId);
    }

    public void unlockFolder(long repositoryId, long folderId, String lockUuid) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(repositoryId);
        repository.unlockFolder(folderId, lockUuid);
    }

    public void unlockFolder(long repositoryId, long parentFolderId, String name, String lockUuid) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(repositoryId);
        repository.unlockFolder(parentFolderId, name, lockUuid);
    }

    public void unsubscribeFileEntryType(long groupId, long fileEntryTypeId) throws PortalException {
        _portletResourcePermission.check(this.getPermissionChecker(), groupId, "SUBSCRIBE");
        this.dlAppLocalService.unsubscribeFileEntryType(this.getUserId(), groupId, fileEntryTypeId);
    }

    public void unsubscribeFolder(long groupId, long folderId) throws PortalException {
        ModelResourcePermissionUtil.check(_folderModelResourcePermission, (PermissionChecker)this.getPermissionChecker(), (long)groupId, (long)folderId, (String)"SUBSCRIBE");
        this.dlAppLocalService.unsubscribeFolder(this.getUserId(), groupId, folderId);
    }

    public FileEntry updateFileEntry(long fileEntryId, String sourceFileName, String mimeType, String title, String urlTitle, String description, String changeLog, DLVersionNumberIncrease dlVersionNumberIncrease, byte[] bytes, Date expirationDate, Date reviewDate, ServiceContext serviceContext) throws PortalException {
        FileEntry fileEntry;
        File file = null;
        try {
            if (ArrayUtil.isNotEmpty((byte[])bytes)) {
                file = FileUtil.createTempFile((byte[])bytes);
            }
            fileEntry = this.updateFileEntry(fileEntryId, sourceFileName, mimeType, title, urlTitle, description, changeLog, dlVersionNumberIncrease, file, expirationDate, reviewDate, serviceContext);
        }
        catch (IOException ioException) {
            try {
                throw new SystemException("Unable to write temporary file", (Throwable)ioException);
            }
            catch (Throwable throwable) {
                FileUtil.delete(file);
                throw throwable;
            }
        }
        FileUtil.delete((File)file);
        return fileEntry;
    }

    public FileEntry updateFileEntry(long fileEntryId, String sourceFileName, String mimeType, String title, String urlTitle, String description, String changeLog, DLVersionNumberIncrease dlVersionNumberIncrease, File file, Date expirationDate, Date reviewDate, ServiceContext serviceContext) throws PortalException {
        if (file == null || !file.exists() || file.length() == 0L) {
            return this.updateFileEntry(fileEntryId, sourceFileName, mimeType, title, urlTitle, description, changeLog, dlVersionNumberIncrease, null, 0L, expirationDate, reviewDate, serviceContext);
        }
        mimeType = DLAppUtil.getMimeType(sourceFileName, mimeType, title, file);
        com.liferay.portal.kernel.repository.Repository repository = this.repositoryProvider.getFileEntryRepository(fileEntryId);
        FileEntry fileEntry = repository.updateFileEntry(this.getUserId(), fileEntryId, sourceFileName, mimeType, title, urlTitle, description, changeLog, dlVersionNumberIncrease, file, expirationDate, reviewDate, serviceContext);
        this._dlAppHelperLocalService.updateFileEntry(this.getUserId(), fileEntry, null, fileEntry.getLatestFileVersion(), serviceContext);
        return fileEntry;
    }

    public FileEntry updateFileEntry(long fileEntryId, String sourceFileName, String mimeType, String title, String urlTitle, String description, String changeLog, DLVersionNumberIncrease dlVersionNumberIncrease, InputStream inputStream, long size, Date expirationDate, Date reviewDate, ServiceContext serviceContext) throws PortalException {
        if (Validator.isNull((String)mimeType) || mimeType.equals("application/octet-stream")) {
            if (size == 0L) {
                mimeType = MimeTypesUtil.getExtensionContentType((String)DLAppUtil.getExtension(title, sourceFileName));
            } else {
                File file = null;
                try {
                    file = FileUtil.createTempFile((InputStream)inputStream);
                    FileEntry fileEntry = this.updateFileEntry(fileEntryId, sourceFileName, mimeType, title, urlTitle, description, changeLog, dlVersionNumberIncrease, file, expirationDate, reviewDate, serviceContext);
                    return fileEntry;
                }
                catch (IOException ioException) {
                    throw new SystemException("Unable to write temporary file", (Throwable)ioException);
                }
                finally {
                    FileUtil.delete((File)file);
                }
            }
        }
        com.liferay.portal.kernel.repository.Repository repository = this.repositoryProvider.getFileEntryRepository(fileEntryId);
        FileEntry fileEntry = repository.updateFileEntry(this.getUserId(), fileEntryId, sourceFileName, mimeType, title, urlTitle, description, changeLog, dlVersionNumberIncrease, inputStream, size, expirationDate, reviewDate, serviceContext);
        this._dlAppHelperLocalService.updateFileEntry(this.getUserId(), fileEntry, null, fileEntry.getLatestFileVersion(), serviceContext);
        return fileEntry;
    }

    public FileEntry updateFileEntryAndCheckIn(long fileEntryId, String sourceFileName, String mimeType, String title, String urlTitle, String description, String changeLog, DLVersionNumberIncrease dlVersionNumberIncrease, File file, Date expirationDate, Date reviewDate, ServiceContext serviceContext) throws PortalException {
        if (file == null || !file.exists() || file.length() == 0L) {
            return this.updateFileEntryAndCheckIn(fileEntryId, sourceFileName, mimeType, title, urlTitle, description, changeLog, dlVersionNumberIncrease, null, 0L, expirationDate, reviewDate, serviceContext);
        }
        com.liferay.portal.kernel.repository.Repository repository = this.repositoryProvider.getFileEntryRepository(fileEntryId);
        this._withDLAppHelperDisabled((UnsafeRunnable<PortalException>)((UnsafeRunnable)() -> repository.updateFileEntry(this.getUserId(), fileEntryId, sourceFileName, mimeType, title, urlTitle, description, changeLog, dlVersionNumberIncrease, file, expirationDate, reviewDate, serviceContext)));
        repository.checkInFileEntry(this.getUserId(), fileEntryId, dlVersionNumberIncrease, changeLog, serviceContext);
        FileEntry fileEntry = repository.getFileEntry(fileEntryId);
        this._dlAppHelperLocalService.updateFileEntry(this.getUserId(), fileEntry, null, fileEntry.getFileVersion(), serviceContext);
        return fileEntry;
    }

    public FileEntry updateFileEntryAndCheckIn(long fileEntryId, String sourceFileName, String mimeType, String title, String urlTitle, String description, String changeLog, DLVersionNumberIncrease dlVersionNumberIncrease, InputStream inputStream, long size, Date expirationDate, Date reviewDate, ServiceContext serviceContext) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.repositoryProvider.getFileEntryRepository(fileEntryId);
        this._withDLAppHelperDisabled((UnsafeRunnable<PortalException>)((UnsafeRunnable)() -> repository.updateFileEntry(this.getUserId(), fileEntryId, sourceFileName, mimeType, title, urlTitle, description, changeLog, dlVersionNumberIncrease, inputStream, size, expirationDate, reviewDate, serviceContext)));
        repository.checkInFileEntry(this.getUserId(), fileEntryId, dlVersionNumberIncrease, changeLog, serviceContext);
        FileEntry fileEntry = repository.getFileEntry(fileEntryId);
        this._dlAppHelperLocalService.updateFileEntry(this.getUserId(), fileEntry, null, fileEntry.getFileVersion(), serviceContext);
        return fileEntry;
    }

    public FileShortcut updateFileShortcut(long fileShortcutId, long folderId, long toFileEntryId, ServiceContext serviceContext) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.repositoryProvider.getFileShortcutRepository(fileShortcutId);
        return repository.updateFileShortcut(this.getUserId(), fileShortcutId, folderId, toFileEntryId, serviceContext);
    }

    public Folder updateFolder(long folderId, String name, String description, ServiceContext serviceContext) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getFolderRepository(folderId, serviceContext.getScopeGroupId());
        Folder folder = repository.updateFolder(folderId, name, description, serviceContext);
        if (folderId != 0L) {
            this._dlAppHelperLocalService.updateFolder(this.getUserId(), folder, serviceContext);
        }
        return folder;
    }

    public boolean verifyFileEntryCheckOut(long repositoryId, long fileEntryId, String lockUuid) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(repositoryId);
        return repository.verifyFileEntryCheckOut(fileEntryId, lockUuid);
    }

    public boolean verifyFileEntryLock(long repositoryId, long fileEntryId, String lockUuid) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(repositoryId);
        return repository.verifyFileEntryLock(fileEntryId, lockUuid);
    }

    public boolean verifyInheritableLock(long repositoryId, long folderId, String lockUuid) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(repositoryId);
        return repository.verifyInheritableLock(folderId, lockUuid);
    }

    protected FileEntry copyFileEntry(com.liferay.portal.kernel.repository.Repository toRepository, FileEntry fileEntry, long newFolderId, ServiceContext serviceContext) throws PortalException {
        List fileVersions = fileEntry.getFileVersions(-1);
        FileVersion latestFileVersion = (FileVersion)fileVersions.get(fileVersions.size() - 1);
        String sourceFileName = DLAppUtil.getSourceFileName(latestFileVersion);
        FileEntry destinationFileEntry = toRepository.addFileEntry(null, this.getUserId(), newFolderId, sourceFileName, latestFileVersion.getMimeType(), latestFileVersion.getTitle(), latestFileVersion.getTitle(), latestFileVersion.getDescription(), "", latestFileVersion.getContentStream(false), latestFileVersion.getSize(), latestFileVersion.getExpirationDate(), latestFileVersion.getReviewDate(), serviceContext);
        for (int i = fileVersions.size() - 2; i >= 0; --i) {
            FileVersion fileVersion = (FileVersion)fileVersions.get(i);
            sourceFileName = DLAppUtil.getSourceFileName(fileVersion);
            FileVersion previousFileVersion = (FileVersion)fileVersions.get(i + 1);
            try {
                destinationFileEntry = toRepository.updateFileEntry(this.getUserId(), destinationFileEntry.getFileEntryId(), sourceFileName, fileVersion.getMimeType(), fileVersion.getTitle(), fileVersion.getTitle(), fileVersion.getDescription(), "", DLVersionNumberIncrease.fromMajorVersion((boolean)DLAppUtil.isMajorVersion(previousFileVersion, fileVersion)), fileVersion.getContentStream(false), fileVersion.getSize(), fileVersion.getExpirationDate(), fileVersion.getReviewDate(), serviceContext);
                FileVersion destinationFileVersion = destinationFileEntry.getFileVersion();
                this._dlAppHelperLocalService.updateFileEntry(this.getUserId(), destinationFileEntry, null, destinationFileVersion, serviceContext);
                continue;
            }
            catch (PortalException portalException) {
                toRepository.deleteFileEntry(destinationFileEntry.getFileEntryId());
                throw portalException;
            }
        }
        return destinationFileEntry;
    }

    protected Folder copyFolder(long folderId, long parentFolderId, com.liferay.portal.kernel.repository.Repository fromRepository, com.liferay.portal.kernel.repository.Repository toRepository, ServiceContext serviceContext) throws PortalException {
        Folder newFolder = null;
        try {
            Folder folder = fromRepository.getFolder(folderId);
            newFolder = toRepository.addFolder(null, this.getUserId(), parentFolderId, folder.getName(), folder.getDescription(), serviceContext);
            this._dlAppHelperLocalService.addFolder(this.getUserId(), newFolder, serviceContext);
            this.copyFolderDependencies(folder, newFolder, fromRepository, toRepository, serviceContext);
            return newFolder;
        }
        catch (PortalException portalException) {
            if (newFolder != null) {
                toRepository.deleteFolder(newFolder.getFolderId());
            }
            throw portalException;
        }
    }

    protected void copyFolder(com.liferay.portal.kernel.repository.Repository repository, Folder srcFolder, Folder destFolder, ServiceContext serviceContext) throws PortalException {
        LinkedList<Folder[]> folders = new LinkedList<Folder[]>();
        ArrayList<FileEntry> fileEntries = new ArrayList<FileEntry>();
        Folder curSrcFolder = srcFolder;
        Folder curDestFolder = destFolder;
        while (true) {
            Object srcFileEntry2;
            List srcFileEntries = repository.getFileEntries(curSrcFolder.getFolderId(), -1, -1, null);
            for (Object srcFileEntry2 : srcFileEntries) {
                try {
                    FileEntry fileEntry = repository.copyFileEntry(this.getUserId(), curDestFolder.getGroupId(), srcFileEntry2.getFileEntryId(), curDestFolder.getFolderId(), serviceContext);
                    fileEntries.add(fileEntry);
                }
                catch (Exception exception) {
                    _log.error((Throwable)exception);
                }
            }
            List srcSubfolders = repository.getFolders(curSrcFolder.getFolderId(), false, -1, -1, null);
            srcFileEntry2 = srcSubfolders.iterator();
            while (srcFileEntry2.hasNext()) {
                Folder srcSubfolder = (Folder)srcFileEntry2.next();
                Folder destSubfolder = repository.addFolder(null, this.getUserId(), curDestFolder.getFolderId(), srcSubfolder.getName(), srcSubfolder.getDescription(), serviceContext);
                this._dlAppHelperLocalService.addFolder(this.getUserId(), destSubfolder, serviceContext);
                folders.offer(new Folder[]{srcSubfolder, destSubfolder});
            }
            Folder[] next = (Folder[])folders.poll();
            if (next == null) break;
            curSrcFolder = next[0];
            curDestFolder = next[1];
        }
        TransactionCommitCallbackUtil.registerCallback(() -> {
            for (FileEntry fileEntry : fileEntries) {
                DLProcessorRegistryUtil.trigger((FileEntry)fileEntry, null);
            }
            return null;
        });
    }

    protected void copyFolderDependencies(Folder sourceFolder, Folder destinationFolder, com.liferay.portal.kernel.repository.Repository fromRepository, com.liferay.portal.kernel.repository.Repository toRepository, ServiceContext serviceContext) throws PortalException {
        List repositoryEntries = fromRepository.getFoldersAndFileEntriesAndFileShortcuts(sourceFolder.getFolderId(), -1, true, -1, -1, null);
        for (RepositoryEntry repositoryEntry : repositoryEntries) {
            if (repositoryEntry instanceof FileEntry) {
                FileEntry fileEntry = (FileEntry)repositoryEntry;
                this.copyFileEntry(toRepository, fileEntry, destinationFolder.getFolderId(), serviceContext);
                continue;
            }
            if (repositoryEntry instanceof FileShortcut) {
                if (!destinationFolder.isSupportsShortcuts()) continue;
                FileShortcut fileShortcut = (FileShortcut)repositoryEntry;
                toRepository.addFileShortcut(this.getUserId(), destinationFolder.getFolderId(), fileShortcut.getToFileEntryId(), serviceContext);
                continue;
            }
            if (!(repositoryEntry instanceof Folder)) continue;
            Folder currentFolder = (Folder)repositoryEntry;
            Folder newFolder = toRepository.addFolder(null, this.getUserId(), destinationFolder.getFolderId(), currentFolder.getName(), currentFolder.getDescription(), serviceContext);
            this._dlAppHelperLocalService.addFolder(this.getUserId(), newFolder, serviceContext);
            this.copyFolderDependencies(currentFolder, newFolder, fromRepository, toRepository, serviceContext);
        }
    }

    protected void deleteFileEntry(long oldFileEntryId, long newFileEntryId, com.liferay.portal.kernel.repository.Repository fromRepository, com.liferay.portal.kernel.repository.Repository toRepository) throws PortalException {
        try {
            this._dlAppHelperLocalService.deleteFileEntry(fromRepository.getFileEntry(oldFileEntryId));
            fromRepository.deleteFileEntry(oldFileEntryId);
        }
        catch (PortalException portalException) {
            FileEntry fileEntry = toRepository.getFileEntry(newFileEntryId);
            toRepository.deleteFileEntry(newFileEntryId);
            this._dlAppHelperLocalService.deleteFileEntry(fileEntry);
            throw portalException;
        }
    }

    protected FileEntry fetchFileEntryByUuidAndRepositoryId(String uuid, long repositoryId) throws PortalException {
        try {
            com.liferay.portal.kernel.repository.Repository repository = this.getRepository(repositoryId);
            return repository.getFileEntryByUuid(uuid);
        }
        catch (NoSuchFileEntryException noSuchFileEntryException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)noSuchFileEntryException);
            }
            return null;
        }
        catch (RepositoryException repositoryException) {
            throw new NoSuchFileEntryException((Throwable)repositoryException);
        }
    }

    protected com.liferay.portal.kernel.repository.Repository getFolderRepository(long folderId, long groupId) throws PortalException {
        if (folderId == 0L) {
            return this.getRepository(groupId);
        }
        return this.repositoryProvider.getFolderRepository(folderId);
    }

    protected com.liferay.portal.kernel.repository.Repository getRepository(long repositoryId) throws PortalException {
        try {
            return this.repositoryProvider.getRepository(repositoryId);
        }
        catch (InvalidRepositoryIdException invalidRepositoryIdException) {
            throw new NoSuchGroupException(StringBundler.concat((Object[])new Object[]{"No Group exists with the key {repositoryId=", repositoryId, "}"}), (Throwable)invalidRepositoryIdException);
        }
    }

    protected FileEntry moveFileEntry(long fileEntryId, long newFolderId, com.liferay.portal.kernel.repository.Repository fromRepository, com.liferay.portal.kernel.repository.Repository toRepository, ServiceContext serviceContext) throws PortalException {
        FileEntry sourceFileEntry = fromRepository.getFileEntry(fileEntryId);
        if (sourceFileEntry.isCheckedOut()) {
            throw new FileEntryLockException.MustBeUnlocked();
        }
        FileEntry destinationFileEntry = this.copyFileEntry(toRepository, sourceFileEntry, newFolderId, serviceContext);
        this.deleteFileEntry(fileEntryId, destinationFileEntry.getFileEntryId(), fromRepository, toRepository);
        return destinationFileEntry;
    }

    protected Folder moveFolder(long folderId, long parentFolderId, com.liferay.portal.kernel.repository.Repository fromRepository, com.liferay.portal.kernel.repository.Repository toRepository, ServiceContext serviceContext) throws PortalException {
        Folder newFolder = this.copyFolder(folderId, parentFolderId, fromRepository, toRepository, serviceContext);
        fromRepository.deleteFolder(folderId);
        return newFolder;
    }

    private void _withDLAppHelperDisabled(UnsafeRunnable<PortalException> unsafeRunnable) throws PortalException {
        boolean enabled = DLAppHelperThreadLocal.isEnabled();
        try {
            DLAppHelperThreadLocal.setEnabled((boolean)false);
            unsafeRunnable.run();
        }
        finally {
            DLAppHelperThreadLocal.setEnabled((boolean)enabled);
        }
    }
}

