/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.impl;

import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.lock.Lock;
import com.liferay.portal.kernel.lock.LockManagerUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionFactory;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portlet.documentlibrary.DLGroupServiceSettings;
import com.liferay.portlet.documentlibrary.model.impl.DLFolderImpl;
import com.liferay.portlet.documentlibrary.service.base.DLFolderServiceBaseImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DLFolderServiceImpl
extends DLFolderServiceBaseImpl {
    private static volatile ModelResourcePermission<DLFolder> _dlFolderModelResourcePermission = ModelResourcePermissionFactory.getInstance(DLFolderServiceImpl.class, (String)"_dlFolderModelResourcePermission", DLFolder.class);

    public DLFolder addFolder(String externalReferenceCode, long groupId, long repositoryId, boolean mountPoint, long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException {
        ModelResourcePermissionUtil.check(_dlFolderModelResourcePermission, (PermissionChecker)this.getPermissionChecker(), (long)groupId, (long)parentFolderId, (String)"ADD_FOLDER");
        return this.dlFolderLocalService.addFolder(externalReferenceCode, this.getUserId(), groupId, repositoryId, mountPoint, parentFolderId, name, description, false, serviceContext);
    }

    public void deleteFolder(long folderId) throws PortalException {
        this.deleteFolder(folderId, true);
    }

    public void deleteFolder(long folderId, boolean includeTrashedEntries) throws PortalException {
        DLFolder dlFolder = this.dlFolderLocalService.getFolder(folderId);
        _dlFolderModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)dlFolder, "DELETE");
        this.dlFolderLocalService.deleteFolder(this.getUserId(), folderId, includeTrashedEntries);
    }

    public void deleteFolder(long groupId, long parentFolderId, String name) throws PortalException {
        DLFolder dlFolder = this.getFolder(groupId, parentFolderId, name);
        this.deleteFolder(dlFolder.getFolderId());
    }

    public DLFolder getDLFolderByExternalReferenceCode(String externalReferenceCode, long groupId) throws PortalException {
        DLFolder dlFolder = this.dlFolderLocalService.getDLFolderByExternalReferenceCode(externalReferenceCode, groupId);
        _dlFolderModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)dlFolder, "VIEW");
        return dlFolder;
    }

    public List<Object> getFileEntriesAndFileShortcuts(long groupId, long folderId, int status, int start, int end) throws PortalException {
        if (!ModelResourcePermissionUtil.contains(_dlFolderModelResourcePermission, (PermissionChecker)this.getPermissionChecker(), (long)groupId, (long)folderId, (String)"VIEW")) {
            return Collections.emptyList();
        }
        QueryDefinition queryDefinition = new QueryDefinition(status, start, end, null);
        return this.dlFolderFinder.filterFindFE_FS_ByG_F(groupId, folderId, queryDefinition);
    }

    public int getFileEntriesAndFileShortcutsCount(long groupId, long folderId, int status) throws PortalException {
        if (!ModelResourcePermissionUtil.contains(_dlFolderModelResourcePermission, (PermissionChecker)this.getPermissionChecker(), (long)groupId, (long)folderId, (String)"VIEW")) {
            return 0;
        }
        QueryDefinition queryDefinition = new QueryDefinition(status);
        return this.dlFolderFinder.filterCountFE_FS_ByG_F(groupId, folderId, queryDefinition);
    }

    public int getFileEntriesAndFileShortcutsCount(long groupId, long folderId, String[] mimeTypes, int status) throws PortalException {
        if (!ModelResourcePermissionUtil.contains(_dlFolderModelResourcePermission, (PermissionChecker)this.getPermissionChecker(), (long)groupId, (long)folderId, (String)"VIEW")) {
            return 0;
        }
        QueryDefinition queryDefinition = new QueryDefinition(status);
        return this.dlFolderFinder.filterCountFE_FS_ByG_F_M(groupId, folderId, mimeTypes, queryDefinition);
    }

    public DLFolder getFolder(long folderId) throws PortalException {
        DLFolder dlFolder = this.dlFolderLocalService.getFolder(folderId);
        _dlFolderModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)dlFolder, "VIEW");
        return dlFolder;
    }

    public DLFolder getFolder(long groupId, long parentFolderId, String name) throws PortalException {
        DLFolder dlFolder = this.dlFolderLocalService.getFolder(groupId, parentFolderId, name);
        _dlFolderModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)dlFolder, "VIEW");
        return dlFolder;
    }

    public List<Long> getFolderIds(long groupId, long folderId) throws PortalException {
        if (!ModelResourcePermissionUtil.contains(_dlFolderModelResourcePermission, (PermissionChecker)this.getPermissionChecker(), (long)groupId, (long)folderId, (String)"VIEW")) {
            return Collections.emptyList();
        }
        List<Long> folderIds = this.getSubfolderIds(groupId, folderId, true);
        folderIds.add(0, folderId);
        return folderIds;
    }

    public List<DLFolder> getFolders(long groupId, long parentFolderId, boolean includeMountfolders, int status, int start, int end, OrderByComparator<DLFolder> orderByComparator) throws PortalException {
        if (!ModelResourcePermissionUtil.contains(_dlFolderModelResourcePermission, (PermissionChecker)this.getPermissionChecker(), (long)groupId, (long)parentFolderId, (String)"VIEW")) {
            return Collections.emptyList();
        }
        if (includeMountfolders) {
            return this.dlFolderPersistence.filterFindByG_P_H_S(groupId, parentFolderId, false, status, start, end, orderByComparator);
        }
        return this.dlFolderPersistence.filterFindByG_M_P_H_S(groupId, false, parentFolderId, false, status, start, end, orderByComparator);
    }

    public List<DLFolder> getFolders(long groupId, long parentFolderId, int start, int end, OrderByComparator<DLFolder> orderByComparator) throws PortalException {
        return this.getFolders(groupId, parentFolderId, true, 0, start, end, orderByComparator);
    }

    public List<Object> getFoldersAndFileEntriesAndFileShortcuts(long groupId, long folderId, boolean includeMountFolders, int status, int start, int end, OrderByComparator<?> orderByComparator) throws PortalException {
        if (!ModelResourcePermissionUtil.contains(_dlFolderModelResourcePermission, (PermissionChecker)this.getPermissionChecker(), (long)groupId, (long)folderId, (String)"VIEW")) {
            return Collections.emptyList();
        }
        QueryDefinition queryDefinition = new QueryDefinition(status, start, end, orderByComparator);
        return this.dlFolderFinder.filterFindF_FE_FS_ByG_F_M_M(groupId, folderId, null, includeMountFolders, queryDefinition);
    }

    public List<Object> getFoldersAndFileEntriesAndFileShortcuts(long groupId, long folderId, String[] mimeTypes, boolean includeMountFolders, int status, int start, int end, OrderByComparator<?> orderByComparator) throws PortalException {
        if (!ModelResourcePermissionUtil.contains(_dlFolderModelResourcePermission, (PermissionChecker)this.getPermissionChecker(), (long)groupId, (long)folderId, (String)"VIEW")) {
            return Collections.emptyList();
        }
        QueryDefinition queryDefinition = new QueryDefinition(status, start, end, orderByComparator);
        return this.dlFolderFinder.filterFindF_FE_FS_ByG_F_M_M(groupId, folderId, mimeTypes, includeMountFolders, queryDefinition);
    }

    public List<Object> getFoldersAndFileEntriesAndFileShortcuts(long groupId, long folderId, String[] mimeTypes, boolean includeMountFolders, QueryDefinition<?> queryDefinition) throws PortalException {
        if (queryDefinition.isIncludeOwner() && queryDefinition.getOwnerUserId() != 0L) {
            queryDefinition.setOwnerUserId(this.getUserId());
        }
        if (!ModelResourcePermissionUtil.contains(_dlFolderModelResourcePermission, (PermissionChecker)this.getPermissionChecker(), (long)groupId, (long)folderId, (String)"VIEW")) {
            return Collections.emptyList();
        }
        return this.dlFolderFinder.filterFindF_FE_FS_ByG_F_M_M(groupId, folderId, mimeTypes, includeMountFolders, queryDefinition);
    }

    public List<Object> getFoldersAndFileEntriesAndFileShortcuts(long groupId, long folderId, String[] mimeTypes, long fileEntryTypeId, boolean includeMountFolders, int status, int start, int end, OrderByComparator<?> orderByComparator) throws PortalException {
        if (!ModelResourcePermissionUtil.contains(_dlFolderModelResourcePermission, (PermissionChecker)this.getPermissionChecker(), (long)groupId, (long)folderId, (String)"VIEW")) {
            return Collections.emptyList();
        }
        QueryDefinition queryDefinition = new QueryDefinition(status, start, end, orderByComparator);
        return this.dlFolderFinder.filterFindF_FE_FS_ByG_F_M_FETI_M(groupId, folderId, mimeTypes, fileEntryTypeId, includeMountFolders, queryDefinition);
    }

    public int getFoldersAndFileEntriesAndFileShortcutsCount(long groupId, long folderId, int status, boolean includeMountFolders) throws PortalException {
        if (!ModelResourcePermissionUtil.contains(_dlFolderModelResourcePermission, (PermissionChecker)this.getPermissionChecker(), (long)groupId, (long)folderId, (String)"VIEW")) {
            return 0;
        }
        QueryDefinition queryDefinition = new QueryDefinition(status);
        return this.dlFolderFinder.filterCountF_FE_FS_ByG_F_M_M(groupId, folderId, null, includeMountFolders, queryDefinition);
    }

    @Deprecated
    public int getFoldersAndFileEntriesAndFileShortcutsCount(long groupId, long folderId, int status, String[] mimeTypes, boolean includeMountFolders) throws PortalException {
        return this.getFoldersAndFileEntriesAndFileShortcutsCount(groupId, folderId, mimeTypes, includeMountFolders, status);
    }

    public int getFoldersAndFileEntriesAndFileShortcutsCount(long groupId, long folderId, String[] mimeTypes, boolean includeMountFolders, int status) throws PortalException {
        if (!ModelResourcePermissionUtil.contains(_dlFolderModelResourcePermission, (PermissionChecker)this.getPermissionChecker(), (long)groupId, (long)folderId, (String)"VIEW")) {
            return 0;
        }
        QueryDefinition queryDefinition = new QueryDefinition(status);
        return this.dlFolderFinder.filterCountF_FE_FS_ByG_F_M_M(groupId, folderId, mimeTypes, includeMountFolders, queryDefinition);
    }

    public int getFoldersAndFileEntriesAndFileShortcutsCount(long groupId, long folderId, String[] mimeTypes, boolean includeMountFolders, QueryDefinition<?> queryDefinition) throws PortalException {
        if (!ModelResourcePermissionUtil.contains(_dlFolderModelResourcePermission, (PermissionChecker)this.getPermissionChecker(), (long)groupId, (long)folderId, (String)"VIEW")) {
            return 0;
        }
        if (queryDefinition.isIncludeOwner() && queryDefinition.getOwnerUserId() != 0L) {
            queryDefinition.setOwnerUserId(this.getUserId());
        }
        return this.dlFolderFinder.filterCountF_FE_FS_ByG_F_M_M(groupId, folderId, mimeTypes, includeMountFolders, queryDefinition);
    }

    public int getFoldersAndFileEntriesAndFileShortcutsCount(long groupId, long folderId, String[] mimeTypes, long fileEntryTypeId, boolean includeMountFolders, int status) throws PortalException {
        if (!ModelResourcePermissionUtil.contains(_dlFolderModelResourcePermission, (PermissionChecker)this.getPermissionChecker(), (long)groupId, (long)folderId, (String)"VIEW")) {
            return 0;
        }
        QueryDefinition queryDefinition = new QueryDefinition(status);
        return this.dlFolderFinder.filterCountF_FE_FS_ByG_F_M_FETI_M(groupId, folderId, mimeTypes, fileEntryTypeId, includeMountFolders, queryDefinition);
    }

    public int getFoldersCount(long groupId, long parentFolderId) throws PortalException {
        return this.getFoldersCount(groupId, parentFolderId, true, 0);
    }

    public int getFoldersCount(long groupId, long parentFolderId, boolean includeMountfolders, int status) throws PortalException {
        if (!ModelResourcePermissionUtil.contains(_dlFolderModelResourcePermission, (PermissionChecker)this.getPermissionChecker(), (long)groupId, (long)parentFolderId, (String)"VIEW")) {
            return 0;
        }
        if (includeMountfolders) {
            return this.dlFolderPersistence.filterCountByG_P_H_S(groupId, parentFolderId, false, status);
        }
        return this.dlFolderPersistence.filterCountByG_M_P_H_S(groupId, false, parentFolderId, false, status);
    }

    @Deprecated
    public int getFoldersCount(long groupId, long parentFolderId, int status, boolean includeMountfolders) throws PortalException {
        return this.getFoldersCount(groupId, parentFolderId, includeMountfolders, status);
    }

    public List<DLFolder> getMountFolders(long groupId, long parentFolderId, int start, int end, OrderByComparator<DLFolder> orderByComparator) throws PortalException {
        if (!ModelResourcePermissionUtil.contains(_dlFolderModelResourcePermission, (PermissionChecker)this.getPermissionChecker(), (long)groupId, (long)parentFolderId, (String)"VIEW")) {
            return Collections.emptyList();
        }
        DLGroupServiceSettings dlGroupServiceSettings = DLGroupServiceSettings.getInstance(groupId);
        if (dlGroupServiceSettings.isShowHiddenMountFolders()) {
            return this.dlFolderPersistence.filterFindByG_M_P(groupId, true, parentFolderId, start, end, orderByComparator);
        }
        return this.dlFolderPersistence.filterFindByG_M_P_H(groupId, true, parentFolderId, false, start, end, orderByComparator);
    }

    public int getMountFoldersCount(long groupId, long parentFolderId) throws PortalException {
        if (!ModelResourcePermissionUtil.contains(_dlFolderModelResourcePermission, (PermissionChecker)this.getPermissionChecker(), (long)groupId, (long)parentFolderId, (String)"VIEW")) {
            return 0;
        }
        return this.dlFolderPersistence.filterCountByG_M_P_H(groupId, true, parentFolderId, false);
    }

    public void getSubfolderIds(List<Long> folderIds, long groupId, long folderId, boolean recurse) throws PortalException {
        if (!ModelResourcePermissionUtil.contains(_dlFolderModelResourcePermission, (PermissionChecker)this.getPermissionChecker(), (long)groupId, (long)folderId, (String)"VIEW")) {
            return;
        }
        List dlFolders = this.dlFolderPersistence.filterFindByG_P_H_S(groupId, folderId, false, 0);
        for (DLFolder dlFolder : dlFolders) {
            if (dlFolder.isInHiddenFolder() || dlFolder.isInTrash()) continue;
            folderIds.add(dlFolder.getFolderId());
            if (!recurse) continue;
            this.getSubfolderIds(folderIds, dlFolder.getGroupId(), dlFolder.getFolderId(), recurse);
        }
    }

    public List<Long> getSubfolderIds(long groupId, long folderId, boolean recurse) throws PortalException {
        ArrayList<Long> folderIds = new ArrayList<Long>();
        this.getSubfolderIds(folderIds, groupId, folderId, recurse);
        return folderIds;
    }

    public boolean hasFolderLock(long folderId) throws PortalException {
        return LockManagerUtil.hasLock((long)this.getUserId(), (String)DLFolder.class.getName(), (long)folderId);
    }

    public boolean hasInheritableLock(long folderId) throws PortalException {
        return this.dlFolderLocalService.hasInheritableLock(folderId);
    }

    public boolean isFolderLocked(long folderId) {
        return LockManagerUtil.isLocked((String)DLFolder.class.getName(), (long)folderId);
    }

    public Lock lockFolder(long folderId) throws PortalException {
        return this.lockFolder(folderId, null, false, DLFolderImpl.LOCK_EXPIRATION_TIME);
    }

    public Lock lockFolder(long folderId, String owner, boolean inheritable, long expirationTime) throws PortalException {
        DLFolder dlFolder = this.dlFolderLocalService.getFolder(folderId);
        _dlFolderModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)dlFolder, "UPDATE");
        return this.dlFolderLocalService.lockFolder(this.getUserId(), folderId, owner, inheritable, expirationTime);
    }

    public DLFolder moveFolder(long folderId, long parentFolderId, ServiceContext serviceContext) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        DLFolder dlFolder = this.dlFolderLocalService.getFolder(folderId);
        _dlFolderModelResourcePermission.check(permissionChecker, (ClassedModel)dlFolder, "UPDATE");
        ModelResourcePermissionUtil.check(_dlFolderModelResourcePermission, (PermissionChecker)permissionChecker, (long)serviceContext.getScopeGroupId(), (long)parentFolderId, (String)"ADD_FOLDER");
        return this.dlFolderLocalService.moveFolder(this.getUserId(), folderId, parentFolderId, serviceContext);
    }

    public Lock refreshFolderLock(String lockUuid, long companyId, long expirationTime) throws PortalException {
        return LockManagerUtil.refresh((String)lockUuid, (long)companyId, (long)expirationTime);
    }

    public void unlockFolder(long groupId, long parentFolderId, String name, String lockUuid) throws PortalException {
        DLFolder dlFolder = this.getFolder(groupId, parentFolderId, name);
        this.unlockFolder(dlFolder.getFolderId(), lockUuid);
    }

    public void unlockFolder(long folderId, String lockUuid) throws PortalException {
        DLFolder dlFolder = this.dlFolderLocalService.fetchFolder(folderId);
        if (dlFolder != null) {
            _dlFolderModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)dlFolder, "UPDATE");
        }
        this.dlFolderLocalService.unlockFolder(folderId, lockUuid);
    }

    public DLFolder updateFolder(long folderId, long parentFolderId, String name, String description, long defaultFileEntryTypeId, List<Long> fileEntryTypeIds, int restrictionType, ServiceContext serviceContext) throws PortalException {
        ModelResourcePermissionUtil.check(_dlFolderModelResourcePermission, (PermissionChecker)this.getPermissionChecker(), (long)serviceContext.getScopeGroupId(), (long)folderId, (String)"UPDATE");
        serviceContext.setUserId(this.getUserId());
        return this.dlFolderLocalService.updateFolder(folderId, parentFolderId, name, description, defaultFileEntryTypeId, fileEntryTypeIds, restrictionType, serviceContext);
    }

    public DLFolder updateFolder(long folderId, String name, String description, long defaultFileEntryTypeId, List<Long> fileEntryTypeIds, int restrictionType, ServiceContext serviceContext) throws PortalException {
        ModelResourcePermissionUtil.check(_dlFolderModelResourcePermission, (PermissionChecker)this.getPermissionChecker(), (long)serviceContext.getScopeGroupId(), (long)folderId, (String)"UPDATE");
        serviceContext.setUserId(this.getUserId());
        return this.dlFolderLocalService.updateFolder(folderId, name, description, defaultFileEntryTypeId, fileEntryTypeIds, restrictionType, serviceContext);
    }

    public boolean verifyInheritableLock(long folderId, String lockUuid) throws PortalException {
        return this.dlFolderLocalService.verifyInheritableLock(folderId, lockUuid);
    }
}

