/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.internal;

import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.module.util.ServiceTrackerFieldUpdaterCustomizer;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.portlet.FriendlyURLMapper;
import com.liferay.portal.kernel.portlet.FriendlyURLMapperTracker;
import com.liferay.portal.kernel.portlet.Route;
import com.liferay.portal.kernel.portlet.Router;
import com.liferay.portal.kernel.util.HttpComponentsUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.UnsecureSAXReaderUtil;
import com.liferay.portlet.RouterImpl;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class FriendlyURLMapperTrackerImpl
implements FriendlyURLMapperTracker {
    private static final Log _log = LogFactoryUtil.getLog(FriendlyURLMapperTrackerImpl.class);
    private final BundleContext _bundleContext = SystemBundleUtil.getBundleContext();
    private volatile FriendlyURLMapper _friendlyURLMapper;
    private final Portlet _portlet;
    private final Map<FriendlyURLMapper, ServiceRegistration<?>> _serviceRegistrations = new ConcurrentHashMap();
    private final ServiceTracker<FriendlyURLMapper, FriendlyURLMapper> _serviceTracker;

    public FriendlyURLMapperTrackerImpl(Portlet portlet) throws Exception {
        this._portlet = portlet;
        String filterString = null;
        String portletId = portlet.getPortletId();
        String portletName = portlet.getPortletName();
        filterString = portletId.equals(portletName) ? StringBundler.concat((String[])new String[]{"(&(javax.portlet.name=", portletId, ")(objectClass=", FriendlyURLMapper.class.getName(), "))"}) : StringBundler.concat((String[])new String[]{"(&(|(javax.portlet.name=", portletId, ")(javax.portlet.name=", portletName, "))(objectClass=", FriendlyURLMapper.class.getName(), "))"});
        this._serviceTracker = new ServiceTracker(this._bundleContext, SystemBundleUtil.createFilter((String)filterString), (ServiceTrackerCustomizer)new FriendlyURLMapperServiceTrackerCustomizer());
        this._serviceTracker.open();
    }

    public void close() {
        for (Map.Entry<FriendlyURLMapper, ServiceRegistration<?>> entry : this._serviceRegistrations.entrySet()) {
            ServiceRegistration<?> serviceRegistration = entry.getValue();
            serviceRegistration.unregister();
        }
        this._serviceTracker.close();
    }

    public FriendlyURLMapper getFriendlyURLMapper() {
        return this._friendlyURLMapper;
    }

    public void register(FriendlyURLMapper friendlyURLMapper) {
        ServiceRegistration serviceRegistration = this._bundleContext.registerService(FriendlyURLMapper.class, (Object)friendlyURLMapper, MapUtil.singletonDictionary((Object)"javax.portlet.name", (Object)this._portlet.getPortletId()));
        this._serviceRegistrations.put(friendlyURLMapper, serviceRegistration);
    }

    public void unregister(FriendlyURLMapper friendlyURLMapper) {
        ServiceRegistration<?> serviceRegistration = this._serviceRegistrations.remove(friendlyURLMapper);
        if (serviceRegistration != null) {
            serviceRegistration.unregister();
        }
    }

    protected String getContent(ClassLoader classLoader, String fileName) throws Exception {
        String queryString = HttpComponentsUtil.getQueryString((String)fileName);
        if (Validator.isNull((String)queryString)) {
            return StringUtil.read((ClassLoader)classLoader, (String)fileName);
        }
        int pos = fileName.indexOf("?");
        String xml = StringUtil.read((ClassLoader)classLoader, (String)fileName.substring(0, pos));
        Map parameterMap = HttpComponentsUtil.getParameterMap((String)queryString);
        if (parameterMap == null) {
            return xml;
        }
        for (Map.Entry entry : parameterMap.entrySet()) {
            String[] values = (String[])entry.getValue();
            if (values.length == 0) continue;
            String value = values[0];
            xml = StringUtil.replace((String)xml, (String)("@" + (String)entry.getKey() + "@"), (String)value);
        }
        return xml;
    }

    private class FriendlyURLMapperServiceTrackerCustomizer
    extends ServiceTrackerFieldUpdaterCustomizer<FriendlyURLMapper, FriendlyURLMapper> {
        protected FriendlyURLMapper doAddingService(ServiceReference<FriendlyURLMapper> serviceReference) {
            FriendlyURLMapper friendlyURLMapper = (FriendlyURLMapper)FriendlyURLMapperTrackerImpl.this._bundleContext.getService(serviceReference);
            try {
                if (Validator.isNotNull((String)FriendlyURLMapperTrackerImpl.this._portlet.getFriendlyURLMapping())) {
                    friendlyURLMapper.setMapping(FriendlyURLMapperTrackerImpl.this._portlet.getFriendlyURLMapping());
                }
                friendlyURLMapper.setPortletId(FriendlyURLMapperTrackerImpl.this._portlet.getPortletId());
                friendlyURLMapper.setPortletInstanceable(FriendlyURLMapperTrackerImpl.this._portlet.isInstanceable());
                String friendlyURLRoutes = (String)serviceReference.getProperty("com.liferay.portlet.friendly-url-routes");
                if (Validator.isNotNull((String)FriendlyURLMapperTrackerImpl.this._portlet.getFriendlyURLRoutes())) {
                    friendlyURLRoutes = FriendlyURLMapperTrackerImpl.this._portlet.getFriendlyURLRoutes();
                }
                String xml = null;
                if (Validator.isNotNull((String)friendlyURLRoutes)) {
                    Class<?> clazz = friendlyURLMapper.getClass();
                    xml = FriendlyURLMapperTrackerImpl.this.getContent(clazz.getClassLoader(), friendlyURLRoutes);
                }
                friendlyURLMapper.setRouter(this.newFriendlyURLRouter(xml));
            }
            catch (Exception exception) {
                _log.error((Throwable)exception);
                return null;
            }
            return friendlyURLMapper;
        }

        protected Router newFriendlyURLRouter(String xml) throws Exception {
            if (Validator.isNull((String)xml)) {
                return null;
            }
            Document document = UnsecureSAXReaderUtil.read((String)xml, (boolean)true);
            Element rootElement = document.getRootElement();
            List routeElements = rootElement.elements("route");
            RouterImpl router = new RouterImpl(routeElements.size());
            for (Element routeElement : routeElements) {
                String value;
                String name;
                String pattern = routeElement.elementText("pattern");
                Route route = router.addRoute(pattern);
                for (Element generatedParameterElement : routeElement.elements("generated-parameter")) {
                    name = generatedParameterElement.attributeValue("name");
                    value = generatedParameterElement.getText();
                    route.addGeneratedParameter(name, value);
                }
                for (Element ignoredParameterElement : routeElement.elements("ignored-parameter")) {
                    name = ignoredParameterElement.attributeValue("name");
                    route.addIgnoredParameter(name);
                }
                for (Element implicitParameterElement : routeElement.elements("implicit-parameter")) {
                    name = implicitParameterElement.attributeValue("name");
                    value = implicitParameterElement.getText();
                    route.addImplicitParameter(name, value);
                }
                for (Element overriddenParameterElement : routeElement.elements("overridden-parameter")) {
                    name = overriddenParameterElement.attributeValue("name");
                    value = overriddenParameterElement.getText();
                    route.addOverriddenParameter(name, value);
                }
            }
            return router;
        }

        private FriendlyURLMapperServiceTrackerCustomizer() throws Exception {
            super(ReflectionUtil.getDeclaredField(FriendlyURLMapperTrackerImpl.class, (String)"_friendlyURLMapper"), (Object)FriendlyURLMapperTrackerImpl.this, null);
        }
    }
}

