/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.social.service.base;

import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.ParamSetter;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdate;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdateFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DefaultActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.BaseLocalService;
import com.liferay.portal.kernel.service.BaseLocalServiceImpl;
import com.liferay.portal.kernel.service.PersistedModelLocalService;
import com.liferay.portal.kernel.service.PersistedModelLocalServiceRegistry;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.service.persistence.change.tracking.CTPersistence;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.social.kernel.model.SocialRequest;
import com.liferay.social.kernel.service.SocialRequestLocalService;
import com.liferay.social.kernel.service.SocialRequestLocalServiceUtil;
import com.liferay.social.kernel.service.persistence.SocialRequestPersistence;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.List;
import javax.sql.DataSource;

public abstract class SocialRequestLocalServiceBaseImpl
extends BaseLocalServiceImpl
implements IdentifiableOSGiService,
SocialRequestLocalService {
    @BeanReference(type=SocialRequestLocalService.class)
    protected SocialRequestLocalService socialRequestLocalService;
    @BeanReference(type=SocialRequestPersistence.class)
    protected SocialRequestPersistence socialRequestPersistence;
    @BeanReference(type=CounterLocalService.class)
    protected CounterLocalService counterLocalService;
    private static final Log _log = LogFactoryUtil.getLog(SocialRequestLocalServiceBaseImpl.class);
    @BeanReference(type=PersistedModelLocalServiceRegistry.class)
    protected PersistedModelLocalServiceRegistry persistedModelLocalServiceRegistry;

    @Indexable(type=IndexableType.REINDEX)
    public SocialRequest addSocialRequest(SocialRequest socialRequest) {
        socialRequest.setNew(true);
        return (SocialRequest)this.socialRequestPersistence.update((BaseModel)socialRequest);
    }

    @Transactional(enabled=false)
    public SocialRequest createSocialRequest(long requestId) {
        return this.socialRequestPersistence.create(requestId);
    }

    @Indexable(type=IndexableType.DELETE)
    public SocialRequest deleteSocialRequest(long requestId) throws PortalException {
        return this.socialRequestPersistence.remove(requestId);
    }

    @Indexable(type=IndexableType.DELETE)
    public SocialRequest deleteSocialRequest(SocialRequest socialRequest) {
        return (SocialRequest)this.socialRequestPersistence.remove((BaseModel)socialRequest);
    }

    public <T> T dslQuery(DSLQuery dslQuery) {
        return (T)this.socialRequestPersistence.dslQuery(dslQuery);
    }

    public int dslQueryCount(DSLQuery dslQuery) {
        Long count = (Long)this.dslQuery(dslQuery);
        return count.intValue();
    }

    public DynamicQuery dynamicQuery() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        return DynamicQueryFactoryUtil.forClass(SocialRequest.class, (ClassLoader)clazz.getClassLoader());
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery) {
        return this.socialRequestPersistence.findWithDynamicQuery(dynamicQuery);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end) {
        return this.socialRequestPersistence.findWithDynamicQuery(dynamicQuery, start, end);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end, OrderByComparator<T> orderByComparator) {
        return this.socialRequestPersistence.findWithDynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery) {
        return this.socialRequestPersistence.countWithDynamicQuery(dynamicQuery);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery, Projection projection) {
        return this.socialRequestPersistence.countWithDynamicQuery(dynamicQuery, projection);
    }

    public SocialRequest fetchSocialRequest(long requestId) {
        return this.socialRequestPersistence.fetchByPrimaryKey(requestId);
    }

    public SocialRequest fetchSocialRequestByUuidAndGroupId(String uuid, long groupId) {
        return this.socialRequestPersistence.fetchByUUID_G(uuid, groupId);
    }

    public SocialRequest getSocialRequest(long requestId) throws PortalException {
        return this.socialRequestPersistence.findByPrimaryKey(requestId);
    }

    public ActionableDynamicQuery getActionableDynamicQuery() {
        DefaultActionableDynamicQuery actionableDynamicQuery = new DefaultActionableDynamicQuery();
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.socialRequestLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(SocialRequest.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("requestId");
        return actionableDynamicQuery;
    }

    public IndexableActionableDynamicQuery getIndexableActionableDynamicQuery() {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = new IndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setBaseLocalService((BaseLocalService)this.socialRequestLocalService);
        indexableActionableDynamicQuery.setClassLoader(this.getClassLoader());
        indexableActionableDynamicQuery.setModelClass(SocialRequest.class);
        indexableActionableDynamicQuery.setPrimaryKeyPropertyName("requestId");
        return indexableActionableDynamicQuery;
    }

    protected void initActionableDynamicQuery(ActionableDynamicQuery actionableDynamicQuery) {
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.socialRequestLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(SocialRequest.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("requestId");
    }

    public PersistedModel createPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return this.socialRequestPersistence.create(((Long)primaryKeyObj).longValue());
    }

    public PersistedModel deletePersistedModel(PersistedModel persistedModel) throws PortalException {
        if (_log.isWarnEnabled()) {
            _log.warn((Object)"Implement SocialRequestLocalServiceImpl#deleteSocialRequest(SocialRequest) to avoid orphaned data");
        }
        return this.socialRequestLocalService.deleteSocialRequest((SocialRequest)persistedModel);
    }

    public BasePersistence<SocialRequest> getBasePersistence() {
        return this.socialRequestPersistence;
    }

    public PersistedModel getPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return (PersistedModel)this.socialRequestPersistence.findByPrimaryKey(primaryKeyObj);
    }

    public List<SocialRequest> getSocialRequestsByUuidAndCompanyId(String uuid, long companyId) {
        return this.socialRequestPersistence.findByUuid_C(uuid, companyId);
    }

    public List<SocialRequest> getSocialRequestsByUuidAndCompanyId(String uuid, long companyId, int start, int end, OrderByComparator<SocialRequest> orderByComparator) {
        return this.socialRequestPersistence.findByUuid_C(uuid, companyId, start, end, orderByComparator);
    }

    public SocialRequest getSocialRequestByUuidAndGroupId(String uuid, long groupId) throws PortalException {
        return this.socialRequestPersistence.findByUUID_G(uuid, groupId);
    }

    public List<SocialRequest> getSocialRequests(int start, int end) {
        return this.socialRequestPersistence.findAll(start, end);
    }

    public int getSocialRequestsCount() {
        return this.socialRequestPersistence.countAll();
    }

    @Indexable(type=IndexableType.REINDEX)
    public SocialRequest updateSocialRequest(SocialRequest socialRequest) {
        return (SocialRequest)this.socialRequestPersistence.update((BaseModel)socialRequest);
    }

    public SocialRequestLocalService getSocialRequestLocalService() {
        return this.socialRequestLocalService;
    }

    public void setSocialRequestLocalService(SocialRequestLocalService socialRequestLocalService) {
        this.socialRequestLocalService = socialRequestLocalService;
    }

    public SocialRequestPersistence getSocialRequestPersistence() {
        return this.socialRequestPersistence;
    }

    public void setSocialRequestPersistence(SocialRequestPersistence socialRequestPersistence) {
        this.socialRequestPersistence = socialRequestPersistence;
    }

    public CounterLocalService getCounterLocalService() {
        return this.counterLocalService;
    }

    public void setCounterLocalService(CounterLocalService counterLocalService) {
        this.counterLocalService = counterLocalService;
    }

    public void afterPropertiesSet() {
        this.persistedModelLocalServiceRegistry.register("com.liferay.social.kernel.model.SocialRequest", (PersistedModelLocalService)this.socialRequestLocalService);
        this._setLocalServiceUtilService(this.socialRequestLocalService);
    }

    public void destroy() {
        this.persistedModelLocalServiceRegistry.unregister("com.liferay.social.kernel.model.SocialRequest");
        this._setLocalServiceUtilService(null);
    }

    public String getOSGiServiceIdentifier() {
        return SocialRequestLocalService.class.getName();
    }

    public CTPersistence<SocialRequest> getCTPersistence() {
        return this.socialRequestPersistence;
    }

    public Class<SocialRequest> getModelClass() {
        return SocialRequest.class;
    }

    public <R, E extends Throwable> R updateWithUnsafeFunction(UnsafeFunction<CTPersistence<SocialRequest>, R, E> updateUnsafeFunction) throws E {
        return (R)updateUnsafeFunction.apply((Object)this.socialRequestPersistence);
    }

    protected String getModelClassName() {
        return SocialRequest.class.getName();
    }

    protected void runSQL(String sql) {
        try {
            DataSource dataSource = this.socialRequestPersistence.getDataSource();
            DB db = DBManagerUtil.getDB();
            sql = db.buildSQL(sql);
            sql = PortalUtil.transformSQL((String)sql);
            SqlUpdate sqlUpdate = SqlUpdateFactoryUtil.getSqlUpdate((DataSource)dataSource, (String)sql, (ParamSetter[])new ParamSetter[0]);
            sqlUpdate.update(new Object[0]);
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    private void _setLocalServiceUtilService(SocialRequestLocalService socialRequestLocalService) {
        try {
            Field field = SocialRequestLocalServiceUtil.class.getDeclaredField("_service");
            field.setAccessible(true);
            field.set(null, socialRequestLocalService);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
    }
}

