/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.portal.model.impl;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.Address;
import com.liferay.portal.kernel.model.AddressModel;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the Address service. Represents a row in the &quot;Address&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>AddressModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link AddressImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see AddressImpl
 * @generated
 */
@JSON(strict = true)
public class AddressModelImpl
	extends BaseModelImpl<Address> implements AddressModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a address model instance should use the <code>Address</code> interface instead.
	 */
	public static final String TABLE_NAME = "Address";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"ctCollectionId", Types.BIGINT},
		{"uuid_", Types.VARCHAR}, {"externalReferenceCode", Types.VARCHAR},
		{"addressId", Types.BIGINT}, {"companyId", Types.BIGINT},
		{"userId", Types.BIGINT}, {"userName", Types.VARCHAR},
		{"createDate", Types.TIMESTAMP}, {"modifiedDate", Types.TIMESTAMP},
		{"classNameId", Types.BIGINT}, {"classPK", Types.BIGINT},
		{"countryId", Types.BIGINT}, {"listTypeId", Types.BIGINT},
		{"regionId", Types.BIGINT}, {"city", Types.VARCHAR},
		{"description", Types.VARCHAR}, {"latitude", Types.DOUBLE},
		{"longitude", Types.DOUBLE}, {"mailing", Types.BOOLEAN},
		{"name", Types.VARCHAR}, {"primary_", Types.BOOLEAN},
		{"street1", Types.VARCHAR}, {"street2", Types.VARCHAR},
		{"street3", Types.VARCHAR}, {"validationDate", Types.TIMESTAMP},
		{"validationStatus", Types.INTEGER}, {"zip", Types.VARCHAR}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("ctCollectionId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("externalReferenceCode", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("addressId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("classNameId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("classPK", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("countryId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("listTypeId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("regionId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("city", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("description", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("latitude", Types.DOUBLE);
		TABLE_COLUMNS_MAP.put("longitude", Types.DOUBLE);
		TABLE_COLUMNS_MAP.put("mailing", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("name", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("primary_", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("street1", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("street2", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("street3", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("validationDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("validationStatus", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("zip", Types.VARCHAR);
	}

	public static final String TABLE_SQL_CREATE =
		"create table Address (mvccVersion LONG default 0 not null,ctCollectionId LONG default 0 not null,uuid_ VARCHAR(75) null,externalReferenceCode VARCHAR(75) null,addressId LONG not null,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,classNameId LONG,classPK LONG,countryId LONG,listTypeId LONG,regionId LONG,city VARCHAR(75) null,description STRING null,latitude DOUBLE,longitude DOUBLE,mailing BOOLEAN,name VARCHAR(255) null,primary_ BOOLEAN,street1 VARCHAR(255) null,street2 VARCHAR(255) null,street3 VARCHAR(255) null,validationDate DATE null,validationStatus INTEGER,zip VARCHAR(75) null,primary key (addressId, ctCollectionId))";

	public static final String TABLE_SQL_DROP = "drop table Address";

	public static final String ORDER_BY_JPQL =
		" ORDER BY address.createDate ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY Address.createDate ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean ENTITY_CACHE_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean FINDER_CACHE_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean COLUMN_BITMASK_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CLASSNAMEID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CLASSPK_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMPANYID_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COUNTRYID_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long EXTERNALREFERENCECODE_COLUMN_BITMASK = 16L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long LISTTYPEID_COLUMN_BITMASK = 32L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long MAILING_COLUMN_BITMASK = 64L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long PRIMARY_COLUMN_BITMASK = 128L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long REGIONID_COLUMN_BITMASK = 256L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long USERID_COLUMN_BITMASK = 512L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long UUID_COLUMN_BITMASK = 1024L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CREATEDATE_COLUMN_BITMASK = 2048L;

	public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(
		com.liferay.portal.util.PropsUtil.get(
			"lock.expiration.time.com.liferay.portal.kernel.model.Address"));

	public AddressModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _addressId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setAddressId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _addressId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return Address.class;
	}

	@Override
	public String getModelClassName() {
		return Address.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<Address, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		for (Map.Entry<String, Function<Address, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<Address, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName, attributeGetterFunction.apply((Address)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<Address, Object>> attributeSetterBiConsumers =
			getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<Address, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(Address)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<Address, Object>>
		getAttributeGetterFunctions() {

		return AttributeGetterFunctionsHolder._attributeGetterFunctions;
	}

	public Map<String, BiConsumer<Address, Object>>
		getAttributeSetterBiConsumers() {

		return AttributeSetterBiConsumersHolder._attributeSetterBiConsumers;
	}

	private static class AttributeGetterFunctionsHolder {

		private static final Map<String, Function<Address, Object>>
			_attributeGetterFunctions;

		static {
			Map<String, Function<Address, Object>> attributeGetterFunctions =
				new LinkedHashMap<String, Function<Address, Object>>();

			attributeGetterFunctions.put(
				"mvccVersion", Address::getMvccVersion);
			attributeGetterFunctions.put(
				"ctCollectionId", Address::getCtCollectionId);
			attributeGetterFunctions.put("uuid", Address::getUuid);
			attributeGetterFunctions.put(
				"externalReferenceCode", Address::getExternalReferenceCode);
			attributeGetterFunctions.put("addressId", Address::getAddressId);
			attributeGetterFunctions.put("companyId", Address::getCompanyId);
			attributeGetterFunctions.put("userId", Address::getUserId);
			attributeGetterFunctions.put("userName", Address::getUserName);
			attributeGetterFunctions.put("createDate", Address::getCreateDate);
			attributeGetterFunctions.put(
				"modifiedDate", Address::getModifiedDate);
			attributeGetterFunctions.put(
				"classNameId", Address::getClassNameId);
			attributeGetterFunctions.put("classPK", Address::getClassPK);
			attributeGetterFunctions.put("countryId", Address::getCountryId);
			attributeGetterFunctions.put("listTypeId", Address::getListTypeId);
			attributeGetterFunctions.put("regionId", Address::getRegionId);
			attributeGetterFunctions.put("city", Address::getCity);
			attributeGetterFunctions.put(
				"description", Address::getDescription);
			attributeGetterFunctions.put("latitude", Address::getLatitude);
			attributeGetterFunctions.put("longitude", Address::getLongitude);
			attributeGetterFunctions.put("mailing", Address::getMailing);
			attributeGetterFunctions.put("name", Address::getName);
			attributeGetterFunctions.put("primary", Address::getPrimary);
			attributeGetterFunctions.put("street1", Address::getStreet1);
			attributeGetterFunctions.put("street2", Address::getStreet2);
			attributeGetterFunctions.put("street3", Address::getStreet3);
			attributeGetterFunctions.put(
				"validationDate", Address::getValidationDate);
			attributeGetterFunctions.put(
				"validationStatus", Address::getValidationStatus);
			attributeGetterFunctions.put("zip", Address::getZip);

			_attributeGetterFunctions = Collections.unmodifiableMap(
				attributeGetterFunctions);
		}

	}

	private static class AttributeSetterBiConsumersHolder {

		private static final Map<String, BiConsumer<Address, Object>>
			_attributeSetterBiConsumers;

		static {
			Map<String, BiConsumer<Address, ?>> attributeSetterBiConsumers =
				new LinkedHashMap<String, BiConsumer<Address, ?>>();

			attributeSetterBiConsumers.put(
				"mvccVersion",
				(BiConsumer<Address, Long>)Address::setMvccVersion);
			attributeSetterBiConsumers.put(
				"ctCollectionId",
				(BiConsumer<Address, Long>)Address::setCtCollectionId);
			attributeSetterBiConsumers.put(
				"uuid", (BiConsumer<Address, String>)Address::setUuid);
			attributeSetterBiConsumers.put(
				"externalReferenceCode",
				(BiConsumer<Address, String>)Address::setExternalReferenceCode);
			attributeSetterBiConsumers.put(
				"addressId", (BiConsumer<Address, Long>)Address::setAddressId);
			attributeSetterBiConsumers.put(
				"companyId", (BiConsumer<Address, Long>)Address::setCompanyId);
			attributeSetterBiConsumers.put(
				"userId", (BiConsumer<Address, Long>)Address::setUserId);
			attributeSetterBiConsumers.put(
				"userName", (BiConsumer<Address, String>)Address::setUserName);
			attributeSetterBiConsumers.put(
				"createDate",
				(BiConsumer<Address, Date>)Address::setCreateDate);
			attributeSetterBiConsumers.put(
				"modifiedDate",
				(BiConsumer<Address, Date>)Address::setModifiedDate);
			attributeSetterBiConsumers.put(
				"classNameId",
				(BiConsumer<Address, Long>)Address::setClassNameId);
			attributeSetterBiConsumers.put(
				"classPK", (BiConsumer<Address, Long>)Address::setClassPK);
			attributeSetterBiConsumers.put(
				"countryId", (BiConsumer<Address, Long>)Address::setCountryId);
			attributeSetterBiConsumers.put(
				"listTypeId",
				(BiConsumer<Address, Long>)Address::setListTypeId);
			attributeSetterBiConsumers.put(
				"regionId", (BiConsumer<Address, Long>)Address::setRegionId);
			attributeSetterBiConsumers.put(
				"city", (BiConsumer<Address, String>)Address::setCity);
			attributeSetterBiConsumers.put(
				"description",
				(BiConsumer<Address, String>)Address::setDescription);
			attributeSetterBiConsumers.put(
				"latitude", (BiConsumer<Address, Double>)Address::setLatitude);
			attributeSetterBiConsumers.put(
				"longitude",
				(BiConsumer<Address, Double>)Address::setLongitude);
			attributeSetterBiConsumers.put(
				"mailing", (BiConsumer<Address, Boolean>)Address::setMailing);
			attributeSetterBiConsumers.put(
				"name", (BiConsumer<Address, String>)Address::setName);
			attributeSetterBiConsumers.put(
				"primary", (BiConsumer<Address, Boolean>)Address::setPrimary);
			attributeSetterBiConsumers.put(
				"street1", (BiConsumer<Address, String>)Address::setStreet1);
			attributeSetterBiConsumers.put(
				"street2", (BiConsumer<Address, String>)Address::setStreet2);
			attributeSetterBiConsumers.put(
				"street3", (BiConsumer<Address, String>)Address::setStreet3);
			attributeSetterBiConsumers.put(
				"validationDate",
				(BiConsumer<Address, Date>)Address::setValidationDate);
			attributeSetterBiConsumers.put(
				"validationStatus",
				(BiConsumer<Address, Integer>)Address::setValidationStatus);
			attributeSetterBiConsumers.put(
				"zip", (BiConsumer<Address, String>)Address::setZip);

			_attributeSetterBiConsumers = Collections.unmodifiableMap(
				(Map)attributeSetterBiConsumers);
		}

	}

	@JSON
	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@JSON
	@Override
	public long getCtCollectionId() {
		return _ctCollectionId;
	}

	@Override
	public void setCtCollectionId(long ctCollectionId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_ctCollectionId = ctCollectionId;
	}

	@JSON
	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_uuid = uuid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalUuid() {
		return getColumnOriginalValue("uuid_");
	}

	@JSON
	@Override
	public String getExternalReferenceCode() {
		if (_externalReferenceCode == null) {
			return "";
		}
		else {
			return _externalReferenceCode;
		}
	}

	@Override
	public void setExternalReferenceCode(String externalReferenceCode) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_externalReferenceCode = externalReferenceCode;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalExternalReferenceCode() {
		return getColumnOriginalValue("externalReferenceCode");
	}

	@JSON
	@Override
	public long getAddressId() {
		return _addressId;
	}

	@Override
	public void setAddressId(long addressId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_addressId = addressId;
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCompanyId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("companyId"));
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalUserId() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("userId"));
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@Override
	public String getClassName() {
		if (getClassNameId() <= 0) {
			return "";
		}

		return PortalUtil.getClassName(getClassNameId());
	}

	@Override
	public void setClassName(String className) {
		long classNameId = 0;

		if (Validator.isNotNull(className)) {
			classNameId = PortalUtil.getClassNameId(className);
		}

		setClassNameId(classNameId);
	}

	@JSON
	@Override
	public long getClassNameId() {
		return _classNameId;
	}

	@Override
	public void setClassNameId(long classNameId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_classNameId = classNameId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalClassNameId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("classNameId"));
	}

	@JSON
	@Override
	public long getClassPK() {
		return _classPK;
	}

	@Override
	public void setClassPK(long classPK) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_classPK = classPK;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalClassPK() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("classPK"));
	}

	@JSON
	@Override
	public long getCountryId() {
		return _countryId;
	}

	@Override
	public void setCountryId(long countryId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_countryId = countryId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCountryId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("countryId"));
	}

	@JSON
	@Override
	public long getListTypeId() {
		return _listTypeId;
	}

	@Override
	public void setListTypeId(long listTypeId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_listTypeId = listTypeId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalListTypeId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("listTypeId"));
	}

	@JSON
	@Override
	public long getRegionId() {
		return _regionId;
	}

	@Override
	public void setRegionId(long regionId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_regionId = regionId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalRegionId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("regionId"));
	}

	@JSON
	@Override
	public String getCity() {
		if (_city == null) {
			return "";
		}
		else {
			return _city;
		}
	}

	@Override
	public void setCity(String city) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_city = city;
	}

	@JSON
	@Override
	public String getDescription() {
		if (_description == null) {
			return "";
		}
		else {
			return _description;
		}
	}

	@Override
	public void setDescription(String description) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_description = description;
	}

	@JSON
	@Override
	public double getLatitude() {
		return _latitude;
	}

	@Override
	public void setLatitude(double latitude) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_latitude = latitude;
	}

	@JSON
	@Override
	public double getLongitude() {
		return _longitude;
	}

	@Override
	public void setLongitude(double longitude) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_longitude = longitude;
	}

	@JSON
	@Override
	public boolean getMailing() {
		return _mailing;
	}

	@JSON
	@Override
	public boolean isMailing() {
		return _mailing;
	}

	@Override
	public void setMailing(boolean mailing) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mailing = mailing;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public boolean getOriginalMailing() {
		return GetterUtil.getBoolean(
			this.<Boolean>getColumnOriginalValue("mailing"));
	}

	@JSON
	@Override
	public String getName() {
		if (_name == null) {
			return "";
		}
		else {
			return _name;
		}
	}

	@Override
	public void setName(String name) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_name = name;
	}

	@JSON
	@Override
	public boolean getPrimary() {
		return _primary;
	}

	@JSON
	@Override
	public boolean isPrimary() {
		return _primary;
	}

	@Override
	public void setPrimary(boolean primary) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_primary = primary;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public boolean getOriginalPrimary() {
		return GetterUtil.getBoolean(
			this.<Boolean>getColumnOriginalValue("primary_"));
	}

	@JSON
	@Override
	public String getStreet1() {
		if (_street1 == null) {
			return "";
		}
		else {
			return _street1;
		}
	}

	@Override
	public void setStreet1(String street1) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_street1 = street1;
	}

	@JSON
	@Override
	public String getStreet2() {
		if (_street2 == null) {
			return "";
		}
		else {
			return _street2;
		}
	}

	@Override
	public void setStreet2(String street2) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_street2 = street2;
	}

	@JSON
	@Override
	public String getStreet3() {
		if (_street3 == null) {
			return "";
		}
		else {
			return _street3;
		}
	}

	@Override
	public void setStreet3(String street3) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_street3 = street3;
	}

	@JSON
	@Override
	public Date getValidationDate() {
		return _validationDate;
	}

	@Override
	public void setValidationDate(Date validationDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_validationDate = validationDate;
	}

	@JSON
	@Override
	public int getValidationStatus() {
		return _validationStatus;
	}

	@Override
	public void setValidationStatus(int validationStatus) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_validationStatus = validationStatus;
	}

	@JSON
	@Override
	public String getZip() {
		if (_zip == null) {
			return "";
		}
		else {
			return _zip;
		}
	}

	@Override
	public void setZip(String zip) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_zip = zip;
	}

	@Override
	public StagedModelType getStagedModelType() {
		return new StagedModelType(
			PortalUtil.getClassNameId(Address.class.getName()),
			getClassNameId());
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), Address.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public Address toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, Address>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		AddressImpl addressImpl = new AddressImpl();

		addressImpl.setMvccVersion(getMvccVersion());
		addressImpl.setCtCollectionId(getCtCollectionId());
		addressImpl.setUuid(getUuid());
		addressImpl.setExternalReferenceCode(getExternalReferenceCode());
		addressImpl.setAddressId(getAddressId());
		addressImpl.setCompanyId(getCompanyId());
		addressImpl.setUserId(getUserId());
		addressImpl.setUserName(getUserName());
		addressImpl.setCreateDate(getCreateDate());
		addressImpl.setModifiedDate(getModifiedDate());
		addressImpl.setClassNameId(getClassNameId());
		addressImpl.setClassPK(getClassPK());
		addressImpl.setCountryId(getCountryId());
		addressImpl.setListTypeId(getListTypeId());
		addressImpl.setRegionId(getRegionId());
		addressImpl.setCity(getCity());
		addressImpl.setDescription(getDescription());
		addressImpl.setLatitude(getLatitude());
		addressImpl.setLongitude(getLongitude());
		addressImpl.setMailing(isMailing());
		addressImpl.setName(getName());
		addressImpl.setPrimary(isPrimary());
		addressImpl.setStreet1(getStreet1());
		addressImpl.setStreet2(getStreet2());
		addressImpl.setStreet3(getStreet3());
		addressImpl.setValidationDate(getValidationDate());
		addressImpl.setValidationStatus(getValidationStatus());
		addressImpl.setZip(getZip());

		addressImpl.resetOriginalValues();

		return addressImpl;
	}

	@Override
	public Address cloneWithOriginalValues() {
		AddressImpl addressImpl = new AddressImpl();

		addressImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		addressImpl.setCtCollectionId(
			this.<Long>getColumnOriginalValue("ctCollectionId"));
		addressImpl.setUuid(this.<String>getColumnOriginalValue("uuid_"));
		addressImpl.setExternalReferenceCode(
			this.<String>getColumnOriginalValue("externalReferenceCode"));
		addressImpl.setAddressId(
			this.<Long>getColumnOriginalValue("addressId"));
		addressImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		addressImpl.setUserId(this.<Long>getColumnOriginalValue("userId"));
		addressImpl.setUserName(
			this.<String>getColumnOriginalValue("userName"));
		addressImpl.setCreateDate(
			this.<Date>getColumnOriginalValue("createDate"));
		addressImpl.setModifiedDate(
			this.<Date>getColumnOriginalValue("modifiedDate"));
		addressImpl.setClassNameId(
			this.<Long>getColumnOriginalValue("classNameId"));
		addressImpl.setClassPK(this.<Long>getColumnOriginalValue("classPK"));
		addressImpl.setCountryId(
			this.<Long>getColumnOriginalValue("countryId"));
		addressImpl.setListTypeId(
			this.<Long>getColumnOriginalValue("listTypeId"));
		addressImpl.setRegionId(this.<Long>getColumnOriginalValue("regionId"));
		addressImpl.setCity(this.<String>getColumnOriginalValue("city"));
		addressImpl.setDescription(
			this.<String>getColumnOriginalValue("description"));
		addressImpl.setLatitude(
			this.<Double>getColumnOriginalValue("latitude"));
		addressImpl.setLongitude(
			this.<Double>getColumnOriginalValue("longitude"));
		addressImpl.setMailing(this.<Boolean>getColumnOriginalValue("mailing"));
		addressImpl.setName(this.<String>getColumnOriginalValue("name"));
		addressImpl.setPrimary(
			this.<Boolean>getColumnOriginalValue("primary_"));
		addressImpl.setStreet1(this.<String>getColumnOriginalValue("street1"));
		addressImpl.setStreet2(this.<String>getColumnOriginalValue("street2"));
		addressImpl.setStreet3(this.<String>getColumnOriginalValue("street3"));
		addressImpl.setValidationDate(
			this.<Date>getColumnOriginalValue("validationDate"));
		addressImpl.setValidationStatus(
			this.<Integer>getColumnOriginalValue("validationStatus"));
		addressImpl.setZip(this.<String>getColumnOriginalValue("zip"));

		return addressImpl;
	}

	@Override
	public int compareTo(Address address) {
		int value = 0;

		value = DateUtil.compareTo(getCreateDate(), address.getCreateDate());

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof Address)) {
			return false;
		}

		Address address = (Address)object;

		long primaryKey = address.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return ENTITY_CACHE_ENABLED;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return FINDER_CACHE_ENABLED;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<Address> toCacheModel() {
		AddressCacheModel addressCacheModel = new AddressCacheModel();

		addressCacheModel.mvccVersion = getMvccVersion();

		addressCacheModel.ctCollectionId = getCtCollectionId();

		addressCacheModel.uuid = getUuid();

		String uuid = addressCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			addressCacheModel.uuid = null;
		}

		addressCacheModel.externalReferenceCode = getExternalReferenceCode();

		String externalReferenceCode = addressCacheModel.externalReferenceCode;

		if ((externalReferenceCode != null) &&
			(externalReferenceCode.length() == 0)) {

			addressCacheModel.externalReferenceCode = null;
		}

		addressCacheModel.addressId = getAddressId();

		addressCacheModel.companyId = getCompanyId();

		addressCacheModel.userId = getUserId();

		addressCacheModel.userName = getUserName();

		String userName = addressCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			addressCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			addressCacheModel.createDate = createDate.getTime();
		}
		else {
			addressCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			addressCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			addressCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		addressCacheModel.classNameId = getClassNameId();

		addressCacheModel.classPK = getClassPK();

		addressCacheModel.countryId = getCountryId();

		addressCacheModel.listTypeId = getListTypeId();

		addressCacheModel.regionId = getRegionId();

		addressCacheModel.city = getCity();

		String city = addressCacheModel.city;

		if ((city != null) && (city.length() == 0)) {
			addressCacheModel.city = null;
		}

		addressCacheModel.description = getDescription();

		String description = addressCacheModel.description;

		if ((description != null) && (description.length() == 0)) {
			addressCacheModel.description = null;
		}

		addressCacheModel.latitude = getLatitude();

		addressCacheModel.longitude = getLongitude();

		addressCacheModel.mailing = isMailing();

		addressCacheModel.name = getName();

		String name = addressCacheModel.name;

		if ((name != null) && (name.length() == 0)) {
			addressCacheModel.name = null;
		}

		addressCacheModel.primary = isPrimary();

		addressCacheModel.street1 = getStreet1();

		String street1 = addressCacheModel.street1;

		if ((street1 != null) && (street1.length() == 0)) {
			addressCacheModel.street1 = null;
		}

		addressCacheModel.street2 = getStreet2();

		String street2 = addressCacheModel.street2;

		if ((street2 != null) && (street2.length() == 0)) {
			addressCacheModel.street2 = null;
		}

		addressCacheModel.street3 = getStreet3();

		String street3 = addressCacheModel.street3;

		if ((street3 != null) && (street3.length() == 0)) {
			addressCacheModel.street3 = null;
		}

		Date validationDate = getValidationDate();

		if (validationDate != null) {
			addressCacheModel.validationDate = validationDate.getTime();
		}
		else {
			addressCacheModel.validationDate = Long.MIN_VALUE;
		}

		addressCacheModel.validationStatus = getValidationStatus();

		addressCacheModel.zip = getZip();

		String zip = addressCacheModel.zip;

		if ((zip != null) && (zip.length() == 0)) {
			addressCacheModel.zip = null;
		}

		return addressCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<Address, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<Address, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<Address, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply((Address)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, Address>
			_escapedModelProxyProviderFunction =
				ProxyUtil.getProxyProviderFunction(
					Address.class, ModelWrapper.class);

	}

	private long _mvccVersion;
	private long _ctCollectionId;
	private String _uuid;
	private String _externalReferenceCode;
	private long _addressId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _classNameId;
	private long _classPK;
	private long _countryId;
	private long _listTypeId;
	private long _regionId;
	private String _city;
	private String _description;
	private double _latitude;
	private double _longitude;
	private boolean _mailing;
	private String _name;
	private boolean _primary;
	private String _street1;
	private String _street2;
	private String _street3;
	private Date _validationDate;
	private int _validationStatus;
	private String _zip;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<Address, Object> function =
			AttributeGetterFunctionsHolder._attributeGetterFunctions.get(
				columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((Address)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put("ctCollectionId", _ctCollectionId);
		_columnOriginalValues.put("uuid_", _uuid);
		_columnOriginalValues.put(
			"externalReferenceCode", _externalReferenceCode);
		_columnOriginalValues.put("addressId", _addressId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put("classNameId", _classNameId);
		_columnOriginalValues.put("classPK", _classPK);
		_columnOriginalValues.put("countryId", _countryId);
		_columnOriginalValues.put("listTypeId", _listTypeId);
		_columnOriginalValues.put("regionId", _regionId);
		_columnOriginalValues.put("city", _city);
		_columnOriginalValues.put("description", _description);
		_columnOriginalValues.put("latitude", _latitude);
		_columnOriginalValues.put("longitude", _longitude);
		_columnOriginalValues.put("mailing", _mailing);
		_columnOriginalValues.put("name", _name);
		_columnOriginalValues.put("primary_", _primary);
		_columnOriginalValues.put("street1", _street1);
		_columnOriginalValues.put("street2", _street2);
		_columnOriginalValues.put("street3", _street3);
		_columnOriginalValues.put("validationDate", _validationDate);
		_columnOriginalValues.put("validationStatus", _validationStatus);
		_columnOriginalValues.put("zip", _zip);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put("uuid_", "uuid");
		attributeNames.put("primary_", "primary");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("ctCollectionId", 2L);

		columnBitmasks.put("uuid_", 4L);

		columnBitmasks.put("externalReferenceCode", 8L);

		columnBitmasks.put("addressId", 16L);

		columnBitmasks.put("companyId", 32L);

		columnBitmasks.put("userId", 64L);

		columnBitmasks.put("userName", 128L);

		columnBitmasks.put("createDate", 256L);

		columnBitmasks.put("modifiedDate", 512L);

		columnBitmasks.put("classNameId", 1024L);

		columnBitmasks.put("classPK", 2048L);

		columnBitmasks.put("countryId", 4096L);

		columnBitmasks.put("listTypeId", 8192L);

		columnBitmasks.put("regionId", 16384L);

		columnBitmasks.put("city", 32768L);

		columnBitmasks.put("description", 65536L);

		columnBitmasks.put("latitude", 131072L);

		columnBitmasks.put("longitude", 262144L);

		columnBitmasks.put("mailing", 524288L);

		columnBitmasks.put("name", 1048576L);

		columnBitmasks.put("primary_", 2097152L);

		columnBitmasks.put("street1", 4194304L);

		columnBitmasks.put("street2", 8388608L);

		columnBitmasks.put("street3", 16777216L);

		columnBitmasks.put("validationDate", 33554432L);

		columnBitmasks.put("validationStatus", 67108864L);

		columnBitmasks.put("zip", 134217728L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private Address _escapedModel;

}