/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.portal.model.impl;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.Country;
import com.liferay.portal.kernel.model.CountryLocalization;
import com.liferay.portal.kernel.model.CountryModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.CountryLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the Country service. Represents a row in the &quot;Country&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>CountryModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CountryImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see CountryImpl
 * @generated
 */
@JSON(strict = true)
public class CountryModelImpl
	extends BaseModelImpl<Country> implements CountryModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a country model instance should use the <code>Country</code> interface instead.
	 */
	public static final String TABLE_NAME = "Country";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"ctCollectionId", Types.BIGINT},
		{"uuid_", Types.VARCHAR}, {"defaultLanguageId", Types.VARCHAR},
		{"countryId", Types.BIGINT}, {"companyId", Types.BIGINT},
		{"userId", Types.BIGINT}, {"userName", Types.VARCHAR},
		{"createDate", Types.TIMESTAMP}, {"modifiedDate", Types.TIMESTAMP},
		{"a2", Types.VARCHAR}, {"a3", Types.VARCHAR},
		{"active_", Types.BOOLEAN}, {"billingAllowed", Types.BOOLEAN},
		{"groupFilterEnabled", Types.BOOLEAN}, {"idd_", Types.VARCHAR},
		{"name", Types.VARCHAR}, {"number_", Types.VARCHAR},
		{"position", Types.DOUBLE}, {"shippingAllowed", Types.BOOLEAN},
		{"subjectToVAT", Types.BOOLEAN}, {"zipRequired", Types.BOOLEAN},
		{"lastPublishDate", Types.TIMESTAMP}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("ctCollectionId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("defaultLanguageId", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("countryId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("a2", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("a3", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("active_", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("billingAllowed", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("groupFilterEnabled", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("idd_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("name", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("number_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("position", Types.DOUBLE);
		TABLE_COLUMNS_MAP.put("shippingAllowed", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("subjectToVAT", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("zipRequired", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("lastPublishDate", Types.TIMESTAMP);
	}

	public static final String TABLE_SQL_CREATE =
		"create table Country (mvccVersion LONG default 0 not null,ctCollectionId LONG default 0 not null,uuid_ VARCHAR(75) null,defaultLanguageId VARCHAR(75) null,countryId LONG not null,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,a2 VARCHAR(75) null,a3 VARCHAR(75) null,active_ BOOLEAN,billingAllowed BOOLEAN,groupFilterEnabled BOOLEAN,idd_ VARCHAR(75) null,name VARCHAR(75) null,number_ VARCHAR(75) null,position DOUBLE,shippingAllowed BOOLEAN,subjectToVAT BOOLEAN,zipRequired BOOLEAN,lastPublishDate DATE null,primary key (countryId, ctCollectionId))";

	public static final String TABLE_SQL_DROP = "drop table Country";

	public static final String ORDER_BY_JPQL = " ORDER BY country.name ASC";

	public static final String ORDER_BY_SQL = " ORDER BY Country.name ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean ENTITY_CACHE_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean FINDER_CACHE_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean COLUMN_BITMASK_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long A2_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long A3_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long ACTIVE_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long BILLINGALLOWED_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMPANYID_COLUMN_BITMASK = 16L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long NAME_COLUMN_BITMASK = 32L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long NUMBER_COLUMN_BITMASK = 64L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long SHIPPINGALLOWED_COLUMN_BITMASK = 128L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long UUID_COLUMN_BITMASK = 256L;

	public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(
		com.liferay.portal.util.PropsUtil.get(
			"lock.expiration.time.com.liferay.portal.kernel.model.Country"));

	public CountryModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _countryId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setCountryId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _countryId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return Country.class;
	}

	@Override
	public String getModelClassName() {
		return Country.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<Country, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		for (Map.Entry<String, Function<Country, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<Country, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName, attributeGetterFunction.apply((Country)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<Country, Object>> attributeSetterBiConsumers =
			getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<Country, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(Country)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<Country, Object>>
		getAttributeGetterFunctions() {

		return AttributeGetterFunctionsHolder._attributeGetterFunctions;
	}

	public Map<String, BiConsumer<Country, Object>>
		getAttributeSetterBiConsumers() {

		return AttributeSetterBiConsumersHolder._attributeSetterBiConsumers;
	}

	private static class AttributeGetterFunctionsHolder {

		private static final Map<String, Function<Country, Object>>
			_attributeGetterFunctions;

		static {
			Map<String, Function<Country, Object>> attributeGetterFunctions =
				new LinkedHashMap<String, Function<Country, Object>>();

			attributeGetterFunctions.put(
				"mvccVersion", Country::getMvccVersion);
			attributeGetterFunctions.put(
				"ctCollectionId", Country::getCtCollectionId);
			attributeGetterFunctions.put("uuid", Country::getUuid);
			attributeGetterFunctions.put(
				"defaultLanguageId", Country::getDefaultLanguageId);
			attributeGetterFunctions.put("countryId", Country::getCountryId);
			attributeGetterFunctions.put("companyId", Country::getCompanyId);
			attributeGetterFunctions.put("userId", Country::getUserId);
			attributeGetterFunctions.put("userName", Country::getUserName);
			attributeGetterFunctions.put("createDate", Country::getCreateDate);
			attributeGetterFunctions.put(
				"modifiedDate", Country::getModifiedDate);
			attributeGetterFunctions.put("a2", Country::getA2);
			attributeGetterFunctions.put("a3", Country::getA3);
			attributeGetterFunctions.put("active", Country::getActive);
			attributeGetterFunctions.put(
				"billingAllowed", Country::getBillingAllowed);
			attributeGetterFunctions.put(
				"groupFilterEnabled", Country::getGroupFilterEnabled);
			attributeGetterFunctions.put("idd", Country::getIdd);
			attributeGetterFunctions.put("name", Country::getName);
			attributeGetterFunctions.put("number", Country::getNumber);
			attributeGetterFunctions.put("position", Country::getPosition);
			attributeGetterFunctions.put(
				"shippingAllowed", Country::getShippingAllowed);
			attributeGetterFunctions.put(
				"subjectToVAT", Country::getSubjectToVAT);
			attributeGetterFunctions.put(
				"zipRequired", Country::getZipRequired);
			attributeGetterFunctions.put(
				"lastPublishDate", Country::getLastPublishDate);

			_attributeGetterFunctions = Collections.unmodifiableMap(
				attributeGetterFunctions);
		}

	}

	private static class AttributeSetterBiConsumersHolder {

		private static final Map<String, BiConsumer<Country, Object>>
			_attributeSetterBiConsumers;

		static {
			Map<String, BiConsumer<Country, ?>> attributeSetterBiConsumers =
				new LinkedHashMap<String, BiConsumer<Country, ?>>();

			attributeSetterBiConsumers.put(
				"mvccVersion",
				(BiConsumer<Country, Long>)Country::setMvccVersion);
			attributeSetterBiConsumers.put(
				"ctCollectionId",
				(BiConsumer<Country, Long>)Country::setCtCollectionId);
			attributeSetterBiConsumers.put(
				"uuid", (BiConsumer<Country, String>)Country::setUuid);
			attributeSetterBiConsumers.put(
				"defaultLanguageId",
				(BiConsumer<Country, String>)Country::setDefaultLanguageId);
			attributeSetterBiConsumers.put(
				"countryId", (BiConsumer<Country, Long>)Country::setCountryId);
			attributeSetterBiConsumers.put(
				"companyId", (BiConsumer<Country, Long>)Country::setCompanyId);
			attributeSetterBiConsumers.put(
				"userId", (BiConsumer<Country, Long>)Country::setUserId);
			attributeSetterBiConsumers.put(
				"userName", (BiConsumer<Country, String>)Country::setUserName);
			attributeSetterBiConsumers.put(
				"createDate",
				(BiConsumer<Country, Date>)Country::setCreateDate);
			attributeSetterBiConsumers.put(
				"modifiedDate",
				(BiConsumer<Country, Date>)Country::setModifiedDate);
			attributeSetterBiConsumers.put(
				"a2", (BiConsumer<Country, String>)Country::setA2);
			attributeSetterBiConsumers.put(
				"a3", (BiConsumer<Country, String>)Country::setA3);
			attributeSetterBiConsumers.put(
				"active", (BiConsumer<Country, Boolean>)Country::setActive);
			attributeSetterBiConsumers.put(
				"billingAllowed",
				(BiConsumer<Country, Boolean>)Country::setBillingAllowed);
			attributeSetterBiConsumers.put(
				"groupFilterEnabled",
				(BiConsumer<Country, Boolean>)Country::setGroupFilterEnabled);
			attributeSetterBiConsumers.put(
				"idd", (BiConsumer<Country, String>)Country::setIdd);
			attributeSetterBiConsumers.put(
				"name", (BiConsumer<Country, String>)Country::setName);
			attributeSetterBiConsumers.put(
				"number", (BiConsumer<Country, String>)Country::setNumber);
			attributeSetterBiConsumers.put(
				"position", (BiConsumer<Country, Double>)Country::setPosition);
			attributeSetterBiConsumers.put(
				"shippingAllowed",
				(BiConsumer<Country, Boolean>)Country::setShippingAllowed);
			attributeSetterBiConsumers.put(
				"subjectToVAT",
				(BiConsumer<Country, Boolean>)Country::setSubjectToVAT);
			attributeSetterBiConsumers.put(
				"zipRequired",
				(BiConsumer<Country, Boolean>)Country::setZipRequired);
			attributeSetterBiConsumers.put(
				"lastPublishDate",
				(BiConsumer<Country, Date>)Country::setLastPublishDate);

			_attributeSetterBiConsumers = Collections.unmodifiableMap(
				(Map)attributeSetterBiConsumers);
		}

	}

	@Override
	public String[] getAvailableLanguageIds() {
		List<CountryLocalization> countryLocalizations =
			CountryLocalServiceUtil.getCountryLocalizations(getPrimaryKey());

		String[] availableLanguageIds = new String[countryLocalizations.size()];

		for (int i = 0; i < availableLanguageIds.length; i++) {
			CountryLocalization countryLocalization = countryLocalizations.get(
				i);

			availableLanguageIds[i] = countryLocalization.getLanguageId();
		}

		return availableLanguageIds;
	}

	@Override
	public String getTitle() {
		return getTitle(getDefaultLanguageId(), false);
	}

	@Override
	public String getTitle(String languageId) {
		return getTitle(languageId, true);
	}

	@Override
	public String getTitle(String languageId, boolean useDefault) {
		if (useDefault) {
			return LocalizationUtil.getLocalization(
				new Function<String, String>() {

					@Override
					public String apply(String languageId) {
						return _getTitle(languageId);
					}

				},
				languageId, getDefaultLanguageId());
		}

		return _getTitle(languageId);
	}

	@Override
	public String getTitleMapAsXML() {
		return LocalizationUtil.getXml(
			getLanguageIdToTitleMap(), getDefaultLanguageId(), "Title");
	}

	@Override
	public Map<String, String> getLanguageIdToTitleMap() {
		Map<String, String> languageIdToTitleMap =
			new HashMap<String, String>();

		List<CountryLocalization> countryLocalizations =
			CountryLocalServiceUtil.getCountryLocalizations(getPrimaryKey());

		for (CountryLocalization countryLocalization : countryLocalizations) {
			languageIdToTitleMap.put(
				countryLocalization.getLanguageId(),
				countryLocalization.getTitle());
		}

		return languageIdToTitleMap;
	}

	private String _getTitle(String languageId) {
		CountryLocalization countryLocalization =
			CountryLocalServiceUtil.fetchCountryLocalization(
				getPrimaryKey(), languageId);

		if (countryLocalization == null) {
			return "";
		}

		return countryLocalization.getTitle();
	}

	@JSON
	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@JSON
	@Override
	public long getCtCollectionId() {
		return _ctCollectionId;
	}

	@Override
	public void setCtCollectionId(long ctCollectionId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_ctCollectionId = ctCollectionId;
	}

	@JSON
	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_uuid = uuid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalUuid() {
		return getColumnOriginalValue("uuid_");
	}

	@JSON
	@Override
	public String getDefaultLanguageId() {
		if (_defaultLanguageId == null) {
			return "";
		}
		else {
			return _defaultLanguageId;
		}
	}

	@Override
	public void setDefaultLanguageId(String defaultLanguageId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_defaultLanguageId = defaultLanguageId;
	}

	@JSON
	@Override
	public long getCountryId() {
		return _countryId;
	}

	@Override
	public void setCountryId(long countryId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_countryId = countryId;
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCompanyId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("companyId"));
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@JSON
	@Override
	public String getA2() {
		if (_a2 == null) {
			return "";
		}
		else {
			return _a2;
		}
	}

	@Override
	public void setA2(String a2) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_a2 = a2;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalA2() {
		return getColumnOriginalValue("a2");
	}

	@JSON
	@Override
	public String getA3() {
		if (_a3 == null) {
			return "";
		}
		else {
			return _a3;
		}
	}

	@Override
	public void setA3(String a3) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_a3 = a3;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalA3() {
		return getColumnOriginalValue("a3");
	}

	@JSON
	@Override
	public boolean getActive() {
		return _active;
	}

	@JSON
	@Override
	public boolean isActive() {
		return _active;
	}

	@Override
	public void setActive(boolean active) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_active = active;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public boolean getOriginalActive() {
		return GetterUtil.getBoolean(
			this.<Boolean>getColumnOriginalValue("active_"));
	}

	@JSON
	@Override
	public boolean getBillingAllowed() {
		return _billingAllowed;
	}

	@JSON
	@Override
	public boolean isBillingAllowed() {
		return _billingAllowed;
	}

	@Override
	public void setBillingAllowed(boolean billingAllowed) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_billingAllowed = billingAllowed;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public boolean getOriginalBillingAllowed() {
		return GetterUtil.getBoolean(
			this.<Boolean>getColumnOriginalValue("billingAllowed"));
	}

	@JSON
	@Override
	public boolean getGroupFilterEnabled() {
		return _groupFilterEnabled;
	}

	@JSON
	@Override
	public boolean isGroupFilterEnabled() {
		return _groupFilterEnabled;
	}

	@Override
	public void setGroupFilterEnabled(boolean groupFilterEnabled) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_groupFilterEnabled = groupFilterEnabled;
	}

	@JSON
	@Override
	public String getIdd() {
		if (_idd == null) {
			return "";
		}
		else {
			return _idd;
		}
	}

	@Override
	public void setIdd(String idd) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_idd = idd;
	}

	@JSON
	@Override
	public String getName() {
		if (_name == null) {
			return "";
		}
		else {
			return _name;
		}
	}

	@Override
	public void setName(String name) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_name = name;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalName() {
		return getColumnOriginalValue("name");
	}

	@JSON
	@Override
	public String getNumber() {
		if (_number == null) {
			return "";
		}
		else {
			return _number;
		}
	}

	@Override
	public void setNumber(String number) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_number = number;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalNumber() {
		return getColumnOriginalValue("number_");
	}

	@JSON
	@Override
	public double getPosition() {
		return _position;
	}

	@Override
	public void setPosition(double position) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_position = position;
	}

	@JSON
	@Override
	public boolean getShippingAllowed() {
		return _shippingAllowed;
	}

	@JSON
	@Override
	public boolean isShippingAllowed() {
		return _shippingAllowed;
	}

	@Override
	public void setShippingAllowed(boolean shippingAllowed) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_shippingAllowed = shippingAllowed;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public boolean getOriginalShippingAllowed() {
		return GetterUtil.getBoolean(
			this.<Boolean>getColumnOriginalValue("shippingAllowed"));
	}

	@JSON
	@Override
	public boolean getSubjectToVAT() {
		return _subjectToVAT;
	}

	@JSON
	@Override
	public boolean isSubjectToVAT() {
		return _subjectToVAT;
	}

	@Override
	public void setSubjectToVAT(boolean subjectToVAT) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_subjectToVAT = subjectToVAT;
	}

	@JSON
	@Override
	public boolean getZipRequired() {
		return _zipRequired;
	}

	@JSON
	@Override
	public boolean isZipRequired() {
		return _zipRequired;
	}

	@Override
	public void setZipRequired(boolean zipRequired) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_zipRequired = zipRequired;
	}

	@JSON
	@Override
	public Date getLastPublishDate() {
		return _lastPublishDate;
	}

	@Override
	public void setLastPublishDate(Date lastPublishDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_lastPublishDate = lastPublishDate;
	}

	@Override
	public StagedModelType getStagedModelType() {
		return new StagedModelType(
			PortalUtil.getClassNameId(Country.class.getName()));
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), Country.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public Country toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, Country>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		CountryImpl countryImpl = new CountryImpl();

		countryImpl.setMvccVersion(getMvccVersion());
		countryImpl.setCtCollectionId(getCtCollectionId());
		countryImpl.setUuid(getUuid());
		countryImpl.setDefaultLanguageId(getDefaultLanguageId());
		countryImpl.setCountryId(getCountryId());
		countryImpl.setCompanyId(getCompanyId());
		countryImpl.setUserId(getUserId());
		countryImpl.setUserName(getUserName());
		countryImpl.setCreateDate(getCreateDate());
		countryImpl.setModifiedDate(getModifiedDate());
		countryImpl.setA2(getA2());
		countryImpl.setA3(getA3());
		countryImpl.setActive(isActive());
		countryImpl.setBillingAllowed(isBillingAllowed());
		countryImpl.setGroupFilterEnabled(isGroupFilterEnabled());
		countryImpl.setIdd(getIdd());
		countryImpl.setName(getName());
		countryImpl.setNumber(getNumber());
		countryImpl.setPosition(getPosition());
		countryImpl.setShippingAllowed(isShippingAllowed());
		countryImpl.setSubjectToVAT(isSubjectToVAT());
		countryImpl.setZipRequired(isZipRequired());
		countryImpl.setLastPublishDate(getLastPublishDate());

		countryImpl.resetOriginalValues();

		return countryImpl;
	}

	@Override
	public Country cloneWithOriginalValues() {
		CountryImpl countryImpl = new CountryImpl();

		countryImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		countryImpl.setCtCollectionId(
			this.<Long>getColumnOriginalValue("ctCollectionId"));
		countryImpl.setUuid(this.<String>getColumnOriginalValue("uuid_"));
		countryImpl.setDefaultLanguageId(
			this.<String>getColumnOriginalValue("defaultLanguageId"));
		countryImpl.setCountryId(
			this.<Long>getColumnOriginalValue("countryId"));
		countryImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		countryImpl.setUserId(this.<Long>getColumnOriginalValue("userId"));
		countryImpl.setUserName(
			this.<String>getColumnOriginalValue("userName"));
		countryImpl.setCreateDate(
			this.<Date>getColumnOriginalValue("createDate"));
		countryImpl.setModifiedDate(
			this.<Date>getColumnOriginalValue("modifiedDate"));
		countryImpl.setA2(this.<String>getColumnOriginalValue("a2"));
		countryImpl.setA3(this.<String>getColumnOriginalValue("a3"));
		countryImpl.setActive(this.<Boolean>getColumnOriginalValue("active_"));
		countryImpl.setBillingAllowed(
			this.<Boolean>getColumnOriginalValue("billingAllowed"));
		countryImpl.setGroupFilterEnabled(
			this.<Boolean>getColumnOriginalValue("groupFilterEnabled"));
		countryImpl.setIdd(this.<String>getColumnOriginalValue("idd_"));
		countryImpl.setName(this.<String>getColumnOriginalValue("name"));
		countryImpl.setNumber(this.<String>getColumnOriginalValue("number_"));
		countryImpl.setPosition(
			this.<Double>getColumnOriginalValue("position"));
		countryImpl.setShippingAllowed(
			this.<Boolean>getColumnOriginalValue("shippingAllowed"));
		countryImpl.setSubjectToVAT(
			this.<Boolean>getColumnOriginalValue("subjectToVAT"));
		countryImpl.setZipRequired(
			this.<Boolean>getColumnOriginalValue("zipRequired"));
		countryImpl.setLastPublishDate(
			this.<Date>getColumnOriginalValue("lastPublishDate"));

		return countryImpl;
	}

	@Override
	public int compareTo(Country country) {
		int value = 0;

		value = getName().compareTo(country.getName());

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof Country)) {
			return false;
		}

		Country country = (Country)object;

		long primaryKey = country.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return ENTITY_CACHE_ENABLED;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return FINDER_CACHE_ENABLED;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<Country> toCacheModel() {
		CountryCacheModel countryCacheModel = new CountryCacheModel();

		countryCacheModel.mvccVersion = getMvccVersion();

		countryCacheModel.ctCollectionId = getCtCollectionId();

		countryCacheModel.uuid = getUuid();

		String uuid = countryCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			countryCacheModel.uuid = null;
		}

		countryCacheModel.defaultLanguageId = getDefaultLanguageId();

		String defaultLanguageId = countryCacheModel.defaultLanguageId;

		if ((defaultLanguageId != null) && (defaultLanguageId.length() == 0)) {
			countryCacheModel.defaultLanguageId = null;
		}

		countryCacheModel.countryId = getCountryId();

		countryCacheModel.companyId = getCompanyId();

		countryCacheModel.userId = getUserId();

		countryCacheModel.userName = getUserName();

		String userName = countryCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			countryCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			countryCacheModel.createDate = createDate.getTime();
		}
		else {
			countryCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			countryCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			countryCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		countryCacheModel.a2 = getA2();

		String a2 = countryCacheModel.a2;

		if ((a2 != null) && (a2.length() == 0)) {
			countryCacheModel.a2 = null;
		}

		countryCacheModel.a3 = getA3();

		String a3 = countryCacheModel.a3;

		if ((a3 != null) && (a3.length() == 0)) {
			countryCacheModel.a3 = null;
		}

		countryCacheModel.active = isActive();

		countryCacheModel.billingAllowed = isBillingAllowed();

		countryCacheModel.groupFilterEnabled = isGroupFilterEnabled();

		countryCacheModel.idd = getIdd();

		String idd = countryCacheModel.idd;

		if ((idd != null) && (idd.length() == 0)) {
			countryCacheModel.idd = null;
		}

		countryCacheModel.name = getName();

		String name = countryCacheModel.name;

		if ((name != null) && (name.length() == 0)) {
			countryCacheModel.name = null;
		}

		countryCacheModel.number = getNumber();

		String number = countryCacheModel.number;

		if ((number != null) && (number.length() == 0)) {
			countryCacheModel.number = null;
		}

		countryCacheModel.position = getPosition();

		countryCacheModel.shippingAllowed = isShippingAllowed();

		countryCacheModel.subjectToVAT = isSubjectToVAT();

		countryCacheModel.zipRequired = isZipRequired();

		Date lastPublishDate = getLastPublishDate();

		if (lastPublishDate != null) {
			countryCacheModel.lastPublishDate = lastPublishDate.getTime();
		}
		else {
			countryCacheModel.lastPublishDate = Long.MIN_VALUE;
		}

		return countryCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<Country, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<Country, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<Country, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply((Country)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, Country>
			_escapedModelProxyProviderFunction =
				ProxyUtil.getProxyProviderFunction(
					Country.class, ModelWrapper.class);

	}

	private long _mvccVersion;
	private long _ctCollectionId;
	private String _uuid;
	private String _defaultLanguageId;
	private long _countryId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private String _a2;
	private String _a3;
	private boolean _active;
	private boolean _billingAllowed;
	private boolean _groupFilterEnabled;
	private String _idd;
	private String _name;
	private String _number;
	private double _position;
	private boolean _shippingAllowed;
	private boolean _subjectToVAT;
	private boolean _zipRequired;
	private Date _lastPublishDate;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<Country, Object> function =
			AttributeGetterFunctionsHolder._attributeGetterFunctions.get(
				columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((Country)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put("ctCollectionId", _ctCollectionId);
		_columnOriginalValues.put("uuid_", _uuid);
		_columnOriginalValues.put("defaultLanguageId", _defaultLanguageId);
		_columnOriginalValues.put("countryId", _countryId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put("a2", _a2);
		_columnOriginalValues.put("a3", _a3);
		_columnOriginalValues.put("active_", _active);
		_columnOriginalValues.put("billingAllowed", _billingAllowed);
		_columnOriginalValues.put("groupFilterEnabled", _groupFilterEnabled);
		_columnOriginalValues.put("idd_", _idd);
		_columnOriginalValues.put("name", _name);
		_columnOriginalValues.put("number_", _number);
		_columnOriginalValues.put("position", _position);
		_columnOriginalValues.put("shippingAllowed", _shippingAllowed);
		_columnOriginalValues.put("subjectToVAT", _subjectToVAT);
		_columnOriginalValues.put("zipRequired", _zipRequired);
		_columnOriginalValues.put("lastPublishDate", _lastPublishDate);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put("uuid_", "uuid");
		attributeNames.put("active_", "active");
		attributeNames.put("idd_", "idd");
		attributeNames.put("number_", "number");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("ctCollectionId", 2L);

		columnBitmasks.put("uuid_", 4L);

		columnBitmasks.put("defaultLanguageId", 8L);

		columnBitmasks.put("countryId", 16L);

		columnBitmasks.put("companyId", 32L);

		columnBitmasks.put("userId", 64L);

		columnBitmasks.put("userName", 128L);

		columnBitmasks.put("createDate", 256L);

		columnBitmasks.put("modifiedDate", 512L);

		columnBitmasks.put("a2", 1024L);

		columnBitmasks.put("a3", 2048L);

		columnBitmasks.put("active_", 4096L);

		columnBitmasks.put("billingAllowed", 8192L);

		columnBitmasks.put("groupFilterEnabled", 16384L);

		columnBitmasks.put("idd_", 32768L);

		columnBitmasks.put("name", 65536L);

		columnBitmasks.put("number_", 131072L);

		columnBitmasks.put("position", 262144L);

		columnBitmasks.put("shippingAllowed", 524288L);

		columnBitmasks.put("subjectToVAT", 1048576L);

		columnBitmasks.put("zipRequired", 2097152L);

		columnBitmasks.put("lastPublishDate", 4194304L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private Country _escapedModel;

}