/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.portal.model.impl;

import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;

/**
 * The extended model base implementation for the Layout service. Represents a row in the &quot;Layout&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link LayoutImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see LayoutImpl
 * @see Layout
 * @generated
 */
public abstract class LayoutBaseImpl extends LayoutModelImpl implements Layout {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a layout model instance should use the <code>Layout</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			LayoutLocalServiceUtil.addLayout(this);
		}
		else {
			LayoutLocalServiceUtil.updateLayout(this);
		}
	}

}