/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.portal.model.impl;

import com.liferay.portal.kernel.model.LayoutRevision;
import com.liferay.portal.kernel.service.LayoutRevisionLocalServiceUtil;

/**
 * The extended model base implementation for the LayoutRevision service. Represents a row in the &quot;LayoutRevision&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link LayoutRevisionImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see LayoutRevisionImpl
 * @see LayoutRevision
 * @generated
 */
public abstract class LayoutRevisionBaseImpl
	extends LayoutRevisionModelImpl implements LayoutRevision {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a layout revision model instance should use the <code>LayoutRevision</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			LayoutRevisionLocalServiceUtil.addLayoutRevision(this);
		}
		else {
			LayoutRevisionLocalServiceUtil.updateLayoutRevision(this);
		}
	}

}