/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.portal.model.impl;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.RecentLayoutBranch;
import com.liferay.portal.kernel.model.RecentLayoutBranchModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the RecentLayoutBranch service. Represents a row in the &quot;RecentLayoutBranch&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>RecentLayoutBranchModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link RecentLayoutBranchImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see RecentLayoutBranchImpl
 * @generated
 */
public class RecentLayoutBranchModelImpl
	extends BaseModelImpl<RecentLayoutBranch>
	implements RecentLayoutBranchModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a recent layout branch model instance should use the <code>RecentLayoutBranch</code> interface instead.
	 */
	public static final String TABLE_NAME = "RecentLayoutBranch";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"recentLayoutBranchId", Types.BIGINT},
		{"groupId", Types.BIGINT}, {"companyId", Types.BIGINT},
		{"userId", Types.BIGINT}, {"layoutBranchId", Types.BIGINT},
		{"layoutSetBranchId", Types.BIGINT}, {"plid", Types.BIGINT}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("recentLayoutBranchId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("groupId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("layoutBranchId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("layoutSetBranchId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("plid", Types.BIGINT);
	}

	public static final String TABLE_SQL_CREATE =
		"create table RecentLayoutBranch (mvccVersion LONG default 0 not null,recentLayoutBranchId LONG not null primary key,groupId LONG,companyId LONG,userId LONG,layoutBranchId LONG,layoutSetBranchId LONG,plid LONG)";

	public static final String TABLE_SQL_DROP = "drop table RecentLayoutBranch";

	public static final String ORDER_BY_JPQL =
		" ORDER BY recentLayoutBranch.recentLayoutBranchId ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY RecentLayoutBranch.recentLayoutBranchId ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean ENTITY_CACHE_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean FINDER_CACHE_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean COLUMN_BITMASK_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long GROUPID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long LAYOUTBRANCHID_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long LAYOUTSETBRANCHID_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long PLID_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long USERID_COLUMN_BITMASK = 16L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long RECENTLAYOUTBRANCHID_COLUMN_BITMASK = 32L;

	public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(
		com.liferay.portal.util.PropsUtil.get(
			"lock.expiration.time.com.liferay.portal.kernel.model.RecentLayoutBranch"));

	public RecentLayoutBranchModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _recentLayoutBranchId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setRecentLayoutBranchId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _recentLayoutBranchId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return RecentLayoutBranch.class;
	}

	@Override
	public String getModelClassName() {
		return RecentLayoutBranch.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<RecentLayoutBranch, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry<String, Function<RecentLayoutBranch, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<RecentLayoutBranch, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((RecentLayoutBranch)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<RecentLayoutBranch, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<RecentLayoutBranch, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(RecentLayoutBranch)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<RecentLayoutBranch, Object>>
		getAttributeGetterFunctions() {

		return AttributeGetterFunctionsHolder._attributeGetterFunctions;
	}

	public Map<String, BiConsumer<RecentLayoutBranch, Object>>
		getAttributeSetterBiConsumers() {

		return AttributeSetterBiConsumersHolder._attributeSetterBiConsumers;
	}

	private static class AttributeGetterFunctionsHolder {

		private static final Map<String, Function<RecentLayoutBranch, Object>>
			_attributeGetterFunctions;

		static {
			Map<String, Function<RecentLayoutBranch, Object>>
				attributeGetterFunctions =
					new LinkedHashMap
						<String, Function<RecentLayoutBranch, Object>>();

			attributeGetterFunctions.put(
				"mvccVersion", RecentLayoutBranch::getMvccVersion);
			attributeGetterFunctions.put(
				"recentLayoutBranchId",
				RecentLayoutBranch::getRecentLayoutBranchId);
			attributeGetterFunctions.put(
				"groupId", RecentLayoutBranch::getGroupId);
			attributeGetterFunctions.put(
				"companyId", RecentLayoutBranch::getCompanyId);
			attributeGetterFunctions.put(
				"userId", RecentLayoutBranch::getUserId);
			attributeGetterFunctions.put(
				"layoutBranchId", RecentLayoutBranch::getLayoutBranchId);
			attributeGetterFunctions.put(
				"layoutSetBranchId", RecentLayoutBranch::getLayoutSetBranchId);
			attributeGetterFunctions.put("plid", RecentLayoutBranch::getPlid);

			_attributeGetterFunctions = Collections.unmodifiableMap(
				attributeGetterFunctions);
		}

	}

	private static class AttributeSetterBiConsumersHolder {

		private static final Map<String, BiConsumer<RecentLayoutBranch, Object>>
			_attributeSetterBiConsumers;

		static {
			Map<String, BiConsumer<RecentLayoutBranch, ?>>
				attributeSetterBiConsumers =
					new LinkedHashMap
						<String, BiConsumer<RecentLayoutBranch, ?>>();

			attributeSetterBiConsumers.put(
				"mvccVersion",
				(BiConsumer<RecentLayoutBranch, Long>)
					RecentLayoutBranch::setMvccVersion);
			attributeSetterBiConsumers.put(
				"recentLayoutBranchId",
				(BiConsumer<RecentLayoutBranch, Long>)
					RecentLayoutBranch::setRecentLayoutBranchId);
			attributeSetterBiConsumers.put(
				"groupId",
				(BiConsumer<RecentLayoutBranch, Long>)
					RecentLayoutBranch::setGroupId);
			attributeSetterBiConsumers.put(
				"companyId",
				(BiConsumer<RecentLayoutBranch, Long>)
					RecentLayoutBranch::setCompanyId);
			attributeSetterBiConsumers.put(
				"userId",
				(BiConsumer<RecentLayoutBranch, Long>)
					RecentLayoutBranch::setUserId);
			attributeSetterBiConsumers.put(
				"layoutBranchId",
				(BiConsumer<RecentLayoutBranch, Long>)
					RecentLayoutBranch::setLayoutBranchId);
			attributeSetterBiConsumers.put(
				"layoutSetBranchId",
				(BiConsumer<RecentLayoutBranch, Long>)
					RecentLayoutBranch::setLayoutSetBranchId);
			attributeSetterBiConsumers.put(
				"plid",
				(BiConsumer<RecentLayoutBranch, Long>)
					RecentLayoutBranch::setPlid);

			_attributeSetterBiConsumers = Collections.unmodifiableMap(
				(Map)attributeSetterBiConsumers);
		}

	}

	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@Override
	public long getRecentLayoutBranchId() {
		return _recentLayoutBranchId;
	}

	@Override
	public void setRecentLayoutBranchId(long recentLayoutBranchId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_recentLayoutBranchId = recentLayoutBranchId;
	}

	@Override
	public long getGroupId() {
		return _groupId;
	}

	@Override
	public void setGroupId(long groupId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_groupId = groupId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalGroupId() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("groupId"));
	}

	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalUserId() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("userId"));
	}

	@Override
	public long getLayoutBranchId() {
		return _layoutBranchId;
	}

	@Override
	public void setLayoutBranchId(long layoutBranchId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_layoutBranchId = layoutBranchId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalLayoutBranchId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("layoutBranchId"));
	}

	@Override
	public long getLayoutSetBranchId() {
		return _layoutSetBranchId;
	}

	@Override
	public void setLayoutSetBranchId(long layoutSetBranchId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_layoutSetBranchId = layoutSetBranchId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalLayoutSetBranchId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("layoutSetBranchId"));
	}

	@Override
	public long getPlid() {
		return _plid;
	}

	@Override
	public void setPlid(long plid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_plid = plid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalPlid() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("plid"));
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), RecentLayoutBranch.class.getName(),
			getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public RecentLayoutBranch toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, RecentLayoutBranch>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		RecentLayoutBranchImpl recentLayoutBranchImpl =
			new RecentLayoutBranchImpl();

		recentLayoutBranchImpl.setMvccVersion(getMvccVersion());
		recentLayoutBranchImpl.setRecentLayoutBranchId(
			getRecentLayoutBranchId());
		recentLayoutBranchImpl.setGroupId(getGroupId());
		recentLayoutBranchImpl.setCompanyId(getCompanyId());
		recentLayoutBranchImpl.setUserId(getUserId());
		recentLayoutBranchImpl.setLayoutBranchId(getLayoutBranchId());
		recentLayoutBranchImpl.setLayoutSetBranchId(getLayoutSetBranchId());
		recentLayoutBranchImpl.setPlid(getPlid());

		recentLayoutBranchImpl.resetOriginalValues();

		return recentLayoutBranchImpl;
	}

	@Override
	public RecentLayoutBranch cloneWithOriginalValues() {
		RecentLayoutBranchImpl recentLayoutBranchImpl =
			new RecentLayoutBranchImpl();

		recentLayoutBranchImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		recentLayoutBranchImpl.setRecentLayoutBranchId(
			this.<Long>getColumnOriginalValue("recentLayoutBranchId"));
		recentLayoutBranchImpl.setGroupId(
			this.<Long>getColumnOriginalValue("groupId"));
		recentLayoutBranchImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		recentLayoutBranchImpl.setUserId(
			this.<Long>getColumnOriginalValue("userId"));
		recentLayoutBranchImpl.setLayoutBranchId(
			this.<Long>getColumnOriginalValue("layoutBranchId"));
		recentLayoutBranchImpl.setLayoutSetBranchId(
			this.<Long>getColumnOriginalValue("layoutSetBranchId"));
		recentLayoutBranchImpl.setPlid(
			this.<Long>getColumnOriginalValue("plid"));

		return recentLayoutBranchImpl;
	}

	@Override
	public int compareTo(RecentLayoutBranch recentLayoutBranch) {
		long primaryKey = recentLayoutBranch.getPrimaryKey();

		if (getPrimaryKey() < primaryKey) {
			return -1;
		}
		else if (getPrimaryKey() > primaryKey) {
			return 1;
		}
		else {
			return 0;
		}
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof RecentLayoutBranch)) {
			return false;
		}

		RecentLayoutBranch recentLayoutBranch = (RecentLayoutBranch)object;

		long primaryKey = recentLayoutBranch.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return ENTITY_CACHE_ENABLED;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return FINDER_CACHE_ENABLED;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<RecentLayoutBranch> toCacheModel() {
		RecentLayoutBranchCacheModel recentLayoutBranchCacheModel =
			new RecentLayoutBranchCacheModel();

		recentLayoutBranchCacheModel.mvccVersion = getMvccVersion();

		recentLayoutBranchCacheModel.recentLayoutBranchId =
			getRecentLayoutBranchId();

		recentLayoutBranchCacheModel.groupId = getGroupId();

		recentLayoutBranchCacheModel.companyId = getCompanyId();

		recentLayoutBranchCacheModel.userId = getUserId();

		recentLayoutBranchCacheModel.layoutBranchId = getLayoutBranchId();

		recentLayoutBranchCacheModel.layoutSetBranchId = getLayoutSetBranchId();

		recentLayoutBranchCacheModel.plid = getPlid();

		return recentLayoutBranchCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<RecentLayoutBranch, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<RecentLayoutBranch, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<RecentLayoutBranch, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply(
				(RecentLayoutBranch)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, RecentLayoutBranch>
			_escapedModelProxyProviderFunction =
				ProxyUtil.getProxyProviderFunction(
					RecentLayoutBranch.class, ModelWrapper.class);

	}

	private long _mvccVersion;
	private long _recentLayoutBranchId;
	private long _groupId;
	private long _companyId;
	private long _userId;
	private long _layoutBranchId;
	private long _layoutSetBranchId;
	private long _plid;

	public <T> T getColumnValue(String columnName) {
		Function<RecentLayoutBranch, Object> function =
			AttributeGetterFunctionsHolder._attributeGetterFunctions.get(
				columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((RecentLayoutBranch)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put(
			"recentLayoutBranchId", _recentLayoutBranchId);
		_columnOriginalValues.put("groupId", _groupId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("layoutBranchId", _layoutBranchId);
		_columnOriginalValues.put("layoutSetBranchId", _layoutSetBranchId);
		_columnOriginalValues.put("plid", _plid);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("recentLayoutBranchId", 2L);

		columnBitmasks.put("groupId", 4L);

		columnBitmasks.put("companyId", 8L);

		columnBitmasks.put("userId", 16L);

		columnBitmasks.put("layoutBranchId", 32L);

		columnBitmasks.put("layoutSetBranchId", 64L);

		columnBitmasks.put("plid", 128L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private RecentLayoutBranch _escapedModel;

}