/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.portal.model.impl;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.RegionLocalization;
import com.liferay.portal.kernel.model.RegionLocalizationModel;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the RegionLocalization service. Represents a row in the &quot;RegionLocalization&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>RegionLocalizationModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link RegionLocalizationImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see RegionLocalizationImpl
 * @generated
 */
public class RegionLocalizationModelImpl
	extends BaseModelImpl<RegionLocalization>
	implements RegionLocalizationModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a region localization model instance should use the <code>RegionLocalization</code> interface instead.
	 */
	public static final String TABLE_NAME = "RegionLocalization";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"ctCollectionId", Types.BIGINT},
		{"regionLocalizationId", Types.BIGINT}, {"companyId", Types.BIGINT},
		{"regionId", Types.BIGINT}, {"languageId", Types.VARCHAR},
		{"title", Types.VARCHAR}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("ctCollectionId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("regionLocalizationId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("regionId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("languageId", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("title", Types.VARCHAR);
	}

	public static final String TABLE_SQL_CREATE =
		"create table RegionLocalization (mvccVersion LONG default 0 not null,ctCollectionId LONG default 0 not null,regionLocalizationId LONG not null,companyId LONG,regionId LONG,languageId VARCHAR(75) null,title VARCHAR(75) null,primary key (regionLocalizationId, ctCollectionId))";

	public static final String TABLE_SQL_DROP = "drop table RegionLocalization";

	public static final String ORDER_BY_JPQL =
		" ORDER BY regionLocalization.regionLocalizationId ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY RegionLocalization.regionLocalizationId ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean ENTITY_CACHE_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean FINDER_CACHE_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean COLUMN_BITMASK_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long LANGUAGEID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long REGIONID_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long REGIONLOCALIZATIONID_COLUMN_BITMASK = 4L;

	public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(
		com.liferay.portal.util.PropsUtil.get(
			"lock.expiration.time.com.liferay.portal.kernel.model.RegionLocalization"));

	public RegionLocalizationModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _regionLocalizationId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setRegionLocalizationId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _regionLocalizationId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return RegionLocalization.class;
	}

	@Override
	public String getModelClassName() {
		return RegionLocalization.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<RegionLocalization, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry<String, Function<RegionLocalization, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<RegionLocalization, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((RegionLocalization)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<RegionLocalization, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<RegionLocalization, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(RegionLocalization)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<RegionLocalization, Object>>
		getAttributeGetterFunctions() {

		return AttributeGetterFunctionsHolder._attributeGetterFunctions;
	}

	public Map<String, BiConsumer<RegionLocalization, Object>>
		getAttributeSetterBiConsumers() {

		return AttributeSetterBiConsumersHolder._attributeSetterBiConsumers;
	}

	private static class AttributeGetterFunctionsHolder {

		private static final Map<String, Function<RegionLocalization, Object>>
			_attributeGetterFunctions;

		static {
			Map<String, Function<RegionLocalization, Object>>
				attributeGetterFunctions =
					new LinkedHashMap
						<String, Function<RegionLocalization, Object>>();

			attributeGetterFunctions.put(
				"mvccVersion", RegionLocalization::getMvccVersion);
			attributeGetterFunctions.put(
				"ctCollectionId", RegionLocalization::getCtCollectionId);
			attributeGetterFunctions.put(
				"regionLocalizationId",
				RegionLocalization::getRegionLocalizationId);
			attributeGetterFunctions.put(
				"companyId", RegionLocalization::getCompanyId);
			attributeGetterFunctions.put(
				"regionId", RegionLocalization::getRegionId);
			attributeGetterFunctions.put(
				"languageId", RegionLocalization::getLanguageId);
			attributeGetterFunctions.put("title", RegionLocalization::getTitle);

			_attributeGetterFunctions = Collections.unmodifiableMap(
				attributeGetterFunctions);
		}

	}

	private static class AttributeSetterBiConsumersHolder {

		private static final Map<String, BiConsumer<RegionLocalization, Object>>
			_attributeSetterBiConsumers;

		static {
			Map<String, BiConsumer<RegionLocalization, ?>>
				attributeSetterBiConsumers =
					new LinkedHashMap
						<String, BiConsumer<RegionLocalization, ?>>();

			attributeSetterBiConsumers.put(
				"mvccVersion",
				(BiConsumer<RegionLocalization, Long>)
					RegionLocalization::setMvccVersion);
			attributeSetterBiConsumers.put(
				"ctCollectionId",
				(BiConsumer<RegionLocalization, Long>)
					RegionLocalization::setCtCollectionId);
			attributeSetterBiConsumers.put(
				"regionLocalizationId",
				(BiConsumer<RegionLocalization, Long>)
					RegionLocalization::setRegionLocalizationId);
			attributeSetterBiConsumers.put(
				"companyId",
				(BiConsumer<RegionLocalization, Long>)
					RegionLocalization::setCompanyId);
			attributeSetterBiConsumers.put(
				"regionId",
				(BiConsumer<RegionLocalization, Long>)
					RegionLocalization::setRegionId);
			attributeSetterBiConsumers.put(
				"languageId",
				(BiConsumer<RegionLocalization, String>)
					RegionLocalization::setLanguageId);
			attributeSetterBiConsumers.put(
				"title",
				(BiConsumer<RegionLocalization, String>)
					RegionLocalization::setTitle);

			_attributeSetterBiConsumers = Collections.unmodifiableMap(
				(Map)attributeSetterBiConsumers);
		}

	}

	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@Override
	public long getCtCollectionId() {
		return _ctCollectionId;
	}

	@Override
	public void setCtCollectionId(long ctCollectionId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_ctCollectionId = ctCollectionId;
	}

	@Override
	public long getRegionLocalizationId() {
		return _regionLocalizationId;
	}

	@Override
	public void setRegionLocalizationId(long regionLocalizationId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_regionLocalizationId = regionLocalizationId;
	}

	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	@Override
	public long getRegionId() {
		return _regionId;
	}

	@Override
	public void setRegionId(long regionId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_regionId = regionId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalRegionId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("regionId"));
	}

	@Override
	public String getLanguageId() {
		if (_languageId == null) {
			return "";
		}
		else {
			return _languageId;
		}
	}

	@Override
	public void setLanguageId(String languageId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_languageId = languageId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalLanguageId() {
		return getColumnOriginalValue("languageId");
	}

	@Override
	public String getTitle() {
		if (_title == null) {
			return "";
		}
		else {
			return _title;
		}
	}

	@Override
	public void setTitle(String title) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_title = title;
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), RegionLocalization.class.getName(),
			getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public RegionLocalization toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, RegionLocalization>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		RegionLocalizationImpl regionLocalizationImpl =
			new RegionLocalizationImpl();

		regionLocalizationImpl.setMvccVersion(getMvccVersion());
		regionLocalizationImpl.setCtCollectionId(getCtCollectionId());
		regionLocalizationImpl.setRegionLocalizationId(
			getRegionLocalizationId());
		regionLocalizationImpl.setCompanyId(getCompanyId());
		regionLocalizationImpl.setRegionId(getRegionId());
		regionLocalizationImpl.setLanguageId(getLanguageId());
		regionLocalizationImpl.setTitle(getTitle());

		regionLocalizationImpl.resetOriginalValues();

		return regionLocalizationImpl;
	}

	@Override
	public RegionLocalization cloneWithOriginalValues() {
		RegionLocalizationImpl regionLocalizationImpl =
			new RegionLocalizationImpl();

		regionLocalizationImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		regionLocalizationImpl.setCtCollectionId(
			this.<Long>getColumnOriginalValue("ctCollectionId"));
		regionLocalizationImpl.setRegionLocalizationId(
			this.<Long>getColumnOriginalValue("regionLocalizationId"));
		regionLocalizationImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		regionLocalizationImpl.setRegionId(
			this.<Long>getColumnOriginalValue("regionId"));
		regionLocalizationImpl.setLanguageId(
			this.<String>getColumnOriginalValue("languageId"));
		regionLocalizationImpl.setTitle(
			this.<String>getColumnOriginalValue("title"));

		return regionLocalizationImpl;
	}

	@Override
	public int compareTo(RegionLocalization regionLocalization) {
		long primaryKey = regionLocalization.getPrimaryKey();

		if (getPrimaryKey() < primaryKey) {
			return -1;
		}
		else if (getPrimaryKey() > primaryKey) {
			return 1;
		}
		else {
			return 0;
		}
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof RegionLocalization)) {
			return false;
		}

		RegionLocalization regionLocalization = (RegionLocalization)object;

		long primaryKey = regionLocalization.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return ENTITY_CACHE_ENABLED;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return FINDER_CACHE_ENABLED;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<RegionLocalization> toCacheModel() {
		RegionLocalizationCacheModel regionLocalizationCacheModel =
			new RegionLocalizationCacheModel();

		regionLocalizationCacheModel.mvccVersion = getMvccVersion();

		regionLocalizationCacheModel.ctCollectionId = getCtCollectionId();

		regionLocalizationCacheModel.regionLocalizationId =
			getRegionLocalizationId();

		regionLocalizationCacheModel.companyId = getCompanyId();

		regionLocalizationCacheModel.regionId = getRegionId();

		regionLocalizationCacheModel.languageId = getLanguageId();

		String languageId = regionLocalizationCacheModel.languageId;

		if ((languageId != null) && (languageId.length() == 0)) {
			regionLocalizationCacheModel.languageId = null;
		}

		regionLocalizationCacheModel.title = getTitle();

		String title = regionLocalizationCacheModel.title;

		if ((title != null) && (title.length() == 0)) {
			regionLocalizationCacheModel.title = null;
		}

		return regionLocalizationCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<RegionLocalization, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<RegionLocalization, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<RegionLocalization, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply(
				(RegionLocalization)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, RegionLocalization>
			_escapedModelProxyProviderFunction =
				ProxyUtil.getProxyProviderFunction(
					RegionLocalization.class, ModelWrapper.class);

	}

	private long _mvccVersion;
	private long _ctCollectionId;
	private long _regionLocalizationId;
	private long _companyId;
	private long _regionId;
	private String _languageId;
	private String _title;

	public <T> T getColumnValue(String columnName) {
		Function<RegionLocalization, Object> function =
			AttributeGetterFunctionsHolder._attributeGetterFunctions.get(
				columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((RegionLocalization)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put("ctCollectionId", _ctCollectionId);
		_columnOriginalValues.put(
			"regionLocalizationId", _regionLocalizationId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("regionId", _regionId);
		_columnOriginalValues.put("languageId", _languageId);
		_columnOriginalValues.put("title", _title);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("ctCollectionId", 2L);

		columnBitmasks.put("regionLocalizationId", 4L);

		columnBitmasks.put("companyId", 8L);

		columnBitmasks.put("regionId", 16L);

		columnBitmasks.put("languageId", 32L);

		columnBitmasks.put("title", 64L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private RegionLocalization _escapedModel;

}