/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.portal.model.impl;

import com.liferay.portal.kernel.model.UserNotificationDelivery;
import com.liferay.portal.kernel.service.UserNotificationDeliveryLocalServiceUtil;

/**
 * The extended model base implementation for the UserNotificationDelivery service. Represents a row in the &quot;UserNotificationDelivery&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link UserNotificationDeliveryImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see UserNotificationDeliveryImpl
 * @see UserNotificationDelivery
 * @generated
 */
public abstract class UserNotificationDeliveryBaseImpl
	extends UserNotificationDeliveryModelImpl
	implements UserNotificationDelivery {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a user notification delivery model instance should use the <code>UserNotificationDelivery</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			UserNotificationDeliveryLocalServiceUtil.
				addUserNotificationDelivery(this);
		}
		else {
			UserNotificationDeliveryLocalServiceUtil.
				updateUserNotificationDelivery(this);
		}
	}

}