/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.portal.model.impl;

import com.liferay.portal.kernel.model.UserTrackerPath;
import com.liferay.portal.kernel.service.UserTrackerPathLocalServiceUtil;

/**
 * The extended model base implementation for the UserTrackerPath service. Represents a row in the &quot;UserTrackerPath&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link UserTrackerPathImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see UserTrackerPathImpl
 * @see UserTrackerPath
 * @generated
 */
public abstract class UserTrackerPathBaseImpl
	extends UserTrackerPathModelImpl implements UserTrackerPath {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a user tracker path model instance should use the <code>UserTrackerPath</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			UserTrackerPathLocalServiceUtil.addUserTrackerPath(this);
		}
		else {
			UserTrackerPathLocalServiceUtil.updateUserTrackerPath(this);
		}
	}

}