/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.portal.model.impl;

import com.liferay.portal.kernel.model.WorkflowInstanceLink;
import com.liferay.portal.kernel.service.WorkflowInstanceLinkLocalServiceUtil;

/**
 * The extended model base implementation for the WorkflowInstanceLink service. Represents a row in the &quot;WorkflowInstanceLink&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link WorkflowInstanceLinkImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see WorkflowInstanceLinkImpl
 * @see WorkflowInstanceLink
 * @generated
 */
public abstract class WorkflowInstanceLinkBaseImpl
	extends WorkflowInstanceLinkModelImpl implements WorkflowInstanceLink {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a workflow instance link model instance should use the <code>WorkflowInstanceLink</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			WorkflowInstanceLinkLocalServiceUtil.addWorkflowInstanceLink(this);
		}
		else {
			WorkflowInstanceLinkLocalServiceUtil.updateWorkflowInstanceLink(
				this);
		}
	}

}