/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.portal.upgrade.v7_1_x;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.upgrade.BaseDBColumnSizeUpgradeProcess;

/**
 * @author Preston Crary
 */
public class UpgradeDB2 extends BaseDBColumnSizeUpgradeProcess {

	public UpgradeDB2() {
		super(DBType.DB2, "varchar", 750);
	}

	@Override
	protected void upgradeColumn(String tableName, String columnName)
		throws Exception {

		runSQL(
			StringBundler.concat(
				"alter table ", tableName, " alter column ", columnName,
				" set data type varchar(4000)"));
	}

}