/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.portlet.documentlibrary.model.impl;

import com.liferay.document.library.kernel.model.DLFileShortcut;
import com.liferay.document.library.kernel.service.DLFileShortcutLocalServiceUtil;

/**
 * The extended model base implementation for the DLFileShortcut service. Represents a row in the &quot;DLFileShortcut&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link DLFileShortcutImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see DLFileShortcutImpl
 * @see DLFileShortcut
 * @generated
 */
public abstract class DLFileShortcutBaseImpl
	extends DLFileShortcutModelImpl implements DLFileShortcut {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a document library file shortcut model instance should use the <code>DLFileShortcut</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			DLFileShortcutLocalServiceUtil.addDLFileShortcut(this);
		}
		else {
			DLFileShortcutLocalServiceUtil.updateDLFileShortcut(this);
		}
	}

	@Override
	public void updateTreePath(String treePath) {
		DLFileShortcut dlFileShortcut = this;

		dlFileShortcut.setTreePath(treePath);

		DLFileShortcutLocalServiceUtil.updateDLFileShortcut(dlFileShortcut);
	}

}