/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.portlet.social.model.impl;

import com.liferay.social.kernel.model.SocialActivityCounter;
import com.liferay.social.kernel.service.SocialActivityCounterLocalServiceUtil;

/**
 * The extended model base implementation for the SocialActivityCounter service. Represents a row in the &quot;SocialActivityCounter&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link SocialActivityCounterImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see SocialActivityCounterImpl
 * @see SocialActivityCounter
 * @generated
 */
public abstract class SocialActivityCounterBaseImpl
	extends SocialActivityCounterModelImpl implements SocialActivityCounter {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a social activity counter model instance should use the <code>SocialActivityCounter</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			SocialActivityCounterLocalServiceUtil.addSocialActivityCounter(
				this);
		}
		else {
			SocialActivityCounterLocalServiceUtil.updateSocialActivityCounter(
				this);
		}
	}

}