/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.counter.service.persistence.impl;

import com.liferay.counter.kernel.model.Counter;
import com.liferay.counter.kernel.service.persistence.CounterFinder;
import com.liferay.counter.model.CounterHolder;
import com.liferay.counter.model.CounterRegister;
import com.liferay.counter.model.impl.CounterImpl;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.cache.CacheRegistryItem;
import com.liferay.portal.kernel.concurrent.CompeteLatch;
import com.liferay.portal.kernel.dao.orm.LockMode;
import com.liferay.portal.kernel.dao.orm.ORMException;
import com.liferay.portal.kernel.dao.orm.ObjectNotFoundException;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;

public class CounterFinderImpl
implements CacheRegistryItem,
CounterFinder {
    private static final int _DEFAULT_CURRENT_ID = 0;
    private static final int _MINIMUM_INCREMENT_SIZE = 1;
    private static final String _NAME = Counter.class.getName();
    private static final String _SQL_INSERT = "insert into Counter(name, currentId) values (?, ?)";
    private static final String _SQL_SELECT_ID_BY_NAME = "select currentId from Counter where name = ?";
    private static final String _SQL_SELECT_NAMES = "select name from Counter order by name asc";
    private static final String _SQL_UPDATE_NAME_BY_NAME = "update Counter set name = ? where name = ?";
    private static final Log _log = LogFactoryUtil.getLog(CounterFinderImpl.class);
    private final Map<String, CounterRegister> _counterRegisterMap = new ConcurrentHashMap<String, CounterRegister>();
    private DataSource _dataSource;
    private final Map<String, Integer> _rangeSizeMap = new ConcurrentHashMap<String, Integer>();
    private SessionFactory _sessionFactory;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getCurrentId(String name) {
        try (Connection connection = this.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(_SQL_SELECT_ID_BY_NAME);){
            preparedStatement.setString(1, name);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (!resultSet.next()) return 0L;
                long l = resultSet.getLong(1);
                return l;
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
    }

    /*
     * Exception decompiling
     */
    public List<String> getNames() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String getRegistryName() {
        return CounterFinderImpl.class.getName();
    }

    public long increment() {
        return this.increment(_NAME);
    }

    public long increment(String name) {
        return this.increment(name, 1);
    }

    public long increment(String name, int size) {
        if (size < 1) {
            size = 1;
        }
        return this._competeIncrement(this.getCounterRegister(name), size);
    }

    public void invalidate() {
        this._counterRegisterMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rename(String oldName, String newName) {
        CounterRegister counterRegister;
        CounterRegister counterRegister2 = counterRegister = this.getCounterRegister(oldName);
        synchronized (counterRegister2) {
            if (this._counterRegisterMap.containsKey(newName)) {
                throw new SystemException(StringBundler.concat((String[])new String[]{"Cannot rename ", oldName, " to ", newName}));
            }
            try (Connection connection = this.getConnection();
                 PreparedStatement preparedStatement = connection.prepareStatement(_SQL_UPDATE_NAME_BY_NAME);){
                preparedStatement.setString(1, newName);
                preparedStatement.setString(2, oldName);
                preparedStatement.executeUpdate();
            }
            catch (ObjectNotFoundException objectNotFoundException) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Throwable)objectNotFoundException);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            counterRegister.setName(newName);
            this._counterRegisterMap.put(newName, counterRegister);
            this._counterRegisterMap.remove(oldName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset(String name) {
        CounterRegister counterRegister;
        CounterRegister counterRegister2 = counterRegister = this.getCounterRegister(name);
        synchronized (counterRegister2) {
            Session session = null;
            try {
                session = this.openSession();
                Counter counter = (Counter)session.get(CounterImpl.class, (Serializable)((Object)name));
                session.delete((Object)counter);
                session.flush();
            }
            catch (ObjectNotFoundException objectNotFoundException) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Throwable)objectNotFoundException);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
            this._counterRegisterMap.remove(name);
        }
    }

    public void reset(String name, long size) {
        CounterRegister counterRegister = this.createCounterRegister(name, size);
        this._counterRegisterMap.put(name, counterRegister);
    }

    protected void closeSession(Session session) throws ORMException {
        this._sessionFactory.closeSession(session);
    }

    protected CounterRegister createCounterRegister(String name) {
        return this.createCounterRegister(name, -1L);
    }

    protected CounterRegister createCounterRegister(String name, long size) {
        block51: {
            long rangeMin = -1L;
            try (Connection connection = this.getConnection();
                 PreparedStatement preparedStatement1 = connection.prepareStatement(_SQL_SELECT_ID_BY_NAME);){
                preparedStatement1.setString(1, name);
                try (ResultSet resultSet = preparedStatement1.executeQuery();){
                    if (resultSet.next()) break block51;
                    rangeMin = 0L;
                    if (size > rangeMin) {
                        rangeMin = size;
                    }
                    try (PreparedStatement preparedStatement2 = connection.prepareStatement(_SQL_INSERT);){
                        preparedStatement2.setString(1, name);
                        preparedStatement2.setLong(2, rangeMin);
                        preparedStatement2.executeUpdate();
                    }
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
        }
        int rangeSize = this.getRangeSize(name);
        CounterHolder counterHolder = this._obtainIncrement(name, rangeSize, size);
        return new CounterRegister(name, counterHolder, rangeSize);
    }

    protected Connection getConnection() throws SQLException {
        return this._dataSource.getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CounterRegister getCounterRegister(String name) {
        CounterRegister counterRegister = this._counterRegisterMap.get(name);
        if (counterRegister != null) {
            return counterRegister;
        }
        Map<String, CounterRegister> map = this._counterRegisterMap;
        synchronized (map) {
            counterRegister = this._counterRegisterMap.get(name);
            if (counterRegister == null) {
                counterRegister = this.createCounterRegister(name);
                this._counterRegisterMap.put(name, counterRegister);
            }
            return counterRegister;
        }
    }

    protected int getRangeSize(String name) {
        if (name.equals(_NAME)) {
            return PropsValues.COUNTER_INCREMENT;
        }
        String incrementType = null;
        int pos = name.indexOf(35);
        incrementType = pos != -1 ? name.substring(0, pos) : name;
        Integer rangeSize = this._rangeSizeMap.get(incrementType);
        if (rangeSize == null) {
            rangeSize = GetterUtil.getInteger((String)PropsUtil.get("counter.increment." + incrementType), (int)PropsValues.COUNTER_INCREMENT);
            this._rangeSizeMap.put(incrementType, rangeSize);
        }
        return rangeSize;
    }

    protected Session openSession() throws ORMException {
        return this._sessionFactory.openSession();
    }

    protected SystemException processException(Exception exception) {
        if (!(exception instanceof ORMException)) {
            _log.error((Object)"Caught unexpected exception", (Throwable)exception);
        } else if (_log.isDebugEnabled()) {
            _log.debug((Throwable)exception);
        }
        return new SystemException((Throwable)exception);
    }

    protected void setDataSource(DataSource dataSource) {
        this._dataSource = dataSource;
    }

    protected void setSessionFactory(SessionFactory sessionFactory) {
        this._sessionFactory = sessionFactory;
    }

    private long _competeIncrement(CounterRegister counterRegister, int size) {
        CounterHolder counterHolder = counterRegister.getCounterHolder();
        long newValue = counterHolder.addAndGet(size);
        if (newValue <= counterHolder.getRangeMax()) {
            return newValue;
        }
        CompeteLatch competeLatch = counterRegister.getCompeteLatch();
        if (!competeLatch.compete()) {
            try {
                competeLatch.await();
            }
            catch (InterruptedException interruptedException) {
                throw this.processException(interruptedException);
            }
            return this._competeIncrement(counterRegister, size);
        }
        try {
            counterHolder = counterRegister.getCounterHolder();
            newValue = counterHolder.addAndGet(size);
            if (newValue > counterHolder.getRangeMax()) {
                int range = counterRegister.getRangeSize();
                if (size > range) {
                    range = size;
                }
                CounterHolder newCounterHolder = this._obtainIncrement(counterRegister.getName(), range, 0L);
                newValue = newCounterHolder.addAndGet(size);
                counterRegister.setCounterHolder(newCounterHolder);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            competeLatch.done();
        }
        return newValue;
    }

    private CounterHolder _obtainIncrement(String counterName, long range, long size) {
        Session session = null;
        try {
            session = this.openSession();
            Counter counter = (Counter)session.get(CounterImpl.class, (Serializable)((Object)counterName), LockMode.UPGRADE);
            long newValue = counter.getCurrentId();
            if (size > newValue) {
                newValue = size;
            }
            long rangeMax = newValue + range;
            counter.setCurrentId(rangeMax);
            CounterHolder counterHolder = new CounterHolder(newValue, rangeMax);
            session.saveOrUpdate((Object)counter);
            session.flush();
            CounterHolder counterHolder2 = counterHolder;
            return counterHolder2;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }
}

