/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mail.service.impl;

import com.liferay.mail.kernel.auth.token.provider.MailAuthTokenProvider;
import com.liferay.mail.kernel.auth.token.provider.MailAuthTokenProviderRegistryUtil;
import com.liferay.mail.kernel.model.Account;
import com.liferay.mail.kernel.model.MailMessage;
import com.liferay.mail.kernel.service.MailService;
import com.liferay.portal.kernel.change.tracking.CTAware;
import com.liferay.portal.kernel.cluster.Clusterable;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InfrastructureUtil;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.mail.Authenticator;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;

@CTAware
public class MailServiceImpl
implements IdentifiableOSGiService,
MailService {
    private static final Log _log = LogFactoryUtil.getLog(MailServiceImpl.class);
    private final Map<Long, Session> _sessions = new ConcurrentHashMap<Long, Session>();

    @Clusterable
    public void clearSession() {
        this.clearSession(0L);
    }

    @Clusterable
    public void clearSession(long companyId) {
        if (companyId == 0L) {
            this._sessions.clear();
        }
        this._sessions.remove(companyId);
    }

    public String getOSGiServiceIdentifier() {
        return MailService.class.getName();
    }

    public Session getSession() {
        return this.getSession(CompanyThreadLocal.getCompanyId());
    }

    public Session getSession(Account account) {
        Session session = Session.getInstance((Properties)this._getProperties(account));
        if (_log.isDebugEnabled()) {
            session.setDebug(true);
            Properties sessionProperties = session.getProperties();
            sessionProperties.list(System.out);
        }
        return session;
    }

    public Session getSession(long companyId) {
        boolean smtpAuth;
        String transportPrefix;
        boolean oAuth2AuthEnable;
        Properties properties;
        String smtpUser;
        Session session;
        block13: {
            session = this._sessions.get(companyId);
            if (session != null) {
                return session;
            }
            session = InfrastructureUtil.getMailSession();
            Function<String, String> function = key -> PrefsPropsUtil.getString((long)companyId, (String)key, (String)PrefsPropsUtil.getString((String)key, (String)PropsUtil.get((String)key)));
            if (!GetterUtil.getBoolean((String)function.apply("mail.session.mail"))) {
                this._sessions.put(companyId, session);
                return session;
            }
            String advancedPropertiesString = function.apply("mail.session.mail.advanced.properties");
            String pop3Host = function.apply("mail.session.mail.pop3.host");
            String pop3Password = function.apply("mail.session.mail.pop3.password");
            int pop3Port = GetterUtil.getInteger((String)function.apply("mail.session.mail.pop3.port"));
            String pop3User = function.apply("mail.session.mail.pop3.user");
            String smtpHost = function.apply("mail.session.mail.smtp.host");
            String smtpPassword = function.apply("mail.session.mail.smtp.password");
            int smtpPort = GetterUtil.getInteger((String)function.apply("mail.session.mail.smtp.port"));
            boolean smtpStartTLSEnable = GetterUtil.getBoolean((String)function.apply("mail.session.mail.smtp.starttls.enable"));
            smtpUser = function.apply("mail.session.mail.smtp.user");
            String storeProtocol = function.apply("mail.session.mail.store.protocol");
            String transportProtocol = function.apply("mail.session.mail.transport.protocol");
            properties = session.getProperties();
            if (!storeProtocol.equals("pop3s")) {
                storeProtocol = "pop3";
            }
            properties.setProperty("mail.store.protocol", storeProtocol);
            String storePrefix = "mail." + storeProtocol + ".";
            oAuth2AuthEnable = false;
            MailAuthTokenProvider pop3MailAuthTokenProvider = MailAuthTokenProviderRegistryUtil.getMailAuthTokenProvider((long)companyId, (String)pop3Host, (String)storeProtocol);
            if (pop3MailAuthTokenProvider != null) {
                oAuth2AuthEnable = true;
                pop3Password = pop3MailAuthTokenProvider.getAccessToken(companyId);
                properties.put(storePrefix + "auth.mechanisms", "XOAUTH2");
                properties.put(storePrefix + "auth.xoauth2.two.line.authentication.format", "true");
            }
            properties.setProperty(storePrefix + "host", pop3Host);
            properties.setProperty(storePrefix + "password", pop3Password);
            properties.setProperty(storePrefix + "port", String.valueOf(pop3Port));
            properties.setProperty(storePrefix + "user", pop3User);
            if (!transportProtocol.equals("smtps")) {
                transportProtocol = "smtp";
            }
            properties.setProperty("mail.transport.protocol", transportProtocol);
            transportPrefix = "mail." + transportProtocol + ".";
            smtpAuth = false;
            if (Validator.isNotNull((String)smtpPassword) || Validator.isNotNull((String)smtpUser)) {
                smtpAuth = true;
            }
            properties.setProperty(transportPrefix + "auth", String.valueOf(smtpAuth));
            MailAuthTokenProvider smtpMailAuthTokenProvider = MailAuthTokenProviderRegistryUtil.getMailAuthTokenProvider((long)companyId, (String)smtpHost, (String)transportProtocol);
            if (smtpMailAuthTokenProvider != null) {
                oAuth2AuthEnable = true;
                properties.put(transportPrefix + "auth.mechanisms", "XOAUTH2");
                properties.put(transportPrefix + "auth.xoauth2.two.line.authentication.format", "false");
                smtpPassword = smtpMailAuthTokenProvider.getAccessToken(companyId);
            }
            properties.setProperty(transportPrefix + "host", smtpHost);
            properties.setProperty(transportPrefix + "password", smtpPassword);
            properties.setProperty(transportPrefix + "port", String.valueOf(smtpPort));
            properties.setProperty(transportPrefix + "starttls.enable", String.valueOf(smtpStartTLSEnable));
            properties.setProperty(transportPrefix + "user", smtpUser);
            try {
                if (Validator.isNotNull((String)advancedPropertiesString)) {
                    Properties advancedProperties = PropertiesUtil.load((String)advancedPropertiesString);
                    for (Map.Entry<Object, Object> entry : advancedProperties.entrySet()) {
                        String key2 = (String)entry.getKey();
                        String value = (String)entry.getValue();
                        properties.setProperty(key2, value);
                    }
                }
            }
            catch (IOException ioException) {
                if (!_log.isWarnEnabled()) break block13;
                _log.warn((Throwable)ioException);
            }
        }
        session = smtpAuth ? Session.getInstance((Properties)properties, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(smtpUser, properties.getProperty(transportPrefix + "password"));
            }
        }) : Session.getInstance((Properties)properties);
        if (_log.isDebugEnabled()) {
            session.setDebug(true);
            properties.list(System.out);
        }
        if (!oAuth2AuthEnable) {
            this._sessions.put(companyId, session);
        }
        return session;
    }

    public void sendEmail(MailMessage mailMessage) {
        TransactionCommitCallbackUtil.registerCallback(() -> {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"sendEmail");
            }
            MessageBusUtil.sendMessage((String)"liferay/mail", (Object)mailMessage);
            return null;
        });
    }

    private Properties _getProperties(Account account) {
        Properties properties = new Properties();
        String protocol = account.getProtocol();
        properties.setProperty("mail.transport.protocol", protocol);
        properties.setProperty("mail." + protocol + ".host", account.getHost());
        properties.setProperty("mail." + protocol + ".port", String.valueOf(account.getPort()));
        if (account.isRequiresAuthentication()) {
            properties.setProperty("mail." + protocol + ".auth", "true");
            properties.setProperty("mail." + protocol + ".user", account.getUser());
            properties.setProperty("mail." + protocol + ".password", account.getPassword());
        }
        if (account.isSecure()) {
            properties.setProperty("mail." + protocol + ".socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            properties.setProperty("mail." + protocol + ".socketFactory.fallback", "false");
            properties.setProperty("mail." + protocol + ".socketFactory.port", String.valueOf(account.getPort()));
        }
        return properties;
    }
}

