/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.db;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.dao.db.BaseDB;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.dao.db.Index;
import com.liferay.portal.kernel.dao.db.IndexMetadata;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import java.io.IOException;
import java.io.Reader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;

public class MySQLDB
extends BaseDB {
    private static final String[] _MYSQL = new String[]{"##", "1", "0", "'1970-01-01'", "now()", " longblob", " longblob", " decimal(30, 16)", " tinyint", " datetime(6)", " double", " integer", " bigint", " longtext", " longtext", " varchar", "  auto_increment", "commit"};
    private static final int[] _SQL_TYPES = new int[]{-4, -4, 3, -6, 93, 8, 4, -5, -1, -1, 12};
    private static final boolean _SUPPORTS_NEW_UUID_FUNCTION = true;
    private static final boolean _SUPPORTS_UPDATE_WITH_INNER_JOIN = true;

    public MySQLDB(int majorVersion, int minorVersion) {
        super(DBType.MYSQL, majorVersion, minorVersion);
    }

    @Override
    public void alterColumnType(Connection connection, String tableName, String columnName, String newColumnType) throws Exception {
        List<IndexMetadata> indexMetadatas = new ArrayList<IndexMetadata>();
        Matcher matcher = columnTypePattern.matcher(newColumnType);
        if (matcher.lookingAt() && ArrayUtil.contains((int[])SQL_VARCHAR_TYPES, (int)this.getSQLType(matcher.group(1)))) {
            indexMetadatas = this.dropIndexes(connection, tableName, columnName);
        }
        super.alterColumnType(connection, tableName, columnName, newColumnType);
        if (!indexMetadatas.isEmpty()) {
            this.addIndexes(connection, indexMetadatas);
        }
    }

    @Override
    public String buildSQL(String template) throws IOException {
        template = this.replaceTemplate(template);
        template = this.reword(template);
        template = StringUtil.replace((String)template, (String)"\\'", (String)"''");
        return template;
    }

    @Override
    public List<Index> getIndexes(Connection connection) throws SQLException {
        ArrayList<Index> indexes = new ArrayList<Index>();
        String sql = StringBundler.concat((String[])new String[]{"select distinct(index_name), table_name, non_unique from ", "information_schema.statistics where index_schema = database() ", "and (index_name like 'LIFERAY_%' or index_name like 'IX_%')"});
        try (PreparedStatement preparedStatement = connection.prepareStatement(sql);
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                String indexName = resultSet.getString("index_name");
                String tableName = resultSet.getString("table_name");
                boolean unique = !resultSet.getBoolean("non_unique");
                indexes.add(new Index(indexName, tableName, unique));
            }
        }
        return indexes;
    }

    public String getNewUuidFunctionName() {
        return "UUID()";
    }

    public String getPopulateSQL(String databaseName, String sqlContent) {
        return StringBundler.concat((String[])new String[]{"use ", databaseName, ";\n\n", sqlContent});
    }

    public String getRecreateSQL(String databaseName) {
        return StringBundler.concat((String[])new String[]{"drop database if exists ", databaseName, ";\n", "create database ", databaseName, " character set utf8;\n"});
    }

    public boolean isSupportsNewUuidFunction() {
        return true;
    }

    @Override
    public boolean isSupportsUpdateWithInnerJoin() {
        return true;
    }

    protected MySQLDB(DBType dbType, int majorVersion, int minorVersion) {
        super(dbType, majorVersion, minorVersion);
    }

    @Override
    protected final void doRenameTables(Connection connection, ObjectValuePair<String, String> ... tableNameObjectValuePairs) throws Exception {
        StringBundler sb = new StringBundler(tableNameObjectValuePairs.length * 4 + 1);
        sb.append("rename table ");
        for (int i = 0; i < tableNameObjectValuePairs.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append((String)tableNameObjectValuePairs[i].getKey());
            sb.append(" to ");
            sb.append((String)tableNameObjectValuePairs[i].getValue());
        }
        this.runSQL(connection, sb.toString());
    }

    @Override
    protected int[] getSQLTypes() {
        return _SQL_TYPES;
    }

    @Override
    protected String[] getTemplate() {
        return _MYSQL;
    }

    @Override
    protected String reword(String data) throws IOException {
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(data));){
            StringBundler sb = new StringBundler();
            boolean createTable = false;
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                String defaultValue;
                if (StringUtil.startsWith((String)line, (String)"create table")) {
                    createTable = true;
                } else if (line.startsWith("alter_column_name ")) {
                    String[] template = this.buildColumnNameTokens(line);
                    defaultValue = template[template.length - 2];
                    if (!Validator.isBlank((String)defaultValue)) {
                        line = StringUtil.replace((String)"alter table @table@ change column @old-column@ @new-column@ @type@ default @default@ @nullable@;", (String[])REWORD_TEMPLATE, (String[])template);
                    } else {
                        line = StringUtil.replace((String)"alter table @table@ change column @old-column@ @new-column@ @type@ @nullable@;", (String[])REWORD_TEMPLATE, (String[])template);
                        line = StringUtil.replace((String)line, (String)" ;", (String)";");
                    }
                } else if (line.startsWith("alter_column_type ")) {
                    String[] template = this.buildColumnTypeTokens(line);
                    defaultValue = template[template.length - 2];
                    if (!Validator.isBlank((String)defaultValue)) {
                        line = StringUtil.replace((String)"alter table @table@ modify @old-column@ @type@ default @default@ @nullable@;", (String[])REWORD_TEMPLATE, (String[])template);
                    } else {
                        line = StringUtil.replace((String)"alter table @table@ modify @old-column@ @type@ @nullable@;", (String[])REWORD_TEMPLATE, (String[])template);
                        line = StringUtil.replace((String)line, (String)" ;", (String)";");
                    }
                } else if (line.startsWith("alter_table_name ")) {
                    String[] template = this.buildTableNameTokens(line);
                    line = StringUtil.replace((String)"rename table @old-table@ to @new-table@;", (String[])RENAME_TABLE_TEMPLATE, (String[])template);
                }
                int pos = line.indexOf(59);
                if (createTable && pos != -1) {
                    createTable = false;
                    line = StringBundler.concat((String[])new String[]{line.substring(0, pos), " engine ", PropsValues.DATABASE_MYSQL_ENGINE, line.substring(pos)});
                }
                sb.append(line);
                sb.append("\n");
            }
            String string = sb.toString();
            return string;
        }
    }
}

