/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.db.index;

import com.liferay.portal.db.DBResourceUtil;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.dependency.manager.DependencyManagerSyncUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.util.BundleUtil;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.Validator;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.FutureTask;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;

public class IndexUpdaterUtil {
    private static final Log _log = LogFactoryUtil.getLog(IndexUpdaterUtil.class);

    public static void updateAllIndexes() {
        IndexUpdaterUtil.updatePortalIndexes();
        BundleTracker bundleTracker = new BundleTracker(SystemBundleUtil.getBundleContext(), 32, (BundleTrackerCustomizer)new BundleTrackerCustomizer<Void>(){

            public Void addingBundle(Bundle bundle, BundleEvent bundleEvent) {
                if (BundleUtil.isLiferayServiceBundle((Bundle)bundle)) {
                    try {
                        IndexUpdaterUtil.updateIndexes(bundle);
                    }
                    catch (Exception exception) {
                        _log.error((Throwable)exception);
                    }
                }
                return null;
            }

            public void modifiedBundle(Bundle bundle, BundleEvent bundleEvent, Void tracked) {
            }

            public void removedBundle(Bundle bundle, BundleEvent bundleEvent, Void tracked) {
            }
        });
        DependencyManagerSyncUtil.registerSyncFutureTask(new FutureTask<Object>(() -> {
            bundleTracker.open();
            DependencyManagerSyncUtil.registerSyncCallable(() -> {
                bundleTracker.close();
                return null;
            });
            return null;
        }), (String)(IndexUpdaterUtil.class.getName() + "-BundleTrackerOpener"));
    }

    public static void updateIndexes(Bundle bundle) throws Exception {
        String indexesSQL = DBResourceUtil.getModuleIndexesSQL(bundle);
        String tablesSQL = DBResourceUtil.getModuleTablesSQL(bundle);
        if (indexesSQL == null || tablesSQL == null) {
            return;
        }
        DB db = DBManagerUtil.getDB();
        db.process(companyId -> {
            String message = new String("Updating database indexes for " + bundle.getSymbolicName());
            if (Validator.isNotNull((Long)companyId) && _log.isInfoEnabled()) {
                message = message + " and company " + companyId;
            }
            try (Connection connection = DataAccess.getConnection();
                 LoggingTimer loggingTimer = new LoggingTimer(message);){
                db.updateIndexes(connection, tablesSQL, indexesSQL, true);
            }
        });
    }

    public static void updatePortalIndexes() {
        block2: {
            DB db = DBManagerUtil.getDB();
            try {
                db.process(companyId -> {
                    block27: {
                        String message = new String("Updating portal database indexes");
                        if (Validator.isNotNull((Long)companyId) && _log.isInfoEnabled()) {
                            message = message + " for company " + companyId;
                        }
                        try (Connection connection = DataAccess.getConnection();
                             LoggingTimer loggingTimer = new LoggingTimer(message);){
                            IndexUpdaterUtil._updatePortalIndexes(db, connection);
                        }
                        catch (SQLException sqlException) {
                            if (!_log.isWarnEnabled()) break block27;
                            _log.warn((Throwable)sqlException);
                        }
                    }
                });
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Throwable)exception);
            }
        }
    }

    private static void _updatePortalIndexes(DB db, Connection connection) throws Exception {
        db.updateIndexes(connection, DBResourceUtil.getPortalTablesSQL(), DBResourceUtil.getPortalIndexesSQL(), true);
    }
}

