/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.db.partition;

import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.dao.jdbc.util.ConnectionWrapper;
import com.liferay.portal.dao.jdbc.util.DataSourceWrapper;
import com.liferay.portal.dao.jdbc.util.StatementWrapper;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBInspector;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.dao.jdbc.CurrentConnectionUtil;
import com.liferay.portal.kernel.db.partition.DBPartition;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.framework.ThrowableCollector;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InfrastructureUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.spring.hibernate.DialectDetector;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.util.PropsValues;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.sql.DataSource;

public class DBPartitionUtil {
    private static final String _DATABASE_PARTITION_SCHEMA_NAME_PREFIX = GetterUtil.get((String)PropsUtil.get((String)"database.partition.schema.name.prefix"), (String)"lpartition_");
    private static final boolean _DATABASE_PARTITION_THREAD_POOL_ENABLED = GetterUtil.getBoolean((String)PropsUtil.get((String)"database.partition.thread.pool.enabled"), (boolean)true);
    private static final Log _log = LogFactoryUtil.getLog(DBPartitionUtil.class);
    private static final List<Long> _companyIds = new CopyOnWriteArrayList<Long>();
    private static volatile long _defaultCompanyId;
    private static String _defaultSchemaName;

    public static boolean addDBPartition(long companyId) throws PortalException {
        if (!DBPartition.isPartitionEnabled() || companyId == _defaultCompanyId) {
            return false;
        }
        Connection connection = CurrentConnectionUtil.getConnection((DataSource)InfrastructureUtil.getDataSource());
        try (PreparedStatement preparedStatement = connection.prepareStatement(DBPartitionUtil._getCreateSchemaSQL(companyId));){
            preparedStatement.executeUpdate();
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            DBInspector dbInspector = new DBInspector(connection);
            try (ResultSet resultSet = databaseMetaData.getTables(dbInspector.getCatalog(), dbInspector.getSchema(), null, new String[]{"TABLE"});
                 Statement statement = connection.createStatement();){
                while (resultSet.next()) {
                    String tableName = resultSet.getString("TABLE_NAME");
                    if (DBInspector.isObjectTable(DBPartitionUtil._getCompanyIds(), (String)tableName)) continue;
                    if (dbInspector.isControlTable(DBPartitionUtil._getCompanyIds(), tableName)) {
                        statement.executeUpdate(DBPartitionUtil._getCreateViewSQL(companyId, tableName));
                        continue;
                    }
                    statement.executeUpdate(DBPartitionUtil._getCreateTableSQL(companyId, tableName));
                    if (!dbInspector.isPartitionedControlTable(tableName)) continue;
                    DBPartitionUtil._copyData(tableName, _defaultSchemaName, DBPartitionUtil._getSchemaName(companyId), statement, "");
                }
            }
        }
        catch (Exception exception) {
            throw new PortalException((Throwable)exception);
        }
        _companyIds.add(companyId);
        return true;
    }

    public static boolean extractDBPartition(long companyId) throws PortalException {
        if (!DBPartition.isPartitionEnabled() || companyId == _defaultCompanyId) {
            return false;
        }
        DBPartitionUtil._extractDBPartition(companyId);
        return true;
    }

    public static void forEachCompanyId(UnsafeConsumer<Long, Exception> unsafeConsumer) throws Exception {
        if (!DBPartition.isPartitionEnabled()) {
            unsafeConsumer.accept(null);
            return;
        }
        if (CompanyThreadLocal.isLocked()) {
            unsafeConsumer.accept((Object)CompanyThreadLocal.getCompanyId());
            return;
        }
        if (_DATABASE_PARTITION_THREAD_POOL_ENABLED) {
            DBPartitionUtil._forEachCompanyIdConcurrently(unsafeConsumer);
            return;
        }
        List<Long> companyIds = DBPartitionUtil._getCompanyIds();
        if (companyIds.isEmpty()) {
            unsafeConsumer.accept(null);
        } else {
            for (long companyId : companyIds) {
                SafeCloseable safeCloseable = CompanyThreadLocal.lock((long)companyId);
                Throwable throwable = null;
                try {
                    unsafeConsumer.accept((Object)companyId);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (safeCloseable == null) continue;
                    if (throwable != null) {
                        try {
                            safeCloseable.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    safeCloseable.close();
                }
            }
        }
    }

    public static long getCurrentCompanyId() {
        long companyId = CompanyThreadLocal.getCompanyId();
        if (!DBPartition.isPartitionEnabled()) {
            return companyId;
        }
        if (companyId == 0L) {
            companyId = _defaultCompanyId;
        }
        return companyId;
    }

    public static boolean insertDBPartition(long companyId) throws PortalException {
        if (!DBPartition.isPartitionEnabled()) {
            return false;
        }
        DBPartitionUtil._insertDBPartition(companyId);
        return true;
    }

    public static boolean removeDBPartition(long companyId) throws PortalException {
        if (!DBPartition.isPartitionEnabled() || companyId == _defaultCompanyId) {
            return false;
        }
        DBPartitionUtil._dropDBPartition(companyId);
        return true;
    }

    public static void replaceByTable(Connection connection, String viewName) throws Exception {
        long companyId = DBPartitionUtil.getCurrentCompanyId();
        if (companyId == _defaultCompanyId) {
            return;
        }
        try (Statement statement = connection.createStatement();){
            statement.execute(DBPartitionUtil._getDropViewSQL(companyId, viewName));
            statement.execute(DBPartitionUtil._getCreateTableSQL(companyId, viewName));
            DBPartitionUtil._copyData(viewName, _defaultSchemaName, DBPartitionUtil._getSchemaName(companyId), statement, "");
        }
    }

    public static void setDefaultCompanyId(Connection connection) throws SQLException {
        if (DBPartition.isPartitionEnabled()) {
            try (PreparedStatement preparedStatement = connection.prepareStatement("select companyId from Company where webId = '" + PropsValues.COMPANY_DEFAULT_WEB_ID + "'");
                 ResultSet resultSet = preparedStatement.executeQuery();){
                if (resultSet.next()) {
                    _defaultCompanyId = resultSet.getLong(1);
                }
            }
        }
    }

    public static void setDefaultCompanyId(long companyId) {
        if (DBPartition.isPartitionEnabled()) {
            _defaultCompanyId = companyId;
        }
    }

    public static DataSource wrapDataSource(DataSource dataSource) throws SQLException {
        if (!DBPartition.isPartitionEnabled()) {
            return dataSource;
        }
        DB db = DBManagerUtil.getDB((DBType)DBManagerUtil.getDBType((Object)DialectDetector.getDialect(dataSource)), (DataSource)dataSource);
        if (db.getDBType() != DBType.MYSQL) {
            throw new Error("Database partition requires MySQL");
        }
        try (Connection connection = dataSource.getConnection();){
            _defaultSchemaName = connection.getCatalog();
        }
        return new DataSourceWrapper(dataSource){

            @Override
            public Connection getConnection() throws SQLException {
                return DBPartitionUtil._getConnectionWrapper(super.getConnection());
            }

            @Override
            public Connection getConnection(String userName, String password) throws SQLException {
                return DBPartitionUtil._getConnectionWrapper(super.getConnection());
            }
        };
    }

    private static void _copyData(String tableName, String fromSchemaName, String toSchemaName, Statement statement, String whereClause) throws Exception {
        statement.executeUpdate(StringBundler.concat((String[])new String[]{"insert ", toSchemaName, ".", tableName, " select * from ", fromSchemaName, ".", tableName, whereClause}));
    }

    private static void _deleteCompanyData(long companyId, String tableName, String schemaName, Statement statement) throws Exception {
        statement.executeUpdate(StringBundler.concat((Object[])new Object[]{"delete from ", schemaName, ".", tableName, " where companyId = ", companyId}));
    }

    private static void _dropDBPartition(long companyId) throws PortalException {
        Connection connection = CurrentConnectionUtil.getConnection((DataSource)InfrastructureUtil.getDataSource());
        DBInspector dbInspector = new DBInspector(connection);
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            try (ResultSet resultSet = databaseMetaData.getTables(_defaultSchemaName, dbInspector.getSchema(), null, new String[]{"TABLE"});
                 Statement statement = connection.createStatement();){
                while (resultSet.next()) {
                    String tableName = resultSet.getString("TABLE_NAME");
                    if (!dbInspector.isControlTable(DBPartitionUtil._getCompanyIds(), tableName) || !dbInspector.hasColumn(tableName, "companyId")) continue;
                    statement.executeUpdate(StringBundler.concat((Object[])new Object[]{"delete from ", _defaultSchemaName, ".", tableName, " where companyId = ", companyId}));
                }
                statement.executeUpdate("drop schema " + DBPartitionUtil._getSchemaName(companyId));
            }
        }
        catch (Exception exception) {
            throw new PortalException("Unable to drop database partition", (Throwable)exception);
        }
        _companyIds.remove(companyId);
    }

    private static void _extractDBPartition(long companyId) throws PortalException {
        Connection connection = CurrentConnectionUtil.getConnection((DataSource)InfrastructureUtil.getDataSource());
        ArrayList<String> controlTableNames = new ArrayList<String>();
        DBInspector dbInspector = new DBInspector(connection);
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            try (ResultSet resultSet = databaseMetaData.getTables(_defaultSchemaName, dbInspector.getSchema(), null, new String[]{"TABLE"});
                 Statement statement = connection.createStatement();){
                while (resultSet.next()) {
                    String tableName = resultSet.getString("TABLE_NAME");
                    if (!dbInspector.isControlTable(DBPartitionUtil._getCompanyIds(), tableName)) continue;
                    controlTableNames.add(tableName);
                    DBPartitionUtil._extractTable(companyId, tableName, statement, dbInspector);
                }
            }
        }
        catch (Exception exception1) {
            if (ListUtil.isEmpty(controlTableNames)) {
                throw new PortalException((Throwable)exception1);
            }
            try {
                for (String tableName : controlTableNames) {
                    Statement statement = connection.createStatement();
                    Throwable throwable = null;
                    try {
                        DBPartitionUtil._restoreTable(companyId, tableName, statement, dbInspector);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (statement == null) continue;
                        if (throwable != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        statement.close();
                    }
                }
            }
            catch (Exception exception2) {
                throw new PortalException(StringBundler.concat((String[])new String[]{"Unable to roll back the extraction of database ", "partition. Recover a backup of the database schema ", DBPartitionUtil._getSchemaName(companyId), "."}), (Throwable)exception2);
            }
            throw new PortalException("Removal of database partition extraction was rolled back", (Throwable)exception1);
        }
        _companyIds.remove(companyId);
    }

    private static void _extractTable(long companyId, String tableName, Statement statement, DBInspector dbInspector) throws Exception {
        statement.executeUpdate(DBPartitionUtil._getDropViewSQL(companyId, tableName));
        statement.executeUpdate(DBPartitionUtil._getCreateTableSQL(companyId, tableName));
        if (dbInspector.hasColumn(tableName, "companyId")) {
            DBPartitionUtil._moveCompanyData(companyId, tableName, _defaultSchemaName, DBPartitionUtil._getSchemaName(companyId), statement);
        } else {
            DBPartitionUtil._copyData(tableName, _defaultSchemaName, DBPartitionUtil._getSchemaName(companyId), statement, "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _forEachCompanyIdConcurrently(UnsafeConsumer<Long, Exception> unsafeConsumer) throws Exception {
        ThrowableCollector throwableCollector;
        block18: {
            ExecutorService executorService = Executors.newWorkStealingPool();
            ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
            throwableCollector = new ThrowableCollector();
            try {
                List<Long> companyIds = DBPartitionUtil._getCompanyIds();
                if (companyIds.isEmpty()) {
                    unsafeConsumer.accept(null);
                    break block18;
                }
                Iterator<Long> iterator = companyIds.iterator();
                while (iterator.hasNext()) {
                    long companyId = iterator.next();
                    if (companyId == _defaultCompanyId) {
                        SafeCloseable safeCloseable = CompanyThreadLocal.lock((long)companyId);
                        Throwable throwable = null;
                        try {
                            unsafeConsumer.accept((Object)companyId);
                            continue;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (safeCloseable == null) continue;
                            if (throwable != null) {
                                try {
                                    safeCloseable.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            safeCloseable.close();
                            continue;
                        }
                    }
                    Future<Void> future = executorService.submit(() -> {
                        try (SafeCloseable safeCloseable = CompanyThreadLocal.lock((long)companyId);){
                            unsafeConsumer.accept((Object)companyId);
                        }
                        catch (Exception exception) {
                            throwableCollector.collect((Throwable)exception);
                        }
                        return null;
                    });
                    futures.add(future);
                }
            }
            finally {
                executorService.shutdown();
                for (Future future : futures) {
                    future.get();
                }
            }
        }
        Throwable throwable = throwableCollector.getThrowable();
        if (throwable != null) {
            ReflectionUtil.throwException((Throwable)throwable);
        }
    }

    private static List<Long> _getCompanyIds() throws SQLException {
        if (_companyIds.isEmpty()) {
            for (long companyId : PortalInstances.getCompanyIdsBySQL()) {
                _companyIds.add(companyId);
            }
        }
        return _companyIds;
    }

    private static Connection _getConnectionWrapper(final Connection connection) {
        return new ConnectionWrapper(connection){

            @Override
            public Statement createStatement() throws SQLException {
                this._setCatalog();
                return DBPartitionUtil._wrapStatement(super.createStatement());
            }

            @Override
            public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
                this._setCatalog();
                return DBPartitionUtil._wrapStatement(super.createStatement(resultSetType, resultSetConcurrency));
            }

            @Override
            public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
                this._setCatalog();
                return DBPartitionUtil._wrapStatement(super.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability));
            }

            @Override
            public String getCatalog() throws SQLException {
                return DBPartitionUtil._getSchemaName(CompanyThreadLocal.getCompanyId());
            }

            @Override
            public PreparedStatement prepareStatement(String sql) throws SQLException {
                this._setCatalog();
                return super.prepareStatement(sql);
            }

            @Override
            public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
                this._setCatalog();
                return super.prepareStatement(sql, autoGeneratedKeys);
            }

            @Override
            public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
                this._setCatalog();
                return super.prepareStatement(sql, resultSetType, resultSetConcurrency);
            }

            @Override
            public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
                this._setCatalog();
                return super.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            }

            @Override
            public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
                this._setCatalog();
                return super.prepareStatement(sql, columnIndexes);
            }

            @Override
            public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
                this._setCatalog();
                return super.prepareStatement(sql, columnNames);
            }

            private void _setCatalog() throws SQLException {
                long companyId = CompanyThreadLocal.getCompanyId();
                String schemaName = DBPartitionUtil._getSchemaName(companyId);
                connection.setCatalog(schemaName);
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Using database schema ", schemaName, " and company ", companyId}));
                }
            }
        };
    }

    private static String _getCreateSchemaSQL(long companyId) {
        return StringBundler.concat((String[])new String[]{"create schema if not exists ", DBPartitionUtil._getSchemaName(companyId), " character set ", DBPartitionUtil._getSessionCharsetEncoding()});
    }

    private static String _getCreateTableSQL(long companyId, String tableName) {
        return StringBundler.concat((String[])new String[]{"create table if not exists ", DBPartitionUtil._getSchemaName(companyId), ".", tableName, " like ", _defaultSchemaName, ".", tableName});
    }

    private static String _getCreateViewSQL(long companyId, String viewName) {
        return StringBundler.concat((String[])new String[]{"create or replace view ", DBPartitionUtil._getSchemaName(companyId), ".", viewName, " as select * from ", _defaultSchemaName, ".", viewName});
    }

    private static String _getDropTableSQL(long companyId, String tableName) {
        return StringBundler.concat((String[])new String[]{"drop table if exists ", DBPartitionUtil._getSchemaName(companyId), ".", tableName});
    }

    private static String _getDropViewSQL(long companyId, String viewName) {
        return StringBundler.concat((String[])new String[]{"drop view if exists ", DBPartitionUtil._getSchemaName(companyId), ".", viewName});
    }

    private static String _getSchemaName(long companyId) {
        if (companyId == 0L || companyId == _defaultCompanyId) {
            return _defaultSchemaName;
        }
        return _DATABASE_PARTITION_SCHEMA_NAME_PREFIX + companyId;
    }

    /*
     * Exception decompiling
     */
    private static String _getSessionCharsetEncoding() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void _insertDBPartition(long companyId) throws PortalException {
        ArrayList<String> companyIdControlTableNames = new ArrayList<String>();
        Connection connection = CurrentConnectionUtil.getConnection((DataSource)InfrastructureUtil.getDataSource());
        try (Statement statement = connection.createStatement();){
            DBInspector dbInspector = new DBInspector(connection);
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            try (ResultSet resultSet = databaseMetaData.getTables(_defaultSchemaName, dbInspector.getSchema(), null, new String[]{"TABLE"});){
                while (resultSet.next()) {
                    String tableName = resultSet.getString("TABLE_NAME");
                    if (!dbInspector.isControlTable(DBPartitionUtil._getCompanyIds(), tableName)) continue;
                    if (dbInspector.hasColumn(tableName, "companyId")) {
                        DBPartitionUtil._copyData(tableName, DBPartitionUtil._getSchemaName(companyId), _defaultSchemaName, statement, " where companyId = " + companyId);
                        companyIdControlTableNames.add(tableName);
                    }
                    statement.executeUpdate(DBPartitionUtil._getDropTableSQL(companyId, tableName));
                    statement.executeUpdate(DBPartitionUtil._getCreateViewSQL(companyId, tableName));
                }
            }
        }
        catch (Exception exception1) {
            try (Statement statement2 = connection.createStatement();){
                for (String companyIdControlTable : companyIdControlTableNames) {
                    DBPartitionUtil._deleteCompanyData(companyId, companyIdControlTable, _defaultSchemaName, statement2);
                }
            }
            catch (Exception exception2) {
                throw new PortalException(StringBundler.concat((Object[])new Object[]{"Unable to roll back the data inserted into the ", "default schema for tables ", companyIdControlTableNames, " and company ID ", companyId}), (Throwable)exception2);
            }
            throw new PortalException(StringBundler.concat((String[])new String[]{"Unable to roll back the insertion of database partition. ", "Recover a backup of the database schema ", DBPartitionUtil._getSchemaName(companyId), "."}), (Throwable)exception1);
        }
        _companyIds.add(companyId);
    }

    private static boolean _isSkip(Connection connection, String tableName) throws SQLException {
        try {
            DBInspector dbInspector = new DBInspector(connection);
            if (dbInspector.isControlTable(DBPartitionUtil._getCompanyIds(), tableName) && CompanyThreadLocal.getCompanyId() != _defaultCompanyId) {
                return true;
            }
        }
        catch (Exception exception) {
            throw new SQLException("Unable to check if the table " + tableName + " is a control table", exception);
        }
        return false;
    }

    private static void _moveCompanyData(long companyId, String tableName, String fromSchemaName, String toSchemaName, Statement statement) throws Exception {
        DBPartitionUtil._copyData(tableName, fromSchemaName, toSchemaName, statement, " where companyId = " + companyId);
        DBPartitionUtil._deleteCompanyData(companyId, tableName, fromSchemaName, statement);
    }

    private static void _restoreTable(long companyId, String tableName, Statement statement, DBInspector dbInspector) throws Exception {
        if (dbInspector.hasColumn(tableName, "companyId")) {
            DBPartitionUtil._moveCompanyData(companyId, tableName, DBPartitionUtil._getSchemaName(companyId), _defaultSchemaName, statement);
        }
        statement.executeUpdate(DBPartitionUtil._getDropTableSQL(companyId, tableName));
        statement.executeUpdate(DBPartitionUtil._getCreateViewSQL(companyId, tableName));
    }

    private static Statement _wrapStatement(final Statement statement) {
        return new StatementWrapper(statement){

            @Override
            public int executeUpdate(String sql) throws SQLException {
                Connection connection = statement.getConnection();
                String lowerCaseSQL = StringUtil.toLowerCase((String)sql);
                String[] query = sql.split(" ");
                if (StringUtil.startsWith((String)lowerCaseSQL, (String)"alter table") && DBPartitionUtil._isSkip(connection, query[2]) || (StringUtil.startsWith((String)lowerCaseSQL, (String)"create index") || StringUtil.startsWith((String)lowerCaseSQL, (String)"drop index")) && DBPartitionUtil._isSkip(connection, query[4]) || StringUtil.startsWith((String)lowerCaseSQL, (String)"create unique index") && DBPartitionUtil._isSkip(connection, query[5])) {
                    return 0;
                }
                int returnValue = super.executeUpdate(sql);
                if (!StringUtil.startsWith((String)lowerCaseSQL, (String)"alter table")) {
                    return returnValue;
                }
                try {
                    DBInspector dbInspector = new DBInspector(connection);
                    String tableName = query[2];
                    if (!dbInspector.isControlTable(DBPartitionUtil._getCompanyIds(), tableName)) {
                        return returnValue;
                    }
                    Iterator iterator = DBPartitionUtil._getCompanyIds().iterator();
                    while (iterator.hasNext()) {
                        long companyId = (Long)iterator.next();
                        if (companyId == _defaultCompanyId) continue;
                        super.execute(DBPartitionUtil._getCreateViewSQL(companyId, tableName));
                    }
                    return returnValue;
                }
                catch (Exception exception) {
                    throw new SQLException(exception);
                }
            }
        };
    }
}

