/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.repository;

import com.liferay.document.library.kernel.model.DLVersionNumberIncrease;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.repository.DocumentRepository;
import com.liferay.portal.kernel.repository.capabilities.Capability;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileShortcut;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.repository.model.RepositoryEntry;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.io.File;
import java.io.InputStream;
import java.util.Date;
import java.util.List;

public abstract class InitializedDocumentRepository<T extends DocumentRepository>
implements DocumentRepository {
    protected T documentRepository;

    public FileEntry addFileEntry(String externalReferenceCode, long userId, long folderId, String sourceFileName, String mimeType, String title, String urlTitle, String description, String changeLog, File file, Date expirationDate, Date reviewDate, ServiceContext serviceContext) throws PortalException {
        this.checkDocumentRepository();
        return this.documentRepository.addFileEntry(externalReferenceCode, userId, folderId, sourceFileName, mimeType, title, urlTitle, description, changeLog, file, expirationDate, reviewDate, serviceContext);
    }

    public FileEntry addFileEntry(String externalReferenceCode, long userId, long folderId, String sourceFileName, String mimeType, String title, String urlTitle, String description, String changeLog, InputStream inputStream, long size, Date expirationDate, Date reviewDate, ServiceContext serviceContext) throws PortalException {
        this.checkDocumentRepository();
        return this.documentRepository.addFileEntry(externalReferenceCode, userId, folderId, sourceFileName, mimeType, title, urlTitle, description, changeLog, inputStream, size, expirationDate, reviewDate, serviceContext);
    }

    public FileShortcut addFileShortcut(long userId, long folderId, long toFileEntryId, ServiceContext serviceContext) throws PortalException {
        this.checkDocumentRepository();
        return this.documentRepository.addFileShortcut(userId, folderId, toFileEntryId, serviceContext);
    }

    public Folder addFolder(String externalReferenceCode, long userId, long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException {
        this.checkDocumentRepository();
        return this.documentRepository.addFolder(externalReferenceCode, userId, parentFolderId, name, description, serviceContext);
    }

    public void checkInFileEntry(long userId, long fileEntryId, DLVersionNumberIncrease dlVersionNumberIncrease, String changeLog, ServiceContext serviceContext) throws PortalException {
        this.checkDocumentRepository();
        this.documentRepository.checkInFileEntry(userId, fileEntryId, dlVersionNumberIncrease, changeLog, serviceContext);
    }

    public void checkInFileEntry(long userId, long fileEntryId, String lockUuid, ServiceContext serviceContext) throws PortalException {
        this.checkDocumentRepository();
        this.documentRepository.checkInFileEntry(userId, fileEntryId, lockUuid, serviceContext);
    }

    public FileEntry copyFileEntry(long userId, long groupId, long fileEntryId, long destFolderId, ServiceContext serviceContext) throws PortalException {
        this.checkDocumentRepository();
        return this.documentRepository.copyFileEntry(userId, groupId, fileEntryId, destFolderId, serviceContext);
    }

    public void deleteAll() throws PortalException {
        this.checkDocumentRepository();
        this.documentRepository.deleteAll();
    }

    public void deleteFileEntry(long fileEntryId) throws PortalException {
        this.checkDocumentRepository();
        this.documentRepository.deleteFileEntry(fileEntryId);
    }

    public void deleteFileShortcut(long fileShortcutId) throws PortalException {
        this.checkDocumentRepository();
        this.documentRepository.deleteFileShortcut(fileShortcutId);
    }

    public void deleteFileShortcuts(long toFileEntryId) throws PortalException {
        this.checkDocumentRepository();
        this.documentRepository.deleteFileShortcuts(toFileEntryId);
    }

    public void deleteFileVersion(long fileVersionId) throws PortalException {
        this.checkDocumentRepository();
        this.documentRepository.deleteFileVersion(fileVersionId);
    }

    public void deleteFolder(long folderId) throws PortalException {
        this.checkDocumentRepository();
        this.documentRepository.deleteFolder(folderId);
    }

    public FileEntry fetchFileEntry(long folderId, String title) throws PortalException {
        this.checkDocumentRepository();
        return this.documentRepository.fetchFileEntry(folderId, title);
    }

    public <C extends Capability> C getCapability(Class<C> capabilityClass) {
        this.checkDocumentRepository();
        return (C)this.documentRepository.getCapability(capabilityClass);
    }

    public List<FileEntry> getFileEntries(long folderId, int status, int start, int end, OrderByComparator<FileEntry> orderByComparator) throws PortalException {
        this.checkDocumentRepository();
        return this.documentRepository.getFileEntries(folderId, status, start, end, orderByComparator);
    }

    public List<FileEntry> getFileEntries(long folderId, int start, int end, OrderByComparator<FileEntry> orderByComparator) throws PortalException {
        this.checkDocumentRepository();
        return this.documentRepository.getFileEntries(folderId, start, end, orderByComparator);
    }

    public List<RepositoryEntry> getFileEntriesAndFileShortcuts(long folderId, int status, int start, int end) throws PortalException {
        return this.documentRepository.getFileEntriesAndFileShortcuts(folderId, status, start, end);
    }

    public int getFileEntriesAndFileShortcutsCount(long folderId, int status) throws PortalException {
        return this.documentRepository.getFileEntriesAndFileShortcutsCount(folderId, status);
    }

    public int getFileEntriesCount(long folderId) throws PortalException {
        this.checkDocumentRepository();
        return this.documentRepository.getFileEntriesCount(folderId);
    }

    public int getFileEntriesCount(long folderId, int status) throws PortalException {
        this.checkDocumentRepository();
        return this.documentRepository.getFileEntriesCount(folderId, status);
    }

    public FileEntry getFileEntry(long fileEntryId) throws PortalException {
        this.checkDocumentRepository();
        return this.documentRepository.getFileEntry(fileEntryId);
    }

    public FileEntry getFileEntry(long folderId, String title) throws PortalException {
        this.checkDocumentRepository();
        return this.documentRepository.getFileEntry(folderId, title);
    }

    public FileEntry getFileEntryByFileName(long folderId, String fileName) throws PortalException {
        this.checkDocumentRepository();
        return this.documentRepository.getFileEntryByFileName(folderId, fileName);
    }

    public FileEntry getFileEntryByUuid(String uuid) throws PortalException {
        this.checkDocumentRepository();
        return this.documentRepository.getFileEntryByUuid(uuid);
    }

    public FileShortcut getFileShortcut(long fileShortcutId) throws PortalException {
        this.checkDocumentRepository();
        return this.documentRepository.getFileShortcut(fileShortcutId);
    }

    public FileVersion getFileVersion(long fileVersionId) throws PortalException {
        this.checkDocumentRepository();
        return this.documentRepository.getFileVersion(fileVersionId);
    }

    public Folder getFolder(long folderId) throws PortalException {
        this.checkDocumentRepository();
        return this.documentRepository.getFolder(folderId);
    }

    public Folder getFolder(long parentFolderId, String name) throws PortalException {
        this.checkDocumentRepository();
        return this.documentRepository.getFolder(parentFolderId, name);
    }

    public List<Folder> getFolders(long parentFolderId, boolean includeMountFolders, int start, int end, OrderByComparator<Folder> orderByComparator) throws PortalException {
        return this.documentRepository.getFolders(parentFolderId, includeMountFolders, start, end, orderByComparator);
    }

    public List<Folder> getFolders(long parentFolderId, int status, boolean includeMountFolders, int start, int end, OrderByComparator<Folder> orderByComparator) throws PortalException {
        return this.documentRepository.getFolders(parentFolderId, status, includeMountFolders, start, end, orderByComparator);
    }

    public List<RepositoryEntry> getFoldersAndFileEntriesAndFileShortcuts(long folderId, int status, boolean includeMountFolders, int start, int end, OrderByComparator<?> orderByComparator) throws PortalException {
        this.checkDocumentRepository();
        return this.documentRepository.getFoldersAndFileEntriesAndFileShortcuts(folderId, status, includeMountFolders, start, end, orderByComparator);
    }

    public int getFoldersAndFileEntriesAndFileShortcutsCount(long folderId, int status, boolean includeMountFolders) throws PortalException {
        this.checkDocumentRepository();
        return this.documentRepository.getFoldersAndFileEntriesAndFileShortcutsCount(folderId, status, includeMountFolders);
    }

    public int getFoldersCount(long parentFolderId, boolean includeMountfolders) throws PortalException {
        return this.documentRepository.getFoldersCount(parentFolderId, includeMountfolders);
    }

    public int getFoldersCount(long parentFolderId, int status, boolean includeMountfolders) throws PortalException {
        return this.documentRepository.getFoldersCount(parentFolderId, status, includeMountfolders);
    }

    public List<FileEntry> getRepositoryFileEntries(long userId, long rootFolderId, int start, int end, OrderByComparator<FileEntry> orderByComparator) throws PortalException {
        this.checkDocumentRepository();
        return this.documentRepository.getRepositoryFileEntries(userId, rootFolderId, start, end, orderByComparator);
    }

    public long getRepositoryId() {
        this.checkDocumentRepository();
        return this.documentRepository.getRepositoryId();
    }

    public <C extends Capability> boolean isCapabilityProvided(Class<C> capabilityClass) {
        this.checkDocumentRepository();
        return this.documentRepository.isCapabilityProvided(capabilityClass);
    }

    public FileEntry moveFileEntry(long userId, long fileEntryId, long newFolderId, ServiceContext serviceContext) throws PortalException {
        this.checkDocumentRepository();
        return this.documentRepository.moveFileEntry(userId, fileEntryId, newFolderId, serviceContext);
    }

    public Folder moveFolder(long userId, long folderId, long parentFolderId, ServiceContext serviceContext) throws PortalException {
        this.checkDocumentRepository();
        return this.documentRepository.moveFolder(userId, folderId, parentFolderId, serviceContext);
    }

    public void revertFileEntry(long userId, long fileEntryId, String version, ServiceContext serviceContext) throws PortalException {
        this.checkDocumentRepository();
        this.documentRepository.revertFileEntry(userId, fileEntryId, version, serviceContext);
    }

    public void setDocumentRepository(T documentRepository) {
        if (this.documentRepository != null) {
            throw new IllegalStateException("Unable to initialize an initialized document repository");
        }
        this.documentRepository = documentRepository;
    }

    public FileEntry updateFileEntry(long userId, long fileEntryId, String sourceFileName, String mimeType, String title, String urlTitle, String description, String changeLog, DLVersionNumberIncrease dlVersionNumberIncrease, File file, Date expirationDate, Date reviewDate, ServiceContext serviceContext) throws PortalException {
        this.checkDocumentRepository();
        return this.documentRepository.updateFileEntry(userId, fileEntryId, sourceFileName, mimeType, title, urlTitle, description, changeLog, dlVersionNumberIncrease, file, expirationDate, reviewDate, serviceContext);
    }

    public FileEntry updateFileEntry(long userId, long fileEntryId, String sourceFileName, String mimeType, String title, String urlTitle, String description, String changeLog, DLVersionNumberIncrease dlVersionNumberIncrease, InputStream inputStream, long size, Date expirationDate, Date reviewDate, ServiceContext serviceContext) throws PortalException {
        this.checkDocumentRepository();
        return this.documentRepository.updateFileEntry(userId, fileEntryId, sourceFileName, mimeType, title, urlTitle, description, changeLog, dlVersionNumberIncrease, inputStream, size, expirationDate, reviewDate, serviceContext);
    }

    public FileShortcut updateFileShortcut(long userId, long fileShortcutId, long folderId, long toFileEntryId, ServiceContext serviceContext) throws PortalException {
        this.checkDocumentRepository();
        return this.documentRepository.updateFileShortcut(userId, fileShortcutId, folderId, toFileEntryId, serviceContext);
    }

    public void updateFileShortcuts(long oldToFileEntryId, long newToFileEntryId) throws PortalException {
        this.checkDocumentRepository();
        this.documentRepository.updateFileShortcuts(oldToFileEntryId, newToFileEntryId);
    }

    public Folder updateFolder(long folderId, long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException {
        this.checkDocumentRepository();
        return this.documentRepository.updateFolder(folderId, parentFolderId, name, description, serviceContext);
    }

    protected void checkDocumentRepository() {
        if (this.documentRepository == null) {
            throw new IllegalStateException("Document repositry is not initialized");
        }
    }
}

