/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth;

import com.liferay.petra.string.StringBundler;
import com.liferay.petra.url.pattern.mapper.URLPatternMapper;
import com.liferay.petra.url.pattern.mapper.URLPatternMapperFactory;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.security.auth.AccessControlContext;
import com.liferay.portal.kernel.security.auth.verifier.AuthVerifier;
import com.liferay.portal.kernel.security.auth.verifier.AuthVerifierConfiguration;
import com.liferay.portal.kernel.security.auth.verifier.AuthVerifierResult;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.security.auth.registry.AuthVerifierRegistry;
import com.liferay.portal.spring.context.PortalContextLoaderListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Consumer;
import javax.servlet.http.HttpServletRequest;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class AuthVerifierPipeline {
    public static final String AUTH_TYPE = "auth.type";
    private static final Log _log = LogFactoryUtil.getLog(AuthVerifierPipeline.class);
    private final List<AuthVerifierConfiguration> _authVerifierConfigurations;
    private final String _contextPath;
    private volatile URLPatternMapper<List<AuthVerifierConfiguration>> _excludeURLPatternMapper;
    private volatile URLPatternMapper<List<AuthVerifierConfiguration>> _includeURLPatternMapper;

    public static String getAuthVerifierPropertyName(String className) {
        String simpleClassName = StringUtil.extractLast((String)className, (String)".");
        return StringBundler.concat((String[])new String[]{"auth.verifier.", simpleClassName, "."});
    }

    public static AuthVerifierPipeline getPortalAuthVerifierPipeline() {
        return PortalAuthVerifierPipelineHolder._PORTAL_AUTH_VERIFIER_PIPELINE;
    }

    public AuthVerifierPipeline(List<AuthVerifierConfiguration> authVerifierConfigurations, String contextPath) {
        this._authVerifierConfigurations = new ArrayList<AuthVerifierConfiguration>(authVerifierConfigurations);
        this._contextPath = contextPath;
        this._buildURLPatternMapper();
    }

    public AuthVerifierResult verifyRequest(AccessControlContext accessControlContext) throws PortalException {
        if (accessControlContext == null) {
            throw new IllegalArgumentException("Access control context is null");
        }
        HttpServletRequest httpServletRequest = accessControlContext.getRequest();
        String requestURI = httpServletRequest.getRequestURI();
        AuthVerifierConfigurationConsumer authVerifierConfigurationConsumer = new AuthVerifierConfigurationConsumer(accessControlContext, this._excludeURLPatternMapper, requestURI);
        this._includeURLPatternMapper.consumeValues((Consumer)authVerifierConfigurationConsumer, requestURI);
        if (authVerifierConfigurationConsumer.getAuthVerifierResult() != null) {
            return authVerifierConfigurationConsumer.getAuthVerifierResult();
        }
        return this._createGuestVerificationResult(accessControlContext);
    }

    private synchronized void _addAuthVerifierConfiguration(AuthVerifierConfiguration authVerifierConfiguration) {
        this._authVerifierConfigurations.add(authVerifierConfiguration);
        this._buildURLPatternMapper();
    }

    private void _buildURLPatternMapper() {
        HashMap<String, List> excludeAuthVerifierConfigurationsMap = new HashMap<String, List>();
        HashMap<String, List> includeAuthVerifierConfigurationsMap = new HashMap<String, List>();
        for (AuthVerifierConfiguration authVerifierConfiguration : this._authVerifierConfigurations) {
            String[] urlsIncludes;
            String[] urlsExcludes;
            Properties properties = authVerifierConfiguration.getProperties();
            for (String urlsExclude : urlsExcludes = StringUtil.split((String)properties.getProperty("urls.excludes"))) {
                urlsExclude = this._contextPath + this._fixLegacyURLPattern(urlsExclude);
                List excludeAuthVerifierConfigurations = excludeAuthVerifierConfigurationsMap.computeIfAbsent(urlsExclude, key -> new ArrayList());
                excludeAuthVerifierConfigurations.add(authVerifierConfiguration);
            }
            for (String urlsInclude : urlsIncludes = StringUtil.split((String)properties.getProperty("urls.includes"))) {
                urlsInclude = this._contextPath + this._fixLegacyURLPattern(urlsInclude);
                List includeAuthVerifierConfigurations = includeAuthVerifierConfigurationsMap.computeIfAbsent(urlsInclude, key -> new ArrayList());
                includeAuthVerifierConfigurations.add(authVerifierConfiguration);
            }
        }
        this._excludeURLPatternMapper = URLPatternMapperFactory.create(excludeAuthVerifierConfigurationsMap);
        this._includeURLPatternMapper = URLPatternMapperFactory.create(includeAuthVerifierConfigurationsMap);
    }

    private AuthVerifierResult _createGuestVerificationResult(AccessControlContext accessControlContext) throws PortalException {
        AuthVerifierResult authVerifierResult = new AuthVerifierResult();
        authVerifierResult.setState(AuthVerifierResult.State.UNSUCCESSFUL);
        HttpServletRequest httpServletRequest = accessControlContext.getRequest();
        authVerifierResult.setUserId(UserLocalServiceUtil.getGuestUserId((long)PortalUtil.getCompanyId((HttpServletRequest)httpServletRequest)));
        return authVerifierResult;
    }

    private String _fixLegacyURLPattern(String urlPattern) {
        if (urlPattern == null || urlPattern.length() == 0 || urlPattern.charAt(urlPattern.length() - 1) != '*') {
            return urlPattern;
        }
        if (urlPattern.length() > 1 && urlPattern.charAt(urlPattern.length() - 2) == '/') {
            return urlPattern;
        }
        return urlPattern.substring(0, urlPattern.length() - 1) + "/*";
    }

    private synchronized void _removeAuthVerifierConfiguration(AuthVerifierConfiguration authVerifierConfiguration) {
        this._authVerifierConfigurations.remove(authVerifierConfiguration);
        this._buildURLPatternMapper();
    }

    private static class PortalAuthVerifierPipelineHolder {
        private static final AuthVerifierPipeline _PORTAL_AUTH_VERIFIER_PIPELINE;

        private PortalAuthVerifierPipelineHolder() {
        }

        static {
            final AuthVerifierPipeline portalAuthVerifierPipeline = new AuthVerifierPipeline(Collections.emptyList(), PortalContextLoaderListener.getPortalServletContextPath());
            final BundleContext bundleContext = SystemBundleUtil.getBundleContext();
            ServiceTracker serviceTracker = new ServiceTracker(bundleContext, AuthVerifierConfiguration.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<AuthVerifierConfiguration, AuthVerifierConfiguration>(){

                public AuthVerifierConfiguration addingService(ServiceReference<AuthVerifierConfiguration> serviceReference) {
                    AuthVerifierConfiguration authVerifierConfiguration = (AuthVerifierConfiguration)bundleContext.getService(serviceReference);
                    if (authVerifierConfiguration != null) {
                        portalAuthVerifierPipeline._addAuthVerifierConfiguration(authVerifierConfiguration);
                    }
                    return authVerifierConfiguration;
                }

                public void modifiedService(ServiceReference<AuthVerifierConfiguration> serviceReference, AuthVerifierConfiguration authVerifierConfiguration) {
                }

                public void removedService(ServiceReference<AuthVerifierConfiguration> serviceReference, AuthVerifierConfiguration authVerifierConfiguration) {
                    portalAuthVerifierPipeline._removeAuthVerifierConfiguration(authVerifierConfiguration);
                    bundleContext.ungetService(serviceReference);
                }
            });
            serviceTracker.open();
            _PORTAL_AUTH_VERIFIER_PIPELINE = portalAuthVerifierPipeline;
        }
    }

    private static class AuthVerifierConfigurationConsumer
    implements Consumer<List<AuthVerifierConfiguration>> {
        private final AccessControlContext _accessControlContext;
        private AuthVerifierResult _authVerifierResult;
        private Set<AuthVerifierConfiguration> _excludedAuthVerifierConfigurations;
        private final URLPatternMapper<List<AuthVerifierConfiguration>> _excludeURLPatternMapper;
        private final String _requestURI;

        @Override
        public void accept(List<AuthVerifierConfiguration> authVerifierConfigurations) {
            if (this._authVerifierResult != null) {
                return;
            }
            if (this._excludedAuthVerifierConfigurations == null) {
                this._excludedAuthVerifierConfigurations = new HashSet<AuthVerifierConfiguration>();
                this._excludeURLPatternMapper.consumeValues(this._excludedAuthVerifierConfigurations::addAll, this._requestURI);
            }
            for (AuthVerifierConfiguration authVerifierConfiguration : authVerifierConfigurations) {
                if (this._excludedAuthVerifierConfigurations.contains(authVerifierConfiguration)) continue;
                this._authVerifierResult = this._verifyWithAuthVerifierConfiguration(this._accessControlContext, authVerifierConfiguration);
                if (this._authVerifierResult == null) continue;
                return;
            }
        }

        public AuthVerifierResult getAuthVerifierResult() {
            return this._authVerifierResult;
        }

        private AuthVerifierConfigurationConsumer(AccessControlContext accessControlContext, URLPatternMapper<List<AuthVerifierConfiguration>> excludeURLPatternMapper, String requestURI) {
            this._accessControlContext = accessControlContext;
            this._excludeURLPatternMapper = excludeURLPatternMapper;
            this._requestURI = requestURI;
        }

        private Map<String, Object> _mergeSettings(Properties properties, Map<String, Object> settings) {
            HashMap<String, Object> mergedSettings = new HashMap<String, Object>(settings);
            if (properties != null) {
                for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                    mergedSettings.put((String)entry.getKey(), entry.getValue());
                }
            }
            return mergedSettings;
        }

        private AuthVerifierResult _verifyWithAuthVerifierConfiguration(AccessControlContext accessControlContext, AuthVerifierConfiguration authVerifierConfiguration) {
            AuthVerifierResult authVerifierResult = null;
            AuthVerifier authVerifier = AuthVerifierRegistry.getAuthVerifier(authVerifierConfiguration.getAuthVerifierClassName());
            if (authVerifier == null) {
                return authVerifierResult;
            }
            Properties properties = authVerifierConfiguration.getProperties();
            try {
                authVerifierResult = authVerifier.verify(accessControlContext, properties);
            }
            catch (Exception exception) {
                if (_log.isDebugEnabled()) {
                    Class<?> authVerifierClass = authVerifier.getClass();
                    _log.debug((Object)("Skipping " + authVerifierClass.getName()), (Throwable)exception);
                }
                return null;
            }
            if (authVerifierResult == null) {
                Class<?> authVerifierClass = authVerifier.getClass();
                _log.error((Object)("Auth verifier " + authVerifierClass.getName() + " did not return an auth verifier result"));
                return null;
            }
            if (authVerifierResult.getState() == AuthVerifierResult.State.NOT_APPLICABLE) {
                return null;
            }
            User user = UserLocalServiceUtil.fetchUser((long)authVerifierResult.getUserId());
            if (user != null && !user.isActive()) {
                if (_log.isDebugEnabled()) {
                    Class<?> authVerifierClass = authVerifier.getClass();
                    _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Auth verifier ", authVerifierClass.getName(), " returned inactive user", authVerifierResult.getUserId()}));
                }
                authVerifierResult.setState(AuthVerifierResult.State.UNSUCCESSFUL);
            }
            Map<String, Object> settings = this._mergeSettings(properties, authVerifierResult.getSettings());
            settings.put(AuthVerifierPipeline.AUTH_TYPE, authVerifier.getAuthType());
            authVerifierResult.setSettings(settings);
            return authVerifierResult;
        }
    }
}

