/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.base;

import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.exportimport.kernel.lar.ExportImportHelperUtil;
import com.liferay.exportimport.kernel.lar.ManifestSummary;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.ParamSetter;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdate;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdateFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DefaultActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Country;
import com.liferay.portal.kernel.model.CountryLocalization;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.BaseLocalService;
import com.liferay.portal.kernel.service.BaseLocalServiceImpl;
import com.liferay.portal.kernel.service.CountryLocalService;
import com.liferay.portal.kernel.service.CountryLocalServiceUtil;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.service.persistence.CountryLocalizationPersistence;
import com.liferay.portal.kernel.service.persistence.CountryPersistence;
import com.liferay.portal.kernel.service.persistence.change.tracking.CTPersistence;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;

public abstract class CountryLocalServiceBaseImpl
extends BaseLocalServiceImpl
implements CountryLocalService,
IdentifiableOSGiService {
    @BeanReference(type=CountryLocalService.class)
    protected CountryLocalService countryLocalService;
    @BeanReference(type=CountryPersistence.class)
    protected CountryPersistence countryPersistence;
    @BeanReference(type=CounterLocalService.class)
    protected CounterLocalService counterLocalService;
    @BeanReference(type=CountryLocalizationPersistence.class)
    protected CountryLocalizationPersistence countryLocalizationPersistence;
    private static final Log _log = LogFactoryUtil.getLog(CountryLocalServiceBaseImpl.class);

    @Indexable(type=IndexableType.REINDEX)
    public Country addCountry(Country country) {
        country.setNew(true);
        return (Country)this.countryPersistence.update((BaseModel)country);
    }

    @Transactional(enabled=false)
    public Country createCountry(long countryId) {
        return this.countryPersistence.create(countryId);
    }

    @Indexable(type=IndexableType.DELETE)
    public Country deleteCountry(long countryId) throws PortalException {
        return this.countryPersistence.remove(countryId);
    }

    @Indexable(type=IndexableType.DELETE)
    public Country deleteCountry(Country country) throws PortalException {
        return (Country)this.countryPersistence.remove((BaseModel)country);
    }

    public <T> T dslQuery(DSLQuery dslQuery) {
        return (T)this.countryPersistence.dslQuery(dslQuery);
    }

    public int dslQueryCount(DSLQuery dslQuery) {
        Long count = (Long)this.dslQuery(dslQuery);
        return count.intValue();
    }

    public DynamicQuery dynamicQuery() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        return DynamicQueryFactoryUtil.forClass(Country.class, (ClassLoader)clazz.getClassLoader());
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery) {
        return this.countryPersistence.findWithDynamicQuery(dynamicQuery);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end) {
        return this.countryPersistence.findWithDynamicQuery(dynamicQuery, start, end);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end, OrderByComparator<T> orderByComparator) {
        return this.countryPersistence.findWithDynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery) {
        return this.countryPersistence.countWithDynamicQuery(dynamicQuery);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery, Projection projection) {
        return this.countryPersistence.countWithDynamicQuery(dynamicQuery, projection);
    }

    public Country fetchCountry(long countryId) {
        return this.countryPersistence.fetchByPrimaryKey(countryId);
    }

    public Country fetchCountryByUuidAndCompanyId(String uuid, long companyId) {
        return this.countryPersistence.fetchByUuid_C_First(uuid, companyId, null);
    }

    public Country getCountry(long countryId) throws PortalException {
        return this.countryPersistence.findByPrimaryKey(countryId);
    }

    public ActionableDynamicQuery getActionableDynamicQuery() {
        DefaultActionableDynamicQuery actionableDynamicQuery = new DefaultActionableDynamicQuery();
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.countryLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(Country.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("countryId");
        return actionableDynamicQuery;
    }

    public IndexableActionableDynamicQuery getIndexableActionableDynamicQuery() {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = new IndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setBaseLocalService((BaseLocalService)this.countryLocalService);
        indexableActionableDynamicQuery.setClassLoader(this.getClassLoader());
        indexableActionableDynamicQuery.setModelClass(Country.class);
        indexableActionableDynamicQuery.setPrimaryKeyPropertyName("countryId");
        return indexableActionableDynamicQuery;
    }

    protected void initActionableDynamicQuery(ActionableDynamicQuery actionableDynamicQuery) {
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.countryLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(Country.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("countryId");
    }

    public ExportActionableDynamicQuery getExportActionableDynamicQuery(final PortletDataContext portletDataContext) {
        ExportActionableDynamicQuery exportActionableDynamicQuery = new ExportActionableDynamicQuery(){

            public long performCount() throws PortalException {
                ManifestSummary manifestSummary = portletDataContext.getManifestSummary();
                StagedModelType stagedModelType = this.getStagedModelType();
                long modelAdditionCount = super.performCount();
                manifestSummary.addModelAdditionCount(stagedModelType, modelAdditionCount);
                long modelDeletionCount = ExportImportHelperUtil.getModelDeletionCount((PortletDataContext)portletDataContext, (StagedModelType)stagedModelType);
                manifestSummary.addModelDeletionCount(stagedModelType, modelDeletionCount);
                return modelAdditionCount;
            }
        };
        this.initActionableDynamicQuery((ActionableDynamicQuery)exportActionableDynamicQuery);
        exportActionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                portletDataContext.addDateRangeCriteria(dynamicQuery, "modifiedDate");
            }
        });
        exportActionableDynamicQuery.setCompanyId(portletDataContext.getCompanyId());
        exportActionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<Country>(){

            public void performAction(Country country) throws PortalException {
                StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)country);
            }
        });
        exportActionableDynamicQuery.setStagedModelType(new StagedModelType(PortalUtil.getClassNameId((String)Country.class.getName())));
        return exportActionableDynamicQuery;
    }

    public PersistedModel createPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return this.countryPersistence.create(((Long)primaryKeyObj).longValue());
    }

    public PersistedModel deletePersistedModel(PersistedModel persistedModel) throws PortalException {
        if (_log.isWarnEnabled()) {
            _log.warn((Object)"Implement CountryLocalServiceImpl#deleteCountry(Country) to avoid orphaned data");
        }
        return this.countryLocalService.deleteCountry((Country)persistedModel);
    }

    public BasePersistence<Country> getBasePersistence() {
        return this.countryPersistence;
    }

    public PersistedModel getPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return (PersistedModel)this.countryPersistence.findByPrimaryKey(primaryKeyObj);
    }

    public Country getCountryByUuidAndCompanyId(String uuid, long companyId) throws PortalException {
        return this.countryPersistence.findByUuid_C_First(uuid, companyId, null);
    }

    public List<Country> getCountries(int start, int end) {
        return this.countryPersistence.findAll(start, end);
    }

    public int getCountriesCount() {
        return this.countryPersistence.countAll();
    }

    @Indexable(type=IndexableType.REINDEX)
    public Country updateCountry(Country country) {
        return (Country)this.countryPersistence.update((BaseModel)country);
    }

    public CountryLocalization fetchCountryLocalization(long countryId, String languageId) {
        return this.countryLocalizationPersistence.fetchByCountryId_LanguageId(countryId, languageId);
    }

    public CountryLocalization getCountryLocalization(long countryId, String languageId) throws PortalException {
        return this.countryLocalizationPersistence.findByCountryId_LanguageId(countryId, languageId);
    }

    public List<CountryLocalization> getCountryLocalizations(long countryId) {
        return this.countryLocalizationPersistence.findByCountryId(countryId);
    }

    public CountryLocalization updateCountryLocalization(Country country, String languageId, String title) throws PortalException {
        country = this.countryPersistence.findByPrimaryKey(country.getPrimaryKey());
        CountryLocalization countryLocalization = this.countryLocalizationPersistence.fetchByCountryId_LanguageId(country.getCountryId(), languageId);
        return this._updateCountryLocalization(country, countryLocalization, languageId, title);
    }

    public List<CountryLocalization> updateCountryLocalizations(Country country, Map<String, String> titleMap) throws PortalException {
        String[] localizedValues;
        country = this.countryPersistence.findByPrimaryKey(country.getPrimaryKey());
        HashMap<String, String[]> localizedValuesMap = new HashMap<String, String[]>();
        for (Map.Entry<String, String> entry : titleMap.entrySet()) {
            String languageId = entry.getKey();
            localizedValues = (String[])localizedValuesMap.get(languageId);
            if (localizedValues == null) {
                localizedValues = new String[1];
                localizedValuesMap.put(languageId, localizedValues);
            }
            localizedValues[0] = (String)entry.getValue();
        }
        ArrayList<CountryLocalization> countryLocalizations = new ArrayList<CountryLocalization>(localizedValuesMap.size());
        for (CountryLocalization countryLocalization : this.countryLocalizationPersistence.findByCountryId(country.getCountryId())) {
            localizedValues = (String[])localizedValuesMap.remove(countryLocalization.getLanguageId());
            if (localizedValues == null) {
                this.countryLocalizationPersistence.remove((BaseModel)countryLocalization);
                continue;
            }
            countryLocalization.setCtCollectionId(country.getCtCollectionId());
            countryLocalization.setCompanyId(country.getCompanyId());
            countryLocalization.setTitle(localizedValues[0]);
            countryLocalizations.add((CountryLocalization)this.countryLocalizationPersistence.update((BaseModel)countryLocalization));
        }
        long batchCounter = this.counterLocalService.increment(CountryLocalization.class.getName(), localizedValuesMap.size()) - (long)localizedValuesMap.size();
        for (Map.Entry entry : localizedValuesMap.entrySet()) {
            String languageId = (String)entry.getKey();
            String[] localizedValues2 = (String[])entry.getValue();
            CountryLocalization countryLocalization = this.countryLocalizationPersistence.create(++batchCounter);
            countryLocalization.setCtCollectionId(country.getCtCollectionId());
            countryLocalization.setCountryId(country.getCountryId());
            countryLocalization.setCompanyId(country.getCompanyId());
            countryLocalization.setLanguageId(languageId);
            countryLocalization.setTitle(localizedValues2[0]);
            countryLocalizations.add((CountryLocalization)this.countryLocalizationPersistence.update((BaseModel)countryLocalization));
        }
        return countryLocalizations;
    }

    private CountryLocalization _updateCountryLocalization(Country country, CountryLocalization countryLocalization, String languageId, String title) throws PortalException {
        if (countryLocalization == null) {
            long countryLocalizationId = this.counterLocalService.increment(CountryLocalization.class.getName());
            countryLocalization = this.countryLocalizationPersistence.create(countryLocalizationId);
            countryLocalization.setCountryId(country.getCountryId());
            countryLocalization.setLanguageId(languageId);
        }
        countryLocalization.setCtCollectionId(country.getCtCollectionId());
        countryLocalization.setCompanyId(country.getCompanyId());
        countryLocalization.setTitle(title);
        return (CountryLocalization)this.countryLocalizationPersistence.update((BaseModel)countryLocalization);
    }

    public CountryLocalService getCountryLocalService() {
        return this.countryLocalService;
    }

    public void setCountryLocalService(CountryLocalService countryLocalService) {
        this.countryLocalService = countryLocalService;
    }

    public CountryPersistence getCountryPersistence() {
        return this.countryPersistence;
    }

    public void setCountryPersistence(CountryPersistence countryPersistence) {
        this.countryPersistence = countryPersistence;
    }

    public CounterLocalService getCounterLocalService() {
        return this.counterLocalService;
    }

    public void setCounterLocalService(CounterLocalService counterLocalService) {
        this.counterLocalService = counterLocalService;
    }

    public CountryLocalizationPersistence getCountryLocalizationPersistence() {
        return this.countryLocalizationPersistence;
    }

    public void setCountryLocalizationPersistence(CountryLocalizationPersistence countryLocalizationPersistence) {
        this.countryLocalizationPersistence = countryLocalizationPersistence;
    }

    public void afterPropertiesSet() {
        CountryLocalServiceUtil.setService((CountryLocalService)this.countryLocalService);
    }

    public void destroy() {
        CountryLocalServiceUtil.setService(null);
    }

    public String getOSGiServiceIdentifier() {
        return CountryLocalService.class.getName();
    }

    public CTPersistence<Country> getCTPersistence() {
        return this.countryPersistence;
    }

    public Class<Country> getModelClass() {
        return Country.class;
    }

    public <R, E extends Throwable> R updateWithUnsafeFunction(UnsafeFunction<CTPersistence<Country>, R, E> updateUnsafeFunction) throws E {
        return (R)updateUnsafeFunction.apply((Object)this.countryPersistence);
    }

    protected String getModelClassName() {
        return Country.class.getName();
    }

    protected void runSQL(String sql) {
        try {
            DataSource dataSource = this.countryPersistence.getDataSource();
            DB db = DBManagerUtil.getDB();
            sql = db.buildSQL(sql);
            sql = PortalUtil.transformSQL((String)sql);
            SqlUpdate sqlUpdate = SqlUpdateFactoryUtil.getSqlUpdate((DataSource)dataSource, (String)sql, (ParamSetter[])new ParamSetter[0]);
            sqlUpdate.update(new Object[0]);
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }
}

