/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Address;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.service.base.AddressServiceBaseImpl;
import com.liferay.portal.service.permission.CommonPermissionUtil;
import java.util.List;

public class AddressServiceImpl
extends AddressServiceBaseImpl {
    public Address addAddress(String className, long classPK, String street1, String street2, String street3, String city, String zip, long regionId, long countryId, long listTypeId, boolean mailing, boolean primary, ServiceContext serviceContext) throws PortalException {
        CommonPermissionUtil.check(this.getPermissionChecker(), className, classPK, "UPDATE");
        return this.addressLocalService.addAddress(null, this.getUserId(), className, classPK, null, null, street1, street2, street3, city, zip, regionId, countryId, listTypeId, mailing, primary, null, serviceContext);
    }

    public void deleteAddress(long addressId) throws PortalException {
        Address address = this.addressPersistence.findByPrimaryKey(addressId);
        CommonPermissionUtil.check(this.getPermissionChecker(), address.getClassNameId(), address.getClassPK(), "UPDATE");
        this.addressLocalService.deleteAddress(address);
    }

    public Address getAddress(long addressId) throws PortalException {
        Address address = this.addressPersistence.findByPrimaryKey(addressId);
        CommonPermissionUtil.check(this.getPermissionChecker(), address.getClassNameId(), address.getClassPK(), "VIEW");
        return address;
    }

    public List<Address> getAddresses(String className, long classPK) throws PortalException {
        CommonPermissionUtil.check(this.getPermissionChecker(), className, classPK, "VIEW");
        User user = this.getUser();
        return this.addressLocalService.getAddresses(user.getCompanyId(), className, classPK);
    }

    public Address updateAddress(long addressId, String street1, String street2, String street3, String city, String zip, long regionId, long countryId, long listTypeId, boolean mailing, boolean primary) throws PortalException {
        Address address = this.addressPersistence.findByPrimaryKey(addressId);
        CommonPermissionUtil.check(this.getPermissionChecker(), address.getClassNameId(), address.getClassPK(), "UPDATE");
        return this.addressLocalService.updateAddress(addressId, street1, street2, street3, city, zip, regionId, countryId, listTypeId, mailing, primary);
    }
}

