/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.EmailAddress;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.service.base.EmailAddressServiceBaseImpl;
import com.liferay.portal.service.permission.CommonPermissionUtil;
import java.util.List;

public class EmailAddressServiceImpl
extends EmailAddressServiceBaseImpl {
    public EmailAddress addEmailAddress(String className, long classPK, String address, long typeId, boolean primary, ServiceContext serviceContext) throws PortalException {
        CommonPermissionUtil.check(this.getPermissionChecker(), className, classPK, "UPDATE");
        return this.emailAddressLocalService.addEmailAddress(this.getUserId(), className, classPK, address, typeId, primary, serviceContext);
    }

    public void deleteEmailAddress(long emailAddressId) throws PortalException {
        EmailAddress emailAddress = this.emailAddressPersistence.findByPrimaryKey(emailAddressId);
        CommonPermissionUtil.check(this.getPermissionChecker(), emailAddress.getClassNameId(), emailAddress.getClassPK(), "UPDATE");
        this.emailAddressLocalService.deleteEmailAddress(emailAddress);
    }

    public EmailAddress fetchEmailAddress(long emailAddressId) throws PortalException {
        EmailAddress emailAddress = this.emailAddressPersistence.fetchByPrimaryKey(emailAddressId);
        if (emailAddress != null) {
            CommonPermissionUtil.check(this.getPermissionChecker(), emailAddress.getClassNameId(), emailAddress.getClassPK(), "VIEW");
        }
        return emailAddress;
    }

    public EmailAddress getEmailAddress(long emailAddressId) throws PortalException {
        EmailAddress emailAddress = this.emailAddressPersistence.findByPrimaryKey(emailAddressId);
        CommonPermissionUtil.check(this.getPermissionChecker(), emailAddress.getClassNameId(), emailAddress.getClassPK(), "VIEW");
        return emailAddress;
    }

    public List<EmailAddress> getEmailAddresses(String className, long classPK) throws PortalException {
        CommonPermissionUtil.check(this.getPermissionChecker(), className, classPK, "VIEW");
        User user = this.getUser();
        return this.emailAddressLocalService.getEmailAddresses(user.getCompanyId(), className, classPK);
    }

    public EmailAddress updateEmailAddress(long emailAddressId, String address, long typeId, boolean primary) throws PortalException {
        EmailAddress emailAddress = this.emailAddressPersistence.findByPrimaryKey(emailAddressId);
        CommonPermissionUtil.check(this.getPermissionChecker(), emailAddress.getClassNameId(), emailAddress.getClassPK(), "UPDATE");
        return this.emailAddressLocalService.updateEmailAddress(emailAddressId, address, typeId, primary);
    }
}

