/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.exportimport.kernel.staging.LayoutStagingUtil;
import com.liferay.exportimport.kernel.staging.MergeLayoutPrototypesThreadLocal;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.exception.LayoutSetVirtualHostException;
import com.liferay.portal.kernel.exception.NoSuchImageException;
import com.liferay.portal.kernel.exception.NoSuchVirtualHostException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Image;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutSetBranch;
import com.liferay.portal.kernel.model.LayoutSetStagingHandler;
import com.liferay.portal.kernel.model.VirtualHost;
import com.liferay.portal.kernel.module.service.Snapshot;
import com.liferay.portal.kernel.service.ImageLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.VirtualHostLocalService;
import com.liferay.portal.kernel.service.persistence.GroupPersistence;
import com.liferay.portal.kernel.service.persistence.LayoutPersistence;
import com.liferay.portal.kernel.service.persistence.LayoutSetBranchPersistence;
import com.liferay.portal.kernel.service.persistence.VirtualHostPersistence;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ColorSchemeFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.UnicodePropertiesBuilder;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.impl.LayoutSetImpl;
import com.liferay.portal.service.base.LayoutSetLocalServiceBaseImpl;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.util.ThemeFactoryUtil;
import com.liferay.sites.kernel.util.Sites;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.IDN;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.TreeMap;

public class LayoutSetLocalServiceImpl
extends LayoutSetLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(LayoutSetLocalServiceImpl.class);
    private static final Snapshot<Sites> _sitesSnapshot = new Snapshot(LayoutSetLocalServiceImpl.class, Sites.class);
    @BeanReference(type=GroupPersistence.class)
    private GroupPersistence _groupPersistence;
    @BeanReference(type=ImageLocalService.class)
    private ImageLocalService _imageLocalService;
    @BeanReference(type=LayoutLocalService.class)
    private LayoutLocalService _layoutLocalService;
    @BeanReference(type=LayoutPersistence.class)
    private LayoutPersistence _layoutPersistence;
    @BeanReference(type=LayoutSetBranchPersistence.class)
    private LayoutSetBranchPersistence _layoutSetBranchPersistence;
    @BeanReference(type=VirtualHostLocalService.class)
    private VirtualHostLocalService _virtualHostLocalService;
    @BeanReference(type=VirtualHostPersistence.class)
    private VirtualHostPersistence _virtualHostPersistence;

    public LayoutSet addLayoutSet(long groupId, boolean privateLayout) throws PortalException {
        Group group = this._groupPersistence.findByPrimaryKey(groupId);
        Date date = new Date();
        long layoutSetId = this.counterLocalService.increment(LayoutSet.class.getName());
        LayoutSet layoutSet = this.layoutSetPersistence.create(layoutSetId);
        layoutSet.setGroupId(groupId);
        layoutSet.setCompanyId(group.getCompanyId());
        layoutSet.setCreateDate(date);
        layoutSet.setModifiedDate(date);
        layoutSet.setPrivateLayout(privateLayout);
        layoutSet = this.initLayoutSet(layoutSet);
        return (LayoutSet)this.layoutSetPersistence.update((BaseModel)layoutSet);
    }

    public void deleteLayoutSet(long groupId, boolean privateLayout, ServiceContext serviceContext) throws PortalException {
        LayoutSet layoutSet;
        Group group;
        block5: {
            group = this._groupPersistence.findByPrimaryKey(groupId);
            layoutSet = this.layoutSetPersistence.findByG_P(groupId, privateLayout);
            serviceContext.setAttribute("updatePageCount", (Serializable)Boolean.FALSE);
            this._layoutLocalService.deleteLayouts(groupId, privateLayout, serviceContext);
            if (group.isStagingGroup() || !group.isOrganization() || !group.isSite()) {
                try {
                    this._imageLocalService.deleteImage(layoutSet.getLogoId());
                }
                catch (NoSuchImageException noSuchImageException) {
                    if (!_log.isWarnEnabled()) break block5;
                    _log.warn((Object)("Unable to delete image " + layoutSet.getLogoId()), (Throwable)noSuchImageException);
                }
            }
        }
        if (!group.isStagingGroup() && group.isOrganization() && group.isSite()) {
            layoutSet = this.initLayoutSet(layoutSet);
            layoutSet.setLogoId(layoutSet.getLogoId());
            layoutSet = (LayoutSet)this.layoutSetPersistence.update((BaseModel)layoutSet);
        } else {
            this.layoutSetPersistence.removeByG_P(groupId, privateLayout);
        }
        this._virtualHostPersistence.removeByC_L(layoutSet.getCompanyId(), layoutSet.getLayoutSetId());
    }

    public LayoutSet fetchLayoutSet(long groupId, boolean privateLayout) {
        return this.layoutSetPersistence.fetchByG_P(groupId, privateLayout);
    }

    public LayoutSet fetchLayoutSet(String virtualHostname) {
        VirtualHost virtualHost = this._virtualHostPersistence.fetchByHostname(virtualHostname = StringUtil.toLowerCase((String)StringUtil.trim((String)virtualHostname)));
        if (virtualHost == null && virtualHostname.contains("xn--")) {
            virtualHost = this._virtualHostPersistence.fetchByHostname(IDN.toUnicode(virtualHostname));
        }
        if (virtualHost == null || virtualHost.getLayoutSetId() == 0L) {
            return null;
        }
        return this.layoutSetPersistence.fetchByPrimaryKey(virtualHost.getLayoutSetId());
    }

    public LayoutSet fetchLayoutSetByLogoId(boolean privateLayout, long logoId) throws PortalException {
        return this.layoutSetPersistence.fetchByP_L(privateLayout, logoId);
    }

    public LayoutSet getLayoutSet(long groupId, boolean privateLayout) throws PortalException {
        return this.layoutSetPersistence.findByG_P(groupId, privateLayout);
    }

    public LayoutSet getLayoutSet(String virtualHostname) throws PortalException {
        virtualHostname = StringUtil.toLowerCase((String)StringUtil.trim((String)virtualHostname));
        VirtualHost virtualHost = null;
        try {
            virtualHost = this._virtualHostPersistence.findByHostname(virtualHostname);
        }
        catch (NoSuchVirtualHostException noSuchVirtualHostException) {
            if (virtualHostname.contains("xn--")) {
                virtualHost = this._virtualHostPersistence.findByHostname(IDN.toUnicode(virtualHostname));
            }
            throw noSuchVirtualHostException;
        }
        if (virtualHost.getLayoutSetId() == 0L) {
            throw new LayoutSetVirtualHostException("Virtual host is associated with company " + virtualHost.getCompanyId());
        }
        return this.layoutSetPersistence.findByPrimaryKey(virtualHost.getLayoutSetId());
    }

    public List<LayoutSet> getLayoutSetsByLayoutSetPrototypeUuid(String layoutSetPrototypeUuid) {
        return this.layoutSetPersistence.findByLayoutSetPrototypeUuid(layoutSetPrototypeUuid);
    }

    public int getPageCount(long groupId, boolean privateLayout) {
        return this._layoutPersistence.countByG_P(groupId, privateLayout);
    }

    public LayoutSet updateFaviconFileEntryId(long groupId, boolean privateLayout, long faviconFileEntryId) throws PortalException {
        LayoutSet layoutSet = this.layoutSetPersistence.findByG_P(groupId, privateLayout);
        layoutSet.setModifiedDate(new Date());
        layoutSet.setFaviconFileEntryId(faviconFileEntryId);
        return (LayoutSet)this.layoutSetPersistence.update((BaseModel)layoutSet);
    }

    public void updateLayoutSetPrototypeLinkEnabled(long groupId, boolean privateLayout, boolean layoutSetPrototypeLinkEnabled, String layoutSetPrototypeUuid) throws PortalException {
        block8: {
            LayoutSet layoutSet = this.layoutSetPersistence.findByG_P(groupId, privateLayout);
            LayoutSetBranch layoutSetBranch = this._getLayoutSetBranch(layoutSet);
            if (layoutSetBranch == null) {
                if (Validator.isNull((String)layoutSetPrototypeUuid)) {
                    layoutSetPrototypeUuid = layoutSet.getLayoutSetPrototypeUuid();
                }
                if (Validator.isNull((String)layoutSetPrototypeUuid)) {
                    layoutSetPrototypeLinkEnabled = false;
                }
                layoutSet.setLayoutSetPrototypeUuid(layoutSetPrototypeUuid);
                layoutSet.setLayoutSetPrototypeLinkEnabled(layoutSetPrototypeLinkEnabled);
                layoutSet = (LayoutSet)this.layoutSetPersistence.update((BaseModel)layoutSet);
            } else {
                if (Validator.isNull((String)layoutSetPrototypeUuid)) {
                    layoutSetPrototypeUuid = layoutSetBranch.getLayoutSetPrototypeUuid();
                }
                if (Validator.isNull((String)layoutSetPrototypeUuid) && layoutSetPrototypeLinkEnabled) {
                    throw new IllegalStateException("Cannot set layoutSetPrototypeLinkEnabled to true when layoutSetPrototypeUuid is null");
                }
                layoutSetBranch.setLayoutSetPrototypeUuid(layoutSetPrototypeUuid);
                layoutSetBranch.setLayoutSetPrototypeLinkEnabled(layoutSetPrototypeLinkEnabled);
                this._layoutSetBranchPersistence.update((BaseModel)layoutSetBranch);
            }
            try {
                MergeLayoutPrototypesThreadLocal.setSkipMerge((boolean)false);
                Sites sites = (Sites)_sitesSnapshot.get();
                sites.mergeLayoutSetPrototypeLayouts(this._groupPersistence.findByPrimaryKey(groupId), layoutSet);
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block8;
                _log.warn((Object)"Unable to force propagation from site template to site", (Throwable)exception);
            }
        }
    }

    public LayoutSet updateLogo(long groupId, boolean privateLayout, boolean hasLogo, byte[] bytes) throws PortalException {
        LayoutSet layoutSet = this.layoutSetPersistence.findByG_P(groupId, privateLayout);
        LayoutSetBranch layoutSetBranch = this._getLayoutSetBranch(layoutSet);
        if (layoutSetBranch == null) {
            layoutSet.setModifiedDate(new Date());
            PortalUtil.updateImageId((BaseModel)layoutSet, (boolean)hasLogo, (byte[])bytes, (String)"logoId", (long)0L, (int)0, (int)0);
            return (LayoutSet)this.layoutSetPersistence.update((BaseModel)layoutSet);
        }
        layoutSetBranch.setModifiedDate(new Date());
        PortalUtil.updateImageId((BaseModel)layoutSetBranch, (boolean)hasLogo, (byte[])bytes, (String)"logoId", (long)0L, (int)0, (int)0);
        this._layoutSetBranchPersistence.update((BaseModel)layoutSetBranch);
        return layoutSet;
    }

    public LayoutSet updateLogo(long groupId, boolean privateLayout, boolean hasLogo, File file) throws PortalException {
        byte[] bytes = null;
        try {
            bytes = FileUtil.getBytes((File)file);
        }
        catch (IOException ioException) {
            throw new SystemException((Throwable)ioException);
        }
        return this.updateLogo(groupId, privateLayout, hasLogo, bytes);
    }

    public LayoutSet updateLogo(long groupId, boolean privateLayout, boolean hasLogo, InputStream inputStream) throws PortalException {
        return this.updateLogo(groupId, privateLayout, hasLogo, inputStream, true);
    }

    public LayoutSet updateLogo(long groupId, boolean privateLayout, boolean hasLogo, InputStream inputStream, boolean cleanUpStream) throws PortalException {
        byte[] bytes = null;
        try {
            bytes = FileUtil.getBytes((InputStream)inputStream, (int)-1, (boolean)cleanUpStream);
        }
        catch (IOException ioException) {
            throw new SystemException((Throwable)ioException);
        }
        return this.updateLogo(groupId, privateLayout, hasLogo, bytes);
    }

    public LayoutSet updateLookAndFeel(long groupId, boolean privateLayout, String themeId, String colorSchemeId, String css) throws PortalException {
        LayoutSetBranch layoutSetBranch;
        LayoutSet layoutSet = this.layoutSetPersistence.findByG_P(groupId, privateLayout);
        if (Validator.isNull((String)themeId)) {
            themeId = ThemeFactoryUtil.getDefaultRegularThemeId(layoutSet.getCompanyId());
        }
        if (Validator.isNull((String)colorSchemeId)) {
            colorSchemeId = ColorSchemeFactoryUtil.getDefaultRegularColorSchemeId();
        }
        if ((layoutSetBranch = this._getLayoutSetBranch(layoutSet)) == null) {
            layoutSet.setModifiedDate(new Date());
            layoutSet.setThemeId(themeId);
            layoutSet.setColorSchemeId(colorSchemeId);
            layoutSet.setCss(css);
            layoutSet = (LayoutSet)this.layoutSetPersistence.update((BaseModel)layoutSet);
            if (PrefsPropsUtil.getBoolean((String)"theme.sync.on.group", (boolean)PropsValues.THEME_SYNC_ON_GROUP)) {
                LayoutSet otherLayoutSet = this.layoutSetPersistence.findByG_P(layoutSet.getGroupId(), layoutSet.isPrivateLayout());
                otherLayoutSet.setThemeId(themeId);
                otherLayoutSet.setColorSchemeId(colorSchemeId);
                this.layoutSetPersistence.update((BaseModel)otherLayoutSet);
            }
            return layoutSet;
        }
        layoutSetBranch.setModifiedDate(new Date());
        layoutSetBranch.setThemeId(themeId);
        layoutSetBranch.setColorSchemeId(colorSchemeId);
        layoutSetBranch.setCss(css);
        this._layoutSetBranchPersistence.update((BaseModel)layoutSetBranch);
        return layoutSet;
    }

    public void updateLookAndFeel(long groupId, String themeId, String colorSchemeId, String css) throws PortalException {
        this.updateLookAndFeel(groupId, false, themeId, colorSchemeId, css);
        this.updateLookAndFeel(groupId, true, themeId, colorSchemeId, css);
    }

    public LayoutSet updateSettings(long groupId, boolean privateLayout, String settings) throws PortalException {
        UnicodeProperties settingsUnicodeProperties = UnicodePropertiesBuilder.fastLoad((String)settings).build();
        LayoutSet layoutSet = this.layoutSetPersistence.findByG_P(groupId, privateLayout);
        LayoutSetBranch layoutSetBranch = this._getLayoutSetBranch(layoutSet);
        if (layoutSetBranch == null) {
            layoutSet.setModifiedDate(new Date());
            this.validateSettings(layoutSet.getSettingsProperties(), settingsUnicodeProperties);
            layoutSet.setSettingsProperties(settingsUnicodeProperties);
            return (LayoutSet)this.layoutSetPersistence.update((BaseModel)layoutSet);
        }
        layoutSetBranch.setModifiedDate(new Date());
        this.validateSettings(layoutSetBranch.getSettingsProperties(), settingsUnicodeProperties);
        layoutSetBranch.setSettingsProperties(settingsUnicodeProperties);
        this._layoutSetBranchPersistence.update((BaseModel)layoutSetBranch);
        return layoutSet;
    }

    public LayoutSet updateVirtualHosts(long groupId, boolean privateLayout, TreeMap<String, String> virtualHostnames) throws PortalException {
        HashSet<String> keySet = new HashSet<String>(virtualHostnames.keySet());
        for (String curVirtualHostname : keySet) {
            if (!Validator.isDomain((String)curVirtualHostname)) {
                throw new LayoutSetVirtualHostException("Invalid host name {" + curVirtualHostname + "}");
            }
            if (StringUtil.isLowerCase((String)curVirtualHostname)) continue;
            virtualHostnames.putIfAbsent(StringUtil.toLowerCase((String)curVirtualHostname), virtualHostnames.remove(curVirtualHostname));
        }
        LayoutSet layoutSet = this.layoutSetPersistence.findByG_P(groupId, privateLayout);
        if (!virtualHostnames.isEmpty()) {
            long virtualHostsCount = this._virtualHostLocalService.getVirtualHostsCount(layoutSet.getLayoutSetId(), ArrayUtil.toStringArray(virtualHostnames.keySet()));
            if (virtualHostsCount > 0L) {
                throw new LayoutSetVirtualHostException();
            }
            this._virtualHostLocalService.updateVirtualHosts(layoutSet.getCompanyId(), layoutSet.getLayoutSetId(), virtualHostnames);
        } else {
            this._virtualHostPersistence.removeByC_L(layoutSet.getCompanyId(), layoutSet.getLayoutSetId());
            this.layoutSetPersistence.clearCache((BaseModel)layoutSet);
            TransactionCommitCallbackUtil.registerCallback(() -> {
                EntityCacheUtil.removeResult(LayoutSetImpl.class, (Serializable)Long.valueOf(layoutSet.getLayoutSetId()));
                return null;
            });
        }
        return layoutSet;
    }

    protected LayoutSet initLayoutSet(LayoutSet layoutSet) throws PortalException {
        Group group = layoutSet.getGroup();
        if (group.isStagingGroup()) {
            LayoutSet liveLayoutSet = null;
            Group liveGroup = group.getLiveGroup();
            liveLayoutSet = layoutSet.isPrivateLayout() ? liveGroup.getPrivateLayoutSet() : liveGroup.getPublicLayoutSet();
            layoutSet.setLogoId(liveLayoutSet.getLogoId());
            if (liveLayoutSet.isLogo()) {
                Image logoImage = this._imageLocalService.getImage(liveLayoutSet.getLogoId());
                long logoId = this.counterLocalService.increment();
                this._imageLocalService.updateImage(layoutSet.getCompanyId(), logoId, logoImage.getTextObj(), logoImage.getType(), logoImage.getHeight(), logoImage.getWidth(), logoImage.getSize());
                layoutSet.setLogoId(logoId);
            }
            layoutSet.setThemeId(liveLayoutSet.getThemeId());
            layoutSet.setColorSchemeId(liveLayoutSet.getColorSchemeId());
            layoutSet.setCss(liveLayoutSet.getCss());
            layoutSet.setSettings(liveLayoutSet.getSettings());
        } else {
            layoutSet.setThemeId(ThemeFactoryUtil.getDefaultRegularThemeId(group.getCompanyId()));
            layoutSet.setColorSchemeId(ColorSchemeFactoryUtil.getDefaultRegularColorSchemeId());
            layoutSet.setCss("");
            layoutSet.setSettings("");
        }
        return layoutSet;
    }

    protected void validateSettings(UnicodeProperties oldSettingsUnicodeProperties, UnicodeProperties newSettingsUnicodeProperties) {
        boolean enableJavaScript = PropsValues.FIELD_ENABLE_COM_LIFERAY_PORTAL_KERNEL_MODEL_LAYOUTSET_JAVASCRIPT;
        if (!enableJavaScript) {
            String javaScript = oldSettingsUnicodeProperties.getProperty("javascript");
            newSettingsUnicodeProperties.setProperty("javascript", javaScript);
        }
    }

    private LayoutSetBranch _getLayoutSetBranch(LayoutSet layoutSet) throws PortalException {
        LayoutSetStagingHandler layoutSetStagingHandler = LayoutStagingUtil.getLayoutSetStagingHandler((LayoutSet)layoutSet);
        if (layoutSetStagingHandler != null) {
            return layoutSetStagingHandler.getLayoutSetBranch();
        }
        if (LayoutStagingUtil.isBranchingLayoutSet((Group)layoutSet.getGroup(), (boolean)layoutSet.isPrivateLayout())) {
            layoutSetStagingHandler = new LayoutSetStagingHandler(layoutSet);
            return layoutSetStagingHandler.getLayoutSetBranch();
        }
        return null;
    }
}

