/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.asset.kernel.service.AssetTagLocalService;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Address;
import com.liferay.portal.kernel.model.EmailAddress;
import com.liferay.portal.kernel.model.OrgLabor;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.Phone;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.Website;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.security.membershippolicy.OrganizationMembershipPolicyUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import com.liferay.portal.kernel.service.permission.OrganizationPermissionUtil;
import com.liferay.portal.kernel.service.permission.PortalPermissionUtil;
import com.liferay.portal.kernel.service.permission.UserPermissionUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.util.comparator.OrganizationIdComparator;
import com.liferay.portal.service.base.OrganizationServiceBaseImpl;
import com.liferay.portal.service.permission.PasswordPolicyPermissionUtil;
import com.liferay.portlet.usersadmin.util.UsersAdminUtil;
import java.util.List;
import java.util.Map;

public class OrganizationServiceImpl
extends OrganizationServiceBaseImpl {
    @BeanReference(type=AssetCategoryLocalService.class)
    private AssetCategoryLocalService _assetCategoryLocalService;
    @BeanReference(type=AssetTagLocalService.class)
    private AssetTagLocalService _assetTagLocalService;

    public void addGroupOrganizations(long groupId, long[] organizationIds) throws PortalException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"ASSIGN_MEMBERS");
        this.organizationLocalService.addGroupOrganizations(groupId, organizationIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Organization addOrganization(String externalReferenceCode, long parentOrganizationId, String name, String type, long regionId, long countryId, long statusListTypeId, String comments, boolean site, List<Address> addresses, List<EmailAddress> emailAddresses, List<OrgLabor> orgLabors, List<Phone> phones, List<Website> websites, ServiceContext serviceContext) throws PortalException {
        boolean indexingEnabled = true;
        if (serviceContext != null) {
            indexingEnabled = serviceContext.isIndexingEnabled();
            serviceContext.setIndexingEnabled(false);
        }
        try {
            Organization organization = this.addOrganization(externalReferenceCode, parentOrganizationId, name, type, regionId, countryId, statusListTypeId, comments, site, serviceContext);
            UsersAdminUtil.updateAddresses(Organization.class.getName(), organization.getOrganizationId(), addresses);
            UsersAdminUtil.updateEmailAddresses(Organization.class.getName(), organization.getOrganizationId(), emailAddresses);
            UsersAdminUtil.updateOrgLabors(organization.getOrganizationId(), orgLabors);
            UsersAdminUtil.updatePhones(Organization.class.getName(), organization.getOrganizationId(), phones);
            UsersAdminUtil.updateWebsites(Organization.class.getName(), organization.getOrganizationId(), websites);
            if (indexingEnabled) {
                Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(Organization.class);
                indexer.reindex((Object)organization);
            }
            Organization organization2 = organization;
            return organization2;
        }
        finally {
            if (serviceContext != null) {
                serviceContext.setIndexingEnabled(indexingEnabled);
            }
        }
    }

    public Organization addOrganization(String externalReferenceCode, long parentOrganizationId, String name, String type, long regionId, long countryId, long statusListTypeId, String comments, boolean site, ServiceContext serviceContext) throws PortalException {
        if (parentOrganizationId == 0L) {
            PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"ADD_ORGANIZATION");
        } else {
            OrganizationPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)parentOrganizationId, (String)"ADD_ORGANIZATION");
        }
        Organization organization = this.organizationLocalService.addOrganization(externalReferenceCode, this.getUserId(), parentOrganizationId, name, type, regionId, countryId, statusListTypeId, comments, site, serviceContext);
        OrganizationMembershipPolicyUtil.verifyPolicy((Organization)organization);
        return organization;
    }

    public User addOrganizationUserByEmailAddress(String emailAddress, long organizationId, ServiceContext serviceContext) throws PortalException {
        OrganizationPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)organizationId, (String)"ASSIGN_MEMBERS");
        return this.organizationLocalService.addOrganizationUserByEmailAddress(emailAddress, organizationId, serviceContext);
    }

    public Organization addOrUpdateOrganization(String externalReferenceCode, long parentOrganizationId, String name, String type, long regionId, long countryId, long statusListTypeId, String comments, boolean hasLogo, byte[] logoBytes, boolean site, List<Address> addresses, List<EmailAddress> emailAddresses, List<OrgLabor> orgLabors, List<Phone> phones, List<Website> websites, ServiceContext serviceContext) throws PortalException {
        User user = this.getUser();
        Organization organization = this.organizationLocalService.fetchOrganizationByExternalReferenceCode(externalReferenceCode, user.getCompanyId());
        if (organization == null) {
            if (parentOrganizationId == 0L) {
                PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"ADD_ORGANIZATION");
            } else {
                OrganizationPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)parentOrganizationId, (String)"ADD_ORGANIZATION");
            }
        } else {
            OrganizationPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (Organization)organization, (String)"UPDATE");
            if (organization.getParentOrganizationId() != parentOrganizationId) {
                if (parentOrganizationId == 0L) {
                    PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"ADD_ORGANIZATION");
                } else {
                    OrganizationPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)parentOrganizationId, (String)"ADD_ORGANIZATION");
                }
            }
        }
        organization = this.organizationLocalService.addOrUpdateOrganization(externalReferenceCode, user.getUserId(), parentOrganizationId, name, type, regionId, countryId, statusListTypeId, comments, hasLogo, logoBytes, site, serviceContext);
        if (addresses != null) {
            UsersAdminUtil.updateAddresses(Organization.class.getName(), organization.getOrganizationId(), addresses);
        }
        if (emailAddresses != null) {
            UsersAdminUtil.updateEmailAddresses(Organization.class.getName(), organization.getOrganizationId(), emailAddresses);
        }
        if (orgLabors != null) {
            UsersAdminUtil.updateOrgLabors(organization.getOrganizationId(), orgLabors);
        }
        if (phones != null) {
            UsersAdminUtil.updatePhones(Organization.class.getName(), organization.getOrganizationId(), phones);
        }
        if (websites != null) {
            UsersAdminUtil.updateWebsites(Organization.class.getName(), organization.getOrganizationId(), websites);
        }
        return organization;
    }

    public void addPasswordPolicyOrganizations(long passwordPolicyId, long[] organizationIds) throws PortalException {
        PasswordPolicyPermissionUtil.check(this.getPermissionChecker(), passwordPolicyId, "UPDATE");
        this.organizationLocalService.addPasswordPolicyOrganizations(passwordPolicyId, organizationIds);
    }

    public void addUserOrganizationByEmailAddress(String emailAddress, long organizationId) throws PortalException {
        OrganizationPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)organizationId, (String)"ASSIGN_MEMBERS");
        this.organizationLocalService.addUserOrganizationByEmailAddress(emailAddress, organizationId);
    }

    public void deleteLogo(long organizationId) throws PortalException {
        OrganizationPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)organizationId, (String)"UPDATE");
        this.organizationLocalService.deleteLogo(organizationId);
    }

    public void deleteOrganization(long organizationId) throws PortalException {
        OrganizationPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)organizationId, (String)"DELETE");
        this.organizationLocalService.deleteOrganization(organizationId);
    }

    public void deleteUserOrganizationByEmailAddress(String emailAddress, long organizationId) throws PortalException {
        OrganizationPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)organizationId, (String)"ASSIGN_MEMBERS");
        this.organizationLocalService.deleteUserOrganizationByEmailAddress(emailAddress, organizationId);
    }

    public Organization fetchOrganization(long organizationId) throws PortalException {
        Organization organization = this.organizationLocalService.fetchOrganization(organizationId);
        if (organization != null) {
            OrganizationPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (Organization)organization, (String)"VIEW");
        }
        return organization;
    }

    public List<Organization> getGtOrganizations(long gtOrganizationId, long companyId, long parentOrganizationId, int size) {
        return this.organizationPersistence.filterFindByGtO_C_P(gtOrganizationId, companyId, parentOrganizationId, 0, size, (OrderByComparator)new OrganizationIdComparator(true));
    }

    public Organization getOrganization(long organizationId) throws PortalException {
        Organization organization = this.organizationLocalService.getOrganization(organizationId);
        OrganizationPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (Organization)organization, (String)"VIEW");
        return organization;
    }

    public Organization getOrganizationByExternalReferenceCode(long companyId, String externalReferenceCode) throws PortalException {
        Organization organization = this.organizationLocalService.getOrganizationByExternalReferenceCode(externalReferenceCode, companyId);
        OrganizationPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (Organization)organization, (String)"VIEW");
        return organization;
    }

    public long getOrganizationId(long companyId, String name) throws PortalException {
        long organizationId = this.organizationLocalService.getOrganizationId(companyId, name);
        OrganizationPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)organizationId, (String)"VIEW");
        return organizationId;
    }

    public List<Organization> getOrganizations(long companyId, long parentOrganizationId) {
        if (parentOrganizationId == -1L) {
            return this.organizationPersistence.filterFindByCompanyId(companyId);
        }
        return this.organizationPersistence.filterFindByC_P(companyId, parentOrganizationId);
    }

    public List<Organization> getOrganizations(long companyId, long parentOrganizationId, int start, int end) {
        if (parentOrganizationId == -1L) {
            return this.organizationPersistence.filterFindByCompanyId(companyId, start, end);
        }
        return this.organizationPersistence.filterFindByC_P(companyId, parentOrganizationId, start, end);
    }

    public List<Organization> getOrganizations(long companyId, long parentOrganizationId, int start, int end, OrderByComparator<Organization> orderByComparator) {
        if (parentOrganizationId == -1L) {
            return this.organizationPersistence.filterFindByCompanyId(companyId, start, end, orderByComparator);
        }
        return this.organizationPersistence.filterFindByC_P(companyId, parentOrganizationId, start, end, orderByComparator);
    }

    public List<Organization> getOrganizations(long companyId, long parentOrganizationId, String name, int start, int end) {
        if (Validator.isNull((String)name)) {
            return this.getOrganizations(companyId, parentOrganizationId, start, end);
        }
        if (parentOrganizationId == -1L) {
            return this.organizationPersistence.filterFindByC_LikeN(companyId, name);
        }
        return this.organizationPersistence.filterFindByC_P_LikeN(companyId, parentOrganizationId, name, start, end);
    }

    public List<Organization> getOrganizations(long companyId, long parentOrganizationId, String name, int start, int end, OrderByComparator<Organization> orderByComparator) {
        if (Validator.isNull((String)name)) {
            return this.getOrganizations(companyId, parentOrganizationId, start, end, orderByComparator);
        }
        if (parentOrganizationId == -1L) {
            return this.organizationPersistence.filterFindByC_LikeN(companyId, name, start, end, orderByComparator);
        }
        return this.organizationPersistence.filterFindByC_P_LikeN(companyId, parentOrganizationId, name, start, end, orderByComparator);
    }

    public int getOrganizationsCount(long companyId, long parentOrganizationId) {
        if (parentOrganizationId == -1L) {
            return this.organizationPersistence.filterCountByCompanyId(companyId);
        }
        return this.organizationPersistence.filterCountByC_P(companyId, parentOrganizationId);
    }

    public int getOrganizationsCount(long companyId, long parentOrganizationId, String name) throws PortalException {
        if (Validator.isNull((String)name)) {
            return this.getOrganizationsCount(companyId, parentOrganizationId);
        }
        if (parentOrganizationId == -1L) {
            return this.organizationPersistence.filterCountByC_LikeN(companyId, name);
        }
        return this.organizationPersistence.filterCountByC_P_LikeN(companyId, parentOrganizationId, name);
    }

    public List<Organization> getUserOrganizations(long userId) throws PortalException {
        UserPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)userId, (String)"VIEW");
        return this.organizationLocalService.getUserOrganizations(userId);
    }

    public void setGroupOrganizations(long groupId, long[] organizationIds) throws PortalException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"ASSIGN_MEMBERS");
        this.organizationLocalService.setGroupOrganizations(groupId, organizationIds);
    }

    public void unsetGroupOrganizations(long groupId, long[] organizationIds) throws PortalException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"ASSIGN_MEMBERS");
        this.organizationLocalService.unsetGroupOrganizations(groupId, organizationIds);
    }

    public void unsetPasswordPolicyOrganizations(long passwordPolicyId, long[] organizationIds) throws PortalException {
        PasswordPolicyPermissionUtil.check(this.getPermissionChecker(), passwordPolicyId, "UPDATE");
        this.organizationLocalService.unsetPasswordPolicyOrganizations(passwordPolicyId, organizationIds);
    }

    public Organization updateLogo(long organizationId, byte[] logoBytes) throws PortalException {
        OrganizationPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)organizationId, (String)"UPDATE");
        return this.organizationLocalService.updateLogo(organizationId, logoBytes);
    }

    public Organization updateOrganization(String externalReferenceCode, long organizationId, long parentOrganizationId, String name, String type, long regionId, long countryId, long statusListTypeId, String comments, boolean hasLogo, byte[] logoBytes, boolean site, List<Address> addresses, List<EmailAddress> emailAddresses, List<OrgLabor> orgLabors, List<Phone> phones, List<Website> websites, ServiceContext serviceContext) throws PortalException {
        Organization organization = this.organizationPersistence.findByPrimaryKey(organizationId);
        OrganizationPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (Organization)organization, (String)"UPDATE");
        if (organization.getParentOrganizationId() != parentOrganizationId) {
            if (parentOrganizationId == 0L) {
                PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"ADD_ORGANIZATION");
            } else {
                OrganizationPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)parentOrganizationId, (String)"ADD_ORGANIZATION");
            }
        }
        if (addresses != null) {
            UsersAdminUtil.updateAddresses(Organization.class.getName(), organizationId, addresses);
        }
        if (emailAddresses != null) {
            UsersAdminUtil.updateEmailAddresses(Organization.class.getName(), organizationId, emailAddresses);
        }
        if (orgLabors != null) {
            UsersAdminUtil.updateOrgLabors(organizationId, orgLabors);
        }
        if (phones != null) {
            UsersAdminUtil.updatePhones(Organization.class.getName(), organizationId, phones);
        }
        if (websites != null) {
            UsersAdminUtil.updateWebsites(Organization.class.getName(), organizationId, websites);
        }
        User user = this.getUser();
        Organization oldOrganization = organization;
        List oldAssetCategories = this._assetCategoryLocalService.getCategories(Organization.class.getName(), organizationId);
        List oldAssetTags = this._assetTagLocalService.getTags(Organization.class.getName(), organizationId);
        ExpandoBridge oldExpandoBridge = oldOrganization.getExpandoBridge();
        Map oldExpandoAttributes = oldExpandoBridge.getAttributes();
        organization = this.organizationLocalService.updateOrganization(externalReferenceCode, user.getCompanyId(), organizationId, parentOrganizationId, name, type, regionId, countryId, statusListTypeId, comments, hasLogo, logoBytes, site, serviceContext);
        OrganizationMembershipPolicyUtil.verifyPolicy((Organization)organization, (Organization)oldOrganization, (List)oldAssetCategories, (List)oldAssetTags, (Map)oldExpandoAttributes);
        return organization;
    }

    public Organization updateOrganization(String externalReferenceCode, long organizationId, long parentOrganizationId, String name, String type, long regionId, long countryId, long statusListTypeId, String comments, boolean site, ServiceContext serviceContext) throws PortalException {
        return this.updateOrganization(externalReferenceCode, organizationId, parentOrganizationId, name, type, regionId, countryId, statusListTypeId, comments, true, null, site, null, null, null, null, null, serviceContext);
    }
}

