/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.exportimport.kernel.staging.LayoutStagingUtil;
import com.liferay.exportimport.kernel.staging.MergeLayoutPrototypesThreadLocal;
import com.liferay.exportimport.kernel.staging.StagingUtil;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.change.tracking.CTCollectionThreadLocal;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutRevision;
import com.liferay.portal.kernel.model.LayoutStagingHandler;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletPreferenceValue;
import com.liferay.portal.kernel.model.PortletPreferenceValueTable;
import com.liferay.portal.kernel.model.PortletPreferences;
import com.liferay.portal.kernel.model.PortletPreferencesIds;
import com.liferay.portal.kernel.model.PortletPreferencesTable;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.service.LayoutRevisionLocalService;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.service.PortletPreferenceValueLocalService;
import com.liferay.portal.kernel.service.SQLStateAcceptor;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.LayoutPersistence;
import com.liferay.portal.kernel.service.persistence.LayoutRevisionPersistence;
import com.liferay.portal.kernel.service.persistence.PortletPreferenceValuePersistence;
import com.liferay.portal.kernel.service.persistence.UserPersistence;
import com.liferay.portal.kernel.settings.PortletInstanceSettingsLocator;
import com.liferay.portal.kernel.settings.PortletPreferencesSettings;
import com.liferay.portal.kernel.settings.Settings;
import com.liferay.portal.kernel.settings.SettingsLocatorHelperUtil;
import com.liferay.portal.kernel.spring.aop.Property;
import com.liferay.portal.kernel.spring.aop.Retry;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.CopyLayoutThreadLocal;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.service.base.PortletPreferencesLocalServiceBaseImpl;
import com.liferay.portal.service.impl.PortletPreferenceValueLocalServiceImpl;
import com.liferay.portlet.PortletPreferencesFactoryImpl;
import com.liferay.portlet.PortletPreferencesImpl;
import com.liferay.portlet.Preference;
import com.liferay.portlet.exportimport.staging.ProxiedLayoutsThreadLocal;
import com.liferay.portlet.exportimport.staging.StagingAdvicesThreadLocal;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PortletPreferencesLocalServiceImpl
extends PortletPreferencesLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(PortletPreferencesLocalServiceImpl.class);
    @BeanReference(type=LayoutPersistence.class)
    private LayoutPersistence _layoutPersistence;
    @BeanReference(type=LayoutRevisionLocalService.class)
    private LayoutRevisionLocalService _layoutRevisionLocalService;
    @BeanReference(type=LayoutRevisionPersistence.class)
    private LayoutRevisionPersistence _layoutRevisionPersistence;
    @BeanReference(type=PortletLocalService.class)
    private PortletLocalService _portletLocalService;
    @BeanReference(type=PortletPreferenceValueLocalService.class)
    private PortletPreferenceValueLocalService _portletPreferenceValueLocalService;
    @BeanReference(type=PortletPreferenceValuePersistence.class)
    private PortletPreferenceValuePersistence _portletPreferenceValuePersistence;
    @BeanReference(type=UserPersistence.class)
    private UserPersistence _userPersistence;

    public PortletPreferences addPortletPreferences(long companyId, long ownerId, int ownerType, long plid, String portletId, Portlet portlet, String defaultPreferences) {
        PortletPreferences portletPreferences;
        block8: {
            long portletPreferencesId = this.counterLocalService.increment();
            portletPreferences = this.portletPreferencesPersistence.create(portletPreferencesId);
            portletPreferences.setOwnerId(ownerId);
            portletPreferences.setOwnerType(ownerType);
            portletPreferences.setPlid(plid);
            portletPreferences.setPortletId(portletId);
            if (Validator.isNull((String)defaultPreferences)) {
                javax.portlet.PortletPreferences jxPortletPreferences;
                PortletPreferences layoutPortletPreferences;
                LayoutRevision layoutRevision = this._layoutRevisionLocalService.fetchLayoutRevision(plid);
                if (layoutRevision != null && (layoutPortletPreferences = this.portletPreferencesPersistence.fetchByO_O_P_P(ownerId, ownerType, layoutRevision.getPlid(), portletId)) != null && (jxPortletPreferences = this._portletPreferenceValueLocalService.getPreferences(layoutPortletPreferences)) != null) {
                    defaultPreferences = PortletPreferencesFactoryUtil.toXML((javax.portlet.PortletPreferences)jxPortletPreferences);
                }
                if (Validator.isNull((String)defaultPreferences)) {
                    defaultPreferences = portlet == null ? "<portlet-preferences />" : portlet.getDefaultPreferences();
                }
            }
            if (!Objects.equals("<portlet-preferences />", defaultPreferences)) {
                this._updatePortletPreferences(portletPreferences, Collections.emptyMap(), PortletPreferencesFactoryImpl.createPreferencesMap(defaultPreferences));
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Add {companyId=", companyId, ", ownerId=", ownerId, ", ownerType=", ownerType, ", plid=", plid, ", portletId=", portletId, ", defaultPreferences=", defaultPreferences, "}"}));
            }
            try {
                portletPreferences = (PortletPreferences)this.portletPreferencesPersistence.update((BaseModel)portletPreferences);
            }
            catch (SystemException systemException) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Add failed, fetch {ownerId=", ownerId, ", ownerType=", ownerType, ", plid=", plid, ", portletId=", portletId, "}"}));
                }
                if ((portletPreferences = this.portletPreferencesPersistence.fetchByO_O_P_P(ownerId, ownerType, plid, portletId, false)) != null) break block8;
                throw systemException;
            }
        }
        return portletPreferences;
    }

    @Override
    public PortletPreferences deletePortletPreferences(long portletPreferencesId) throws PortalException {
        for (PortletPreferenceValue portletPreferenceValue : this._portletPreferenceValuePersistence.findByPortletPreferencesId(portletPreferencesId)) {
            this._portletPreferenceValuePersistence.remove((BaseModel)portletPreferenceValue);
        }
        return super.deletePortletPreferences(portletPreferencesId);
    }

    public void deletePortletPreferences(long ownerId, int ownerType, long plid) {
        for (PortletPreferenceValue portletPreferenceValue : this._getPortletPreferenceValues(PortletPreferencesTable.INSTANCE.ownerId.eq((Object)ownerId).and((Expression)PortletPreferencesTable.INSTANCE.ownerType.eq((Object)ownerType)).and((Expression)PortletPreferencesTable.INSTANCE.plid.eq((Object)plid)))) {
            this._portletPreferenceValuePersistence.remove((BaseModel)portletPreferenceValue);
        }
        this.portletPreferencesPersistence.removeByO_O_P(ownerId, ownerType, plid);
    }

    public void deletePortletPreferences(long ownerId, int ownerType, long plid, String portletId) throws PortalException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Delete {ownerId=", ownerId, ", ownerType=", ownerType, ", plid=", plid, ", portletId=", portletId, "}"}));
        }
        PortletPreferences portletPreferences = this.portletPreferencesPersistence.findByO_O_P_P(ownerId, ownerType, plid, portletId);
        this._portletPreferenceValuePersistence.removeByPortletPreferencesId(portletPreferences.getPortletPreferencesId());
        this.portletPreferencesPersistence.remove((BaseModel)portletPreferences);
    }

    public void deletePortletPreferencesByOwnerId(long ownerId) {
        for (PortletPreferenceValue portletPreferenceValue : this._getPortletPreferenceValues(PortletPreferencesTable.INSTANCE.ownerId.eq((Object)ownerId))) {
            this._portletPreferenceValuePersistence.remove((BaseModel)portletPreferenceValue);
        }
        this.portletPreferencesPersistence.removeByOwnerId(ownerId);
    }

    public void deletePortletPreferencesByPlid(long plid) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Delete {plid=" + plid + "}"));
        }
        for (PortletPreferenceValue portletPreferenceValue : this._getPortletPreferenceValues(PortletPreferencesTable.INSTANCE.plid.eq((Object)plid))) {
            this._portletPreferenceValuePersistence.remove((BaseModel)portletPreferenceValue);
        }
        this.portletPreferencesPersistence.removeByPlid(plid);
    }

    public PortletPreferences fetchPortletPreferences(long ownerId, int ownerType, long plid, String portletId) {
        if (!this._exists(plid, portletId)) {
            return null;
        }
        return this.portletPreferencesPersistence.fetchByO_O_P_P(ownerId, ownerType, this._swapPlidForPortletPreferences(plid), portletId);
    }

    public javax.portlet.PortletPreferences fetchPreferences(long companyId, long ownerId, int ownerType, long plid, String portletId) {
        PortletPreferences portletPreferences = this.portletPreferencesPersistence.fetchByO_O_P_P(ownerId, ownerType, plid = this._swapPlidForPortletPreferences(plid), portletId);
        if (portletPreferences == null) {
            return null;
        }
        return this._portletPreferenceValueLocalService.getPreferences(portletPreferences);
    }

    public javax.portlet.PortletPreferences fetchPreferences(PortletPreferencesIds portletPreferencesIds) {
        return this.fetchPreferences(portletPreferencesIds.getCompanyId(), portletPreferencesIds.getOwnerId(), portletPreferencesIds.getOwnerType(), portletPreferencesIds.getPlid(), portletPreferencesIds.getPortletId());
    }

    @Transactional(enabled=false)
    public javax.portlet.PortletPreferences getDefaultPreferences(long companyId, String portletId) {
        Portlet portlet = this._portletLocalService.getPortletById(companyId, portletId);
        return PortletPreferencesFactoryUtil.fromDefaultXML((String)portlet.getDefaultPreferences());
    }

    public Settings getPortletInstanceSettings(long companyId, long groupId, String portletId, PortletInstanceSettingsLocator portletInstanceSettingsLocator, Settings portalPreferencesSettings) {
        String defaultPreferences = "<portlet-preferences />";
        String portletName = PortletIdCodec.decodePortletName((String)portletId);
        Portlet portlet = this._portletLocalService.fetchPortletById(companyId, portletName);
        if (portlet != null) {
            defaultPreferences = portlet.getDefaultPreferences();
        }
        String configurationPid = portletInstanceSettingsLocator.getConfigurationPid();
        Settings companyConfigurationBeanSettings = SettingsLocatorHelperUtil.getCompanyConfigurationBeanSettings((long)companyId, (String)configurationPid, (Settings)portalPreferencesSettings);
        PortletPreferencesSettings companyPortletPreferencesSettings = new PortletPreferencesSettings(this._getStrictPreferences(companyId, companyId, 1, 0L, portletName, defaultPreferences), companyConfigurationBeanSettings);
        Settings groupConfigurationBeanSettings = SettingsLocatorHelperUtil.getGroupConfigurationBeanSettings((long)groupId, (String)configurationPid, (Settings)companyPortletPreferencesSettings);
        PortletPreferencesSettings groupPortletPreferencesSettings = new PortletPreferencesSettings(this._getStrictPreferences(companyId, groupId, 2, 0L, portletName, defaultPreferences), groupConfigurationBeanSettings);
        Settings portletInstanceConfigurationBeanSettings = SettingsLocatorHelperUtil.getPortletInstanceConfigurationBeanSettings((String)portletId, (String)configurationPid, (Settings)groupPortletPreferencesSettings);
        long ownerId = portletInstanceSettingsLocator.getOwnerId();
        int ownerType = 3;
        long userId = PortletIdCodec.decodeUserId((String)portletId);
        if (userId > 0L) {
            ownerId = userId;
            ownerType = 4;
        }
        long plid = this._swapPlidForPortletPreferences(portletInstanceSettingsLocator.getPlid());
        return new PortletPreferencesSettings(this._getStrictPreferences(companyId, ownerId, ownerType, plid, portletId, defaultPreferences), portletInstanceConfigurationBeanSettings);
    }

    public List<PortletPreferences> getPortletPreferences() {
        return this.portletPreferencesPersistence.findAll();
    }

    public List<PortletPreferences> getPortletPreferences(int ownerType, long plid, String portletId) {
        return this.portletPreferencesPersistence.findByO_P_P(ownerType, this._swapPlidForPortletPreferences(plid), portletId);
    }

    public List<PortletPreferences> getPortletPreferences(long ownerId, int ownerType, long plid) {
        return this.portletPreferencesPersistence.findByO_O_P(ownerId, ownerType, this._swapPlidForPortletPreferences(plid));
    }

    public PortletPreferences getPortletPreferences(long ownerId, int ownerType, long plid, String portletId) throws PortalException {
        return this.portletPreferencesPersistence.findByO_O_P_P(ownerId, ownerType, this._swapPlidForPortletPreferences(plid), portletId);
    }

    public List<PortletPreferences> getPortletPreferences(long companyId, long ownerId, int ownerType, String portletId) throws PortalException {
        return this.portletPreferencesPersistence.findByC_O_O_LikeP(companyId, ownerId, ownerType, portletId);
    }

    public List<PortletPreferences> getPortletPreferences(long companyId, long groupId, long ownerId, int ownerType, String portletId, boolean privateLayout) {
        return this.portletPreferencesFinder.findByC_G_O_O_P_P(companyId, groupId, ownerId, ownerType, portletId, privateLayout);
    }

    public List<PortletPreferences> getPortletPreferences(long plid, String portletId) {
        return this.portletPreferencesPersistence.findByP_P(this._swapPlidForPortletPreferences(plid), portletId);
    }

    public List<PortletPreferences> getPortletPreferencesByOwnerId(long ownerId) {
        return this.portletPreferencesPersistence.findByOwnerId(ownerId);
    }

    public List<PortletPreferences> getPortletPreferencesByPlid(long plid) {
        return this.portletPreferencesPersistence.findByPlid(plid);
    }

    public long getPortletPreferencesCount(int ownerType, long plid, String portletId) {
        if (!this._exists(plid, portletId)) {
            return 0L;
        }
        return this.portletPreferencesPersistence.countByO_P_P(ownerType, this._swapPlidForPortletPreferences(plid), portletId);
    }

    public long getPortletPreferencesCount(int ownerType, String portletId) {
        return this.portletPreferencesPersistence.countByO_P(ownerType, portletId);
    }

    public long getPortletPreferencesCount(long ownerId, int ownerType, long plid, Portlet portlet, boolean excludeDefaultPreferences) {
        plid = this._swapPlidForPortletPreferences(plid);
        String portletId = portlet.getPortletId();
        if (plid == -1L) {
            portletId = portlet.getRootPortletId();
        }
        return this.portletPreferencesFinder.countByO_O_P_P_P(ownerId, ownerType, plid, portletId, excludeDefaultPreferences);
    }

    public long getPortletPreferencesCount(long ownerId, int ownerType, String portletId, boolean excludeDefaultPreferences) {
        return this.portletPreferencesFinder.countByO_O_P(ownerId, ownerType, portletId, excludeDefaultPreferences);
    }

    public int getPortletPreferencesCount(long companyId, long ownerId, int ownerType, String portletId) {
        return this.portletPreferencesPersistence.countByC_O_O_LikeP(companyId, ownerId, ownerType, portletId);
    }

    @Retry(acceptor=SQLStateAcceptor.class, properties={@Property(name="SQLSTATE", value="23")})
    public javax.portlet.PortletPreferences getPreferences(long companyId, long ownerId, int ownerType, long plid, String portletId) {
        return this.getPreferences(companyId, ownerId, ownerType, plid, portletId, null);
    }

    @Retry(acceptor=SQLStateAcceptor.class, properties={@Property(name="SQLSTATE", value="23")})
    public javax.portlet.PortletPreferences getPreferences(long companyId, long ownerId, int ownerType, long plid, String portletId, String defaultPreferences) {
        PortletPreferences portletPreferences = this.portletPreferencesPersistence.fetchByO_O_P_P(ownerId, ownerType, plid = this._swapPlidForPreferences(plid), portletId);
        if (portletPreferences == null) {
            Portlet portlet = this._portletLocalService.fetchPortletById(companyId, portletId);
            long ctCollectionId = CTCollectionThreadLocal.getCTCollectionId();
            if (ctCollectionId != 0L) {
                if (plid == 0L) {
                    ctCollectionId = 0L;
                } else {
                    Layout layout = this._layoutPersistence.fetchByPrimaryKey(plid);
                    if (layout != null) {
                        ctCollectionId = layout.getCtCollectionId();
                    }
                }
            }
            try (SafeCloseable safeCloseable = CTCollectionThreadLocal.setCTCollectionIdWithSafeCloseable((long)ctCollectionId);){
                portletPreferences = this.portletPreferencesLocalService.addPortletPreferences(companyId, ownerId, ownerType, plid, portletId, portlet, defaultPreferences);
            }
        }
        return this._portletPreferenceValueLocalService.getPreferences(portletPreferences);
    }

    @Retry(acceptor=SQLStateAcceptor.class, properties={@Property(name="SQLSTATE", value="23")})
    public javax.portlet.PortletPreferences getPreferences(PortletPreferencesIds portletPreferencesIds) {
        return this.getPreferences(portletPreferencesIds.getCompanyId(), portletPreferencesIds.getOwnerId(), portletPreferencesIds.getOwnerType(), portletPreferencesIds.getPlid(), portletPreferencesIds.getPortletId());
    }

    public Map<String, javax.portlet.PortletPreferences> getStrictPreferences(Layout layout, List<Portlet> portlets) {
        long plid = layout.getPlid();
        plid = this._swapPlidForPreferences(plid);
        HashMap<String, javax.portlet.PortletPreferences> portletPreferencesMap = new HashMap<String, javax.portlet.PortletPreferences>();
        ArrayList portletPreferencesList = new ArrayList();
        portletPreferencesList.addAll(this.portletPreferencesPersistence.findByO_O_P(layout.getGroupId(), 3, 0L));
        portletPreferencesList.addAll(this.portletPreferencesPersistence.findByO_O_P(0L, 3, plid));
        for (Portlet portlet : portlets) {
            String preferences;
            String portletId;
            long preferencesPlid;
            int ownerType;
            long ownerId;
            block3: {
                block2: {
                    ownerId = 0L;
                    ownerType = 3;
                    preferencesPlid = plid;
                    portletId = portlet.getPortletId();
                    preferences = portlet.getDefaultPreferences();
                    if (!PortletIdCodec.hasUserId((String)portletId)) break block2;
                    ownerId = PortletIdCodec.decodeUserId((String)portletId);
                    PortletPreferences portletPreferences = this.portletPreferencesPersistence.fetchByO_O_P_P(ownerId, ownerType = 4, plid, portletId);
                    if (portletPreferences == null) break block3;
                    javax.portlet.PortletPreferences jxPortletPreferences = this._portletPreferenceValueLocalService.getPreferences(portletPreferences);
                    preferences = PortletPreferencesFactoryUtil.toXML((javax.portlet.PortletPreferences)jxPortletPreferences);
                    break block3;
                }
                for (PortletPreferences portletPreferences : portletPreferencesList) {
                    if (!portletId.equals(portletPreferences.getPortletId())) continue;
                    ownerId = portletPreferences.getOwnerId();
                    preferencesPlid = portletPreferences.getPlid();
                    javax.portlet.PortletPreferences jxPortletPreferences = this._portletPreferenceValueLocalService.getPreferences(portletPreferences);
                    preferences = PortletPreferencesFactoryUtil.toXML((javax.portlet.PortletPreferences)jxPortletPreferences);
                    break;
                }
            }
            portletPreferencesMap.put(portletId, PortletPreferencesFactoryUtil.strictFromXML((long)layout.getCompanyId(), (long)ownerId, (int)ownerType, (long)preferencesPlid, (String)portletId, (String)preferences));
        }
        return portletPreferencesMap;
    }

    public javax.portlet.PortletPreferences getStrictPreferences(long companyId, long ownerId, int ownerType, long plid, String portletId) {
        if (!this._exists(plid, companyId, portletId)) {
            return PortletPreferencesFactoryUtil.strictFromXML((long)companyId, (long)ownerId, (int)ownerType, (long)plid, (String)portletId, (String)"<portlet-preferences />");
        }
        PortletPreferences portletPreferences = this.portletPreferencesPersistence.fetchByO_O_P_P(ownerId, ownerType, plid = this._swapPlidForPreferences(plid), portletId);
        if (portletPreferences == null) {
            String defaultPreferences = "<portlet-preferences />";
            Portlet portlet = this._portletLocalService.fetchPortletById(companyId, portletId);
            if (portlet != null) {
                defaultPreferences = portlet.getDefaultPreferences();
            }
            return PortletPreferencesFactoryUtil.strictFromXML((long)companyId, (long)ownerId, (int)ownerType, (long)plid, (String)portletId, (String)defaultPreferences);
        }
        return this._portletPreferenceValueLocalService.getPreferences(portletPreferences);
    }

    public javax.portlet.PortletPreferences getStrictPreferences(PortletPreferencesIds portletPreferencesIds) {
        return this.getStrictPreferences(portletPreferencesIds.getCompanyId(), portletPreferencesIds.getOwnerId(), portletPreferencesIds.getOwnerType(), portletPreferencesIds.getPlid(), portletPreferencesIds.getPortletId());
    }

    public PortletPreferences updatePreferences(long ownerId, int ownerType, long plid, String portletId, javax.portlet.PortletPreferences portletPreferences) {
        if (portletPreferences instanceof PortletPreferencesImpl) {
            PortletPreferencesImpl portletPreferencesImpl = (PortletPreferencesImpl)portletPreferences;
            return this._updatePreferences(ownerId, ownerType, plid, portletId, portletPreferencesImpl.getPreferences());
        }
        HashMap<String, Preference> preferenceMap = new HashMap<String, Preference>();
        Map map = portletPreferences.getMap();
        for (Map.Entry entry : map.entrySet()) {
            String name = (String)entry.getKey();
            preferenceMap.put(name, new Preference(name, (String[])entry.getValue(), portletPreferences.isReadOnly(name)));
        }
        return this._updatePreferences(ownerId, ownerType, plid, portletId, preferenceMap);
    }

    public PortletPreferences updatePreferences(long ownerId, int ownerType, long plid, String portletId, String xml) {
        return this._updatePreferences(ownerId, ownerType, plid, portletId, PortletPreferencesFactoryImpl.createPreferencesMap(xml));
    }

    private boolean _exists(long plid, long companyId, String portletId) {
        return plid == 0L || this._portletLocalService.fetchPortletById(companyId, portletId) != null;
    }

    private boolean _exists(long plid, String portletId) {
        if (plid == 0L) {
            return true;
        }
        Layout layout = this._layoutPersistence.fetchByPrimaryKey(plid);
        if (layout == null) {
            return false;
        }
        return this._exists(plid, layout.getCompanyId(), portletId);
    }

    private LayoutRevision _getLayoutRevision(long plid) {
        if (plid <= 0L) {
            return null;
        }
        LayoutRevision layoutRevision = this._layoutRevisionPersistence.fetchByPrimaryKey(plid);
        if (layoutRevision != null) {
            return layoutRevision;
        }
        Layout layout = this._layoutPersistence.fetchByPrimaryKey(plid);
        if (layout == null) {
            return null;
        }
        if (LayoutStagingUtil.isBranchingLayout((Layout)layout)) {
            LayoutStagingHandler layoutStagingHandler = new LayoutStagingHandler(layout);
            return layoutStagingHandler.getLayoutRevision();
        }
        return null;
    }

    private List<PortletPreferenceValue> _getPortletPreferenceValues(Predicate predicate) {
        return (List)this._portletPreferenceValuePersistence.dslQuery((DSLQuery)DSLQueryFactoryUtil.select((Table)PortletPreferenceValueTable.INSTANCE).from((Table)PortletPreferenceValueTable.INSTANCE).innerJoinON((Table)PortletPreferencesTable.INSTANCE, PortletPreferencesTable.INSTANCE.portletPreferencesId.eq((Expression)PortletPreferenceValueTable.INSTANCE.portletPreferencesId)).where(predicate));
    }

    private javax.portlet.PortletPreferences _getStrictPreferences(long companyId, long ownerId, int ownerType, long plid, String portletId, String defaultPreferences) {
        PortletPreferences portletPreferences = this.portletPreferencesPersistence.fetchByO_O_P_P(ownerId, ownerType, plid, portletId);
        if (portletPreferences == null) {
            return PortletPreferencesFactoryUtil.strictFromXML((long)companyId, (long)ownerId, (int)ownerType, (long)plid, (String)portletId, (String)defaultPreferences);
        }
        return this._portletPreferenceValueLocalService.getPreferences(portletPreferences);
    }

    private long _swapPlidForPortletPreferences(long plid) {
        if (!StagingAdvicesThreadLocal.isEnabled()) {
            return plid;
        }
        LayoutRevision layoutRevision = this._getLayoutRevision(plid);
        if (layoutRevision == null) {
            return plid;
        }
        return layoutRevision.getLayoutRevisionId();
    }

    private long _swapPlidForPreferences(long plid) {
        if (!StagingAdvicesThreadLocal.isEnabled()) {
            return plid;
        }
        LayoutRevision layoutRevision = this._getLayoutRevision(plid);
        if (layoutRevision == null) {
            return plid;
        }
        User user = this._userPersistence.fetchByPrimaryKey(PrincipalThreadLocal.getUserId());
        if (user == null || user.isGuestUser()) {
            return layoutRevision.getLayoutRevisionId();
        }
        try {
            return StagingUtil.getRecentLayoutRevisionId((User)user, (long)layoutRevision.getLayoutSetBranchId(), (long)layoutRevision.getPlid());
        }
        catch (PortalException portalException) {
            return (Long)ReflectionUtil.throwException((Throwable)portalException);
        }
    }

    private long _swapPlidForUpdatePreferences(long plid) {
        if (!StagingAdvicesThreadLocal.isEnabled()) {
            return plid;
        }
        LayoutRevision layoutRevision = this._getLayoutRevision(plid);
        if (layoutRevision == null) {
            return plid;
        }
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext == null) {
            return plid;
        }
        boolean exporting = ParamUtil.getBoolean((ServiceContext)serviceContext, (String)"exporting");
        if (exporting) {
            return plid;
        }
        if (!MergeLayoutPrototypesThreadLocal.isInProgress()) {
            serviceContext.setWorkflowAction(2);
        }
        try {
            boolean hasWorkflowTask = StagingUtil.hasWorkflowTask((long)serviceContext.getUserId(), (LayoutRevision)layoutRevision);
            serviceContext.setAttribute("revisionInProgress", (Serializable)Boolean.valueOf(hasWorkflowTask));
            layoutRevision = this._layoutRevisionLocalService.updateLayoutRevision(serviceContext.getUserId(), layoutRevision.getLayoutRevisionId(), layoutRevision.getLayoutBranchId(), layoutRevision.getName(), layoutRevision.getTitle(), layoutRevision.getDescription(), layoutRevision.getKeywords(), layoutRevision.getRobots(), layoutRevision.getTypeSettings(), layoutRevision.getIconImage(), layoutRevision.getIconImageId(), layoutRevision.getThemeId(), layoutRevision.getColorSchemeId(), layoutRevision.getCss(), serviceContext);
        }
        catch (PortalException portalException) {
            ReflectionUtil.throwException((Throwable)portalException);
        }
        plid = layoutRevision.getLayoutRevisionId();
        ProxiedLayoutsThreadLocal.clearProxiedLayouts();
        return plid;
    }

    private void _updatePortletPreferences(PortletPreferences portletPreferences, Map<String, List<PortletPreferenceValue>> portletPreferenceValuesMap, Map<String, Preference> preferencesMap) {
        ArrayList<AbstractMap.SimpleImmutableEntry<List<PortletPreferenceValue>, Preference>> preferenceEntries = new ArrayList<AbstractMap.SimpleImmutableEntry<List<PortletPreferenceValue>, Preference>>(preferencesMap.size());
        int newCount = 0;
        for (Map.Entry<String, Preference> entry : preferencesMap.entrySet()) {
            Preference preference = entry.getValue();
            String[] stringArray = preference.getValues();
            if (stringArray == null) continue;
            int size = 0;
            List<PortletPreferenceValue> portletPreferenceValues = portletPreferenceValuesMap.remove(entry.getKey());
            if (portletPreferenceValues != null) {
                size = portletPreferenceValues.size();
            }
            if (stringArray.length > size) {
                newCount += stringArray.length - size;
            }
            preferenceEntries.add(new AbstractMap.SimpleImmutableEntry<List<PortletPreferenceValue>, Preference>(portletPreferenceValues, preference));
        }
        for (List list : portletPreferenceValuesMap.values()) {
            for (PortletPreferenceValue portletPreferenceValue : list) {
                this._portletPreferenceValuePersistence.remove((BaseModel)portletPreferenceValue);
            }
        }
        long batchCounter = 0L;
        if (newCount > 0) {
            batchCounter = this.counterLocalService.increment(PortletPreferenceValue.class.getName(), newCount);
            batchCounter -= (long)newCount;
        }
        for (Map.Entry entry : preferenceEntries) {
            int i;
            List portletPreferenceValues = (List)entry.getKey();
            Preference preference = (Preference)entry.getValue();
            String[] newValues = preference.getValues();
            int oldSize = 0;
            if (portletPreferenceValues != null) {
                oldSize = portletPreferenceValues.size();
            }
            for (i = 0; i < newValues.length; ++i) {
                PortletPreferenceValue portletPreferenceValue;
                String value = newValues[i];
                boolean readOnly = preference.isReadOnly();
                if (oldSize > i) {
                    portletPreferenceValue = (PortletPreferenceValue)portletPreferenceValues.get(i);
                    if (Objects.equals(newValues[i], portletPreferenceValue.getValue()) && preference.isReadOnly() == portletPreferenceValue.isReadOnly()) continue;
                    portletPreferenceValue.setReadOnly(readOnly);
                    portletPreferenceValue.setValue(value);
                    this._portletPreferenceValuePersistence.update((BaseModel)portletPreferenceValue);
                    continue;
                }
                portletPreferenceValue = this._portletPreferenceValuePersistence.create(++batchCounter);
                portletPreferenceValue.setCompanyId(portletPreferences.getCompanyId());
                portletPreferenceValue.setPortletPreferencesId(portletPreferences.getPortletPreferencesId());
                portletPreferenceValue.setIndex(i);
                portletPreferenceValue.setName(preference.getName());
                portletPreferenceValue.setReadOnly(readOnly);
                portletPreferenceValue.setValue(value);
                this._portletPreferenceValuePersistence.update((BaseModel)portletPreferenceValue);
            }
            for (i = newValues.length; i < oldSize; ++i) {
                this._portletPreferenceValuePersistence.remove((BaseModel)portletPreferenceValues.get(i));
            }
        }
    }

    private PortletPreferences _updatePreferences(long ownerId, int ownerType, long plid, String portletId, Map<String, Preference> preferenceMap) {
        LayoutStagingHandler layoutStagingHandler;
        LayoutRevision layoutRevision;
        Layout layout;
        if (CopyLayoutThreadLocal.isCopyLayout() && (layout = this._layoutPersistence.fetchByPrimaryKey(plid)) != null && LayoutStagingUtil.isBranchingLayout((Layout)layout) && (layoutRevision = (layoutStagingHandler = new LayoutStagingHandler(layout)).getLayoutRevision()) != null) {
            this._updatePreferences(ownerId, ownerType, layoutRevision.getLayoutRevisionId(), portletId, preferenceMap);
        }
        plid = this._swapPlidForUpdatePreferences(plid);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Update {ownerId=", ownerId, ", ownerType=", ownerType, ", plid=", plid, ", portletId=", portletId, ", preferenceMap=", preferenceMap, "}"}));
        }
        PortletPreferences portletPreferences = this.portletPreferencesPersistence.fetchByO_O_P_P(ownerId, ownerType, plid, portletId);
        Map<String, List<PortletPreferenceValue>> portletPreferenceValuesMap = Collections.emptyMap();
        if (portletPreferences == null) {
            long portletPreferencesId = this.counterLocalService.increment();
            portletPreferences = this.portletPreferencesPersistence.create(portletPreferencesId);
            portletPreferences.setOwnerId(ownerId);
            portletPreferences.setOwnerType(ownerType);
            portletPreferences.setPlid(plid);
            portletPreferences.setPortletId(portletId);
        } else {
            portletPreferenceValuesMap = PortletPreferenceValueLocalServiceImpl.getPortletPreferenceValuesMap(this._portletPreferenceValuePersistence, portletPreferences.getPortletPreferencesId());
        }
        this._updatePortletPreferences(portletPreferences, portletPreferenceValuesMap, preferenceMap);
        return (PortletPreferences)this.portletPreferencesPersistence.update((BaseModel)portletPreferences);
    }
}

