/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.language;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletApp;
import com.liferay.portal.kernel.portlet.PortletConfigFactoryUtil;
import com.liferay.portal.kernel.servlet.BufferCacheServletResponse;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.util.AggregateResourceBundle;
import com.liferay.portal.kernel.util.DigesterUtil;
import com.liferay.portal.kernel.util.HttpComponentsUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.language.LanguageResources;
import com.liferay.portal.servlet.filters.BasePortalFilter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import javax.portlet.PortletConfig;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;

public class LanguageFilter
extends BasePortalFilter {
    private static final Log _log = LogFactoryUtil.getLog(LanguageFilter.class);
    private PortletConfig _portletConfig;

    public void init(FilterConfig filterConfig) {
        super.init(filterConfig);
        ServletContext servletContext = filterConfig.getServletContext();
        PortletApp portletApp = (PortletApp)servletContext.getAttribute("com.liferay.portal.kernel.model.PortletApp");
        if (portletApp == null || !portletApp.isWARFile()) {
            return;
        }
        List portlets = portletApp.getPortlets();
        if (portlets.size() <= 0) {
            return;
        }
        this._portletConfig = PortletConfigFactoryUtil.create((Portlet)((Portlet)portlets.get(0)), (ServletContext)filterConfig.getServletContext());
    }

    protected void processFilter(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws Exception {
        httpServletResponse.setHeader("Cache-Control", "private, no-cache");
        BufferCacheServletResponse bufferCacheServletResponse = new BufferCacheServletResponse(httpServletResponse);
        this.processFilter(LanguageFilter.class.getName(), (HttpServletRequest)new NoCacheHttpServletRequestWrapper(httpServletRequest), (HttpServletResponse)bufferCacheServletResponse, filterChain);
        if (_log.isDebugEnabled()) {
            String completeURL = HttpComponentsUtil.getCompleteURL((HttpServletRequest)httpServletRequest);
            _log.debug((Object)("Translating response " + completeURL));
        }
        String content = bufferCacheServletResponse.getString();
        content = this.translateResponse(httpServletRequest, content);
        String eTag = "\"" + DigesterUtil.digest((String)"SHA-1", (String[])new String[]{content}) + "\"";
        httpServletResponse.setHeader("ETag", eTag);
        String ifNoneMatch = httpServletRequest.getHeader("If-None-Match");
        if (ifNoneMatch != null && ifNoneMatch.equals(eTag)) {
            httpServletResponse.setStatus(304);
            return;
        }
        ServletResponseUtil.write((HttpServletResponse)httpServletResponse, (String)content);
    }

    protected String translateResponse(HttpServletRequest httpServletRequest, String content) {
        Locale locale = LocaleUtil.fromLanguageId((String)LanguageUtil.getLanguageId((HttpServletRequest)httpServletRequest));
        return LanguageUtil.process(() -> {
            ResourceBundle resourceBundle = LanguageResources.getResourceBundle(locale);
            if (this._portletConfig != null) {
                resourceBundle = new AggregateResourceBundle(new ResourceBundle[]{this._portletConfig.getResourceBundle(locale), resourceBundle});
            }
            return resourceBundle;
        }, (Locale)locale, (String)content);
    }

    private static class NoCacheHttpServletRequestWrapper
    extends HttpServletRequestWrapper {
        private final HttpServletRequest _httpServletRequest;

        public NoCacheHttpServletRequestWrapper(HttpServletRequest httpServletRequest) {
            super(httpServletRequest);
            this._httpServletRequest = httpServletRequest;
        }

        public long getDateHeader(String name) {
            if (StringUtil.equalsIgnoreCase((String)name, (String)"If-Modified-Since") || StringUtil.equalsIgnoreCase((String)name, (String)"If-None-Match")) {
                return -1L;
            }
            return this._httpServletRequest.getDateHeader(name);
        }

        public String getHeader(String name) {
            if (StringUtil.equalsIgnoreCase((String)name, (String)"If-Modified-Since") || StringUtil.equalsIgnoreCase((String)name, (String)"If-None-Match")) {
                return null;
            }
            return this._httpServletRequest.getHeader(name);
        }

        public Enumeration<String> getHeaderNames() {
            final ArrayList<String> headerNames = new ArrayList<String>();
            Enumeration enumeration = this._httpServletRequest.getHeaderNames();
            while (enumeration.hasMoreElements()) {
                String name = (String)enumeration.nextElement();
                if (StringUtil.equalsIgnoreCase((String)name, (String)"If-Modified-Since") || StringUtil.equalsIgnoreCase((String)name, (String)"If-None-Match")) continue;
                headerNames.add(name);
            }
            return new Enumeration<String>(){
                private int _nextIndex;

                @Override
                public boolean hasMoreElements() {
                    return this._nextIndex < headerNames.size();
                }

                @Override
                public String nextElement() {
                    if (!this.hasMoreElements()) {
                        throw new NoSuchElementException();
                    }
                    ++this._nextIndex;
                    return (String)headerNames.get(this._nextIndex - 1);
                }
            };
        }

        public Enumeration<String> getHeaders(String name) {
            if (StringUtil.equalsIgnoreCase((String)name, (String)"If-Modified-Since") || StringUtil.equalsIgnoreCase((String)name, (String)"If-None-Match")) {
                return null;
            }
            return this._httpServletRequest.getHeaders(name);
        }

        public int getIntHeader(String name) {
            if (StringUtil.equalsIgnoreCase((String)name, (String)"If-Modified-Since") || StringUtil.equalsIgnoreCase((String)name, (String)"If-None-Match")) {
                return -1;
            }
            return this._httpServletRequest.getIntHeader(name);
        }
    }
}

