/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.virtualhost;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.NoSuchLayoutException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.struts.LastPath;
import com.liferay.portal.kernel.util.HttpComponentsUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.impl.LayoutImpl;
import com.liferay.portal.servlet.I18nServlet;
import com.liferay.portal.servlet.filters.BasePortalFilter;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.webserver.WebServerServlet;
import java.util.Map;
import java.util.Objects;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class VirtualHostFilter
extends BasePortalFilter {
    private static final String _PATH_DOCUMENTS = "/documents/";
    private static final String _PATH_MODULE_SLASH = "/o/";
    private static final String _PRIVATE_GROUP_SERVLET_MAPPING = PropsValues.LAYOUT_FRIENDLY_URL_PRIVATE_GROUP_SERVLET_MAPPING;
    private static final String _PRIVATE_GROUP_SERVLET_MAPPING_SLASH = _PRIVATE_GROUP_SERVLET_MAPPING + "/";
    private static final String _PRIVATE_USER_SERVLET_MAPPING = PropsValues.LAYOUT_FRIENDLY_URL_PRIVATE_USER_SERVLET_MAPPING;
    private static final String _PRIVATE_USER_SERVLET_MAPPING_SLASH = _PRIVATE_USER_SERVLET_MAPPING + "/";
    private static final String _PUBLIC_GROUP_SERVLET_MAPPING = PropsValues.LAYOUT_FRIENDLY_URL_PUBLIC_SERVLET_MAPPING;
    private static final String _PUBLIC_GROUP_SERVLET_MAPPING_SLASH = _PUBLIC_GROUP_SERVLET_MAPPING + "/";
    private static final String _WIDGET_SERVLET_MAPPING_SLASH = PropsValues.WIDGET_SERVLET_MAPPING + "/";
    private static final Log _log = LogFactoryUtil.getLog(VirtualHostFilter.class);
    private String _contextPath;
    private String _originalContextPath;
    private ServletContext _servletContext;

    public void init(FilterConfig filterConfig) {
        super.init(filterConfig);
        this._servletContext = filterConfig.getServletContext();
        String contextPath = this._originalContextPath = PortalUtil.getPathContext();
        String proxyPath = PortalUtil.getPathProxy();
        if (!contextPath.isEmpty() && !proxyPath.isEmpty() && contextPath.startsWith(proxyPath)) {
            contextPath = contextPath.substring(proxyPath.length());
        }
        this._contextPath = contextPath;
    }

    public boolean isFilterEnabled(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String uri = httpServletRequest.getRequestURI();
        for (String extension : PropsValues.VIRTUAL_HOSTS_IGNORE_EXTENSIONS) {
            if (!uri.endsWith(extension)) continue;
            return false;
        }
        return true;
    }

    protected boolean isDocumentFriendlyURL(HttpServletRequest httpServletRequest, long groupId, String friendlyURL) throws PortalException {
        if (friendlyURL.startsWith(_PATH_DOCUMENTS) && WebServerServlet.hasFiles(httpServletRequest)) {
            String path = HttpComponentsUtil.fixPath((String)httpServletRequest.getPathInfo());
            String[] pathArray = StringUtil.split((String)path, (char)'/');
            if (pathArray.length == 2) {
                try {
                    LayoutLocalServiceUtil.getFriendlyURLLayout((long)groupId, (boolean)false, (String)friendlyURL);
                }
                catch (NoSuchLayoutException noSuchLayoutException) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Throwable)noSuchLayoutException);
                    }
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    protected boolean isValidFriendlyURL(String friendlyURL) {
        if (PortalInstances.isVirtualHostsIgnorePath(friendlyURL = StringUtil.toLowerCase((String)friendlyURL)) || friendlyURL.startsWith(_PATH_MODULE_SLASH) || friendlyURL.startsWith(_PRIVATE_GROUP_SERVLET_MAPPING_SLASH) || friendlyURL.startsWith(_PRIVATE_USER_SERVLET_MAPPING_SLASH) || friendlyURL.startsWith(_PUBLIC_GROUP_SERVLET_MAPPING_SLASH) || LayoutImpl.hasFriendlyURLKeyword(friendlyURL)) {
            return false;
        }
        int code = LayoutImpl.validateFriendlyURL(friendlyURL, false);
        return code <= -1 || code == 2;
    }

    protected void processFilter(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws Exception {
        String i18nLanguageId;
        int pos;
        String originalFriendlyURL = HttpComponentsUtil.normalizePath((String)httpServletRequest.getRequestURI());
        String friendlyURL = originalFriendlyURL;
        if (!friendlyURL.equals("/") && !this._contextPath.isEmpty() && friendlyURL.length() > this._contextPath.length() && friendlyURL.startsWith(this._contextPath) && friendlyURL.charAt(this._contextPath.length()) == '/') {
            friendlyURL = friendlyURL.substring(this._contextPath.length());
        }
        if ((pos = friendlyURL.indexOf(59)) != -1) {
            friendlyURL = friendlyURL.substring(0, pos);
        }
        if ((i18nLanguageId = this._findLanguageId(friendlyURL)) != null) {
            friendlyURL = friendlyURL.substring(i18nLanguageId.length());
        }
        int widgetServletMappingPos = 0;
        if (friendlyURL.contains(_WIDGET_SERVLET_MAPPING_SLASH)) {
            friendlyURL = StringUtil.replaceFirst((String)friendlyURL, (String)PropsValues.WIDGET_SERVLET_MAPPING, (String)"");
            widgetServletMappingPos = PropsValues.WIDGET_SERVLET_MAPPING.length();
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Friendly URL " + friendlyURL));
        }
        if (!friendlyURL.equals("/") && !this.isValidFriendlyURL(friendlyURL)) {
            int offset;
            _log.debug((Object)"Friendly URL is not valid");
            if (i18nLanguageId != null && !originalFriendlyURL.regionMatches(offset = originalFriendlyURL.length() - friendlyURL.length() - (i18nLanguageId.length() + widgetServletMappingPos), i18nLanguageId, 0, i18nLanguageId.length())) {
                String forwardURL = originalFriendlyURL;
                if (offset > 0) {
                    String prefix = originalFriendlyURL.substring(0, offset);
                    forwardURL = prefix.concat(i18nLanguageId);
                } else {
                    forwardURL = i18nLanguageId;
                }
                forwardURL = forwardURL.concat(friendlyURL);
                RequestDispatcher requestDispatcher = this._servletContext.getRequestDispatcher(forwardURL);
                requestDispatcher.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
                return;
            }
            this.processFilter(VirtualHostFilter.class.getName(), httpServletRequest, httpServletResponse, filterChain);
            return;
        }
        LayoutSet layoutSet = (LayoutSet)httpServletRequest.getAttribute("VIRTUAL_HOST_LAYOUT_SET");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Layout set " + layoutSet));
        }
        if (layoutSet == null) {
            this.processFilter(VirtualHostFilter.class.getName(), httpServletRequest, httpServletResponse, filterChain);
            WebServerServlet.sendMessageObjectEntryAttachmentDownload(httpServletRequest, null);
            return;
        }
        long companyId = PortalInstances.getCompanyId(httpServletRequest);
        try {
            Map parameterMap = httpServletRequest.getParameterMap();
            String parameters = "";
            if (!parameterMap.isEmpty()) {
                parameters = HttpComponentsUtil.parameterMapToString((Map)parameterMap);
            }
            LastPath lastPath = new LastPath(this._originalContextPath, friendlyURL, parameters);
            httpServletRequest.setAttribute("LAST_PATH", (Object)lastPath);
            StringBundler sb = new StringBundler(5);
            if (i18nLanguageId != null) {
                sb.append(i18nLanguageId);
            }
            if (originalFriendlyURL.startsWith(PropsValues.WIDGET_SERVLET_MAPPING)) {
                sb.append(PropsValues.WIDGET_SERVLET_MAPPING);
                friendlyURL = StringUtil.replaceFirst((String)friendlyURL, (String)PropsValues.WIDGET_SERVLET_MAPPING, (String)"");
            }
            if (friendlyURL.equals("/") || PortalUtil.getPlidFromFriendlyURL((long)companyId, (String)friendlyURL) <= 0L) {
                Group group = layoutSet.getGroup();
                if (this.isDocumentFriendlyURL(httpServletRequest, group.getGroupId(), friendlyURL)) {
                    this.processFilter(VirtualHostFilter.class.getName(), httpServletRequest, httpServletResponse, filterChain);
                    return;
                }
                if (Objects.equals(group.getGroupKey(), PropsValues.VIRTUAL_HOSTS_DEFAULT_SITE_NAME) && friendlyURL.equals("/") && !layoutSet.isPrivateLayout()) {
                    String homeURL = PortalUtil.getRelativeHomeURL((HttpServletRequest)httpServletRequest);
                    if (Validator.isNotNull((String)homeURL)) {
                        friendlyURL = homeURL;
                    }
                    if (friendlyURL.equals("/")) {
                        if (layoutSet.isPrivateLayout()) {
                            if (group.isUser()) {
                                sb.append(_PRIVATE_USER_SERVLET_MAPPING);
                            } else {
                                sb.append(_PRIVATE_GROUP_SERVLET_MAPPING);
                            }
                        } else {
                            sb.append(_PUBLIC_GROUP_SERVLET_MAPPING);
                        }
                        sb.append(group.getFriendlyURL());
                    }
                } else {
                    if (layoutSet.isPrivateLayout()) {
                        if (group.isUser()) {
                            sb.append(_PRIVATE_USER_SERVLET_MAPPING);
                        } else {
                            sb.append(_PRIVATE_GROUP_SERVLET_MAPPING);
                        }
                    } else {
                        sb.append(_PUBLIC_GROUP_SERVLET_MAPPING);
                    }
                    sb.append(group.getFriendlyURL());
                }
            }
            String forwardURLString = friendlyURL;
            if (sb.index() > 0) {
                sb.append(friendlyURL);
                forwardURLString = sb.toString();
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Forward to " + forwardURLString));
            }
            RequestDispatcher requestDispatcher = this._servletContext.getRequestDispatcher(forwardURLString);
            requestDispatcher.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            this.processFilter(VirtualHostFilter.class.getName(), httpServletRequest, httpServletResponse, filterChain);
        }
    }

    private String _findLanguageId(String friendlyURL) {
        if (friendlyURL.isEmpty() || friendlyURL.charAt(0) != '/') {
            return null;
        }
        String lowerCaseLanguageId = friendlyURL;
        int index = friendlyURL.indexOf(47, 1);
        if (index != -1) {
            lowerCaseLanguageId = friendlyURL.substring(0, index);
        }
        lowerCaseLanguageId = StringUtil.toLowerCase((String)lowerCaseLanguageId);
        Map<String, String> languageIds = I18nServlet.getLanguageIdsMap();
        String languageId = languageIds.get(lowerCaseLanguageId);
        if (languageId == null) {
            return null;
        }
        return languageId;
    }
}

