/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.template;

import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheException;
import com.liferay.portal.kernel.cache.PortalCacheHelperUtil;
import com.liferay.portal.kernel.cache.PortalCacheListener;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.template.StringTemplateResource;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.template.TemplateResourceCache;
import com.liferay.portal.kernel.template.URLTemplateResource;
import com.liferay.portal.kernel.util.ProxyFactory;
import com.liferay.portal.template.CacheTemplateResource;
import java.io.Serializable;

public abstract class BaseTemplateResourceCache
implements TemplateResourceCache {
    protected static final TemplateResource DUMMY_TEMPLATE_RESOURCE = (TemplateResource)ProxyFactory.newDummyInstance(TemplateResource.class);
    private static final Log _log = LogFactoryUtil.getLog(BaseTemplateResourceCache.class);
    private volatile long _modificationCheckInterval;
    private PortalCache<String, TemplateResource> _multiVMPortalCache;
    private PortalCache<TemplateResource, ?> _secondLevelPortalCache;
    private PortalCache<String, TemplateResource> _singleVMPortalCache;

    public void clear() {
        if (!this.isEnabled()) {
            return;
        }
        this._multiVMPortalCache.removeAll();
        this._singleVMPortalCache.removeAll();
    }

    public <T> PortalCache<TemplateResource, T> getSecondLevelPortalCache() {
        return this._secondLevelPortalCache;
    }

    public TemplateResource getTemplateResource(String templateId) {
        if (!this.isEnabled()) {
            return null;
        }
        TemplateResource templateResource = (TemplateResource)this._singleVMPortalCache.get((Serializable)((Object)templateId));
        if (templateResource == null) {
            templateResource = (TemplateResource)this._multiVMPortalCache.get((Serializable)((Object)templateId));
        }
        if (templateResource != null && templateResource != DUMMY_TEMPLATE_RESOURCE && this._modificationCheckInterval > 0L) {
            long expireTime = templateResource.getLastModified() + this._modificationCheckInterval;
            if (System.currentTimeMillis() > expireTime) {
                this.remove(templateId);
                templateResource = null;
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Remove expired template resource " + templateId));
                }
            }
        }
        return templateResource;
    }

    public boolean isEnabled() {
        return this._modificationCheckInterval != 0L;
    }

    public void put(String templateId, TemplateResource templateResource) {
        if (!this.isEnabled()) {
            return;
        }
        if (templateResource == null) {
            this._singleVMPortalCache.put((Serializable)((Object)templateId), (Object)DUMMY_TEMPLATE_RESOURCE);
        } else if (templateResource instanceof URLTemplateResource) {
            this._singleVMPortalCache.put((Serializable)((Object)templateId), (Object)new CacheTemplateResource(templateResource));
        } else if (templateResource instanceof CacheTemplateResource || templateResource instanceof StringTemplateResource) {
            this._multiVMPortalCache.put((Serializable)((Object)templateId), (Object)templateResource);
        } else {
            this._multiVMPortalCache.put((Serializable)((Object)templateId), (Object)new CacheTemplateResource(templateResource));
        }
    }

    public void remove(String templateId) {
        if (!this.isEnabled()) {
            return;
        }
        this._multiVMPortalCache.remove((Serializable)((Object)templateId));
        this._singleVMPortalCache.remove((Serializable)((Object)templateId));
    }

    protected void destroy() {
        PortalCacheHelperUtil.removePortalCache((String)"MULTI_VM_PORTAL_CACHE_MANAGER", (String)this._multiVMPortalCache.getPortalCacheName());
        PortalCacheHelperUtil.removePortalCache((String)"SINGLE_VM_PORTAL_CACHE_MANAGER", (String)this._singleVMPortalCache.getPortalCacheName());
        PortalCacheHelperUtil.removePortalCache((String)"SINGLE_VM_PORTAL_CACHE_MANAGER", (String)this._secondLevelPortalCache.getPortalCacheName());
    }

    protected void init(long modificationCheckInterval, String portalCacheName, String secondLevelPortalCacheName) {
        this._modificationCheckInterval = modificationCheckInterval;
        this._multiVMPortalCache = PortalCacheHelperUtil.getPortalCache((String)"MULTI_VM_PORTAL_CACHE_MANAGER", (String)portalCacheName);
        this._singleVMPortalCache = PortalCacheHelperUtil.getPortalCache((String)"SINGLE_VM_PORTAL_CACHE_MANAGER", (String)portalCacheName);
        this._secondLevelPortalCache = PortalCacheHelperUtil.getPortalCache((String)"SINGLE_VM_PORTAL_CACHE_MANAGER", (String)secondLevelPortalCacheName);
        this._setSecondLevelPortalCache(this._secondLevelPortalCache);
    }

    protected void setModificationCheckInterval(long modificationCheckInterval) {
        this._modificationCheckInterval = modificationCheckInterval;
    }

    private void _setSecondLevelPortalCache(PortalCache<TemplateResource, ?> portalCache) {
        TemplateResourcePortalCacheListener templateResourcePortalCacheListener = new TemplateResourcePortalCacheListener(portalCache);
        this._multiVMPortalCache.registerPortalCacheListener((PortalCacheListener)templateResourcePortalCacheListener);
        this._singleVMPortalCache.registerPortalCacheListener((PortalCacheListener)templateResourcePortalCacheListener);
    }

    private class TemplateResourcePortalCacheListener
    implements PortalCacheListener<String, TemplateResource> {
        private final PortalCache<TemplateResource, ?> _portalCache;

        public void dispose() {
        }

        public void notifyEntryEvicted(PortalCache<String, TemplateResource> portalCache, String key, TemplateResource templateResource, int timeToLive) throws PortalCacheException {
            if (templateResource != null) {
                this._portalCache.remove((Serializable)templateResource);
            }
        }

        public void notifyEntryExpired(PortalCache<String, TemplateResource> portalCache, String key, TemplateResource templateResource, int timeToLive) throws PortalCacheException {
            if (templateResource != null) {
                this._portalCache.remove((Serializable)templateResource);
            }
        }

        public void notifyEntryPut(PortalCache<String, TemplateResource> portalCache, String key, TemplateResource templateResource, int timeToLive) throws PortalCacheException {
        }

        public void notifyEntryRemoved(PortalCache<String, TemplateResource> portalCache, String key, TemplateResource templateResource, int timeToLive) throws PortalCacheException {
            if (templateResource != null) {
                this._portalCache.remove((Serializable)templateResource);
            }
        }

        public void notifyEntryUpdated(PortalCache<String, TemplateResource> portalCache, String key, TemplateResource templateResource, int timeToLive) throws PortalCacheException {
            if (templateResource != null) {
                this._portalCache.remove((Serializable)templateResource);
            }
        }

        public void notifyRemoveAll(PortalCache<String, TemplateResource> portalCache) throws PortalCacheException {
            this._portalCache.removeAll();
        }

        private TemplateResourcePortalCacheListener(PortalCache<TemplateResource, ?> portalCache) {
            this._portalCache = portalCache;
        }
    }
}

