/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.portal.cache.key.SimpleCacheKeyGenerator;
import com.liferay.portal.json.JSONFactoryImpl;
import com.liferay.portal.kernel.cache.MultiVMPool;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheException;
import com.liferay.portal.kernel.cache.PortalCacheListener;
import com.liferay.portal.kernel.cache.PortalCacheListenerScope;
import com.liferay.portal.kernel.cache.PortalCacheManager;
import com.liferay.portal.kernel.cache.PortalCacheManagerListener;
import com.liferay.portal.kernel.cache.PortalCacheManagerProvider;
import com.liferay.portal.kernel.cache.SingleVMPool;
import com.liferay.portal.kernel.cache.key.CacheKeyGenerator;
import com.liferay.portal.kernel.cache.key.CacheKeyGeneratorUtil;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.model.ModelHints;
import com.liferay.portal.kernel.model.ModelHintsUtil;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.security.auth.DefaultFullNameGenerator;
import com.liferay.portal.kernel.security.auth.FullNameGenerator;
import com.liferay.portal.kernel.security.permission.ResourceActions;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.security.xml.SecureXMLFactoryProvider;
import com.liferay.portal.kernel.security.xml.SecureXMLFactoryProviderUtil;
import com.liferay.portal.kernel.util.Digester;
import com.liferay.portal.kernel.util.DigesterUtil;
import com.liferay.portal.kernel.util.FastDateFormatFactory;
import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import com.liferay.portal.kernel.util.File;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.FriendlyURLNormalizer;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.xml.SAXReader;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.xml.UnsecureSAXReaderUtil;
import com.liferay.portal.model.DefaultModelHintsImpl;
import com.liferay.portal.security.permission.ResourceActionsImpl;
import com.liferay.portal.security.xml.SecureXMLFactoryProviderImpl;
import com.liferay.portal.util.DigesterImpl;
import com.liferay.portal.util.FastDateFormatFactoryImpl;
import com.liferay.portal.util.FileImpl;
import com.liferay.portal.util.InitUtil;
import com.liferay.portal.util.PortalImpl;
import com.liferay.portal.xml.SAXReaderImpl;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.osgi.framework.BundleContext;

public class ToolDependencies {
    public static void wireBasic() {
        InitUtil.init();
        ToolDependencies.wireCaches();
        BundleContext bundleContext = SystemBundleUtil.getBundleContext();
        bundleContext.registerService(FriendlyURLNormalizer.class, (Object)((FriendlyURLNormalizer)ProxyUtil.newProxyInstance((ClassLoader)ToolDependencies.class.getClassLoader(), (Class[])new Class[]{FriendlyURLNormalizer.class}, (proxy, method, args) -> null)), null);
        bundleContext.registerService(FullNameGenerator.class, (Object)new DefaultFullNameGenerator(), null);
        CacheKeyGeneratorUtil cacheKeyGeneratorUtil = new CacheKeyGeneratorUtil();
        cacheKeyGeneratorUtil.setDefaultCacheKeyGenerator((CacheKeyGenerator)new SimpleCacheKeyGenerator());
        DigesterUtil digesterUtil = new DigesterUtil();
        digesterUtil.setDigester((Digester)new DigesterImpl());
        FastDateFormatFactoryUtil fastDateFormatFactoryUtil = new FastDateFormatFactoryUtil();
        fastDateFormatFactoryUtil.setFastDateFormatFactory((FastDateFormatFactory)new FastDateFormatFactoryImpl());
        FileUtil fileUtil = new FileUtil();
        fileUtil.setFile((File)new FileImpl());
        JSONFactoryUtil jsonFactoryUtil = new JSONFactoryUtil();
        jsonFactoryUtil.setJSONFactory((JSONFactory)new JSONFactoryImpl());
        SAXReaderUtil saxReaderUtil = new SAXReaderUtil();
        SAXReaderImpl secureSAXReaderImpl = new SAXReaderImpl();
        secureSAXReaderImpl.setSecure(true);
        saxReaderUtil.setSAXReader((SAXReader)secureSAXReaderImpl);
        SecureXMLFactoryProviderUtil secureXMLFactoryProviderUtil = new SecureXMLFactoryProviderUtil();
        secureXMLFactoryProviderUtil.setSecureXMLFactoryProvider((SecureXMLFactoryProvider)new SecureXMLFactoryProviderImpl());
        UnsecureSAXReaderUtil unsecureSAXReaderUtil = new UnsecureSAXReaderUtil();
        unsecureSAXReaderUtil.setSAXReader((SAXReader)new SAXReaderImpl());
        ModelHintsUtil modelHintsUtil = new ModelHintsUtil();
        DefaultModelHintsImpl defaultModelHintsImpl = new DefaultModelHintsImpl();
        defaultModelHintsImpl.afterPropertiesSet();
        modelHintsUtil.setModelHints((ModelHints)defaultModelHintsImpl);
    }

    public static void wireCaches() {
        BundleContext bundleContext = SystemBundleUtil.getBundleContext();
        bundleContext.registerService(PortalCacheManager.class, new TestPortalCacheManager("MULTI_VM_PORTAL_CACHE_MANAGER"), null);
        bundleContext.registerService(PortalCacheManager.class, new TestPortalCacheManager("SINGLE_VM_PORTAL_CACHE_MANAGER"), null);
        bundleContext.registerService(MultiVMPool.class, (Object)new TestMultiVMPool(), null);
        bundleContext.registerService(SingleVMPool.class, (Object)new TestSingleVMPool(), null);
    }

    public static void wireDeployers() {
        ToolDependencies.wireBasic();
        PortalUtil portalUtil = new PortalUtil();
        portalUtil.setPortal((Portal)new PortalImpl());
    }

    public static void wireServiceBuilder() {
        ToolDependencies.wireDeployers();
        ResourceActionsUtil resourceActionsUtil = new ResourceActionsUtil();
        resourceActionsUtil.setResourceActions((ResourceActions)new ResourceActionsImpl());
    }

    private static class TestSingleVMPool
    implements SingleVMPool {
        private final PortalCacheManager<? extends Serializable, ?> _portalCacheManager = PortalCacheManagerProvider.getPortalCacheManager((String)"SINGLE_VM_PORTAL_CACHE_MANAGER");

        private TestSingleVMPool() {
        }

        public void clear() {
            this._portalCacheManager.clearAll();
        }

        public PortalCache<? extends Serializable, ?> getPortalCache(String portalCacheName) {
            return this._portalCacheManager.getPortalCache(portalCacheName);
        }

        public PortalCacheManager<? extends Serializable, ?> getPortalCacheManager() {
            return this._portalCacheManager;
        }

        public void removePortalCache(String portalCacheName) {
            this._portalCacheManager.removePortalCache(portalCacheName);
        }
    }

    private static class TestPortalCacheManager<K extends Serializable, V>
    implements PortalCacheManager<K, V> {
        private final String _portalCacheManagerName;
        private final ConcurrentMap<String, PortalCache<K, V>> _portalCaches = new ConcurrentHashMap<String, PortalCache<K, V>>();

        public void clearAll() throws PortalCacheException {
            for (PortalCache portalCache : this._portalCaches.values()) {
                portalCache.removeAll();
            }
        }

        public void destroy() {
            this._portalCaches.clear();
        }

        public PortalCache<K, V> fetchPortalCache(String portalCacheName) {
            return (PortalCache)this._portalCaches.get(portalCacheName);
        }

        public PortalCache<K, V> getPortalCache(String portalCacheName) throws PortalCacheException {
            return this.getPortalCache(portalCacheName, false);
        }

        public PortalCache<K, V> getPortalCache(String portalCacheName, boolean mvcc) throws PortalCacheException {
            return this.getPortalCache(portalCacheName, mvcc, false);
        }

        public PortalCache<K, V> getPortalCache(String portalCacheName, boolean mvcc, boolean sharded) throws PortalCacheException {
            TestPortalCache portalCache = (TestPortalCache)this._portalCaches.get(portalCacheName);
            if (portalCache != null) {
                return portalCache;
            }
            portalCache = new TestPortalCache(portalCacheName);
            PortalCache previousPortalCache = this._portalCaches.putIfAbsent(portalCacheName, portalCache);
            if (previousPortalCache != null) {
                return previousPortalCache;
            }
            return portalCache;
        }

        public Set<PortalCacheManagerListener> getPortalCacheManagerListeners() {
            return Collections.emptySet();
        }

        public String getPortalCacheManagerName() {
            return this._portalCacheManagerName;
        }

        public void reconfigurePortalCaches(URL configurationURL, ClassLoader classLoader) {
        }

        public boolean registerPortalCacheManagerListener(PortalCacheManagerListener portalCacheManagerListener) {
            return false;
        }

        public void removePortalCache(String portalCacheName) {
            this._portalCaches.remove(portalCacheName);
        }

        public void removePortalCaches(long companyId) {
        }

        public boolean unregisterPortalCacheManagerListener(PortalCacheManagerListener portalCacheManagerListener) {
            return false;
        }

        public void unregisterPortalCacheManagerListeners() {
        }

        private TestPortalCacheManager(String portalCacheManagerName) {
            this._portalCacheManagerName = portalCacheManagerName;
        }
    }

    private static class TestPortalCache<K extends Serializable, V>
    implements PortalCache<K, V> {
        private final Map<K, V> _map = new ConcurrentHashMap();
        private final List<PortalCacheListener<K, V>> _portalCacheListeners = new ArrayList<PortalCacheListener<K, V>>();
        private final String _portalCacheName;

        public TestPortalCache(String portalCacheName) {
            this._portalCacheName = portalCacheName;
        }

        public V get(K key) {
            return this._map.get(key);
        }

        public List<K> getKeys() {
            return new ArrayList<K>(this._map.keySet());
        }

        public PortalCacheManager<K, V> getPortalCacheManager() {
            return null;
        }

        public String getPortalCacheName() {
            return this._portalCacheName;
        }

        public boolean isMVCC() {
            return false;
        }

        public boolean isSharded() {
            return false;
        }

        public void put(K key, V value) {
            this.put(key, value, 0);
        }

        public void put(K key, V value, int timeToLive) {
            V oldValue = this._map.put(key, value);
            for (PortalCacheListener<K, V> portalCacheListener : this._portalCacheListeners) {
                if (oldValue != null) {
                    portalCacheListener.notifyEntryUpdated((PortalCache)this, key, value, timeToLive);
                    continue;
                }
                portalCacheListener.notifyEntryPut((PortalCache)this, key, value, timeToLive);
            }
        }

        public void registerPortalCacheListener(PortalCacheListener<K, V> portalCacheListener) {
            this._portalCacheListeners.add(portalCacheListener);
        }

        public void registerPortalCacheListener(PortalCacheListener<K, V> portalCacheListener, PortalCacheListenerScope portalCacheListenerScope) {
            this._portalCacheListeners.add(portalCacheListener);
        }

        public void remove(K key) {
            this._map.remove(key);
            for (PortalCacheListener<K, V> portalCacheListener : this._portalCacheListeners) {
                portalCacheListener.notifyEntryRemoved((PortalCache)this, key, null, 0);
            }
        }

        public void removeAll() {
            this._map.clear();
            for (PortalCacheListener<K, V> portalCacheListener : this._portalCacheListeners) {
                portalCacheListener.notifyRemoveAll((PortalCache)this);
            }
        }

        public void unregisterPortalCacheListener(PortalCacheListener<K, V> portalCacheListener) {
            portalCacheListener.dispose();
            this._portalCacheListeners.remove(portalCacheListener);
        }

        public void unregisterPortalCacheListeners() {
            for (PortalCacheListener<K, V> portalCacheListener : this._portalCacheListeners) {
                portalCacheListener.dispose();
            }
            this._portalCacheListeners.clear();
        }
    }

    private static class TestMultiVMPool
    implements MultiVMPool {
        private final PortalCacheManager<? extends Serializable, ? extends Serializable> _portalCacheManager = PortalCacheManagerProvider.getPortalCacheManager((String)"MULTI_VM_PORTAL_CACHE_MANAGER");

        private TestMultiVMPool() {
        }

        public void clear() {
            this._portalCacheManager.clearAll();
        }

        public PortalCache<? extends Serializable, ? extends Serializable> getPortalCache(String portalCacheName) {
            return this._portalCacheManager.getPortalCache(portalCacheName);
        }

        public PortalCache<? extends Serializable, ? extends Serializable> getPortalCache(String portalCacheName, boolean mvcc) {
            return this.getPortalCache(portalCacheName);
        }

        public PortalCache<? extends Serializable, ? extends Serializable> getPortalCache(String portalCacheName, boolean mvcc, boolean sharded) {
            return this.getPortalCache(portalCacheName);
        }

        public PortalCacheManager<? extends Serializable, ? extends Serializable> getPortalCacheManager() {
            return this._portalCacheManager;
        }

        public void removePortalCache(String portalCacheName) {
            this._portalCacheManager.removePortalCache(portalCacheName);
        }
    }
}

