/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade;

import com.liferay.counter.kernel.model.Counter;
import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.counter.kernel.service.persistence.CounterFinder;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.PortalBeanLocatorUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.upgrade.UpgradeException;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.spring.aop.AopInvocationHandler;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.List;

public abstract class Pre7UpgradeProcess
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(Pre7UpgradeProcess.class);

    public void upgrade() throws UpgradeException {
        try (Closeable closeable = this._injectFieldProxy(PortalBeanLocatorUtil.locate((String)CounterLocalService.class.getName()), "counterFinder", Pre7CounterFinderImpl.class);){
            super.upgrade();
        }
        catch (UpgradeException upgradeException) {
            throw upgradeException;
        }
        catch (Exception exception) {
            throw new UpgradeException((Throwable)exception);
        }
    }

    private Closeable _injectFieldProxy(Object springServiceProxy, String fieldName, Class<?> wrapperClass) throws Exception {
        AopInvocationHandler aopInvocationHandler = (AopInvocationHandler)ProxyUtil.fetchInvocationHandler((Object)springServiceProxy, AopInvocationHandler.class);
        final Object target = aopInvocationHandler.getTarget();
        Field field = null;
        for (Class<?> clazz = target.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            try {
                field = ReflectionUtil.getDeclaredField(clazz, (String)fieldName);
                break;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Throwable)noSuchFieldException);
                continue;
            }
        }
        if (field == null) {
            throw new IllegalArgumentException(StringBundler.concat((Object[])new Object[]{"Unable to locate field ", fieldName, " in ", target}));
        }
        final Field finalField = field;
        final Object previousValue = finalField.get(target);
        Constructor<?> constructor = wrapperClass.getDeclaredConstructor(finalField.getType());
        constructor.setAccessible(true);
        finalField.set(target, constructor.newInstance(previousValue));
        return new Closeable(){

            @Override
            public void close() throws IOException {
                try {
                    finalField.set(target, previousValue);
                }
                catch (ReflectiveOperationException reflectiveOperationException) {
                    throw new IOException(reflectiveOperationException);
                }
            }
        };
    }

    private static class Pre7CounterFinderImpl
    implements CounterFinder {
        private final CounterFinder _counterFinder;

        public long getCurrentId(String name) {
            return this._counterFinder.getCurrentId(name);
        }

        public List<String> getNames() {
            return this._counterFinder.getNames();
        }

        public String getRegistryName() {
            return this._counterFinder.getRegistryName();
        }

        public long increment() {
            return this._counterFinder.increment("com.liferay.counter.model.Counter");
        }

        public long increment(String name) {
            if (name.equals(Counter.class.getName())) {
                name = "com.liferay.counter.model.Counter";
            } else if (name.equals(ResourcePermission.class.getName())) {
                name = "com.liferay.portal.model.ResourcePermission";
            }
            return this._counterFinder.increment(name);
        }

        public long increment(String name, int size) {
            if (name.equals(Counter.class.getName())) {
                name = "com.liferay.counter.model.Counter";
            } else if (name.equals(ResourcePermission.class.getName())) {
                name = "com.liferay.portal.model.ResourcePermission";
            }
            return this._counterFinder.increment(name, size);
        }

        public void invalidate() {
            this._counterFinder.invalidate();
        }

        public void rename(String oldName, String newName) {
            this._counterFinder.rename(oldName, newName);
        }

        public void reset(String name) {
            this._counterFinder.reset(name);
        }

        public void reset(String name, long size) {
            this._counterFinder.reset(name, size);
        }

        private Pre7CounterFinderImpl(CounterFinder counterFinder) {
            this._counterFinder = counterFinder;
        }
    }
}

