/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.petra.lang.SafeCloseable;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.events.EventsProcessorUtil;
import com.liferay.portal.kernel.cookies.CookiesManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.exception.NoSuchVirtualHostException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.instance.PortalInstancePool;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.PortletCategory;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.VirtualHost;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.service.VirtualHostLocalServiceUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.util.WebAppPool;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.http.HttpServletRequest;

public class PortalInstances {
    private static final String _GET_COMPANY_IDS = "select companyId from Company";
    private static final Log _log = LogFactoryUtil.getLog(PortalInstances.class);
    private static final Set<String> _autoLoginIgnoreHosts;
    private static final Set<String> _autoLoginIgnorePaths;
    private static final List<Long> _companyIdsInDeletionProcess;
    private static final Set<String> _virtualHostsIgnoreHosts;
    private static final Set<String> _virtualHostsIgnorePaths;

    public static long getCompanyId(HttpServletRequest httpServletRequest) {
        try {
            return PortalInstances.getCompanyId(httpServletRequest, false);
        }
        catch (NoSuchVirtualHostException noSuchVirtualHostException) {
            _log.error((Throwable)noSuchVirtualHostException);
            return 0L;
        }
    }

    public static long getCompanyId(HttpServletRequest httpServletRequest, boolean strict) throws NoSuchVirtualHostException {
        long cookieCompanyId;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Get company ID");
        }
        Long companyIdObj = (Long)httpServletRequest.getAttribute("COMPANY_ID");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Company ID from request " + companyIdObj));
        }
        if (companyIdObj != null) {
            return companyIdObj;
        }
        long companyId = PortalInstances._getCompanyIdByVirtualHosts(httpServletRequest, strict);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Company ID from host " + companyId));
        }
        if (companyId <= 0L && (cookieCompanyId = GetterUtil.getLong((String)CookiesManagerUtil.getCookieValue((String)"COMPANY_ID", (HttpServletRequest)httpServletRequest, (boolean)false))) > 0L) {
            try {
                Company cookieCompany = CompanyLocalServiceUtil.fetchCompanyById((long)cookieCompanyId);
                if (cookieCompany == null) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)("Company ID from cookie " + cookieCompanyId + " does not exist"));
                    }
                } else {
                    companyId = cookieCompanyId;
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)("Company ID from cookie " + companyId));
                    }
                }
            }
            catch (Exception exception) {
                _log.error((Throwable)exception);
            }
        }
        if (companyId <= 0L) {
            companyId = PortalInstances.getDefaultCompanyId();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Default company ID " + companyId));
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Set company ID " + companyId));
        }
        httpServletRequest.setAttribute("COMPANY_ID", (Object)companyId);
        CompanyThreadLocal.setCompanyId((Long)companyId);
        if (Validator.isNotNull((String)PropsValues.VIRTUAL_HOSTS_DEFAULT_SITE_NAME) && httpServletRequest.getAttribute("VIRTUAL_HOST_LAYOUT_SET") == null) {
            try {
                Group group = GroupLocalServiceUtil.getGroup((long)companyId, (String)PropsValues.VIRTUAL_HOSTS_DEFAULT_SITE_NAME);
                LayoutSet layoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)group.getGroupId(), (boolean)false);
                TreeMap virtualHostnames = layoutSet.getVirtualHostnames();
                if (virtualHostnames.isEmpty() || PortalInstances._isCompanyVirtualHostname(companyId, httpServletRequest.getServerName())) {
                    httpServletRequest.setAttribute("VIRTUAL_HOST_LAYOUT_SET", (Object)layoutSet);
                }
            }
            catch (Exception exception) {
                _log.error((Throwable)exception);
            }
        }
        return companyId;
    }

    public static long[] getCompanyIds() {
        return PortalInstancePool.getCompanyIds();
    }

    public static long[] getCompanyIdsBySQL() throws SQLException {
        ArrayList<Long> companyIds = new ArrayList<Long>();
        long defaultCompanyId = PortalInstances.getDefaultCompanyIdBySQL();
        if (defaultCompanyId != 0L) {
            companyIds.add(defaultCompanyId);
        }
        try (Connection connection = DataAccess.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(_GET_COMPANY_IDS);
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                long companyId = resultSet.getLong("companyId");
                if (companyId == defaultCompanyId) continue;
                companyIds.add(companyId);
            }
        }
        return ArrayUtil.toArray((Long[])companyIds.toArray(new Long[0]));
    }

    public static long getDefaultCompanyId() {
        long[] companyIds = PortalInstancePool.getCompanyIds();
        if (companyIds.length == 0) {
            try {
                return PortalInstances.getDefaultCompanyIdBySQL();
            }
            catch (SQLException sqlException) {
                _log.error((Object)"Unable to get the default company ID by SQL", (Throwable)sqlException);
                throw new RuntimeException(sqlException);
            }
        }
        return PortalInstancePool.getDefaultCompanyId();
    }

    public static long getDefaultCompanyIdBySQL() throws SQLException {
        try (Connection connection = DataAccess.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement("select companyId from Company where webId = '" + PropsValues.COMPANY_DEFAULT_WEB_ID + "'");
             ResultSet resultSet = preparedStatement.executeQuery();){
            if (resultSet.next()) {
                long l = resultSet.getLong(1);
                return l;
            }
        }
        return 0L;
    }

    public static String[] getWebIds() {
        return PortalInstancePool.getWebIds();
    }

    public static long initCompany(Company company) {
        return PortalInstances.initCompany(company, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long initCompany(Company company, boolean skipCheck) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Begin initializing company with web ID " + company.getWebId()));
        }
        Long currentThreadCompanyId = CompanyThreadLocal.getCompanyId();
        String currentThreadPrincipalName = PrincipalThreadLocal.getName();
        try {
            User user;
            CompanyThreadLocal.setCompanyId((Long)company.getCompanyId());
            if (!skipCheck) {
                try {
                    CompanyLocalServiceUtil.checkCompany((String)company.getWebId());
                }
                catch (Exception exception) {
                    _log.error((Throwable)exception);
                }
            }
            String principalName = null;
            long userId = PrincipalThreadLocal.getUserId();
            if (userId > 0L && (user = UserLocalServiceUtil.fetchUser((long)userId)) != null && user.getCompanyId() == company.getCompanyId()) {
                principalName = currentThreadPrincipalName;
            }
            PrincipalThreadLocal.setName(principalName);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Initialize display");
            }
            try {
                PortletCategory portletCategory = (PortletCategory)WebAppPool.get(company.getCompanyId(), "PORTLET_CATEGORY");
                if (portletCategory == null) {
                    portletCategory = new PortletCategory();
                }
                for (long currentCompanyId : PortalInstancePool.getCompanyIds()) {
                    PortletCategory currentPortletCategory = (PortletCategory)WebAppPool.get(currentCompanyId, "PORTLET_CATEGORY");
                    if (currentPortletCategory == null) continue;
                    portletCategory.merge(currentPortletCategory);
                }
                WebAppPool.put(company.getCompanyId(), "PORTLET_CATEGORY", portletCategory);
            }
            catch (Exception exception) {
                _log.error((Throwable)exception);
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Process application startup events");
            }
            try {
                EventsProcessorUtil.process("application.startup.events", PropsValues.APPLICATION_STARTUP_EVENTS, new String[]{String.valueOf(company.getCompanyId())});
            }
            catch (Exception exception) {
                _log.error((Throwable)exception);
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"End initializing company with web ID ", company.getWebId(), " and company ID ", company.getCompanyId()}));
            }
            PortalInstancePool.add((Company)company);
        }
        finally {
            CompanyThreadLocal.setCompanyId((Long)currentThreadCompanyId);
            PrincipalThreadLocal.setName((String)currentThreadPrincipalName);
        }
        return company.getCompanyId();
    }

    public static boolean isAutoLoginIgnoreHost(String host) {
        return _autoLoginIgnoreHosts.contains(host);
    }

    public static boolean isAutoLoginIgnorePath(String path) {
        return _autoLoginIgnorePaths.contains(path);
    }

    public static boolean isCompanyActive(long companyId) {
        try {
            Company company = CompanyLocalServiceUtil.fetchCompanyById((long)companyId);
            if (company != null) {
                return company.isActive();
            }
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
        return false;
    }

    public static boolean isCompanyInDeletionProcess(long companyId) {
        return _companyIdsInDeletionProcess.contains(companyId);
    }

    public static boolean isCurrentCompanyInDeletionProcess() {
        return _companyIdsInDeletionProcess.contains(CompanyThreadLocal.getCompanyId());
    }

    public static boolean isVirtualHostsIgnoreHost(String host) {
        return _virtualHostsIgnoreHosts.contains(host);
    }

    public static boolean isVirtualHostsIgnorePath(String path) {
        return _virtualHostsIgnorePaths.contains(path);
    }

    public static void removeCompany(long companyId) {
        try {
            EventsProcessorUtil.process("application.shutdown.events", PropsValues.APPLICATION_SHUTDOWN_EVENTS, new String[]{String.valueOf(companyId)});
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
        PortalInstancePool.remove((long)companyId);
        WebAppPool.remove(companyId, "PORTLET_CATEGORY");
    }

    public static SafeCloseable setCompanyInDeletionProcess(long companyId) {
        if (_companyIdsInDeletionProcess.contains(companyId)) {
            throw new UnsupportedOperationException(companyId + " is already in deletion");
        }
        _companyIdsInDeletionProcess.add(companyId);
        return () -> _companyIdsInDeletionProcess.remove(companyId);
    }

    private static long _getCompanyIdByHost(String host, HttpServletRequest httpServletRequest) {
        if (Validator.isNull((String)host)) {
            return 0L;
        }
        try {
            VirtualHost virtualHost = VirtualHostLocalServiceUtil.fetchVirtualHost((String)host);
            if (virtualHost == null) {
                return 0L;
            }
            CompanyThreadLocal.setCompanyId((Long)virtualHost.getCompanyId());
            if (virtualHost.getLayoutSetId() != 0L) {
                PortalInstances._setAttributes(virtualHost, httpServletRequest);
            }
            return virtualHost.getCompanyId();
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            return 0L;
        }
    }

    private static long _getCompanyIdByVirtualHosts(HttpServletRequest httpServletRequest, boolean strict) throws NoSuchVirtualHostException {
        String host = PortalUtil.getHost((HttpServletRequest)httpServletRequest);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Host " + host));
        }
        if (PortalInstances.isVirtualHostsIgnoreHost(host)) {
            return 0L;
        }
        long companyId = PortalInstances._getCompanyIdByHost(host, httpServletRequest);
        if (strict && companyId == 0L) {
            throw new NoSuchVirtualHostException(host);
        }
        return companyId;
    }

    private static boolean _isCompanyVirtualHostname(long companyId, String serverName) throws PortalException {
        Company company = CompanyLocalServiceUtil.getCompany((long)companyId);
        String virtualHostname = company.getVirtualHostname();
        if (Validator.isNull((String)virtualHostname)) {
            virtualHostname = "localhost";
        }
        return Objects.equals(virtualHostname, serverName);
    }

    private static void _setAttributes(VirtualHost virtualHost, HttpServletRequest httpServletRequest) throws PortalException {
        LayoutSet layoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)virtualHost.getLayoutSetId());
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Company ", virtualHost.getCompanyId(), " is associated with layout set ", virtualHost.getLayoutSetId()}));
        }
        httpServletRequest.setAttribute("VIRTUAL_HOST_LAYOUT_SET", (Object)layoutSet);
        String languageId = virtualHost.getLanguageId();
        if (Validator.isNotNull((String)languageId) && LanguageUtil.isAvailableLocale((long)layoutSet.getGroupId(), (String)languageId)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((String[])new String[]{"Virtual host ", virtualHost.getHostname(), " has default language ", languageId}));
            }
            httpServletRequest.setAttribute("VIRTUAL_HOST_LANGUAGE_ID", (Object)languageId);
        }
    }

    private PortalInstances() {
    }

    static {
        _companyIdsInDeletionProcess = new CopyOnWriteArrayList<Long>();
        _autoLoginIgnoreHosts = SetUtil.fromArray((Object[])PropsUtil.getArray("auto.login.ignore.hosts"));
        _autoLoginIgnorePaths = SetUtil.fromArray((Object[])PropsUtil.getArray("auto.login.ignore.paths"));
        _virtualHostsIgnoreHosts = SetUtil.fromArray((Object[])PropsUtil.getArray("virtual.hosts.ignore.hosts"));
        _virtualHostsIgnorePaths = SetUtil.fromArray((Object[])PropsUtil.getArray("virtual.hosts.ignore.paths"));
    }
}

