/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.xmlrpc;

import com.liferay.petra.string.StringBundler;
import com.liferay.petra.string.StringUtil;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.Tuple;
import com.liferay.portal.kernel.xml.StAXReaderUtil;
import com.liferay.portal.kernel.xmlrpc.Response;
import com.liferay.portal.kernel.xmlrpc.XmlRpcException;
import com.liferay.portal.xmlrpc.Fault;
import com.liferay.portal.xmlrpc.Success;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;

public class XmlRpcUtil {
    private static final boolean _HTTP_HEADER_VERSION_VERBOSITY_DEFAULT = StringUtil.equalsIgnoreCase((String)PropsUtil.get((String)"http.header.version.verbosity"), (String)"off");
    private static final boolean _HTTP_HEADER_VERSION_VERBOSITY_PARTIAL = StringUtil.equalsIgnoreCase((String)PropsUtil.get((String)"http.header.version.verbosity"), (String)"partial");
    private static final Log _log = LogFactoryUtil.getLog(XmlRpcUtil.class);

    public static String buildMethod(String methodName, Object[] arguments) throws XmlRpcException {
        StringBundler sb = new StringBundler(arguments.length * 3 + 8);
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("<methodCall>");
        sb.append("<methodName>");
        sb.append(methodName);
        sb.append("</methodName>");
        sb.append("<params>");
        for (Object argument : arguments) {
            sb.append("<param>");
            sb.append(XmlRpcUtil.wrapValue(argument));
            sb.append("</param>");
        }
        sb.append("</params>");
        sb.append("</methodCall>");
        return sb.toString();
    }

    public static Fault createFault(int code, String description) {
        return new Fault(code, description);
    }

    public static Success createSuccess(String description) {
        return new Success(description);
    }

    public static Response executeMethod(String url, String methodName, Object[] arguments) throws XmlRpcException {
        try {
            if (_log.isDebugEnabled()) {
                StringBundler sb = new StringBundler();
                sb.append("XML-RPC invoking ");
                sb.append(methodName);
                sb.append(" ");
                if (arguments != null) {
                    for (int i = 0; i < arguments.length; ++i) {
                        sb.append(arguments[i]);
                        if (i >= arguments.length - 1) continue;
                        sb.append(", ");
                    }
                }
                _log.debug((Object)sb.toString());
            }
            String requestXML = XmlRpcUtil.buildMethod(methodName, arguments);
            Http.Options options = new Http.Options();
            if (!_HTTP_HEADER_VERSION_VERBOSITY_DEFAULT) {
                if (_HTTP_HEADER_VERSION_VERBOSITY_PARTIAL) {
                    options.addHeader("User-Agent", ReleaseInfo.getName());
                } else {
                    options.addHeader("User-Agent", ReleaseInfo.getServerInfo());
                }
            }
            options.setBody(requestXML, "text/xml", "UTF-8");
            options.setLocation(url);
            options.setPost(true);
            return XmlRpcUtil.parseResponse(HttpUtil.URLtoString((Http.Options)options));
        }
        catch (Exception exception) {
            throw new XmlRpcException((Throwable)exception);
        }
    }

    public static Tuple parseMethod(String xml) throws IOException {
        XMLStreamReader xmlStreamReader = null;
        try {
            XMLInputFactory xmlInputFactory = StAXReaderUtil.getXMLInputFactory();
            xmlStreamReader = xmlInputFactory.createXMLStreamReader((Reader)new UnsyncStringReader(xml));
            xmlStreamReader.nextTag();
            xmlStreamReader.nextTag();
            xmlStreamReader.next();
            String methodName = xmlStreamReader.getText();
            ArrayList<Object> arguments = new ArrayList<Object>();
            xmlStreamReader.nextTag();
            String name = xmlStreamReader.getLocalName();
            while (!name.equals("methodCall")) {
                xmlStreamReader.nextTag();
                name = xmlStreamReader.getLocalName();
                if (!name.equals("param")) continue;
                xmlStreamReader.nextTag();
                name = xmlStreamReader.getLocalName();
                int event = xmlStreamReader.next();
                if (event == 1) {
                    name = xmlStreamReader.getLocalName();
                    xmlStreamReader.next();
                    String text = xmlStreamReader.getText();
                    if (name.equals("string")) {
                        arguments.add(text);
                    } else if (name.equals("int") || name.equals("i4")) {
                        arguments.add(GetterUtil.getInteger((String)text));
                    } else if (name.equals("double")) {
                        arguments.add(GetterUtil.getDouble((String)text));
                    } else if (name.equals("boolean")) {
                        arguments.add(GetterUtil.getBoolean((String)text));
                    } else {
                        throw new IOException("XML-RPC not implemented for " + name);
                    }
                    xmlStreamReader.nextTag();
                    xmlStreamReader.nextTag();
                    xmlStreamReader.nextTag();
                } else {
                    arguments.add(xmlStreamReader.getText());
                    xmlStreamReader.nextTag();
                    xmlStreamReader.nextTag();
                }
                name = xmlStreamReader.getLocalName();
            }
            Tuple tuple = new Tuple(new Object[]{methodName, arguments.toArray()});
            return tuple;
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
        finally {
            block21: {
                if (xmlStreamReader != null) {
                    try {
                        xmlStreamReader.close();
                    }
                    catch (Exception exception) {
                        if (!_log.isDebugEnabled()) break block21;
                        _log.debug((Throwable)exception);
                    }
                }
            }
        }
    }

    public static Response parseResponse(String xml) throws XmlRpcException {
        XMLStreamReader xmlStreamReader = null;
        try {
            XMLInputFactory xmlInputFactory = StAXReaderUtil.getXMLInputFactory();
            xmlStreamReader = xmlInputFactory.createXMLStreamReader((Reader)new UnsyncStringReader(xml));
            xmlStreamReader.nextTag();
            xmlStreamReader.nextTag();
            String name = xmlStreamReader.getLocalName();
            if (name.equals("params")) {
                String description = null;
                xmlStreamReader.nextTag();
                xmlStreamReader.nextTag();
                int event = xmlStreamReader.next();
                if (event == 1) {
                    xmlStreamReader.next();
                    description = xmlStreamReader.getText();
                } else {
                    description = xmlStreamReader.getText();
                }
                Success success = XmlRpcUtil.createSuccess(description);
                return success;
            }
            if (name.equals("fault")) {
                int code = 0;
                String description = null;
                xmlStreamReader.nextTag();
                xmlStreamReader.nextTag();
                for (int i = 0; i < 2; ++i) {
                    xmlStreamReader.nextTag();
                    xmlStreamReader.nextTag();
                    xmlStreamReader.next();
                    String valueName = xmlStreamReader.getText();
                    if (valueName.equals("faultCode")) {
                        xmlStreamReader.nextTag();
                        xmlStreamReader.nextTag();
                        xmlStreamReader.nextTag();
                        name = xmlStreamReader.getLocalName();
                        if (name.equals("int") || name.equals("i4")) {
                            xmlStreamReader.next();
                            code = GetterUtil.getInteger((String)xmlStreamReader.getText());
                        }
                        xmlStreamReader.nextTag();
                        xmlStreamReader.nextTag();
                        xmlStreamReader.nextTag();
                        continue;
                    }
                    if (!valueName.equals("faultString")) continue;
                    xmlStreamReader.nextTag();
                    xmlStreamReader.nextTag();
                    int event = xmlStreamReader.next();
                    if (event == 1) {
                        xmlStreamReader.next();
                        description = xmlStreamReader.getText();
                        xmlStreamReader.nextTag();
                    } else {
                        description = xmlStreamReader.getText();
                    }
                    xmlStreamReader.nextTag();
                    xmlStreamReader.nextTag();
                }
                Fault fault = XmlRpcUtil.createFault(code, description);
                return fault;
            }
            Response response = null;
            return response;
        }
        catch (Exception exception) {
            throw new XmlRpcException(xml, (Throwable)exception);
        }
        finally {
            block25: {
                if (xmlStreamReader != null) {
                    try {
                        xmlStreamReader.close();
                    }
                    catch (Exception exception) {
                        if (!_log.isDebugEnabled()) break block25;
                        _log.debug((Throwable)exception);
                    }
                }
            }
        }
    }

    public static String wrapValue(Object value) throws XmlRpcException {
        if (value == null) {
            return "";
        }
        StringBundler sb = new StringBundler(5);
        sb.append("<value>");
        if (value instanceof String) {
            sb.append("<string>");
            sb.append(value.toString());
            sb.append("</string>");
        } else if (value instanceof Integer || value instanceof Short) {
            sb.append("<i4>");
            sb.append(value.toString());
            sb.append("</i4>");
        } else if (value instanceof Double || value instanceof Float) {
            sb.append("<double>");
            sb.append(value.toString());
            sb.append("</double>");
        } else if (value instanceof Boolean) {
            sb.append("<boolean>");
            if (((Boolean)value).booleanValue()) {
                sb.append('1');
            } else {
                sb.append('0');
            }
            sb.append("</boolean>");
        } else {
            throw new XmlRpcException("Unsupported type " + value.getClass());
        }
        sb.append("</value>");
        return sb.toString();
    }
}

