/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.service.persistence.impl;

import com.liferay.asset.kernel.model.AssetEntries_AssetTagsTable;
import com.liferay.asset.kernel.model.AssetEntryTable;
import com.liferay.asset.kernel.model.AssetTag;
import com.liferay.asset.kernel.model.AssetTagModel;
import com.liferay.asset.kernel.model.AssetTagTable;
import com.liferay.asset.kernel.service.persistence.AssetTagFinder;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.petra.sql.dsl.DSLFunctionFactoryUtil;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.sql.dsl.query.LimitStep;
import com.liferay.petra.sql.dsl.query.sort.OrderByExpression;
import com.liferay.petra.sql.dsl.query.sort.OrderByInfo;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portlet.asset.model.impl.AssetTagImpl;
import com.liferay.portlet.asset.service.persistence.impl.AssetTagFinderBaseImpl;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class AssetTagFinderImpl
extends AssetTagFinderBaseImpl
implements AssetTagFinder {
    public int countByG_C_N(long groupId, long classNameId, String name) {
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            Object[] assetTagIds = this._getAssetTagIds(groupId, classNameId, name);
            if (ArrayUtil.isEmpty((Object[])assetTagIds)) {
                int n = 0;
                return n;
            }
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery((DSLQuery)DSLQueryFactoryUtil.countDistinct((Expression)AssetEntries_AssetTagsTable.INSTANCE.entryId).from((Table)AssetEntries_AssetTagsTable.INSTANCE).where(AssetEntries_AssetTagsTable.INSTANCE.tagId.in(assetTagIds)));
            sqlQuery.addScalar("COUNT_VALUE", Type.LONG);
            Iterator iterator = sqlQuery.iterate();
            if (iterator.hasNext() && (count = (Long)iterator.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<AssetTag> findByG_C_N(long groupId, long classNameId, String name, int start, int end, OrderByComparator<AssetTag> orderByComparator) {
        Session session = null;
        try {
            session = this.openSession();
            LimitStep dslQuery = DSLQueryFactoryUtil.selectDistinct((Table)AssetTagTable.INSTANCE).from((Table)AssetTagTable.INSTANCE).innerJoinON((Table)AssetEntries_AssetTagsTable.INSTANCE, AssetEntries_AssetTagsTable.INSTANCE.tagId.eq((Expression)AssetTagTable.INSTANCE.tagId)).where(() -> {
                Predicate predicate = AssetEntries_AssetTagsTable.INSTANCE.entryId.in((DSLQuery)DSLQueryFactoryUtil.select((Expression[])new Expression[]{AssetEntryTable.INSTANCE.entryId}).from((Table)AssetEntryTable.INSTANCE).where(AssetEntryTable.INSTANCE.groupId.eq((Object)groupId).and((Expression)AssetEntryTable.INSTANCE.classNameId.eq((Object)classNameId)).and((Expression)AssetEntryTable.INSTANCE.visible.eq((Object)true))));
                if (name == null) {
                    return predicate;
                }
                return predicate.and((Expression)DSLFunctionFactoryUtil.lower((Expression)AssetTagTable.INSTANCE.name).like(StringUtil.toLowerCase((String)name)));
            }).orderBy(orderByStep -> {
                if (orderByComparator == null) {
                    return orderByStep.orderBy(new OrderByExpression[]{AssetTagTable.INSTANCE.name.ascending()});
                }
                return orderByStep.orderBy((Table)AssetTagTable.INSTANCE, (OrderByInfo)orderByComparator);
            });
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery((DSLQuery)dslQuery);
            sqlQuery.addEntity("AssetTag", AssetTagImpl.class);
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    private Long[] _getAssetTagIds(long groupId, long classNameId, String name) {
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery((DSLQuery)DSLQueryFactoryUtil.selectDistinct((Table)AssetTagTable.INSTANCE).from((Table)AssetTagTable.INSTANCE).innerJoinON((Table)AssetEntries_AssetTagsTable.INSTANCE, AssetEntries_AssetTagsTable.INSTANCE.tagId.eq((Expression)AssetTagTable.INSTANCE.tagId)).innerJoinON((Table)AssetEntryTable.INSTANCE, AssetEntryTable.INSTANCE.entryId.eq((Expression)AssetEntries_AssetTagsTable.INSTANCE.entryId)).where(AssetEntryTable.INSTANCE.groupId.eq((Object)groupId).and(() -> {
                if (classNameId <= 0L) {
                    return null;
                }
                return AssetEntryTable.INSTANCE.classNameId.eq((Object)classNameId);
            }).and((Expression)AssetEntryTable.INSTANCE.visible.eq((Object)true)).and(() -> {
                if (name == null) {
                    return null;
                }
                return AssetTagTable.INSTANCE.name.like(this._getName(name));
            })));
            sqlQuery.addEntity("AssetTag", AssetTagImpl.class);
            List assetTags = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)-1, (int)-1);
            List assetTagIds = !FeatureFlagManagerUtil.isEnabled((String)"LPS-194362") ? TransformUtil.unsafeTransform((Collection)assetTags, AssetTagModel::getTagId) : TransformUtil.unsafeTransform((Collection)assetTags, assetTag -> {
                if (!StringUtil.equals((String)assetTag.getName(), (String)name)) {
                    return null;
                }
                return assetTag.getTagId();
            });
            Long[] longArray = assetTagIds.toArray(new Long[0]);
            return longArray;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    private String _getName(String name) {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPS-194362")) {
            name = StringUtil.toLowerCase((String)name);
        }
        return name;
    }
}

