/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.expando.service.impl;

import com.liferay.expando.kernel.model.ExpandoRow;
import com.liferay.expando.kernel.model.ExpandoTable;
import com.liferay.expando.kernel.service.ExpandoTableLocalService;
import com.liferay.expando.kernel.service.ExpandoValueLocalService;
import com.liferay.expando.kernel.service.persistence.ExpandoTablePersistence;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portlet.expando.service.base.ExpandoRowLocalServiceBaseImpl;
import java.util.Collections;
import java.util.List;

public class ExpandoRowLocalServiceImpl
extends ExpandoRowLocalServiceBaseImpl {
    @BeanReference(type=ClassNameLocalService.class)
    private ClassNameLocalService _classNameLocalService;
    @BeanReference(type=ExpandoTableLocalService.class)
    private ExpandoTableLocalService _expandoTableLocalService;
    @BeanReference(type=ExpandoTablePersistence.class)
    private ExpandoTablePersistence _expandoTablePersistence;
    @BeanReference(type=ExpandoValueLocalService.class)
    private ExpandoValueLocalService _expandoValueLocalService;

    public ExpandoRow addRow(long tableId, long classPK) throws PortalException {
        ExpandoTable table = this._expandoTablePersistence.findByPrimaryKey(tableId);
        long rowId = this.counterLocalService.increment();
        ExpandoRow row = this.expandoRowPersistence.create(rowId);
        row.setCompanyId(table.getCompanyId());
        row.setTableId(tableId);
        row.setClassPK(classPK);
        return (ExpandoRow)this.expandoRowPersistence.update((BaseModel)row);
    }

    public void deleteRow(ExpandoRow row) {
        this.expandoRowPersistence.remove((BaseModel)row);
        this._expandoValueLocalService.deleteRowValues(row.getRowId());
    }

    public void deleteRow(long rowId) throws PortalException {
        ExpandoRow row = this.expandoRowPersistence.findByPrimaryKey(rowId);
        this.deleteRow(row);
    }

    public void deleteRow(long tableId, long classPK) throws PortalException {
        ExpandoRow row = this.expandoRowPersistence.findByT_C(tableId, classPK);
        this.deleteRow(row);
    }

    public void deleteRow(long companyId, long classNameId, String tableName, long classPK) throws PortalException {
        ExpandoTable table = this._expandoTableLocalService.getTable(companyId, classNameId, tableName);
        this.expandoRowLocalService.deleteRow(table.getTableId(), classPK);
    }

    public void deleteRow(long companyId, String className, String tableName, long classPK) throws PortalException {
        this.expandoRowLocalService.deleteRow(companyId, this._classNameLocalService.getClassNameId(className), tableName, classPK);
    }

    public void deleteRows(long classPK) {
        List rows = this.expandoRowPersistence.findByClassPK(classPK);
        for (ExpandoRow row : rows) {
            this.deleteRow(row);
        }
    }

    public void deleteRows(long companyId, long classNameId, long classPK) {
        List tables = this._expandoTableLocalService.getTables(companyId, classNameId);
        for (ExpandoTable table : tables) {
            ExpandoRow row = this.expandoRowPersistence.fetchByT_C(table.getTableId(), classPK);
            if (row == null) continue;
            this.deleteRow(row);
        }
    }

    public ExpandoRow fetchRow(long tableId, long classPK) {
        return this.expandoRowPersistence.fetchByT_C(tableId, classPK);
    }

    public List<ExpandoRow> getDefaultTableRows(long companyId, long classNameId, int start, int end) {
        return this.expandoRowLocalService.getRows(companyId, classNameId, "CUSTOM_FIELDS", start, end);
    }

    public List<ExpandoRow> getDefaultTableRows(long companyId, String className, int start, int end) {
        return this.expandoRowLocalService.getDefaultTableRows(companyId, this._classNameLocalService.getClassNameId(className), start, end);
    }

    public int getDefaultTableRowsCount(long companyId, long classNameId) {
        return this.expandoRowLocalService.getRowsCount(companyId, classNameId, "CUSTOM_FIELDS");
    }

    public int getDefaultTableRowsCount(long companyId, String className) {
        return this.expandoRowLocalService.getDefaultTableRowsCount(companyId, this._classNameLocalService.getClassNameId(className));
    }

    public ExpandoRow getRow(long rowId) throws PortalException {
        return this.expandoRowPersistence.findByPrimaryKey(rowId);
    }

    public ExpandoRow getRow(long tableId, long classPK) throws PortalException {
        return this.expandoRowPersistence.findByT_C(tableId, classPK);
    }

    public ExpandoRow getRow(long companyId, long classNameId, String tableName, long classPK) {
        ExpandoTable table = this._expandoTablePersistence.fetchByC_C_N(companyId, classNameId, tableName);
        if (table == null) {
            return null;
        }
        return this.expandoRowPersistence.fetchByT_C(table.getTableId(), classPK);
    }

    public ExpandoRow getRow(long companyId, String className, String tableName, long classPK) {
        return this.expandoRowLocalService.getRow(companyId, this._classNameLocalService.getClassNameId(className), tableName, classPK);
    }

    public List<ExpandoRow> getRows(long tableId, int start, int end) {
        return this.expandoRowPersistence.findByTableId(tableId, start, end);
    }

    public List<ExpandoRow> getRows(long companyId, long classNameId, String tableName, int start, int end) {
        ExpandoTable table = this._expandoTablePersistence.fetchByC_C_N(companyId, classNameId, tableName);
        if (table == null) {
            return Collections.emptyList();
        }
        return this.expandoRowPersistence.findByTableId(table.getTableId(), start, end);
    }

    public List<ExpandoRow> getRows(long companyId, String className, String tableName, int start, int end) {
        return this.expandoRowLocalService.getRows(companyId, this._classNameLocalService.getClassNameId(className), tableName, start, end);
    }

    public int getRowsCount(long tableId) {
        return this.expandoRowPersistence.countByTableId(tableId);
    }

    public int getRowsCount(long companyId, long classNameId, String tableName) {
        ExpandoTable table = this._expandoTablePersistence.fetchByC_C_N(companyId, classNameId, tableName);
        if (table == null) {
            return 0;
        }
        return this.expandoRowPersistence.countByTableId(table.getTableId());
    }

    public int getRowsCount(long companyId, String className, String tableName) {
        return this.expandoRowLocalService.getRowsCount(companyId, this._classNameLocalService.getClassNameId(className), tableName);
    }
}

