/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.kernel.exception;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.service.AssetCategoryLocalServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.util.Locale;

public class InvalidAssetCategoryException
extends PortalException {
    public static final int CANNOT_MOVE_INTO_CHILD_CATEGORY = 1;
    public static final int CANNOT_MOVE_INTO_ITSELF = 2;
    private static final Log _log = LogFactoryUtil.getLog(InvalidAssetCategoryException.class);
    private final long _categoryId;
    private final int _type;

    public InvalidAssetCategoryException(long categoryId, int type) {
        this._categoryId = categoryId;
        this._type = type;
    }

    public long getCategoryId() {
        return this._categoryId;
    }

    public String getMessageArgument(Locale locale) {
        try {
            AssetCategory category = AssetCategoryLocalServiceUtil.getCategory(this._categoryId);
            return category.getTitle(locale);
        }
        catch (PortalException portalException) {
            if (_log.isWarnEnabled()) {
                _log.warn(portalException, portalException);
            }
            return "";
        }
    }

    public String getMessageKey() {
        if (this._type == 1) {
            return "unable-to-move-category-x-into-one-of-its-children";
        }
        if (this._type == 2) {
            return "unable-to-move-category-x-into-itself";
        }
        return null;
    }
}

