/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.cache;

import com.liferay.portal.kernel.cache.CacheRegistryItem;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CacheRegistryUtil {
    private static final Log _log = LogFactoryUtil.getLog(CacheRegistryUtil.class);
    private static final CacheRegistryUtil _cacheRegistryUtil = new CacheRegistryUtil();
    private volatile boolean _active = true;
    private final Map<String, CacheRegistryItem> _cacheRegistryItems = new ConcurrentHashMap<String, CacheRegistryItem>();
    private final ServiceTracker<CacheRegistryItem, CacheRegistryItem> _serviceTracker;

    public static void clear() {
        _cacheRegistryUtil._clear();
    }

    public static void clear(String name) {
        _cacheRegistryUtil._clear(name);
    }

    public static boolean isActive() {
        return _cacheRegistryUtil._isActive();
    }

    public static void setActive(boolean active) {
        _cacheRegistryUtil._setActive(active);
    }

    private CacheRegistryUtil() {
        Registry registry = RegistryUtil.getRegistry();
        this._serviceTracker = registry.trackServices(CacheRegistryItem.class, (ServiceTrackerCustomizer)new CacheRegistryItemServiceTrackerCustomizer());
        this._serviceTracker.open();
    }

    private void _clear() {
        for (Map.Entry<String, CacheRegistryItem> entry : this._cacheRegistryItems.entrySet()) {
            CacheRegistryItem cacheRegistryItem = entry.getValue();
            if (_log.isDebugEnabled()) {
                _log.debug("Invalidating " + cacheRegistryItem.getRegistryName());
            }
            cacheRegistryItem.invalidate();
        }
    }

    private void _clear(String name) {
        CacheRegistryItem cacheRegistryItem = this._cacheRegistryItems.get(name);
        if (cacheRegistryItem != null) {
            if (_log.isDebugEnabled()) {
                _log.debug("Invalidating " + name);
            }
            cacheRegistryItem.invalidate();
        } else {
            _log.error("No cache registry found with name " + name);
        }
    }

    private boolean _isActive() {
        return this._active;
    }

    private void _setActive(boolean active) {
        this._active = active;
        if (!active) {
            this._clear();
        }
    }

    private class CacheRegistryItemServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<CacheRegistryItem, CacheRegistryItem> {
        private CacheRegistryItemServiceTrackerCustomizer() {
        }

        public CacheRegistryItem addingService(ServiceReference<CacheRegistryItem> serviceReference) {
            Registry registry = RegistryUtil.getRegistry();
            CacheRegistryItem cacheRegistryItem = (CacheRegistryItem)registry.getService(serviceReference);
            CacheRegistryUtil.this._cacheRegistryItems.put(cacheRegistryItem.getRegistryName(), cacheRegistryItem);
            return cacheRegistryItem;
        }

        public void modifiedService(ServiceReference<CacheRegistryItem> serviceReference, CacheRegistryItem cacheRegistryItem) {
        }

        public void removedService(ServiceReference<CacheRegistryItem> serviceReference, CacheRegistryItem cacheRegistryItem) {
            CacheRegistryUtil.this._cacheRegistryItems.remove(cacheRegistryItem.getRegistryName());
        }
    }
}

