/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.dao.db;

import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBInspector;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.db.DBProcess;
import com.liferay.portal.kernel.dao.db.DBTypeToSQLMap;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.NamingException;

public abstract class BaseDBProcess
implements DBProcess {
    protected Connection connection;
    private static final Log _log = LogFactoryUtil.getLog(BaseDBProcess.class);

    @Override
    public void runSQL(Connection connection, String template) throws IOException, SQLException {
        DB db = DBManagerUtil.getDB();
        db.runSQL(connection, template);
    }

    @Override
    public void runSQL(DBTypeToSQLMap dbTypeToSQLMap) throws IOException, SQLException {
        DB db = DBManagerUtil.getDB();
        if (this.connection == null) {
            db.runSQL(dbTypeToSQLMap);
        } else {
            db.runSQL(this.connection, dbTypeToSQLMap);
        }
    }

    @Override
    public void runSQL(String template) throws IOException, SQLException {
        DB db = DBManagerUtil.getDB();
        if (this.connection == null) {
            db.runSQL(template);
        } else {
            db.runSQL(this.connection, template);
        }
    }

    @Override
    public void runSQL(String[] templates) throws IOException, SQLException {
        DB db = DBManagerUtil.getDB();
        if (this.connection == null) {
            db.runSQL(templates);
        } else {
            db.runSQL(this.connection, templates);
        }
    }

    @Override
    public void runSQLTemplate(String path) throws IOException, NamingException, SQLException {
        this.runSQLTemplate(path, true);
    }

    @Override
    public void runSQLTemplate(String path, boolean failOnError) throws IOException, NamingException, SQLException {
        try (LoggingTimer loggingTimer = new LoggingTimer(path);){
            ClassLoader classLoader = PortalClassLoaderUtil.getClassLoader();
            InputStream inputStream = classLoader.getResourceAsStream("com/liferay/portal/tools/sql/dependencies/" + path);
            if (inputStream == null) {
                inputStream = classLoader.getResourceAsStream(path);
            }
            if (inputStream == null) {
                Thread currentThread = Thread.currentThread();
                classLoader = currentThread.getContextClassLoader();
                inputStream = classLoader.getResourceAsStream(path);
            }
            if (inputStream == null) {
                _log.error("Invalid path " + path);
                if (failOnError) {
                    throw new IOException("Invalid path " + path);
                }
                return;
            }
            String template = StringUtil.read(inputStream);
            this.runSQLTemplateString(template, failOnError);
        }
    }

    @Override
    public void runSQLTemplateString(String template, boolean failOnError) throws IOException, NamingException, SQLException {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            DB db = DBManagerUtil.getDB();
            if (this.connection == null) {
                db.runSQLTemplateString(template, failOnError);
            } else {
                db.runSQLTemplateString(this.connection, template, failOnError);
            }
        }
    }

    @Override
    @Deprecated
    public void runSQLTemplateString(String template, boolean evaluate, boolean failOnError) throws IOException, NamingException, SQLException {
        this.runSQLTemplateString(template, failOnError);
    }

    protected boolean doHasTable(String tableName) throws Exception {
        DBInspector dbInspector = new DBInspector(this.connection);
        return dbInspector.hasTable(tableName, true);
    }

    protected boolean hasColumn(String tableName, String columnName) throws Exception {
        DBInspector dbInspector = new DBInspector(this.connection);
        return dbInspector.hasColumn(tableName, columnName);
    }

    @Deprecated
    protected boolean hasColumnType(Class<?> tableClass, String columnName, String columnType) throws Exception {
        DBInspector dbInspector = new DBInspector(this.connection);
        return dbInspector.hasColumnType(tableClass, columnName, columnType);
    }

    protected boolean hasColumnType(String tableName, String columnName, String columnType) throws Exception {
        DBInspector dbInspector = new DBInspector(this.connection);
        return dbInspector.hasColumnType(tableName, columnName, columnType);
    }

    protected boolean hasIndex(String tableName, String indexName) throws Exception {
        DBInspector dbInspector = new DBInspector(this.connection);
        return dbInspector.hasIndex(tableName, indexName);
    }

    protected boolean hasRows(Connection connection, String tableName) {
        DBInspector dbInspector = new DBInspector(connection);
        return dbInspector.hasRows(tableName);
    }

    protected boolean hasRows(String tableName) throws Exception {
        return this.hasRows(this.connection, tableName);
    }

    protected boolean hasTable(String tableName) throws Exception {
        DBInspector dbInspector = new DBInspector(this.connection);
        return dbInspector.hasTable(tableName);
    }

    protected void process(UnsafeConsumer<Long, Exception> unsafeConsumer) throws Exception {
        DB db = DBManagerUtil.getDB();
        db.process(unsafeConsumer);
    }
}

